/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.property;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.egov.commons.Area;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentHibDao;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.demand.model.EgDemandReasonMaster;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.elasticsearch.entity.ApplicationIndex;
import org.egov.infra.elasticsearch.entity.enums.ApprovalStatus;
import org.egov.infra.elasticsearch.entity.enums.ClosureStatus;
import org.egov.infra.elasticsearch.service.ApplicationIndexService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.rest.client.SimpleRestClient;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.MoneyUtils;
import org.egov.infra.web.utils.WebUtils;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infstr.models.BaseModel;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Position;
import org.egov.pims.commons.service.EisCommonsService;
import org.egov.ptis.client.bill.PTBillServiceImpl;
import org.egov.ptis.client.model.calculator.APTaxCalculationInfo;
import org.egov.ptis.client.service.PenaltyCalculationService;
import org.egov.ptis.client.service.calculator.APTaxCalculator;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.dao.property.PropertyStatusValuesDAO;
import org.egov.ptis.domain.dao.property.PropertyTypeMasterDAO;
import org.egov.ptis.domain.entity.demand.FloorwiseDemandCalculations;
import org.egov.ptis.domain.entity.demand.PTDemandCalculations;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.document.DocumentTypeDetails;
import org.egov.ptis.domain.entity.enums.TransactionType;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.egov.ptis.domain.entity.property.Apartment;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Document;
import org.egov.ptis.domain.entity.property.DocumentType;
import org.egov.ptis.domain.entity.property.Floor;
import org.egov.ptis.domain.entity.property.FloorType;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyDepartment;
import org.egov.ptis.domain.entity.property.PropertyDetail;
import org.egov.ptis.domain.entity.property.PropertyID;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyMaterlizeView;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.entity.property.PropertyMutationMaster;
import org.egov.ptis.domain.entity.property.PropertyOccupation;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.entity.property.PropertySource;
import org.egov.ptis.domain.entity.property.PropertyStatus;
import org.egov.ptis.domain.entity.property.PropertyStatusValues;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.entity.property.PropertyUsage;
import org.egov.ptis.domain.entity.property.RoofType;
import org.egov.ptis.domain.entity.property.StructureClassification;
import org.egov.ptis.domain.entity.property.TaxExemptionReason;
import org.egov.ptis.domain.entity.property.VacancyRemission;
import org.egov.ptis.domain.entity.property.VacancyRemissionApproval;
import org.egov.ptis.domain.entity.property.WallType;
import org.egov.ptis.domain.entity.property.WoodType;
import org.egov.ptis.domain.entity.property.vacantland.LayoutApprovalAuthority;
import org.egov.ptis.domain.entity.property.vacantland.VacantLandPlotArea;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.BoundaryDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.model.PropertyDetails;
import org.egov.ptis.domain.model.calculator.MiscellaneousTax;
import org.egov.ptis.domain.model.calculator.TaxCalculationInfo;
import org.egov.ptis.domain.model.calculator.UnitTaxCalculationInfo;
import org.egov.ptis.domain.repository.PropertyDepartmentRepository;
import org.egov.ptis.domain.repository.master.vacantland.LayoutApprovalAuthorityRepository;
import org.egov.ptis.domain.repository.master.vacantland.VacantLandPlotAreaRepository;
import org.egov.ptis.exceptions.TaxCalculatorExeption;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.hibernate.Query;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Transactional(readOnly=true)
public class PropertyService {
    private static final String FROM_PROPERTY_USAGE_WHERE_ID = "from PropertyUsage pu where pu.id = ?";
    private static final String FROM_PROPERTY_OCCUPATION_WHERE_ID = "from PropertyOccupation po where po.id = ?";
    private static final String FROM_PROPERTY_MUTATION_MASTER_WHERE_CODE = "from PropertyMutationMaster PM where upper(PM.code) = ?";
    private static final Logger LOGGER = Logger.getLogger(PropertyService.class);
    public static final String APPLICATION_VIEW_URL = "/ptis/view/viewProperty-viewForm.action?applicationNo=%s&applicationType=%s";
    private static final String PROPERTY_WORKFLOW_STARTED = "Property Workflow Started";
    final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy");
    private PersistenceService propPerServ;
    private Installment currentInstall;
    private BigDecimal totalAlv = BigDecimal.ZERO;
    protected PersistenceService<BasicProperty, Long> basicPropertyService;
    private final Map<Installment, Set<EgDemandDetails>> demandDetails = new HashMap<Installment, Set<EgDemandDetails>>();
    private Map<Installment, Map<String, BigDecimal>> excessCollAmtMap = new LinkedHashMap<Installment, Map<String, BigDecimal>>();
    @Autowired
    private APTaxCalculator taxCalculator;
    private HashMap<Installment, TaxCalculationInfo> instTaxMap;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    protected EisCommonsService eisCommonsService;
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private InstallmentHibDao installmentDao;
    @Autowired
    private UserService userService;
    @Autowired
    private ApplicationNumberGenerator applicationNumberGenerator;
    @Autowired
    @Qualifier(value="documentTypePersistenceService")
    private PersistenceService<DocumentType, Long> documentTypePersistenceService;
    @Autowired
    @Qualifier(value="fileStoreService")
    private FileStoreService fileStoreService;
    @Autowired
    private ApplicationIndexService applicationIndexService;
    @Autowired
    private SimpleRestClient simpleRestClient;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PropertyStatusValuesDAO propertyStatusValuesDAO;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private PenaltyCalculationService penaltyCalculationService;
    @Autowired
    private PTBillServiceImpl ptBillServiceImpl;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private PropertyDepartmentRepository ptDepartmentRepository;
    @Autowired
    private VacantLandPlotAreaRepository vacantLandPlotAreaRepository;
    @Autowired
    private LayoutApprovalAuthorityRepository layoutApprovalAuthorityRepository;
    @Autowired
    @Qualifier(value="documentTypeDetailsService")
    private PersistenceService<DocumentTypeDetails, Long> documentTypeDetailsService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PropertyTypeMasterDAO propertyTypeMasterDAO;

    public PropertyImpl createProperty(PropertyImpl property, String areaOfPlot, String mutationCode, String propTypeId, String propUsageId, String propOccId, Character status, String docnumber, String nonResPlotArea, Long floorTypeId, Long roofTypeId, Long wallTypeId, Long woodTypeId, Long taxExemptId, Long propertyDepartmentId, Long vacantLandPlotAreaId, Long layoutApprovalAuthorityId, Boolean nonVacant) {
        LOGGER.debug((Object)"Entered into createProperty");
        LOGGER.debug((Object)("createProperty: Property: " + property + ", areaOfPlot: " + areaOfPlot + ", mutationCode: " + mutationCode + ",propTypeId: " + propTypeId + ", propUsageId: " + propUsageId + ", propOccId: " + propOccId + ", status: " + status));
        this.currentInstall = (Installment)this.getPropPerServ().find("from Installment I where I.module.name=? and (I.fromDate <= ? and I.toDate >= ?) ", new Object[]{"Property Tax", new Date(), new Date()});
        PropertySource propertySource = (PropertySource)this.getPropPerServ().find("from PropertySource where propSrcCode = ?", new Object[]{"MNCPL-RECORDS"});
        if (floorTypeId != null && floorTypeId != -1L) {
            FloorType floorType = (FloorType)((Object)this.getPropPerServ().find("From FloorType where id = ?", new Object[]{floorTypeId}));
            property.getPropertyDetail().setFloorType(floorType);
        } else {
            property.getPropertyDetail().setFloorType(null);
        }
        if (roofTypeId != null && roofTypeId != -1L) {
            RoofType roofType = (RoofType)((Object)this.getPropPerServ().find("From RoofType where id = ?", new Object[]{roofTypeId}));
            property.getPropertyDetail().setRoofType(roofType);
        } else {
            property.getPropertyDetail().setRoofType(null);
        }
        if (wallTypeId != null && wallTypeId != -1L) {
            WallType wallType = (WallType)((Object)this.getPropPerServ().find("From WallType where id = ?", new Object[]{wallTypeId}));
            property.getPropertyDetail().setWallType(wallType);
        } else {
            property.getPropertyDetail().setWallType(null);
        }
        if (woodTypeId != null && woodTypeId != -1L) {
            WoodType woodType = (WoodType)((Object)this.getPropPerServ().find("From WoodType where id = ?", new Object[]{woodTypeId}));
            property.getPropertyDetail().setWoodType(woodType);
        } else {
            property.getPropertyDetail().setWoodType(null);
        }
        if (taxExemptId != null && taxExemptId != -1L) {
            TaxExemptionReason taxExemptionReason = (TaxExemptionReason)((Object)this.getPropPerServ().find("From TaxExemptionReason where id = ?", new Object[]{taxExemptId}));
            property.setTaxExemptedReason(taxExemptionReason);
            property.setIsExemptedFromTax(Boolean.TRUE);
        }
        Area area = new Area();
        if (property.getId() == null && property.getPropertyDetail().isAppurtenantLandChecked().booleanValue()) {
            if (nonVacant.booleanValue()) {
                area.setArea(new Float(property.getPropertyDetail().getExtentAppartenauntLand()));
            } else {
                area.setArea(new Float(property.getPropertyDetail().getSitalArea().getArea().floatValue()));
            }
        } else if (areaOfPlot != null && !areaOfPlot.isEmpty()) {
            area.setArea(new Float(areaOfPlot));
            property.getPropertyDetail().setSitalArea(area);
        } else {
            area.setArea(new Float(property.getPropertyDetail().getSitalArea().getArea().floatValue()));
        }
        property.getPropertyDetail().setSitalArea(area);
        if (property.getPropertyDetail().getApartment() != null && property.getPropertyDetail().getApartment().getId() != null) {
            Apartment apartment = (Apartment)((Object)this.getPropPerServ().find("From Apartment where id = ?", new Object[]{property.getPropertyDetail().getApartment().getId()}));
            property.getPropertyDetail().setApartment(apartment);
        } else {
            property.getPropertyDetail().setApartment(null);
        }
        if (nonResPlotArea != null && !nonResPlotArea.isEmpty()) {
            area.setArea(new Float(nonResPlotArea));
            property.getPropertyDetail().setNonResPlotArea(area);
        }
        property.getPropertyDetail().setFieldVerified(Character.valueOf('Y'));
        property.getPropertyDetail().setProperty(property);
        PropertyTypeMaster propTypeMstr = property.getId() == null && property.getPropertyDetail().isAppurtenantLandChecked() != false && nonVacant == false ? this.propertyTypeMasterDAO.getPropertyTypeMasterByCode("VAC_LAND") : (PropertyTypeMaster)((Object)this.getPropPerServ().find("from PropertyTypeMaster PTM where PTM.id = ?", new Object[]{Long.valueOf(propTypeId)}));
        PropertyMutationMaster propMutMstr = (PropertyMutationMaster)this.getPropPerServ().find(FROM_PROPERTY_MUTATION_MASTER_WHERE_CODE, new Object[]{mutationCode});
        if (propUsageId != null) {
            PropertyUsage usage = (PropertyUsage)((Object)this.getPropPerServ().find(FROM_PROPERTY_USAGE_WHERE_ID, new Object[]{Long.valueOf(propUsageId)}));
            property.getPropertyDetail().setPropertyUsage(usage);
        } else {
            property.getPropertyDetail().setPropertyUsage(null);
        }
        if (propOccId != null) {
            PropertyOccupation occupancy = (PropertyOccupation)((Object)this.getPropPerServ().find(FROM_PROPERTY_OCCUPATION_WHERE_ID, new Object[]{Long.valueOf(propOccId)}));
            property.getPropertyDetail().setPropertyOccupation(occupancy);
        } else {
            property.getPropertyDetail().setPropertyOccupation(null);
        }
        property.getPropertyDetail().setPropertyType(propTypeMstr.getCode().equals("VAC_LAND") ? "VacantProperty" : "BuiltUpProperty");
        property.getPropertyDetail().setPropertyTypeMaster(propTypeMstr);
        property.getPropertyDetail().setPropertyMutationMaster(propMutMstr);
        property.getPropertyDetail().setUpdatedTime(new Date());
        if (!property.getPropertyDetail().isAppurtenantLandChecked().booleanValue() || property.getPropertyDetail().isAppurtenantLandChecked().booleanValue() && nonVacant.booleanValue()) {
            this.createFloors(property, mutationCode, propUsageId, propOccId);
        }
        property.setStatus(status);
        property.setIsDefaultProperty(PropertyTaxConstants.PROPERTY_IS_DEFAULT);
        property.setInstallment(this.currentInstall);
        property.setEffectiveDate(this.currentInstall.getFromDate());
        property.setPropertySource(propertySource);
        if (StringUtils.isBlank((CharSequence)property.getSource())) {
            property.setSource(this.propertyTaxCommonUtils.setSourceOfProperty(this.securityUtils.getCurrentUser(), "Anonymous".equalsIgnoreCase(this.securityUtils.getCurrentUser().getName())));
        }
        property.setDocNumber(docnumber);
        if (property.getApplicationNo() == null) {
            property.setApplicationNo(this.applicationNumberGenerator.generate());
        }
        LOGGER.debug((Object)"Exiting from createProperty");
        if (propertyDepartmentId != null && propertyDepartmentId != -1L) {
            PropertyDepartment propertyDepartment = (PropertyDepartment)((Object)this.ptDepartmentRepository.findOne(propertyDepartmentId));
            property.getPropertyDetail().setPropertyDepartment(propertyDepartment);
        } else {
            property.getPropertyDetail().setPropertyDepartment(null);
        }
        if (vacantLandPlotAreaId != null) {
            property.getPropertyDetail().setVacantLandPlotArea((VacantLandPlotArea)((Object)this.vacantLandPlotAreaRepository.findOne(vacantLandPlotAreaId)));
        } else {
            property.getPropertyDetail().setVacantLandPlotArea(null);
        }
        if (layoutApprovalAuthorityId != null) {
            property.getPropertyDetail().setLayoutApprovalAuthority((LayoutApprovalAuthority)((Object)this.layoutApprovalAuthorityRepository.findOne(layoutApprovalAuthorityId)));
        } else {
            property.getPropertyDetail().setLayoutApprovalAuthority(null);
        }
        return property;
    }

    public void createFloors(Property property, String mutationCode, String propUsageId, String propOccId) {
        LOGGER.debug((Object)"Entered into createFloors");
        LOGGER.debug((Object)("createFloors: Property: " + property + ", mutationCode: " + mutationCode + ", propUsageId: " + propUsageId + ", propOccId: " + propOccId));
        Area totBltUpArea = new Area();
        Float totBltUpAreaVal = new Float(0.0f);
        if (!property.getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND")) {
            property.getPropertyDetail().getFloorDetails().clear();
            int floorUid = 1;
            for (Floor floor : property.getPropertyDetail().getFloorDetailsProxy()) {
                if (floor == null) continue;
                totBltUpAreaVal = Float.valueOf(totBltUpAreaVal.floatValue() + floor.getBuiltUpArea().getArea().floatValue());
                PropertyTypeMaster unitType = null;
                PropertyUsage usage = null;
                PropertyOccupation occupancy = null;
                if (floor.getUnitType() != null) {
                    unitType = (PropertyTypeMaster)((Object)this.getPropPerServ().find("from PropertyTypeMaster utype where utype.id = ?", new Object[]{floor.getUnitType().getId()}));
                }
                if (floor.getPropertyUsage() != null) {
                    usage = (PropertyUsage)((Object)this.getPropPerServ().find(FROM_PROPERTY_USAGE_WHERE_ID, new Object[]{floor.getPropertyUsage().getId()}));
                }
                if (floor.getPropertyOccupation() != null) {
                    occupancy = (PropertyOccupation)((Object)this.getPropPerServ().find(FROM_PROPERTY_OCCUPATION_WHERE_ID, new Object[]{floor.getPropertyOccupation().getId()}));
                }
                StructureClassification structureClass = null;
                if (floor.getStructureClassification() != null) {
                    structureClass = (StructureClassification)((Object)this.getPropPerServ().find("from StructureClassification sc where sc.id = ?", new Object[]{floor.getStructureClassification().getId()}));
                }
                if (floor.getOccupancyDate() != null && floor.getConstructionDate() != null) {
                    floor.setDepreciationMaster(this.propertyTaxUtil.getDepreciationByDate(floor.getConstructionDate(), floor.getOccupancyDate()));
                }
                LOGGER.debug((Object)("createFloors: PropertyUsage: " + (Object)((Object)usage) + ", PropertyOccupation: " + (Object)((Object)occupancy) + ", StructureClass: " + (Object)((Object)structureClass)));
                if (unitType != null && unitType.getCode().equalsIgnoreCase("OPEN_PLOT")) {
                    floor.setFloorNo(PropertyTaxConstants.OPEN_PLOT_UNIT_FLOORNUMBER);
                }
                floor.setUnitType(unitType);
                floor.setPropertyUsage(usage);
                floor.setPropertyOccupation(occupancy);
                floor.setStructureClassification(structureClass);
                floor.setPropertyDetail(property.getPropertyDetail());
                floor.setCreatedDate(new Date());
                floor.setModifiedDate(new Date());
                floor.setFloorUid(floorUid++);
                User user = this.userService.getUserById(ApplicationThreadLocals.getUserId());
                floor.setCreatedBy(user);
                floor.setModifiedBy(user);
                property.getPropertyDetail().getFloorDetails().add(floor);
                totBltUpArea.setArea(totBltUpAreaVal);
                totBltUpArea.setLength(floor.getBuiltUpArea().getLength());
                totBltUpArea.setBreadth(floor.getBuiltUpArea().getBreadth());
                property.getPropertyDetail().setTotalBuiltupArea(totBltUpArea);
            }
            property.getPropertyDetail().setNoofFloors(property.getPropertyDetail().getFloorDetailsProxy().size());
        } else {
            property.getPropertyDetail().setNoofFloors(0);
            property.getPropertyDetail().getFloorDetails().clear();
            totBltUpArea.setArea(totBltUpAreaVal);
            property.getPropertyDetail().setTotalBuiltupArea(totBltUpArea);
        }
        LOGGER.debug((Object)"Exiting from createFloors");
    }

    public PropertyStatusValues createPropStatVal(BasicProperty basicProperty, String statusCode, Date propCompletionDate, String courtOrdNum, Date orderDate, String judgmtDetails, String parentPropId) {
        LOGGER.debug((Object)"Entered into createPropStatVal");
        LOGGER.debug((Object)("createPropStatVal: basicProperty: " + basicProperty + ", statusCode: " + statusCode + ", propCompletionDate: " + propCompletionDate + ", courtOrdNum: " + courtOrdNum + ", orderDate: " + orderDate + ", judgmtDetails: " + judgmtDetails + ", parentPropId: " + parentPropId));
        PropertyStatusValues propStatVal = new PropertyStatusValues();
        PropertyStatus propertyStatus = (PropertyStatus)this.getPropPerServ().find("from PropertyStatus where statusCode=?", new Object[]{statusCode});
        propStatVal.setIsActive("Y");
        User user = this.userService.getUserById(ApplicationThreadLocals.getUserId());
        propStatVal.setCreatedDate(new Date());
        propStatVal.setModifiedDate(new Date());
        propStatVal.setCreatedBy(user);
        propStatVal.setModifiedBy(user);
        propStatVal.setPropertyStatus(propertyStatus);
        if (orderDate != null || courtOrdNum != null && !courtOrdNum.equals("") || judgmtDetails != null && !judgmtDetails.equals("")) {
            propStatVal.setReferenceDate(orderDate);
            propStatVal.setReferenceNo(courtOrdNum);
            propStatVal.setRemarks(judgmtDetails);
        } else {
            propStatVal.setReferenceDate(new Date());
            propStatVal.setReferenceNo("0001");
        }
        if (!statusCode.equals("CREATE") && propCompletionDate != null) {
            String propCompDateStr = DateUtils.getFormattedDate((Date)propCompletionDate, (String)"dd/MM/yyyy");
            propStatVal.setExtraField1(propCompDateStr);
        }
        propStatVal.setBasicProperty(basicProperty);
        if (basicProperty.getPropertyMutationMaster() != null && basicProperty.getPropertyMutationMaster().getCode().equals("BIFUR")) {
            BasicProperty referenceBasicProperty = (BasicProperty)this.propPerServ.find("from BasicPropertyImpl bp where bp.upicNo=?", new Object[]{parentPropId});
            propStatVal.setReferenceBasicProperty(referenceBasicProperty);
        }
        LOGGER.debug((Object)("createPropStatVal: PropertyStatusValues: " + (Object)((Object)propStatVal)));
        LOGGER.debug((Object)"Exiting from createPropStatVal");
        return propStatVal;
    }

    public Property createDemand(PropertyImpl property, Date dateOfCompletion) throws TaxCalculatorExeption {
        APTaxCalculationInfo taxCalcInfo;
        LOGGER.debug((Object)"Entered into createDemand");
        LOGGER.debug((Object)("createDemand: Property: " + property + ", dateOfCompletion: " + dateOfCompletion));
        this.instTaxMap = this.taxCalculator.calculatePropertyTax(property, dateOfCompletion);
        HashSet<Ptdemand> ptDmdSet = new HashSet<Ptdemand>();
        ArrayList<Installment> instList = new ArrayList<Installment>(this.instTaxMap.keySet());
        LOGGER.debug((Object)("createDemand: instList: " + instList));
        this.currentInstall = this.propertyTaxCommonUtils.getCurrentInstallment();
        property.getPtDemandSet().clear();
        Map<String, Installment> yearwiseInstMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
        Installment installmentFirstHalf = yearwiseInstMap.get("Current 1st Half");
        Installment installmentSecondHalf = yearwiseInstMap.get("Current 2nd Half");
        if (instList.size() == 1 && ((Installment)instList.get(0)).equals((Object)installmentSecondHalf)) {
            taxCalcInfo = (APTaxCalculationInfo)this.instTaxMap.get(installmentSecondHalf);
        } else if (dateOfCompletion.after(installmentSecondHalf.getToDate())) {
            taxCalcInfo = (APTaxCalculationInfo)this.instTaxMap.get(installmentSecondHalf);
            instList.remove(installmentSecondHalf);
        } else {
            taxCalcInfo = (APTaxCalculationInfo)this.instTaxMap.get(installmentFirstHalf);
        }
        Set<EgDemandDetails> dmdDetailSet = this.createAllDmdDetails(instList, this.instTaxMap);
        PTDemandCalculations ptDmdCalc = new PTDemandCalculations();
        Ptdemand ptDemand = new Ptdemand();
        ptDemand.setBaseDemand(taxCalcInfo.getTotalTaxPayable());
        ptDemand.setCreateDate(new Date());
        ptDemand.setModifiedDate(new Date());
        ptDemand.setEgInstallmentMaster(installmentFirstHalf);
        ptDemand.setEgDemandDetails(dmdDetailSet);
        ptDemand.setIsHistory("N");
        ptDemand.setEgptProperty(property);
        ptDmdSet.add(ptDemand);
        ptDmdCalc.setPtDemand(ptDemand);
        ptDmdCalc.setPropertyTax(taxCalcInfo.getTotalTaxPayable());
        ptDmdCalc.setTaxInfo(taxCalcInfo.getTaxCalculationInfoXML().getBytes());
        this.propPerServ.applyAuditing((BaseModel)ptDmdCalc);
        ptDemand.setDmdCalculations(ptDmdCalc);
        if (property.getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND")) {
            ptDmdCalc.setAlv(taxCalcInfo.getTotalNetARV());
        } else if (installmentFirstHalf.equals((Object)this.currentInstall)) {
            for (Floor floor : property.getPropertyDetail().getFloorDetails()) {
                ptDmdCalc.addFlrwiseDmdCalculations(this.createFloorDmdCalc(ptDmdCalc, floor, taxCalcInfo));
            }
            ptDmdCalc.setAlv(this.totalAlv);
        }
        property.getPtDemandSet().addAll(ptDmdSet);
        LOGGER.debug((Object)"Exiting from createDemand");
        return property;
    }

    public Property createDemandForModify(Property oldProperty, Property newProperty, Date dateOfCompletion) {
        LOGGER.debug((Object)"Entered into createDemandForModify");
        LOGGER.debug((Object)("createDemandForModify: oldProperty: " + oldProperty + ", newProperty: " + newProperty + ", dateOfCompletion: " + dateOfCompletion));
        ArrayList<Installment> instList = new ArrayList<Installment>(this.instTaxMap.keySet());
        LOGGER.debug((Object)("createDemandForModify: instList: " + instList));
        Map<String, Installment> yearwiseInstMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
        Installment installmentFirstHalf = yearwiseInstMap.get("Current 1st Half");
        Installment installmentSecondHalf = yearwiseInstMap.get("Current 2nd Half");
        Map<String, Ptdemand> oldPtdemandMap = this.getPtdemandsAsInstMap(oldProperty.getPtDemandSet());
        Ptdemand ptDemandOld = oldPtdemandMap.get(installmentFirstHalf.getDescription());
        PropertyTypeMaster oldPropTypeMaster = oldProperty.getPropertyDetail().getPropertyTypeMaster();
        PropertyTypeMaster newPropTypeMaster = newProperty.getPropertyDetail().getPropertyTypeMaster();
        if (!oldProperty.getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase(newProperty.getPropertyDetail().getPropertyTypeMaster().getCode()) || oldProperty.getIsExemptedFromTax() == false ^ newProperty.getIsExemptedFromTax() == false) {
            this.createAllDmdDetails(oldProperty, newProperty, installmentFirstHalf, instList, this.instTaxMap);
        }
        Map<String, Ptdemand> newPtdemandMap = this.getPtdemandsAsInstMap(newProperty.getPtDemandSet());
        Ptdemand ptDemandNew = newPtdemandMap.get(installmentFirstHalf.getDescription());
        Map<Installment, Set<EgDemandDetails>> newDemandDtlsMap = this.getEgDemandDetailsSetAsMap(new ArrayList<EgDemandDetails>(ptDemandNew.getEgDemandDetails()), instList);
        for (Installment inst : instList) {
            this.carryForwardCollection(newProperty, inst, newDemandDtlsMap.get(inst), ptDemandOld, oldPropTypeMaster, newPropTypeMaster);
            if (instList.size() == 1 && ((Installment)instList.get(0)).equals((Object)installmentSecondHalf)) {
                this.carryForwardPenalty(ptDemandOld, ptDemandNew, installmentFirstHalf);
                continue;
            }
            if (!inst.equals((Object)this.currentInstall)) continue;
            this.carryForwardPenalty(ptDemandOld, ptDemandNew, inst);
        }
        LOGGER.info((Object)("before adjustExcessCollAmt newDemandDtlsMap.size: " + newDemandDtlsMap.size()));
        Collections.sort(instList);
        if (!this.excessCollAmtMap.isEmpty()) {
            this.adjustExcessCollectionAmount(instList, newDemandDtlsMap, ptDemandNew);
        }
        LOGGER.debug((Object)"Exiting from createDemandForModify");
        return newProperty;
    }

    private void carryForwardPenalty(Ptdemand ptDemandOld, Ptdemand ptDemandNew, Installment inst) {
        List<EgDemandDetails> penaltyDmdDtlsList = this.getEgDemandDetailsListForReason(ptDemandOld.getEgDemandDetails(), "PENALTY_FINES");
        if (penaltyDmdDtlsList != null && !penaltyDmdDtlsList.isEmpty()) {
            for (EgDemandDetails penaltyDmdDet : penaltyDmdDtlsList) {
                ptDemandNew.getEgDemandDetails().add((EgDemandDetails)penaltyDmdDet.clone());
            }
        }
        if ((penaltyDmdDtlsList = this.getEgDemandDetailsListForReason(ptDemandOld.getEgDemandDetails(), "CHQ_BUNC_PENALTY")) != null && !penaltyDmdDtlsList.isEmpty()) {
            for (EgDemandDetails penaltyDmdDet : penaltyDmdDtlsList) {
                ptDemandNew.getEgDemandDetails().add((EgDemandDetails)penaltyDmdDet.clone());
            }
        }
    }

    public Property modifyDemand(PropertyImpl propertyModel, PropertyImpl oldProperty) throws TaxCalculatorExeption {
        Date propCompletionDate = !propertyModel.getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND") ? this.getLowestDtOfCompFloorWise(propertyModel.getPropertyDetail().getFloorDetails()) : propertyModel.getPropertyDetail().getDateOfCompletion();
        PropertyImpl newProperty = (PropertyImpl)this.createDemand(propertyModel, propCompletionDate);
        Property modProperty = null;
        if (oldProperty == null) {
            LOGGER.info((Object)"modifyBasicProp, Could not get the previous property. DCB for arrears will be incorrect");
        } else {
            modProperty = this.createDemandForModify(oldProperty, newProperty, propCompletionDate);
            modProperty = this.createArrearsDemand(oldProperty, propCompletionDate, newProperty);
        }
        Set<EgDemandDetails> oldEgDemandDetailsSet = this.getOldDemandDetails(oldProperty, newProperty);
        Map<Installment, Set<EgDemandDetails>> demandDetailsSetByInstallment = this.getEgDemandDetailsSetByInstallment(oldEgDemandDetailsSet);
        ArrayList<Installment> installments = new ArrayList<Installment>(demandDetailsSetByInstallment.keySet());
        Collections.sort(installments);
        for (Installment inst : installments) {
            LinkedHashMap<String, BigDecimal> dmdRsnAmt = new LinkedHashMap<String, BigDecimal>();
            for (String rsn : PropertyTaxConstants.DEMAND_RSNS_LIST) {
                EgDemandDetails newDmndDtls = this.getEgDemandDetailsForReason(demandDetailsSetByInstallment.get(inst), rsn);
                if (newDmndDtls == null || newDmndDtls.getAmtCollected() == null || newDmndDtls.getAmtCollected().compareTo(BigDecimal.ZERO) <= 0) continue;
                dmdRsnAmt.put(newDmndDtls.getEgDemandReason().getEgDemandReasonMaster().getCode(), newDmndDtls.getAmtCollected());
            }
            this.getExcessCollAmtMap().put(inst, dmdRsnAmt);
        }
        Ptdemand currentDemand = this.getCurrrentDemand(modProperty);
        demandDetailsSetByInstallment = this.getEgDemandDetailsSetByInstallment(currentDemand.getEgDemandDetails());
        installments = new ArrayList<Installment>(demandDetailsSetByInstallment.keySet());
        Collections.sort(installments);
        for (Installment inst : installments) {
            LinkedHashMap<String, BigDecimal> dmdRsnAmt = new LinkedHashMap<String, BigDecimal>();
            for (String rsn : PropertyTaxConstants.DEMAND_RSNS_LIST) {
                BigDecimal extraCollAmt;
                EgDemandDetails newDmndDtls = this.getEgDemandDetailsForReason(demandDetailsSetByInstallment.get(inst), rsn);
                if (newDmndDtls == null || newDmndDtls.getAmtCollected() == null || (extraCollAmt = newDmndDtls.getAmtCollected().subtract(newDmndDtls.getAmount())).compareTo(BigDecimal.ZERO) <= 0) continue;
                dmdRsnAmt.put(newDmndDtls.getEgDemandReason().getEgDemandReasonMaster().getCode(), extraCollAmt);
                newDmndDtls.setAmtCollected(newDmndDtls.getAmtCollected().subtract(extraCollAmt));
                newDmndDtls.setModifiedDate(new Date());
            }
            this.getExcessCollAmtMap().put(inst, dmdRsnAmt);
        }
        LOGGER.info((Object)("Excess Collection - " + this.getExcessCollAmtMap()));
        this.adjustExcessCollectionAmount(installments, demandDetailsSetByInstallment, currentDemand);
        return modProperty;
    }

    private Set<EgDemandDetails> getOldDemandDetails(Property oldProperty, Property newProperty) {
        HashSet<EgDemandDetails> oldDemandDetails = new HashSet<EgDemandDetails>();
        for (EgDemandDetails dd : this.getCurrrentDemand(oldProperty).getEgDemandDetails()) {
            if (!dd.getEgDemandReason().getEgInstallmentMaster().getFromDate().before(newProperty.getEffectiveDate())) continue;
            oldDemandDetails.add(dd);
        }
        return oldDemandDetails;
    }

    private Map<Installment, Set<EgDemandDetails>> getEgDemandDetailsSetByInstallment(Set<EgDemandDetails> demandDetailsSet) {
        HashMap<Installment, Set<EgDemandDetails>> newEgDemandDetailsSetByInstallment = new HashMap<Installment, Set<EgDemandDetails>>();
        for (EgDemandDetails dd : demandDetailsSet) {
            if (dd.getAmtCollected() == null) {
                dd.setAmtCollected(BigDecimal.ZERO);
            }
            if (newEgDemandDetailsSetByInstallment.get(dd.getEgDemandReason().getEgInstallmentMaster()) == null) {
                HashSet<EgDemandDetails> ddSet = new HashSet<EgDemandDetails>();
                ddSet.add(dd);
                newEgDemandDetailsSetByInstallment.put(dd.getEgDemandReason().getEgInstallmentMaster(), ddSet);
                continue;
            }
            ((Set)newEgDemandDetailsSetByInstallment.get(dd.getEgDemandReason().getEgInstallmentMaster())).add(dd);
        }
        return newEgDemandDetailsSetByInstallment;
    }

    private Ptdemand getCurrrentDemand(Property property) {
        Ptdemand currentDemand = null;
        for (Ptdemand ptdemand : property.getPtDemandSet()) {
            if (!ptdemand.getEgInstallmentMaster().equals((Object)this.propertyTaxCommonUtils.getCurrentInstallment())) continue;
            currentDemand = ptdemand;
            break;
        }
        return currentDemand;
    }

    public Date getPropOccupatedDate(String dateOfCompletion) {
        LOGGER.debug((Object)("Entered into getPropOccupatedDate, dateOfCompletion: " + dateOfCompletion));
        Date occupationDate = null;
        try {
            if (dateOfCompletion != null && !"".equals(dateOfCompletion)) {
                occupationDate = this.dateFormatter.parse(dateOfCompletion);
            }
        }
        catch (ParseException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        LOGGER.debug((Object)"Exiting from getPropOccupatedDate");
        return occupationDate;
    }

    private Set<EgDemandDetails> createAllDmdDetails(List<Installment> instList, HashMap<Installment, TaxCalculationInfo> instTaxMap) {
        LOGGER.debug((Object)"Entered into createAllDmdDeatails");
        HashSet<EgDemandDetails> dmdDetSet = new HashSet<EgDemandDetails>();
        for (Installment inst : instList) {
            TaxCalculationInfo taxCalcInfo = instTaxMap.get(inst);
            Map<String, BigDecimal> taxMap = this.taxCalculator.getMiscTaxesForProp(taxCalcInfo.getUnitTaxCalculationInfos());
            for (Map.Entry<String, BigDecimal> tax : taxMap.entrySet()) {
                EgDemandReason egDmdRsn = this.propertyTaxUtil.getDemandReasonByCodeAndInstallment(tax.getKey(), inst);
                dmdDetSet.add(this.createDemandDetails(tax.getValue(), egDmdRsn, inst));
            }
        }
        LOGGER.debug((Object)("createAllDmdDeatails: dmdDetSet: " + dmdDetSet));
        return dmdDetSet;
    }

    private void createAllDmdDetails(Property oldProperty, Property newProperty, Installment installment, List<Installment> instList, HashMap<Installment, TaxCalculationInfo> instTaxMap) {
        LOGGER.debug((Object)"Entered into createAllDmdDeatails");
        LOGGER.debug((Object)("createAllDmdDeatails: oldProperty: " + oldProperty + ", newProperty: " + newProperty + ",installment: " + installment + ", instList: " + instList));
        HashSet<EgDemandDetails> adjustedDmdDetailsSet = new HashSet<EgDemandDetails>();
        Map<String, Ptdemand> oldPtdemandMap = this.getPtdemandsAsInstMap(oldProperty.getPtDemandSet());
        Map<String, Ptdemand> newPtdemandMap = this.getPtdemandsAsInstMap(newProperty.getPtDemandSet());
        ArrayList<String> adjstmntReasons = new ArrayList<String>(){
            private static final long serialVersionUID = 860234856101419601L;
            {
                this.add("GEN_TAX");
                this.add("VAC_LAND_TAX");
                this.add("LIB_CESS");
                this.add("SEW_TAX");
                this.add("EDU_CESS");
            }
        };
        ArrayList<String> rsnsForNewResProp = new ArrayList<String>(){
            private static final long serialVersionUID = -1654413629447625291L;
            {
                this.add("GEN_TAX");
                this.add("VAC_LAND_TAX");
                this.add("LIB_CESS");
                this.add("SEW_TAX");
                this.add("EDU_CESS");
            }
        };
        new ArrayList<String>(){
            private static final long serialVersionUID = -8513477823231046385L;
            {
                this.add("GEN_TAX");
                this.add("VAC_LAND_TAX");
                this.add("LIB_CESS");
                this.add("SEW_TAX");
                this.add("EDU_CESS");
            }
        };
        Ptdemand ptDemandOld = oldPtdemandMap.get(installment.getDescription());
        Ptdemand ptDemandNew = newPtdemandMap.get(installment.getDescription());
        LOGGER.info((Object)("instList==========" + instList));
        Map<Installment, Set<EgDemandDetails>> oldDemandDtlsMap = this.getEgDemandDetailsSetAsMap(new ArrayList<EgDemandDetails>(ptDemandOld.getEgDemandDetails()), instList);
        LOGGER.info((Object)("oldDemandDtlsMap : " + oldDemandDtlsMap));
        for (Installment inst : instList) {
            HashSet<EgDemandDetails> oldEgDemandDetailsSet = new HashSet();
            oldEgDemandDetailsSet = oldDemandDtlsMap.get(inst);
            LOGGER.info((Object)("inst==========" + inst));
            Set<EgDemandDetails> demandDtls = this.demandDetails.get(inst);
            if (demandDtls != null) {
                for (EgDemandDetails dd : demandDtls) {
                    EgDemandDetails ddClone = (EgDemandDetails)dd.clone();
                    ddClone.setEgDemand((EgDemand)ptDemandNew);
                    adjustedDmdDetailsSet.add(ddClone);
                }
                continue;
            }
            Set<EgDemandDetails> newEgDemandDetailsSet = new HashSet<EgDemandDetails>();
            for (EgDemandDetails edd : ptDemandNew.getEgDemandDetails()) {
                if (!edd.getEgDemandReason().getEgInstallmentMaster().equals((Object)inst)) continue;
                newEgDemandDetailsSet.add((EgDemandDetails)edd.clone());
            }
            LOGGER.info((Object)("Old Demand Set:" + inst + "=" + oldEgDemandDetailsSet));
            LOGGER.info((Object)("New Demand set:" + inst + "=" + newEgDemandDetailsSet));
            if (!oldProperty.getIsExemptedFromTax().booleanValue() && !newProperty.getIsExemptedFromTax().booleanValue()) {
                for (int i = 0; i < adjstmntReasons.size(); ++i) {
                    String oldPropRsn = (String)adjstmntReasons.get(i);
                    EgDemandDetails newEgDmndDetails = this.getEgDemandDetailsForReason(newEgDemandDetailsSet, oldPropRsn);
                    if (newEgDmndDetails != null) continue;
                    String newPropRsn = (String)rsnsForNewResProp.get(i);
                    EgDemandDetails oldEgdmndDetails = this.getEgDemandDetailsForReason(oldEgDemandDetailsSet, oldPropRsn);
                    newEgDmndDetails = this.getEgDemandDetailsForReason(newEgDemandDetailsSet, newPropRsn);
                    if (newEgDmndDetails == null || oldEgdmndDetails == null) continue;
                    newEgDmndDetails.setAmtCollected(newEgDmndDetails.getAmtCollected().add(oldEgdmndDetails.getAmtCollected()));
                }
            } else if (!oldProperty.getIsExemptedFromTax().booleanValue()) {
                newEgDemandDetailsSet = this.adjustmentsForTaxExempted(ptDemandOld.getEgDemandDetails(), newEgDemandDetailsSet, inst);
            }
            adjustedDmdDetailsSet.addAll(newEgDemandDetailsSet);
            this.demandDetails.put(inst, newEgDemandDetailsSet);
        }
        if (installment.equals((Object)installment)) {
            Ptdemand ptdOld = oldPtdemandMap.get(installment.getDescription());
            Ptdemand ptdNew = newPtdemandMap.get(installment.getDescription());
            ptdNew.setAmtCollected(ptdOld.getAmtCollected());
        }
        LOGGER.info((Object)("Exit from PropertyService.createAllDmdDeatails, Modify Adjustments for " + oldProperty.getBasicProperty().getUpicNo() + " And installment : " + installment + "\n\n" + adjustedDmdDetailsSet));
        ptDemandNew.setEgDemandDetails(adjustedDmdDetailsSet);
        LOGGER.debug((Object)"Exiting from createAllDmdDeatails");
    }

    private Set<EgDemandDetails> carryForwardCollection(Property newProperty, Installment inst, Set<EgDemandDetails> newEgDemandDetailsSet, Ptdemand ptDmndOld, PropertyTypeMaster oldPropTypeMaster, PropertyTypeMaster newPropTypeMaster) {
        LOGGER.debug((Object)"Entered into carryForwardCollection");
        LOGGER.debug((Object)("carryForwardCollection: newProperty: " + newProperty + ", inst: " + inst + ", newEgDemandDetailsSet: " + newEgDemandDetailsSet + ", ptDmndOld: " + (Object)((Object)ptDmndOld) + ", oldPropTypeMaster: " + (Object)((Object)oldPropTypeMaster) + ", newPropTypeMaster: " + (Object)((Object)newPropTypeMaster)));
        LinkedHashMap<String, BigDecimal> dmdRsnAmt = new LinkedHashMap<String, BigDecimal>();
        ArrayList<String> demandReasonsWithAdvance = new ArrayList<String>(PropertyTaxConstants.DEMAND_RSNS_LIST);
        demandReasonsWithAdvance.add("ADVANCE");
        for (String rsn : demandReasonsWithAdvance) {
            List<EgDemandDetails> oldEgDmndDtlsList = this.getEgDemandDetailsListForReason(ptDmndOld.getEgDemandDetails(), rsn);
            List<EgDemandDetails> newEgDmndDtlsList = this.getEgDemandDetailsListForReason(newEgDemandDetailsSet, rsn);
            EgDemandDetails oldDmndDtls = null;
            EgDemandDetails newDmndDtls = null;
            if (oldEgDmndDtlsList != null) {
                Map<Installment, EgDemandDetails> oldDemandDtlsMap = this.getEgDemandDetailsAsMap(oldEgDmndDtlsList);
                oldDmndDtls = oldDemandDtlsMap.get(inst);
            }
            if (newEgDmndDtlsList != null) {
                Map<Installment, EgDemandDetails> newDemandDtlsMap = this.getEgDemandDetailsAsMap(newEgDmndDtlsList);
                newDmndDtls = newDemandDtlsMap.get(inst);
            }
            this.calculateExcessCollection(dmdRsnAmt, rsn, oldDmndDtls, newDmndDtls);
        }
        this.excessCollAmtMap.put(inst, dmdRsnAmt);
        this.demandDetails.put(inst, newEgDemandDetailsSet);
        LOGGER.debug((Object)("carryForwardCollection: newEgDemandDetailsSet: " + newEgDemandDetailsSet));
        LOGGER.debug((Object)"Exiting from carryForwardCollection");
        return newEgDemandDetailsSet;
    }

    public void calculateExcessCollection(Map<String, BigDecimal> dmdRsnAmt, String rsn, EgDemandDetails oldDmndDtls, EgDemandDetails newDmndDtls) {
        BigDecimal extraCollAmt;
        if (newDmndDtls != null && oldDmndDtls != null) {
            newDmndDtls.setAmtCollected(newDmndDtls.getAmtCollected().add(oldDmndDtls.getAmtCollected()));
            newDmndDtls.setAmtRebate(newDmndDtls.getAmtRebate().add(oldDmndDtls.getAmtRebate()));
        } else if (newDmndDtls != null && oldDmndDtls == null) {
            newDmndDtls.setAmtCollected(BigDecimal.ZERO);
            newDmndDtls.setAmtRebate(BigDecimal.ZERO);
        }
        if (newDmndDtls != null && !rsn.equalsIgnoreCase("ADVANCE") && (extraCollAmt = newDmndDtls.getAmtCollected().subtract(newDmndDtls.getAmount())).compareTo(BigDecimal.ZERO) > 0) {
            dmdRsnAmt.put(rsn, extraCollAmt);
            newDmndDtls.setAmtCollected(newDmndDtls.getAmtCollected().subtract(extraCollAmt));
        }
        if (oldDmndDtls != null && newDmndDtls == null && oldDmndDtls.getAmtCollected().compareTo(BigDecimal.ZERO) > 0) {
            dmdRsnAmt.put(rsn, oldDmndDtls.getAmtCollected());
        }
    }

    private Map<String, Ptdemand> getPtdemandsAsInstMap(Set<Ptdemand> ptdemandSet) {
        LOGGER.debug((Object)("Entered into getPtDemandsAsInstMap, PtDemandSet: " + ptdemandSet));
        TreeMap<String, Ptdemand> ptDemandMap = new TreeMap<String, Ptdemand>();
        for (Ptdemand ptDmnd : ptdemandSet) {
            ptDemandMap.put(ptDmnd.getEgInstallmentMaster().getDescription(), ptDmnd);
        }
        LOGGER.debug((Object)("getPtDemandsAsInstMap, ptDemandMap: " + ptDemandMap));
        LOGGER.debug((Object)"Exiting from getPtDemandsAsInstMap");
        return ptDemandMap;
    }

    public Map<Installment, EgDemandDetails> getEgDemandDetailsAsMap(List<EgDemandDetails> demandDetailsList) {
        LOGGER.debug((Object)("Entered into getEgDemandDetailsAsMap, demandDetailsList: " + demandDetailsList));
        HashMap<Installment, EgDemandDetails> demandDetailsMap = new HashMap<Installment, EgDemandDetails>();
        for (EgDemandDetails dmndDtls : demandDetailsList) {
            demandDetailsMap.put(dmndDtls.getEgDemandReason().getEgInstallmentMaster(), dmndDtls);
        }
        LOGGER.debug((Object)("getEgDemandDetailsAsMap: demandDetailsMap: " + demandDetailsMap));
        LOGGER.debug((Object)"Exiting from getEgDemandDetailsAsMap");
        return demandDetailsMap;
    }

    public Map<Installment, Set<EgDemandDetails>> getEgDemandDetailsSetAsMap(List<EgDemandDetails> demandDetailsList, List<Installment> instList) {
        LOGGER.debug((Object)("Entered into getEgDemandDetailsSetAsMap, demandDetailsList: " + demandDetailsList + ", instList: " + instList));
        HashMap<Installment, Set<EgDemandDetails>> demandDetailsMap = new HashMap<Installment, Set<EgDemandDetails>>();
        for (Installment inst : instList) {
            HashSet<EgDemandDetails> ddSet = new HashSet<EgDemandDetails>();
            for (EgDemandDetails dd : demandDetailsList) {
                if (!dd.getEgDemandReason().getEgInstallmentMaster().equals((Object)inst)) continue;
                ddSet.add(dd);
            }
            demandDetailsMap.put(inst, ddSet);
        }
        LOGGER.debug((Object)("getEgDemandDetailsSetAsMap: demandDetailsMap: " + demandDetailsMap));
        LOGGER.debug((Object)"Exiting from getEgDemandDetailsSetAsMap");
        return demandDetailsMap;
    }

    public EgDemandDetails getEgDemandDetailsForReason(Set<EgDemandDetails> egDemandDetailsSet, String demandReason) {
        Map<String, EgDemandDetails> egDmndDtlsMap;
        LOGGER.debug((Object)("Entered into getEgDemandDetailsForReason, egDemandDetailsSet: " + egDemandDetailsSet + ", demandReason: " + demandReason));
        List<Map<String, EgDemandDetails>> egDemandDetailsList = this.getEgDemandDetailsAsMap(egDemandDetailsSet);
        EgDemandDetails egDemandDetails = null;
        Iterator<Map<String, EgDemandDetails>> iterator = egDemandDetailsList.iterator();
        while (iterator.hasNext() && (egDemandDetails = (egDmndDtlsMap = iterator.next()).get(demandReason)) == null) {
        }
        LOGGER.debug((Object)("getEgDemandDetailsForReason: egDemandDetails: " + egDemandDetails));
        LOGGER.debug((Object)"Exiting from getEgDemandDetailsForReason");
        return egDemandDetails;
    }

    private List<EgDemandDetails> getEgDemandDetailsListForReason(Set<EgDemandDetails> egDemandDetailsSet, String demandReason) {
        LOGGER.debug((Object)("Entered into getEgDemandDetailsListForReason: egDemandDetailsSet: " + egDemandDetailsSet + ", demandReason: " + demandReason));
        List<Map<String, EgDemandDetails>> egDemandDetailsList = this.getEgDemandDetailsAsMap(egDemandDetailsSet);
        ArrayList<EgDemandDetails> demandListForReason = new ArrayList<EgDemandDetails>();
        for (Map<String, EgDemandDetails> egDmndDtlsMap : egDemandDetailsList) {
            if (egDmndDtlsMap.get(demandReason) == null) continue;
            demandListForReason.add(egDmndDtlsMap.get(demandReason));
        }
        LOGGER.debug((Object)("getEgDemandDetailsListForReason: demandListForReason: " + demandListForReason));
        LOGGER.debug((Object)"Exiting from getEgDemandDetailsListForReason");
        return demandListForReason;
    }

    public List<Map<String, EgDemandDetails>> getEgDemandDetailsAsMap(Set<EgDemandDetails> egDemandDetailsSet) {
        LOGGER.debug((Object)("Entered into getEgDemandDetailsAsMap, egDemandDetailsSet: " + egDemandDetailsSet));
        ArrayList<EgDemandDetails> egDemandDetailsList = new ArrayList<EgDemandDetails>(egDemandDetailsSet);
        ArrayList<Map<String, EgDemandDetails>> egDemandDetailsListOfMap = new ArrayList<Map<String, EgDemandDetails>>();
        for (EgDemandDetails egDmndDtls : egDemandDetailsList) {
            HashMap<String, EgDemandDetails> egDemandDetailsMap = new HashMap<String, EgDemandDetails>();
            EgDemandReasonMaster dmndRsnMstr = egDmndDtls.getEgDemandReason().getEgDemandReasonMaster();
            if (dmndRsnMstr.getCode().equalsIgnoreCase("GEN_TAX")) {
                egDemandDetailsMap.put("GEN_TAX", egDmndDtls);
            } else if (dmndRsnMstr.getCode().equalsIgnoreCase("VAC_LAND_TAX")) {
                egDemandDetailsMap.put("VAC_LAND_TAX", egDmndDtls);
            } else if (dmndRsnMstr.getCode().equalsIgnoreCase("EDU_CESS")) {
                egDemandDetailsMap.put("EDU_CESS", egDmndDtls);
            } else if (dmndRsnMstr.getCode().equalsIgnoreCase("LIB_CESS")) {
                egDemandDetailsMap.put("LIB_CESS", egDmndDtls);
            } else if (dmndRsnMstr.getCode().equalsIgnoreCase("UNAUTH_PENALTY")) {
                egDemandDetailsMap.put("UNAUTH_PENALTY", egDmndDtls);
            } else if (dmndRsnMstr.getCode().equalsIgnoreCase("PENALTY_FINES")) {
                egDemandDetailsMap.put("PENALTY_FINES", egDmndDtls);
            } else if (dmndRsnMstr.getCode().equalsIgnoreCase("CHQ_BUNC_PENALTY")) {
                egDemandDetailsMap.put("CHQ_BUNC_PENALTY", egDmndDtls);
            } else if (dmndRsnMstr.getCode().equalsIgnoreCase("ADVANCE")) {
                egDemandDetailsMap.put("ADVANCE", egDmndDtls);
            }
            egDemandDetailsListOfMap.add(egDemandDetailsMap);
        }
        LOGGER.debug((Object)("egDemandDetailsListOfMap: " + egDemandDetailsListOfMap + "\n Exiting from getEgDemandDetailsAsMap"));
        return egDemandDetailsListOfMap;
    }

    private Set<EgDemandDetails> adjustmentsForTaxExempted(Set<EgDemandDetails> oldEgDemandDetails, Set<EgDemandDetails> newEgDemandDetails, Installment inst) {
        LOGGER.debug((Object)("Entered into adjustmentsForTaxExempted, oldEgDemandDetails: " + oldEgDemandDetails + ", newEgDemandDetails: " + newEgDemandDetails + ", inst:" + inst));
        BigDecimal totalCollAdjstmntAmnt = BigDecimal.ZERO;
        for (EgDemandDetails egDmndDtls : oldEgDemandDetails) {
            EgDemandReasonMaster egDmndRsnMstr;
            if (!egDmndDtls.getEgDemandReason().getEgInstallmentMaster().equals((Object)inst) || (egDmndRsnMstr = egDmndDtls.getEgDemandReason().getEgDemandReasonMaster()).getCode().equalsIgnoreCase("LIB_CESS") || egDmndRsnMstr.getCode().equalsIgnoreCase("EDU_CESS") || egDmndRsnMstr.getCode().equalsIgnoreCase("UNAUTH_PENALTY")) continue;
            totalCollAdjstmntAmnt = totalCollAdjstmntAmnt.add(egDmndDtls.getAmtCollected());
        }
        ArrayList<EgDemandDetails> newEgDmndDetails = new ArrayList<EgDemandDetails>(newEgDemandDetails);
        for (EgDemandDetails egDmndDtls : newEgDemandDetails) {
            EgDemandReasonMaster egDmndRsnMstr = egDmndDtls.getEgDemandReason().getEgDemandReasonMaster();
            if (egDmndRsnMstr.getCode().equalsIgnoreCase("EDU_CESS")) {
                egDmndDtls.setAmtCollected(totalCollAdjstmntAmnt.multiply(new BigDecimal("0.50")));
                continue;
            }
            if (egDmndRsnMstr.getCode().equalsIgnoreCase("LIB_CESS")) {
                egDmndDtls.setAmtCollected(totalCollAdjstmntAmnt.multiply(new BigDecimal("0.25")));
                continue;
            }
            if (!egDmndRsnMstr.getCode().equalsIgnoreCase("UNAUTH_PENALTY")) continue;
            egDmndDtls.setAmtCollected(totalCollAdjstmntAmnt.multiply(new BigDecimal("0.25")));
        }
        LOGGER.debug((Object)("newEgDmndDetails: " + newEgDmndDetails + "\nExiting from adjustmentsForTaxExempted"));
        return new HashSet<EgDemandDetails>(newEgDmndDetails);
    }

    private EgDemandDetails createDemandDetails(BigDecimal amount, EgDemandReason dmdRsn, Installment inst) {
        LOGGER.debug((Object)("Entered into createDemandDetails, amount: " + amount + ", dmdRsn: " + dmdRsn + ", inst: " + inst));
        EgDemandDetails demandDetail = new EgDemandDetails();
        demandDetail.setAmount(amount);
        demandDetail.setAmtCollected(BigDecimal.ZERO);
        demandDetail.setAmtRebate(BigDecimal.ZERO);
        demandDetail.setEgDemandReason(dmdRsn);
        demandDetail.setCreateDate(new Date());
        demandDetail.setModifiedDate(new Date());
        LOGGER.debug((Object)("demandDetail: " + demandDetail + "\nExiting from createDemandDetails"));
        return demandDetail;
    }

    public EgDemandDetails createDemandDetails(BigDecimal amount, BigDecimal amountCollected, EgDemandReason dmdRsn, Installment inst) {
        LOGGER.debug((Object)("Entered into createDemandDetails, amount: " + amount + "amountCollected: " + amountCollected + ", dmdRsn: " + dmdRsn + ", inst: " + inst));
        EgDemandDetails demandDetail = new EgDemandDetails();
        demandDetail.setAmount(amount != null ? amount : BigDecimal.ZERO);
        demandDetail.setAmtCollected(amountCollected != null ? amountCollected : BigDecimal.ZERO);
        demandDetail.setAmtRebate(BigDecimal.ZERO);
        demandDetail.setEgDemandReason(dmdRsn);
        demandDetail.setCreateDate(new Date());
        demandDetail.setModifiedDate(new Date());
        LOGGER.debug((Object)("demandDetail: " + demandDetail + "\nExiting from createDemandDetails"));
        return demandDetail;
    }

    private FloorwiseDemandCalculations createFloorDmdCalc(PTDemandCalculations ptDmdCal, Floor floor, TaxCalculationInfo taxCalcInfo) {
        LOGGER.debug((Object)("Entered into createFloorDmdCalc, ptDmdCal: " + (Object)((Object)ptDmdCal) + ", floor: " + (Object)((Object)floor) + ", taxCalcInfo: " + taxCalcInfo));
        FloorwiseDemandCalculations floorDmdCalc = new FloorwiseDemandCalculations();
        floorDmdCalc.setPTDemandCalculations(ptDmdCal);
        floorDmdCalc.setFloor(floor);
        for (UnitTaxCalculationInfo unitTax : taxCalcInfo.getUnitTaxCalculationInfos()) {
            if (!PropertyTaxConstants.FLOOR_MAP.get(floor.getFloorNo()).equals(unitTax.getFloorNumber()) || !floor.getPropertyUsage().getUsageCode().equalsIgnoreCase(unitTax.getUnitUsage()) || !floor.getPropertyOccupation().getOccupancyCode().equalsIgnoreCase(unitTax.getUnitOccupation()) || !floor.getStructureClassification().getConstrTypeCode().equalsIgnoreCase(unitTax.getUnitStructure()) || !floor.getBuiltUpArea().getArea().equals(Float.valueOf(unitTax.getFloorArea().toString()))) continue;
            this.setFloorDmdCalTax(unitTax, floorDmdCalc);
        }
        this.totalAlv = this.totalAlv.add(floorDmdCalc.getAlv());
        LOGGER.debug((Object)("floorDmdCalc: " + floorDmdCalc + "\nExiting from createFloorDmdCalc"));
        return floorDmdCalc;
    }

    public void setFloorDmdCalTax(UnitTaxCalculationInfo unitTax, FloorwiseDemandCalculations floorDmdCalc) {
        floorDmdCalc.setAlv(unitTax.getNetARV());
        floorDmdCalc.setMrv(unitTax.getMrv());
        floorDmdCalc.setCategoryAmt(unitTax.getBaseRate());
        floorDmdCalc.setTotalTaxPayble(unitTax.getTotalTaxPayable());
        for (MiscellaneousTax miscTax : unitTax.getMiscellaneousTaxes()) {
            if ("GEN_TAX".equals(miscTax.getTaxName())) {
                floorDmdCalc.setTax1(floorDmdCalc.getTax1().add(miscTax.getTotalCalculatedTax()));
                continue;
            }
            if ("VAC_LAND_TAX".equals(miscTax.getTaxName())) {
                floorDmdCalc.setTax2(floorDmdCalc.getTax2().add(miscTax.getTotalCalculatedTax()));
                continue;
            }
            if ("LIB_CESS".equals(miscTax.getTaxName())) {
                floorDmdCalc.setTax3(floorDmdCalc.getTax3().add(miscTax.getTotalCalculatedTax()));
                continue;
            }
            if ("EDU_CESS".equals(miscTax.getTaxName())) {
                floorDmdCalc.setTax4(floorDmdCalc.getTax4().add(miscTax.getTotalCalculatedTax()));
                continue;
            }
            if ("SEW_TAX".equals(miscTax.getTaxName())) {
                floorDmdCalc.setTax5(floorDmdCalc.getTax5().add(miscTax.getTotalCalculatedTax()));
                continue;
            }
            if ("UNAUTH_PENALTY".equals(miscTax.getTaxName())) {
                floorDmdCalc.setTax6(floorDmdCalc.getTax6().add(miscTax.getTotalCalculatedTax()));
                continue;
            }
            if (!"PRIMARY_SER_CHRG".equals(miscTax.getTaxName())) continue;
            floorDmdCalc.setTax7(floorDmdCalc.getTax7().add(miscTax.getTotalCalculatedTax()));
        }
    }

    public Date getLowestDtOfCompFloorWise(List<Floor> floorList) {
        LOGGER.debug((Object)("Entered into getLowestDtOfCompFloorWise, floorList: " + floorList));
        Date completionDate = null;
        for (Floor floor : floorList) {
            Date floorDate;
            if (floor == null || (floorDate = floor.getOccupancyDate()) == null) continue;
            if (completionDate == null) {
                completionDate = floorDate;
                continue;
            }
            if (!completionDate.after(floorDate)) continue;
            completionDate = floorDate;
        }
        LOGGER.debug((Object)("completionDate: " + completionDate + "\nExiting from getLowestDtOfCompFloorWise"));
        return completionDate;
    }

    public void createAmalgPropStatVal(String[] amalgPropIds, BasicProperty parentBasicProperty) {
        LOGGER.debug((Object)("Entered into createAmalgPropStatVal, amalgPropIds(length): " + (amalgPropIds != null ? Integer.valueOf(amalgPropIds.length) : BigDecimal.ZERO) + ", parentBasicProperty: " + parentBasicProperty));
        List activePropStatVal = this.propPerServ.findAllByNamedQuery("getPropStatValByUpicNoAndStatCodeAndISActive", new Object[]{parentBasicProperty.getUpicNo(), "Y", "CREATE"});
        LOGGER.debug((Object)("createAmalgPropStatVal: activePropStatVal: " + activePropStatVal));
        if (!activePropStatVal.isEmpty()) {
            for (PropertyStatusValues propstatval : activePropStatVal) {
                propstatval.setIsActive("N");
            }
        }
        for (String amalgId : amalgPropIds) {
            if (!StringUtils.isNotBlank((CharSequence)amalgId)) continue;
            BasicProperty amalgBasicProp = (BasicProperty)this.getPropPerServ().findByNamedQuery("getBasicPropertyByUpicNo", new Object[]{amalgId});
            PropertyStatusValues amalgPropStatVal = new PropertyStatusValues();
            PropertyStatus propertyStatus = (PropertyStatus)this.getPropPerServ().find("from PropertyStatus where statusCode=?", new Object[]{"MARK_DEACTIVE"});
            amalgPropStatVal.setIsActive("Y");
            amalgPropStatVal.setPropertyStatus(propertyStatus);
            amalgPropStatVal.setReferenceDate(new Date());
            amalgPropStatVal.setReferenceNo("0001");
            amalgPropStatVal.setRemarks("Property Amalgamated");
            amalgPropStatVal.setReferenceBasicProperty(parentBasicProperty);
            amalgBasicProp.setActive(Boolean.FALSE);
            amalgBasicProp.addPropertyStatusValues(amalgPropStatVal);
            amalgPropStatVal.setBasicProperty(amalgBasicProp);
            parentBasicProperty.addPropertyStatusValues(amalgPropStatVal);
        }
        LOGGER.debug((Object)"Exiting from createAmalgPropStatVal");
    }

    public Property createArrearsDemand(Property oldproperty, Date dateOfCompletion, PropertyImpl property) {
        LOGGER.debug((Object)("Entered into createArrearsDemand, oldproperty: " + oldproperty + ", dateOfCompletion: " + dateOfCompletion + ", property: " + property));
        Ptdemand currPtDmd = null;
        Ptdemand oldCurrPtDmd = null;
        Module module = this.moduleDao.getModuleByName("Property Tax");
        Installment effectiveInstall = this.installmentDao.getInsatllmentByModuleForGivenDate(module, dateOfCompletion);
        Installment currInstall = this.propertyTaxCommonUtils.getCurrentInstallment();
        for (Ptdemand demand : property.getPtDemandSet()) {
            if (!"N".equalsIgnoreCase(demand.getIsHistory()) || !demand.getEgInstallmentMaster().equals((Object)currInstall)) continue;
            currPtDmd = demand;
            break;
        }
        for (Ptdemand ptDmd : oldproperty.getPtDemandSet()) {
            if (!"N".equalsIgnoreCase(ptDmd.getIsHistory()) || !ptDmd.getEgInstallmentMaster().equals((Object)currInstall)) continue;
            oldCurrPtDmd = ptDmd;
        }
        this.addArrDmdDetToCurrentDmd(oldCurrPtDmd, currPtDmd, effectiveInstall, false);
        LOGGER.debug((Object)"Exiting from createArrearsDemand");
        return property;
    }

    public void addArrDmdDetToCurrentDmd(Ptdemand ptDmd, Ptdemand currPtDmd, Installment effectiveInstall, boolean isDemolition) {
        LOGGER.debug((Object)("Entered into addArrDmdDetToCurrentDmd. ptDmd: " + (Object)((Object)ptDmd) + ", currPtDmd: " + (Object)((Object)currPtDmd)));
        for (EgDemandDetails dmdDet : ptDmd.getEgDemandDetails()) {
            if (!dmdDet.getInstallmentStartDate().before(effectiveInstall.getFromDate())) continue;
            if (!isDemolition) {
                if (dmdDet.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("PENALTY_FINES")) continue;
                currPtDmd.addEgDemandDetails((EgDemandDetails)dmdDet.clone());
                continue;
            }
            currPtDmd.addEgDemandDetails((EgDemandDetails)dmdDet.clone());
        }
        LOGGER.debug((Object)"Exiting from addArrDmdDetToCurrentDmd");
    }

    public PropertyImpl creteNewPropertyForObjectionWorkflow(BasicProperty basicProperty2, String objectionNum, Date objectionDate, User objWfInitiator, String docNumber, String modifyRsn) {
        BasicProperty basicProperty = basicProperty2;
        basicProperty.setAllChangesCompleted(Boolean.FALSE);
        LOGGER.debug((Object)("initiateModifyWfForObjection: basicProperty: " + basicProperty));
        PropertyImpl oldProperty = (PropertyImpl)basicProperty.getProperty();
        PropertyImpl newProperty = (PropertyImpl)oldProperty.createPropertyclone();
        LOGGER.debug((Object)("initiateModifyWfForObjection: oldProperty: " + oldProperty + ", newProperty: " + newProperty));
        ArrayList<Floor> floorProxy = new ArrayList<Floor>();
        for (Floor floor : newProperty.getPropertyDetail().getFloorDetails()) {
            if (floor == null) continue;
            this.basicPropertyService.applyAuditing((BaseModel)floor);
            floor.setPropertyDetail(newProperty.getPropertyDetail());
            floorProxy.add(floor);
        }
        newProperty.getPropertyDetail().setFloorDetails(floorProxy);
        if (newProperty.getPropertyDetail().getPropertyOccupation() != null) {
            newProperty.getPropertyDetail().getPropertyOccupation().getId().toString();
        }
        if (newProperty.getPropertyDetail().getPropertyUsage() != null) {
            newProperty.getPropertyDetail().getPropertyUsage().getId().toString();
        }
        newProperty.setStatus(PropertyTaxConstants.STATUS_WORKFLOW);
        newProperty.setBasicProperty(basicProperty);
        newProperty.getPtDemandSet().clear();
        basicProperty.addProperty(newProperty);
        if (!newProperty.getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND")) {
            // empty if block
        }
        LOGGER.debug((Object)"Exiting from creteNewPropertyForObjectionWorkflow");
        return newProperty;
    }

    private Date getPropertyCompletionDate(BasicProperty basicProperty, PropertyImpl newProperty) {
        LOGGER.debug((Object)("Entered into getPropertyCompletionDate - basicProperty.upicNo=" + basicProperty.getUpicNo()));
        Date propCompletionDate = null;
        String propertyTypeMasterCode = newProperty.getPropertyDetail().getPropertyTypeMaster().getCode();
        if (propertyTypeMasterCode.equalsIgnoreCase("VAC_LAND")) {
            for (PropertyStatusValues propstatval : basicProperty.getPropertyStatusValuesSet()) {
                if (propstatval.getExtraField1() != null) {
                    try {
                        propCompletionDate = this.dateFormatter.parse(propstatval.getExtraField1());
                    }
                    catch (ParseException e) {
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                propCompletionDate = basicProperty.getPropOccupationDate();
            }
        } else {
            List<Floor> floorList = newProperty.getPropertyDetail().getFloorDetails();
            propCompletionDate = this.getLowestDtOfCompFloorWise(floorList);
            if (propCompletionDate == null) {
                propCompletionDate = basicProperty.getPropOccupationDate();
            }
        }
        LOGGER.debug((Object)("propCompletionDate=" + propCompletionDate + "\nExiting from getPropertyCompletionDate"));
        return propCompletionDate;
    }

    public PersistenceService getPropPerServ() {
        return this.propPerServ;
    }

    public void setPropPerServ(PersistenceService propPerServ) {
        this.propPerServ = propPerServ;
    }

    public APTaxCalculator getTaxCalculator() {
        return this.taxCalculator;
    }

    public void setTaxCalculator(APTaxCalculator taxCalculator) {
        this.taxCalculator = taxCalculator;
    }

    public PropertyTaxUtil getPropertyTaxUtil() {
        return this.propertyTaxUtil;
    }

    public void setPropertyTaxUtil(PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
    }

    public void setBasicPropertyService(PersistenceService<BasicProperty, Long> basicPropertyService) {
        this.basicPropertyService = basicPropertyService;
    }

    public void setWFPropStatValActive(BasicProperty basicProperty) {
        LOGGER.debug((Object)("Entered into setWFPropStatValActive, basicProperty: " + basicProperty));
        for (PropertyStatusValues psv : basicProperty.getPropertyStatusValuesSet()) {
            if ("ADD_OR_ALTER".equals(psv.getPropertyStatus().getStatusCode()) && "W".equals(psv.getIsActive())) {
                this.updateWFStatusValues(basicProperty, "ADD_OR_ALTER");
            }
            if ("AMALG".equals(psv.getPropertyStatus().getStatusCode()) && "W".equals(psv.getIsActive())) {
                this.updateWFStatusValues(basicProperty, "AMALG");
            }
            if ("BIFURCATE".equals(psv.getPropertyStatus().getStatusCode()) && "W".equals(psv.getIsActive())) {
                this.updateWFStatusValues(basicProperty, "BIFURCATE");
            }
            if ("RP".equals(psv.getPropertyStatus().getStatusCode()) && "W".equals(psv.getIsActive())) {
                this.updateWFStatusValues(basicProperty, "RP");
            }
            if (!"CREATE".equals(psv.getPropertyStatus().getStatusCode()) || !"W".equals(psv.getIsActive())) continue;
            psv.setIsActive("Y");
        }
        LOGGER.debug((Object)"Exitinf from setWFPropStatValActive");
    }

    private void updateWFStatusValues(BasicProperty basicProperty, String statusCode) {
        PropertyStatusValues wfPropStatVal;
        PropertyStatusValues activePropStatVal = (PropertyStatusValues)((Object)this.propPerServ.findByNamedQuery("getPropStatValByUpicNoAndStatCodeAndISActive", new Object[]{basicProperty.getUpicNo(), "Y", statusCode}));
        if (activePropStatVal != null) {
            activePropStatVal.setIsActive("N");
        }
        if ((wfPropStatVal = (PropertyStatusValues)((Object)this.propPerServ.findByNamedQuery("getPropStatValByUpicNoAndStatCodeAndISActive", new Object[]{basicProperty.getUpicNo(), "W", statusCode}))) != null) {
            wfPropStatVal.setIsActive("Y");
        }
    }

    public Map<Installment, Map<String, BigDecimal>> populateTaxesForVoucherCreation(Property property) {
        LOGGER.debug((Object)("Entered into populateTaxesForVoucherCreation, property: " + property));
        HashMap<Installment, Map<String, BigDecimal>> amounts = new HashMap();
        if (this.instTaxMap == null) {
            amounts = this.prepareRsnWiseDemandForOldProp(property);
        }
        LOGGER.debug((Object)("amounts: " + amounts + "\nExiting from populateTaxesForVoucherCreation"));
        return amounts;
    }

    public Map<Installment, Map<String, BigDecimal>> prepareRsnWiseDemandForOldProp(Property property) {
        LOGGER.debug((Object)("Entered into prepareRsnWiseDemandForOldProp, property: " + property));
        Installment inst = null;
        HashMap<Installment, Map<String, BigDecimal>> instWiseDmd = new HashMap<Installment, Map<String, BigDecimal>>();
        for (Ptdemand ptdemand : property.getPtDemandSet()) {
            if (!"N".equals(ptdemand.getIsHistory())) continue;
            inst = ptdemand.getEgInstallmentMaster();
            HashMap<String, BigDecimal> rsnWiseDmd = new HashMap<String, BigDecimal>();
            for (EgDemandDetails dmdDet : ptdemand.getEgDemandDetails()) {
                if (!inst.equals((Object)dmdDet.getEgDemandReason().getEgInstallmentMaster()) || dmdDet.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("PENALTY_FINES") || dmdDet.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("CHQ_BUNC_PENALTY")) continue;
                rsnWiseDmd.put(dmdDet.getEgDemandReason().getEgDemandReasonMaster().getCode(), dmdDet.getAmount());
            }
            instWiseDmd.put(inst, rsnWiseDmd);
        }
        LOGGER.debug((Object)"Exiting from prepareRsnWiseDemandForOldProp");
        return instWiseDmd;
    }

    public Map<Installment, Map<String, BigDecimal>> prepareRsnWiseDemandForPropToBeDeactivated(Property property) {
        LOGGER.debug((Object)("Entered into prepareRsnWiseDemandForPropToBeDeactivated, property: " + property));
        Map<Installment, Map<String, BigDecimal>> amts = this.prepareRsnWiseDemandForOldProp(property);
        for (Installment inst : amts.keySet()) {
            for (String dmdRsn : amts.get(inst).keySet()) {
                amts.get(inst).put(dmdRsn, amts.get(inst).get(dmdRsn).negate());
            }
        }
        LOGGER.debug((Object)("amts: " + amts + "\n Exiting from prepareRsnWiseDemandForPropToBeDeactivated"));
        return amts;
    }

    public void adjustExcessCollectionAmount(List<Installment> installments, Map<Installment, Set<EgDemandDetails>> newDemandDetailsByInstallment, Ptdemand ptDemand) {
        LOGGER.info((Object)"Entered into adjustExcessCollectionAmount");
        LOGGER.info((Object)("adjustExcessCollectionAmount: installments - " + installments + ", newDemandDetailsByInstallment.size - " + newDemandDetailsByInstallment.size()));
        LinkedHashSet<String> demandReasons = new LinkedHashSet<String>(Arrays.asList("PENALTY_FINES", "GEN_TAX", "VAC_LAND_TAX", "EDU_CESS", "LIB_CESS", "UNAUTH_PENALTY"));
        if (!this.excessCollAmtMap.isEmpty()) {
            this.adjustCollection(installments, newDemandDetailsByInstallment, demandReasons, ptDemand);
        }
        LOGGER.info((Object)"Excess collection adjustment is successfully completed..");
        LOGGER.debug((Object)"Exiting from adjustExcessCollectionAmount");
    }

    private Ptdemand adjustCollection(List<Installment> installments, Map<Installment, Set<EgDemandDetails>> newDemandDetailsByInstallment, Set<String> demandReasons, Ptdemand ptDemand) {
        LOGGER.info((Object)"Entered into adjustCollection");
        EgDemandDetails advanceDemandDetails = null;
        BigDecimal excessCollection = BigDecimal.ZERO;
        for (Map<String, BigDecimal> map : this.excessCollAmtMap.values()) {
            for (BigDecimal amount : map.values()) {
                excessCollection = excessCollection.add(amount);
            }
        }
        Installment currSecondHalf = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date()).get("Current 2nd Half");
        if (excessCollection.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal collection = BigDecimal.ZERO;
            for (EgDemandDetails demandDetials : ptDemand.getEgDemandDetails()) {
                if (advanceDemandDetails == null && "ADVANCE".equals(demandDetials.getEgDemandReason().getEgDemandReasonMaster().getCode()) && currSecondHalf.equals((Object)demandDetials.getEgDemandReason().getEgInstallmentMaster())) {
                    advanceDemandDetails = demandDetials;
                }
                if (demandDetials.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("PENALTY_FINES")) continue;
                collection = collection.add(demandDetials.getAmtCollected());
                demandDetials.setAmtCollected(BigDecimal.ZERO);
            }
            collection = collection.add(excessCollection);
            for (Installment installment : installments) {
                for (String demandReason : demandReasons) {
                    BigDecimal balanceDemand;
                    EgDemandDetails newDemandDetail = this.getEgDemandDetailsForReason(newDemandDetailsByInstallment.get(installment), demandReason);
                    if (newDemandDetail != null && (balanceDemand = newDemandDetail.getAmount().subtract(newDemandDetail.getAmtCollected())).compareTo(BigDecimal.ZERO) > 0 && collection.compareTo(BigDecimal.ZERO) > 0) {
                        if (collection.compareTo(balanceDemand) <= 0) {
                            newDemandDetail.setAmtCollected(newDemandDetail.getAmtCollected().add(collection));
                            newDemandDetail.setModifiedDate(new Date());
                            collection = BigDecimal.ZERO;
                        } else {
                            newDemandDetail.setAmtCollected(newDemandDetail.getAmtCollected().add(balanceDemand));
                            newDemandDetail.setModifiedDate(new Date());
                            collection = collection.subtract(balanceDemand);
                        }
                    }
                    if (collection.compareTo(BigDecimal.ZERO) != 0) continue;
                    break;
                }
                if (collection.compareTo(BigDecimal.ZERO) != 0) continue;
                break;
            }
            if (collection.compareTo(BigDecimal.ZERO) > 0) {
                if (advanceDemandDetails == null) {
                    EgDemandDetails demandDetails = this.ptBillServiceImpl.insertDemandDetails("ADVANCE", collection, currSecondHalf);
                    ptDemand.getEgDemandDetails().add(demandDetails);
                } else {
                    advanceDemandDetails.getAmtCollected().add(collection);
                }
            }
            LOGGER.info((Object)"Exiting from adjustCollection");
        }
        return ptDemand;
    }

    public void initiateDataEntryWorkflow(BasicProperty basicProperty, User initiater) {
        LOGGER.debug((Object)"Entered into initiateDataEntryWorkflow");
        PropertyImpl oldProperty = (PropertyImpl)basicProperty.getProperty();
        PropertyImpl newProperty = (PropertyImpl)oldProperty.createPropertyclone();
        Position owner = this.eisCommonsService.getPositionByUserId(initiater.getId());
        String desigName = this.propertyTaxUtil.getDesignationName(initiater.getId());
        String value = "Modify:" + desigName + "_" + "Approval_Pending";
        newProperty.transition().start().withSenderName(initiater.getName()).withComments(PROPERTY_WORKFLOW_STARTED).withStateValue(value).withOwner(owner).withDateInfo(new Date());
        PropertyMutationMaster propMutMstr = (PropertyMutationMaster)this.getPropPerServ().find(FROM_PROPERTY_MUTATION_MASTER_WHERE_CODE, new Object[]{"DATA_ENTRY"});
        newProperty.getPropertyDetail().setPropertyMutationMaster(propMutMstr);
        newProperty.setStatus(PropertyTaxConstants.STATUS_WORKFLOW);
        basicProperty.addProperty(newProperty);
        basicProperty.addPropertyStatusValues(this.createPropStatVal(basicProperty, "ADD_OR_ALTER", this.getPropertyCompletionDate(basicProperty, newProperty), null, null, null, null));
        basicProperty = (BasicProperty)this.basicPropertyService.update((Object)basicProperty);
        LOGGER.debug((Object)"Exiting from initiateDataEntryWorkflow");
    }

    public PropertyImpl changePropertyDetail(PropertyImpl modProperty, PropertyDetail propDetail, Integer numOfFloors) {
        LOGGER.debug((Object)"Entered into changePropertyDetail, Property is Vacant Land");
        PropertyDetail propertyDetail = modProperty.getPropertyDetail();
        propDetail.setSitalArea(propertyDetail.getSitalArea());
        propDetail.setTotalBuiltupArea(propertyDetail.getTotalBuiltupArea());
        propDetail.setCommBuiltUpArea(propertyDetail.getCommBuiltUpArea());
        propDetail.setPlinthArea(propertyDetail.getPlinthArea());
        propDetail.setCommVacantLand(propertyDetail.getCommVacantLand());
        propDetail.setCurrentCapitalValue(propertyDetail.getCurrentCapitalValue());
        propDetail.setSurveyNumber(propertyDetail.getSurveyNumber());
        propDetail.setFieldVerified(propertyDetail.getFieldVerified());
        propDetail.setFieldVerificationDate(propertyDetail.getFieldVerificationDate());
        propDetail.setFloorDetails(propertyDetail.getFloorDetails());
        propDetail.setPropertyDetailsID(propertyDetail.getPropertyDetailsID());
        propDetail.setWater_Meter_Num(propertyDetail.getWater_Meter_Num());
        propDetail.setElec_Meter_Num(propertyDetail.getElec_Meter_Num());
        propDetail.setNoofFloors(numOfFloors);
        propDetail.setFieldIrregular(propertyDetail.getFieldIrregular());
        propDetail.setDateOfCompletion(propertyDetail.getDateOfCompletion());
        propDetail.setProperty(propertyDetail.getProperty());
        propDetail.setUpdatedTime(propertyDetail.getUpdatedTime());
        propDetail.setPropertyTypeMaster(propertyDetail.getPropertyTypeMaster());
        propDetail.setPropertyType(propertyDetail.getPropertyType());
        propDetail.setInstallment(propertyDetail.getInstallment());
        propDetail.setPropertyOccupation(propertyDetail.getPropertyOccupation());
        propDetail.setPropertyMutationMaster(propertyDetail.getPropertyMutationMaster());
        propDetail.setComZone(propertyDetail.getComZone());
        propDetail.setCornerPlot(propertyDetail.getCornerPlot());
        if (numOfFloors == 0) {
            propDetail.setPropertyUsage(propertyDetail.getPropertyUsage());
        } else {
            propDetail.setPropertyUsage(null);
        }
        propDetail.setManualAlv(propertyDetail.getManualAlv());
        propDetail.setOccupierName(propertyDetail.getOccupierName());
        modProperty.setPropertyDetail(propDetail);
        LOGGER.debug((Object)"Exiting from changePropertyDetail");
        return modProperty;
    }

    public List<DocumentType> getDocumentTypesForTransactionType(TransactionType transactionType) {
        return this.documentTypePersistenceService.findAllByNamedQuery("DOCUMENTTYPE_BY_TRANSACTION_TYPE", new Object[]{transactionType});
    }

    public void processAndStoreDocument(List<Document> documents) {
        documents.forEach(document -> {
            if (!document.getUploads().isEmpty() && !document.getUploadsContentType().isEmpty()) {
                int fileCount = 0;
                if (!document.getFiles().isEmpty()) {
                    document.getFiles().clear();
                }
                for (File file : document.getUploads()) {
                    FileStoreMapper fileStore = this.fileStoreService.store(file, document.getUploadsFileName().get(fileCount), document.getUploadsContentType().get(fileCount++), "PTIS");
                    document.getFiles().add(fileStore);
                }
            }
            if (document.getId() == null || document.getType() == null) {
                document.setType((DocumentType)((Object)((Object)this.documentTypePersistenceService.load((Serializable)document.getType().getId(), DocumentType.class))));
            }
        });
    }

    public void updateIndexes(StateAware stateAwareObject, String applictionType) {
        Position position = stateAwareObject.getState().getOwnerPosition();
        Object user = position == null ? stateAwareObject.getState().getCreatedBy() : ((Assignment)this.assignmentService.getAssignmentsForPosition(position.getId(), new Date()).get(0)).getEmployee();
        if (!applictionType.isEmpty() && (applictionType.equalsIgnoreCase("New_Assessment") || applictionType.equalsIgnoreCase("Alter_Assessment") || applictionType.equalsIgnoreCase("Bifuracate_Assessment"))) {
            PropertyImpl property = (PropertyImpl)stateAwareObject;
            ApplicationIndex applicationIndex = this.applicationIndexService.findByApplicationNumber(property.getApplicationNo());
            User owner = property.getBasicProperty().getPrimaryOwner();
            String source = this.propertyTaxCommonUtils.getPropertySource(property);
            if (applicationIndex == null) {
                applicationIndex = ApplicationIndex.builder().withModuleName("Property Tax").withApplicationNumber(property.getApplicationNo()).withApplicationDate(property.getCreatedDate() != null ? property.getCreatedDate() : new Date()).withApplicationType(applictionType).withApplicantName(owner.getName()).withStatus(property.getState().getValue()).withUrl(String.format(APPLICATION_VIEW_URL, property.getApplicationNo(), applictionType)).withApplicantAddress(property.getBasicProperty().getAddress().toString()).withOwnername(user.getUsername() + "::" + user.getName()).withChannel(source).withMobileNumber(owner.getMobileNumber()).withAadharNumber(owner.getAadhaarNumber()).withConsumerCode(property.getBasicProperty().getUpicNo()).withClosed(property.getState().getValue().contains("Closed") ? ClosureStatus.YES : ClosureStatus.NO).withApproved(property.getState().getValue().contains("Commissioner Approved") ? ApprovalStatus.APPROVED : (property.getState().getValue().contains("Rejected") || property.getState().getValue().contains("Closed") ? ApprovalStatus.REJECTED : ApprovalStatus.INPROGRESS)).build();
                this.applicationIndexService.createApplicationIndex(applicationIndex);
            } else {
                applicationIndex.setStatus(property.getState().getValue());
                if (applictionType.equalsIgnoreCase("New_Assessment") || applictionType.equalsIgnoreCase("Alter_Assessment") || applictionType.equalsIgnoreCase("Bifuracate_Assessment") || applictionType.equalsIgnoreCase("General_Revision_Petition")) {
                    applicationIndex.setConsumerCode(property.getBasicProperty().getUpicNo());
                    applicationIndex.setApplicantName(owner.getName());
                    applicationIndex.setOwnerName(user.getUsername() + "::" + user.getName());
                    applicationIndex.setMobileNumber(owner.getMobileNumber());
                    applicationIndex.setAadharNumber(owner.getAadhaarNumber());
                    applicationIndex.setClosed(property.getState().getValue().contains("Closed") ? ClosureStatus.YES : ClosureStatus.NO);
                    applicationIndex.setApproved(property.getState().getValue().contains("Commissioner Approved") ? ApprovalStatus.APPROVED : (property.getState().getValue().contains("Rejected") || property.getState().getValue().contains("Closed") ? ApprovalStatus.REJECTED : ApprovalStatus.INPROGRESS));
                }
                this.applicationIndexService.updateApplicationIndex(applicationIndex);
            }
        } else if (!applictionType.isEmpty() && applictionType.equalsIgnoreCase("Revision_Petition")) {
            RevisionPetition property = (RevisionPetition)stateAwareObject;
            ApplicationIndex applicationIndex = this.applicationIndexService.findByApplicationNumber(property.getObjectionNumber());
            String source = this.propertyTaxCommonUtils.getObjectionSource(property);
            if (applicationIndex == null) {
                User owner = property.getBasicProperty().getPrimaryOwner();
                applicationIndex = ApplicationIndex.builder().withModuleName("Property Tax").withApplicationNumber(property.getObjectionNumber()).withApplicationDate(property.getCreatedDate() != null ? property.getCreatedDate() : new Date()).withApplicationType(applictionType).withApplicantName(owner.getName()).withStatus(property.getState().getValue()).withUrl(String.format(APPLICATION_VIEW_URL, property.getObjectionNumber(), applictionType)).withApplicantAddress(property.getBasicProperty().getAddress().toString()).withOwnername(user.getUsername() + "::" + user.getName()).withChannel(source).withMobileNumber(owner.getMobileNumber()).withAadharNumber(owner.getAadhaarNumber()).withConsumerCode(property.getBasicProperty().getUpicNo()).withClosed(property.getState().getValue().contains("Closed") ? ClosureStatus.YES : ClosureStatus.NO).withApproved(property.getState().getValue().contains("Commissioner Approved") ? ApprovalStatus.APPROVED : (property.getState().getValue().contains("Rejected") || property.getState().getValue().contains("Closed") ? ApprovalStatus.REJECTED : ApprovalStatus.INPROGRESS)).build();
                this.applicationIndexService.createApplicationIndex(applicationIndex);
            } else {
                applicationIndex.setStatus(property.getState().getValue());
                applicationIndex.setOwnerName(user.getUsername() + "::" + user.getName());
                applicationIndex.setClosed(property.getState().getValue().contains("Closed") ? ClosureStatus.YES : ClosureStatus.NO);
                applicationIndex.setApproved(property.getState().getValue().contains("Commissioner Approved") ? ApprovalStatus.APPROVED : (property.getState().getValue().contains("Rejected") || property.getState().getValue().contains("Closed") ? ApprovalStatus.REJECTED : ApprovalStatus.INPROGRESS));
                this.applicationIndexService.updateApplicationIndex(applicationIndex);
            }
        } else if (!applictionType.isEmpty() && applictionType.equalsIgnoreCase("Transfer_of_Ownership")) {
            PropertyMutation property = (PropertyMutation)stateAwareObject;
            ApplicationIndex applicationIndex = this.applicationIndexService.findByApplicationNumber(property.getApplicationNo());
            User owner = property.getBasicProperty().getPrimaryOwner();
            String source = this.propertyTaxCommonUtils.getMutationSource(property);
            if (applicationIndex == null) {
                applicationIndex = ApplicationIndex.builder().withModuleName("Property Tax").withApplicationNumber(property.getApplicationNo()).withApplicationDate(property.getCreatedDate() != null ? property.getCreatedDate() : new Date()).withApplicationType(applictionType).withApplicantName(owner.getName()).withStatus(property.getState().getValue()).withUrl(String.format(APPLICATION_VIEW_URL, property.getApplicationNo(), applictionType)).withApplicantAddress(property.getBasicProperty().getAddress().toString()).withOwnername(user.getUsername() + "::" + user.getName()).withChannel(source).withMobileNumber(owner.getMobileNumber()).withAadharNumber(owner.getAadhaarNumber()).withConsumerCode(property.getBasicProperty().getUpicNo()).withClosed(property.getState().getValue().contains("Closed") ? ClosureStatus.YES : ClosureStatus.NO).withApproved(property.getState().getValue().contains("Commissioner Approved") ? ApprovalStatus.APPROVED : (property.getState().getValue().contains("Rejected") || property.getState().getValue().contains("Closed") ? ApprovalStatus.REJECTED : ApprovalStatus.INPROGRESS)).build();
                this.applicationIndexService.createApplicationIndex(applicationIndex);
            } else {
                applicationIndex.setStatus(property.getState().getValue());
                applicationIndex.setApplicantName(owner.getName());
                applicationIndex.setOwnerName(user.getUsername() + "::" + user.getName());
                applicationIndex.setMobileNumber(owner.getMobileNumber());
                applicationIndex.setAadharNumber(owner.getAadhaarNumber());
                applicationIndex.setClosed(property.getState().getValue().contains("Closed") ? ClosureStatus.YES : ClosureStatus.NO);
                applicationIndex.setApproved(property.getState().getValue().contains("Commissioner Approved") ? ApprovalStatus.APPROVED : (property.getState().getValue().contains("Rejected") || property.getState().getValue().contains("Closed") ? ApprovalStatus.REJECTED : ApprovalStatus.INPROGRESS));
                this.applicationIndexService.updateApplicationIndex(applicationIndex);
            }
        } else if (!applictionType.isEmpty() && applictionType.equalsIgnoreCase("Vacancy_Remission")) {
            VacancyRemission vacancyRemission = (VacancyRemission)stateAwareObject;
            ApplicationIndex applicationIndex = this.applicationIndexService.findByApplicationNumber(vacancyRemission.getApplicationNumber());
            User owner = vacancyRemission.getBasicProperty().getPrimaryOwner();
            VacancyRemissionApproval vacancyRemissionApproval = vacancyRemission.getVacancyRemissionApproval().get(0);
            String source = this.propertyTaxCommonUtils.getVRSource(vacancyRemission);
            if (applicationIndex == null) {
                applicationIndex = ApplicationIndex.builder().withModuleName("Property Tax").withApplicationNumber(vacancyRemission.getApplicationNumber()).withApplicationDate(vacancyRemission.getCreatedDate() != null ? vacancyRemission.getCreatedDate() : new Date()).withApplicationType(applictionType).withApplicantName(owner.getName()).withStatus(vacancyRemissionApproval.getState().getValue()).withUrl(String.format(APPLICATION_VIEW_URL, vacancyRemission.getApplicationNumber(), applictionType)).withApplicantAddress(vacancyRemission.getBasicProperty().getAddress().toString()).withOwnername(user.getUsername() + "::" + user.getName()).withChannel(source).withMobileNumber(owner.getMobileNumber()).withAadharNumber(owner.getAadhaarNumber()).withConsumerCode(vacancyRemission.getBasicProperty().getUpicNo()).withClosed(vacancyRemissionApproval.getState().getValue().contains("Closed") ? ClosureStatus.YES : ClosureStatus.NO).withApproved(vacancyRemissionApproval.getState().getValue().contains("Commissioner Approved") ? ApprovalStatus.APPROVED : (vacancyRemissionApproval.getState().getValue().contains("Rejected") || vacancyRemissionApproval.getState().getValue().contains("Closed") ? ApprovalStatus.REJECTED : ApprovalStatus.INPROGRESS)).build();
                this.applicationIndexService.createApplicationIndex(applicationIndex);
            } else {
                applicationIndex.setStatus(vacancyRemissionApproval.getState().getValue());
                applicationIndex.setApplicantName(owner.getName());
                applicationIndex.setOwnerName(user.getUsername() + "::" + user.getName());
                applicationIndex.setMobileNumber(owner.getMobileNumber());
                applicationIndex.setAadharNumber(owner.getAadhaarNumber());
                applicationIndex.setClosed(vacancyRemissionApproval.getState().getValue().contains("Closed") ? ClosureStatus.YES : ClosureStatus.NO);
                applicationIndex.setApproved(vacancyRemissionApproval.getState().getValue().contains("Commissioner Approved") ? ApprovalStatus.APPROVED : (vacancyRemissionApproval.getState().getValue().contains("Rejected") || vacancyRemissionApproval.getState().getValue().contains("Closed") ? ApprovalStatus.REJECTED : ApprovalStatus.INPROGRESS));
                this.applicationIndexService.updateApplicationIndex(applicationIndex);
            }
        }
    }

    public Boolean hasDemandDues(String assessmentNo) {
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        BigDecimal currentWaterTaxDue = this.getWaterTaxDues(assessmentNo).get("totalTaxDue") == null ? BigDecimal.ZERO : new BigDecimal((Double)this.getWaterTaxDues(assessmentNo).get("totalTaxDue"));
        Map<String, BigDecimal> propertyTaxDetails = this.getCurrentPropertyTaxDetails(basicProperty.getActiveProperty());
        BigDecimal currentPropertyTaxDue = propertyTaxDetails.get("CURR_DMD").subtract(propertyTaxDetails.get("CURR_COLL"));
        BigDecimal arrearPropertyTaxDue = propertyTaxDetails.get("ARR_DMD").subtract(propertyTaxDetails.get("ARR_COLL"));
        return currentWaterTaxDue.add(currentPropertyTaxDue).add(arrearPropertyTaxDue).longValue() > 0L;
    }

    public Map<String, Object> getWaterTaxDues(String assessmentNo) {
        String wtmsRestURL = String.format("%s/wtms/rest/watertax/due/byptno/%s", WebUtils.extractRequestDomainURL((HttpServletRequest)ServletActionContext.getRequest(), (boolean)false), assessmentNo);
        return this.simpleRestClient.getRESTResponseAsMap(wtmsRestURL);
    }

    public Map<String, Object> getWaterTaxDues(String assessmentNo, HttpServletRequest request) {
        String wtmsRestURL = String.format("%s/wtms/rest/watertax/due/byptno/%s", WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false), assessmentNo);
        return this.simpleRestClient.getRESTResponseAsMap(wtmsRestURL);
    }

    public String validationForBifurcation(PropertyImpl propertyModel, BasicProperty basicProperty, String reason) {
        List<PropertyStatusValues> children = this.propertyStatusValuesDAO.getPropertyStatusValuesByReferenceBasicProperty(basicProperty);
        Boolean parentBifurcated = this.isPropertyBifurcated(basicProperty);
        Boolean childrenCreated = !children.isEmpty();
        String errorMsg = null;
        if ("BIFURCATE".equalsIgnoreCase(reason)) {
            if (parentBifurcated.booleanValue() && !childrenCreated.booleanValue()) {
                errorMsg = "error.child.not.created";
            }
        } else if ("ADD_OR_ALTER".equalsIgnoreCase(reason)) {
            if (!childrenCreated.booleanValue()) {
                if (parentBifurcated.booleanValue()) {
                    errorMsg = "error.child.not.created";
                }
            } else if (!parentBifurcated.booleanValue()) {
                errorMsg = "error.parent.not.bifurcated";
            }
        } else if ("BIFUR".equals(reason)) {
            if (parentBifurcated.booleanValue()) {
                this.getLatestHistoryProperty(basicProperty.getUpicNo());
            } else {
                basicProperty.getActiveProperty();
            }
        }
        return errorMsg;
    }

    public PropertyImpl getLatestHistoryProperty(String upicNo) {
        PropertyImpl property = (PropertyImpl)this.propPerServ.find("from PropertyImpl prop where prop.basicProperty.upicNo = ? and prop.status = 'H' order by prop.id desc", new Object[]{upicNo});
        return property;
    }

    public Boolean isPropertyBifurcated(BasicProperty basicProperty) {
        Boolean propBifurcated = Boolean.FALSE;
        for (Property property : basicProperty.getPropertySet()) {
            if (!"BIFURCATE".equalsIgnoreCase(property.getPropertyModifyReason()) && !"BIFUR".equalsIgnoreCase(property.getPropertyModifyReason()) || PropertyTaxConstants.STATUS_WORKFLOW.equals(property.getStatus()) || PropertyTaxConstants.STATUS_CANCELLED.equals(property.getStatus())) continue;
            propBifurcated = Boolean.TRUE;
            break;
        }
        return propBifurcated;
    }

    public BigDecimal convertYardToSquareMeters(Float vacantLandArea) {
        Float areaInSqMts = null;
        areaInSqMts = Float.valueOf(new Float(vacantLandArea.floatValue()).floatValue() * new Float(PropertyTaxConstants.SQUARE_YARD_TO_SQUARE_METER_VALUE.floatValue()).floatValue());
        return new BigDecimal(areaInSqMts.floatValue()).setScale(2, 4);
    }

    public BigDecimal getPropertyArea(BigDecimal area, Property property) {
        PropertyDetail propertyDetail = property.getPropertyDetail();
        area = propertyDetail.isAppurtenantLandChecked() != null && propertyDetail.isAppurtenantLandChecked() != false ? area.add(BigDecimal.valueOf(propertyDetail.getExtentAppartenauntLand())) : area.add(BigDecimal.valueOf(propertyDetail.getSitalArea().getArea().floatValue()));
        return area;
    }

    public Boolean isEmployee(User user) {
        for (Role role : user.getRoles()) {
            for (AppConfigValues appconfig : this.getThirdPartyUserRoles()) {
                if (role == null || !role.getName().equals(appconfig.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public Boolean isMeesevaUser(User user) {
        for (Role role : user.getRoles()) {
            if (role == null || !role.getName().equalsIgnoreCase("MeeSeva Operator")) continue;
            return true;
        }
        return false;
    }

    public Boolean isCscOperator(User user) {
        for (Role role : user.getRoles()) {
            if (role == null || !role.getName().equalsIgnoreCase("CSC Operator")) continue;
            return true;
        }
        return false;
    }

    public Assignment getUserPositionByZone(BasicProperty basicProperty, boolean isForMobile) {
        String designationStr = this.getDesignationForThirdPartyUser(isForMobile);
        String departmentStr = this.getDepartmentForWorkFlow();
        String[] department = departmentStr.split(",");
        String[] designation = designationStr.split(",");
        List assignment = new ArrayList();
        for (String dept : department) {
            for (String desg : designation) {
                assignment = this.assignmentService.findByDepartmentDesignationAndBoundary(this.departmentService.getDepartmentByName(dept).getId(), this.designationService.getDesignationByName(desg).getId(), basicProperty.getPropertyID().getElectionBoundary().getId());
                if (!assignment.isEmpty()) break;
            }
            if (!assignment.isEmpty()) break;
        }
        return !assignment.isEmpty() ? (Assignment)assignment.get(0) : null;
    }

    public Assignment getAssignmentByDeptDesigElecWard(BasicProperty basicProperty) {
        String designationStr = this.getDesignationForCscOperatorWorkFlow();
        String departmentStr = this.getDepartmentForCscOperatorWorkFlow();
        String[] department = departmentStr.split(",");
        String[] designation = designationStr.split(",");
        List assignment = new ArrayList();
        for (String dept : department) {
            for (String desg : designation) {
                Long boundaryId;
                Long desgId;
                Long deptId = this.departmentService.getDepartmentByName(dept).getId();
                assignment = this.assignmentService.findAssignmentByDepartmentDesignationAndBoundary(deptId, desgId = this.designationService.getDesignationByName(desg).getId(), boundaryId = basicProperty.getPropertyID().getElectionBoundary().getId());
                if (!assignment.isEmpty()) break;
            }
            if (!assignment.isEmpty()) break;
        }
        return !assignment.isEmpty() ? (Assignment)assignment.get(0) : null;
    }

    public Assignment getMappedAssignmentForCscOperator(BasicProperty basicProperty) {
        Assignment assignment = this.getAssignmentByDeptDesigElecWard(basicProperty);
        if (assignment == null) {
            assignment = this.getUserPositionByZone(basicProperty, false);
        }
        return assignment;
    }

    public String getDesignationForCscOperatorWorkFlow() {
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Property Tax", "PROPERTYTAXDESIGNATIONFORCSCOPERATORWORKFLOW");
        return null != appConfigValue ? ((AppConfigValues)appConfigValue.get(0)).getValue() : null;
    }

    public String getDepartmentForCscOperatorWorkFlow() {
        String department = "";
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Property Tax", "PROPERTYTAXDEPARTMENTFORCSCOPERATORWORKFLOW");
        if (null != appConfigValue && !appConfigValue.isEmpty()) {
            department = ((AppConfigValues)appConfigValue.get(0)).getValue();
        }
        return department;
    }

    public String getDepartmentForWorkFlow() {
        String department = "";
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Property Tax", "PROPERTYTAXDEPARTMENTFORWORKFLOW");
        if (null != appConfigValue && !appConfigValue.isEmpty()) {
            department = ((AppConfigValues)appConfigValue.get(0)).getValue();
        }
        return department;
    }

    public String getDesignationForThirdPartyUser(boolean isForMobile) {
        String appConfigKey = isForMobile ? "PTIS_DESIGNATIONFORWF_MOBILE" : "PROPERTYTAXDESIGNATIONFORWORKFLOW";
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Property Tax", appConfigKey);
        return null != appConfigValue ? ((AppConfigValues)appConfigValue.get(0)).getValue() : null;
    }

    public List<AppConfigValues> getThirdPartyUserRoles() {
        List appConfigValueList = this.appConfigValuesService.getConfigValuesByModuleAndKey("Property Tax", "PROPERTYTAXROLEFORNONEMPLOYEE");
        return !appConfigValueList.isEmpty() ? appConfigValueList : null;
    }

    public List<PropertyMaterlizeView> getPropertyByDemand(String fromDemand, String toDemand) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select distinct pmv from PropertyMaterlizeView pmv where pmv.aggrCurrFirstHalfDmd is not null and pmv.aggrCurrFirstHalfDmd>=:fromDemand ").append("and pmv.aggrCurrFirstHalfDmd<=:toDemand and pmv.isActive = true ");
        Query query = this.propPerServ.getSession().createQuery(queryStr.toString());
        query.setBigDecimal("fromDemand", new BigDecimal(fromDemand));
        query.setBigDecimal("toDemand", new BigDecimal(toDemand));
        List propertyList = query.list();
        return propertyList;
    }

    public List<PropertyMaterlizeView> getPropertyByAssessmentAndOwnerDetails(String assessmentNum, String oldMuncipalNum, String ownerName, String doorNo) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select distinct pmv from PropertyMaterlizeView pmv ").append(" where pmv.isActive = true ");
        if (assessmentNum != null && !assessmentNum.trim().isEmpty()) {
            queryStr.append(" and pmv.propertyId=:assessmentNum ");
        }
        if (oldMuncipalNum != null && !oldMuncipalNum.trim().isEmpty()) {
            queryStr.append(" and pmv.oldMuncipalNum=:oldMuncipalNum ");
        }
        if (ownerName != null && !ownerName.trim().isEmpty()) {
            queryStr.append(" and upper(trim(pmv.ownerName)) like :OwnerName ");
        }
        if (doorNo != null && !doorNo.trim().isEmpty()) {
            queryStr.append(" and pmv.houseNo like :HouseNo ");
        }
        Query query = this.propPerServ.getSession().createQuery(queryStr.toString());
        if (assessmentNum != null && !assessmentNum.trim().isEmpty()) {
            query.setString("assessmentNum", assessmentNum);
        }
        if (oldMuncipalNum != null && !oldMuncipalNum.trim().isEmpty()) {
            query.setString("oldMuncipalNum", oldMuncipalNum);
        }
        if (doorNo != null && !doorNo.trim().isEmpty()) {
            query.setString("HouseNo", doorNo + "%");
        }
        if (ownerName != null && !ownerName.trim().isEmpty()) {
            query.setString("OwnerName", "%" + ownerName.toUpperCase() + "%");
        }
        List propertyList = query.list();
        return propertyList;
    }

    public List<PropertyMaterlizeView> getPropertyByLocation(Integer locationId, String houseNo, String ownerName) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select distinct pmv from PropertyMaterlizeView pmv ").append(" where pmv.locality.id=:locationId and pmv.isActive = true ");
        if (houseNo != null && !houseNo.trim().isEmpty()) {
            queryStr.append("and pmv.houseNo like :HouseNo ");
        }
        if (ownerName != null && !ownerName.trim().isEmpty()) {
            queryStr.append("and upper(trim(pmv.ownerName)) like :OwnerName");
        }
        Query query = this.propPerServ.getSession().createQuery(queryStr.toString());
        query.setLong("locationId", (long)locationId.intValue());
        if (houseNo != null && !houseNo.trim().isEmpty()) {
            query.setString("HouseNo", houseNo + "%");
        }
        if (ownerName != null && !ownerName.trim().isEmpty()) {
            query.setString("OwnerName", ownerName.toUpperCase() + "%");
        }
        List propertyList = query.list();
        return propertyList;
    }

    public List<PropertyMaterlizeView> getPropertyByBoundary(Long zoneId, Long wardId, String ownerName, String houseNum) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select distinct pmv from PropertyMaterlizeView pmv, BasicPropertyImpl bp where pmv.basicPropertyID=bp.id ").append("and bp.active='Y' ");
        if (null != zoneId && zoneId != -1L) {
            queryStr.append(" and pmv.zone.id=:ZoneID");
        }
        if (null != wardId && wardId != -1L) {
            queryStr.append(" and pmv.ward.id=:WardID");
        }
        if (houseNum != null && !houseNum.trim().isEmpty()) {
            queryStr.append(" and pmv.houseNo like :HouseNo ");
        }
        if (ownerName != null && !ownerName.trim().isEmpty()) {
            queryStr.append(" and upper(trim(pmv.ownerName)) like :OwnerName");
        }
        Query query = this.propPerServ.getSession().createQuery(queryStr.toString());
        if (null != zoneId && zoneId != -1L) {
            query.setLong("ZoneID", zoneId.longValue());
        }
        if (null != wardId && wardId != -1L) {
            query.setLong("WardID", wardId.longValue());
        }
        if (houseNum != null && !houseNum.trim().isEmpty()) {
            query.setString("HouseNo", houseNum + "%");
        }
        if (ownerName != null && !ownerName.trim().isEmpty()) {
            query.setString("OwnerName", ownerName.toUpperCase() + "%");
        }
        List propertyList = query.list();
        return propertyList;
    }

    public List<PropertyMaterlizeView> getPropertyByDoorNo(String doorNo) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select distinct pmv from PropertyMaterlizeView pmv where pmv.isActive = true ");
        if (StringUtils.isNotBlank((CharSequence)doorNo)) {
            queryStr.append("and pmv.houseNo like :doorNo ");
        }
        Query query = this.propPerServ.getSession().createQuery(queryStr.toString());
        if (StringUtils.isNotBlank((CharSequence)doorNo)) {
            query.setString("doorNo", doorNo + "%");
        }
        List propertyList = query.list();
        return propertyList;
    }

    public List<PropertyMaterlizeView> getPropertyByOldMunicipalNo(String oldMuncipalNum) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select distinct pmv from PropertyMaterlizeView pmv where pmv.isActive = true ");
        if (StringUtils.isNotBlank((CharSequence)oldMuncipalNum)) {
            queryStr.append("and pmv.oldMuncipalNum=:oldMuncipalNum ");
        }
        Query query = this.propPerServ.getSession().createQuery(queryStr.toString());
        if (StringUtils.isNotBlank((CharSequence)oldMuncipalNum)) {
            query.setString("oldMuncipalNum", oldMuncipalNum);
        }
        List propertyList = query.list();
        return propertyList;
    }

    public List<PropertyMaterlizeView> getPropertyByMobileNumber(String MobileNo) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select distinct pmv from PropertyMaterlizeView pmv where pmv.isActive = true ");
        if (StringUtils.isNotBlank((CharSequence)MobileNo)) {
            queryStr.append("and pmv.mobileNumber =:MobileNo ");
        }
        Query query = this.propPerServ.getSession().createQuery(queryStr.toString());
        if (StringUtils.isNotBlank((CharSequence)MobileNo)) {
            query.setString("MobileNo", MobileNo);
        }
        List propertyList = query.list();
        return propertyList;
    }

    public Assignment getWorkflowInitiator(PropertyImpl property) {
        Assignment wfInitiator = null;
        if (this.isEmployee(property.getCreatedBy()).booleanValue()) {
            wfInitiator = this.isStateNotNull(property) ? this.getWfInitiatorIfStateNotNull(property) : this.assignmentService.getPrimaryAssignmentForUser(property.getCreatedBy().getId());
        } else if (property.getState().getInitiatorPosition() != null) {
            List assignment = this.assignmentService.getAssignmentsForPosition(property.getState().getInitiatorPosition().getId(), new Date());
            wfInitiator = this.getActiveAssignment(assignment);
            if (wfInitiator == null && !property.getStateHistory().isEmpty()) {
                wfInitiator = this.assignmentService.getPrimaryAssignmentForPositon(((StateHistory)property.getStateHistory().get(0)).getOwnerPosition().getId());
            }
        } else {
            wfInitiator = this.assignmentService.getPrimaryAssignmentForPositon(property.getState().getOwnerPosition().getId());
        }
        return wfInitiator;
    }

    private Assignment getWfInitiatorIfStateNotNull(PropertyImpl property) {
        Assignment wfInitiator = null;
        Assignment assgmnt = this.propertyTaxCommonUtils.getUserAssignmentByPassingPositionAndUser(property.getCreatedBy(), property.getState().getInitiatorPosition());
        if (assgmnt != null && assgmnt.getEmployee().isActive()) {
            wfInitiator = assgmnt;
        }
        if (wfInitiator == null) {
            List assignment = this.assignmentService.getAssignmentsForPosition(property.getState().getInitiatorPosition().getId(), new Date());
            wfInitiator = this.getActiveAssignment(assignment);
        }
        return wfInitiator;
    }

    private boolean isStateNotNull(PropertyImpl property) {
        return property.getState() != null && property.getState().getInitiatorPosition() != null;
    }

    private Assignment getActiveAssignment(List<Assignment> assignment) {
        Assignment wfInitiator = null;
        for (Assignment assign : assignment) {
            if (!assign.getEmployee().isActive()) continue;
            wfInitiator = assign;
            break;
        }
        return wfInitiator;
    }

    public List<Hashtable<String, Object>> populateHistory(StateAware stateAware) {
        ArrayList<Hashtable<String, Object>> historyTable = new ArrayList<Hashtable<String, Object>>();
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        if (stateAware.hasState()) {
            State state = stateAware.getCurrentState();
            map.put("date", state.getLastModifiedDate());
            map.put("updatedBy", state.getLastModifiedBy().getUsername() + "::" + state.getLastModifiedBy().getName());
            map.put("status", state.getValue());
            map.put("comments", null != state.getComments() ? state.getComments() : "");
            User user = state.getOwnerUser();
            Position ownerPosition = state.getOwnerPosition();
            if (null != ownerPosition) {
                User approverUser = this.eisCommonService.getUserForPosition(ownerPosition.getId(), new Date());
                map.put("user", null != approverUser ? approverUser.getUsername() + "::" + approverUser.getName() : "");
            } else if (null != user) {
                map.put("user", user.getUsername() + "::" + user.getName());
            }
            historyTable.add(map);
            List stateHistory = stateAware.getStateHistory();
            if (null != state.getHistory() && !state.getHistory().isEmpty()) {
                Collections.reverse(stateHistory);
                for (StateHistory historyState : stateHistory) {
                    Hashtable<String, Object> HistoryMap = new Hashtable<String, Object>(0);
                    HistoryMap.put("date", historyState.getLastModifiedDate());
                    HistoryMap.put("updatedBy", historyState.getLastModifiedBy().getUsername() + "::" + historyState.getLastModifiedBy().getName());
                    HistoryMap.put("status", historyState.getValue());
                    HistoryMap.put("comments", null != historyState.getComments() ? historyState.getComments() : "");
                    ownerPosition = historyState.getOwnerPosition();
                    user = historyState.getOwnerUser();
                    if (null != ownerPosition) {
                        User approverUser = this.eisCommonService.getUserForPosition(ownerPosition.getId(), historyState.getLastModifiedDate());
                        HistoryMap.put("user", null != approverUser ? approverUser.getUsername() + "::" + approverUser.getName() : "");
                    } else if (null != user) {
                        HistoryMap.put("user", user.getUsername() + "::" + user.getName());
                    }
                    historyTable.add(HistoryMap);
                }
            }
        }
        return historyTable;
    }

    public AssessmentDetails loadAssessmentDetails(BasicProperty basicProperty) {
        AssessmentDetails assessmentDetail = new AssessmentDetails();
        assessmentDetail.setPropertyID(basicProperty.getUpicNo());
        if (basicProperty.getLatitude() != null && basicProperty.getLongitude() != null) {
            assessmentDetail.setLatitude(basicProperty.getLatitude());
            assessmentDetail.setLongitude(basicProperty.getLongitude());
        }
        assessmentDetail.setFlag(0);
        assessmentDetail.setHouseNo(basicProperty.getAddress().getHouseNoBldgApt());
        assessmentDetail.setPropertyAddress(basicProperty.getAddress().toString());
        Property property = basicProperty.getProperty();
        PropertyDetails propertyDetails = new PropertyDetails();
        assessmentDetail.setPropertyDetails(propertyDetails);
        PropertyDetail propertyDetail = null;
        if (property != null) {
            assessmentDetail.setOwnerNames(this.prepareOwnerInfo(property));
            propertyDetail = property.getPropertyDetail();
            this.loadPropertyDues(property, assessmentDetail);
        }
        if (null != propertyDetail) {
            assessmentDetail.setBoundaryDetails(this.prepareBoundaryInfo(basicProperty));
            assessmentDetail.getPropertyDetails().setPropertyType(propertyDetail.getPropertyTypeMaster().getType());
            if (propertyDetail.getPropertyUsage() != null) {
                assessmentDetail.getPropertyDetails().setPropertyUsage(propertyDetail.getPropertyUsage().getUsageName());
            }
            if (null != propertyDetail.getNoofFloors()) {
                assessmentDetail.getPropertyDetails().setNoOfFloors(propertyDetail.getNoofFloors());
            } else {
                assessmentDetail.getPropertyDetails().setNoOfFloors(0);
            }
        }
        return assessmentDetail;
    }

    private Set<OwnerName> prepareOwnerInfo(Property property) {
        List<PropertyOwnerInfo> propertyOwners = property.getBasicProperty().getPropertyOwnerInfo();
        HashSet<OwnerName> ownerNames = new HashSet<OwnerName>(0);
        if (propertyOwners != null && !propertyOwners.isEmpty()) {
            for (PropertyOwnerInfo propertyOwner : propertyOwners) {
                OwnerName ownerName = new OwnerName();
                ownerName.setAadhaarNumber(propertyOwner.getOwner().getAadhaarNumber());
                ownerName.setOwnerName(propertyOwner.getOwner().getName());
                ownerName.setMobileNumber(propertyOwner.getOwner().getMobileNumber());
                ownerName.setEmailId(propertyOwner.getOwner().getEmailId());
                ownerNames.add(ownerName);
            }
        }
        return ownerNames;
    }

    private BoundaryDetails prepareBoundaryInfo(BasicProperty basicProperty) {
        BoundaryDetails boundaryDetails = new BoundaryDetails();
        PropertyID propertyID = basicProperty.getPropertyID();
        if (null != propertyID) {
            if (null != propertyID.getZone()) {
                boundaryDetails.setZoneId(propertyID.getZone().getId());
                boundaryDetails.setZoneNumber(propertyID.getZone().getBoundaryNum());
                boundaryDetails.setZoneName(propertyID.getZone().getName());
                boundaryDetails.setZoneBoundaryType(propertyID.getZone().getBoundaryType().getName());
            }
            if (null != propertyID.getWard()) {
                boundaryDetails.setWardId(propertyID.getWard().getId());
                boundaryDetails.setWardNumber(propertyID.getWard().getBoundaryNum());
                boundaryDetails.setWardName(propertyID.getWard().getName());
                boundaryDetails.setWardBoundaryType(propertyID.getWard().getBoundaryType().getName());
            }
            if (null != propertyID.getElectionBoundary()) {
                boundaryDetails.setAdminWardId(propertyID.getElectionBoundary().getId());
                boundaryDetails.setAdminWardNumber(propertyID.getElectionBoundary().getBoundaryNum());
                boundaryDetails.setAdminWardName(propertyID.getElectionBoundary().getName());
                boundaryDetails.setAdminWardBoundaryType(propertyID.getElectionBoundary().getBoundaryType().getName());
            }
            if (null != propertyID.getArea()) {
                boundaryDetails.setBlockId(propertyID.getArea().getId());
                boundaryDetails.setBlockNumber(propertyID.getArea().getBoundaryNum());
                boundaryDetails.setBlockName(propertyID.getArea().getName());
            }
            if (null != propertyID.getLocality()) {
                boundaryDetails.setLocalityId(propertyID.getLocality().getId());
                boundaryDetails.setLocalityName(propertyID.getLocality().getName());
            }
            if (null != propertyID.getStreet()) {
                boundaryDetails.setStreetId(propertyID.getStreet().getId());
                boundaryDetails.setStreetName(propertyID.getStreet().getName());
            }
        }
        return boundaryDetails;
    }

    private void loadPropertyDues(Property property, AssessmentDetails assessmentDetail) {
        Map<String, BigDecimal> resultmap = this.ptDemandDAO.getDemandCollMap(property);
        if (null != resultmap && !resultmap.isEmpty()) {
            BigDecimal currDmd = resultmap.get("CURR_FIRSTHALF_DMD");
            BigDecimal arrDmd = resultmap.get("ARR_DMD");
            BigDecimal currCollection = resultmap.get("CURR_FIRSTHALF_COLL");
            BigDecimal arrColelection = resultmap.get("ARR_COLL");
            BigDecimal taxDue = currDmd.add(arrDmd).subtract(currCollection).subtract(arrColelection);
            assessmentDetail.getPropertyDetails().setTaxDue(taxDue);
            assessmentDetail.getPropertyDetails().setCurrentTax(currDmd);
            assessmentDetail.getPropertyDetails().setArrearTax(arrDmd);
        }
    }

    public Map<String, BigDecimal> getCurrentPropertyTaxDetails(Property propertyImpl) {
        return this.ptDemandDAO.getDemandCollMap(propertyImpl);
    }

    public Map<String, BigDecimal> getCurrentTaxAndBalance(Map<String, BigDecimal> propertyTaxDetails, Date currDate) {
        HashMap<String, BigDecimal> taxValues = new HashMap<String, BigDecimal>();
        Map<String, Installment> currYearInstMap = this.propertyTaxUtil.getInstallmentsForCurrYear(currDate);
        Installment currInstFirstHalf = currYearInstMap.get("Current 1st Half");
        if (DateUtils.between((Date)new Date(), (Date)currInstFirstHalf.getFromDate(), (Date)currInstFirstHalf.getToDate())) {
            taxValues.put("CURR_DMD", propertyTaxDetails.get("CURR_FIRSTHALF_DMD"));
            taxValues.put("CURR_BAL", propertyTaxDetails.get("CURR_FIRSTHALF_DMD").subtract(propertyTaxDetails.get("CURR_FIRSTHALF_COLL")));
        } else {
            taxValues.put("CURR_DMD", propertyTaxDetails.get("CURR_SECONDHALF_DMD"));
            taxValues.put("CURR_BAL", propertyTaxDetails.get("CURR_SECONDHALF_DMD").subtract(propertyTaxDetails.get("CURR_SECONDHALF_COLL")));
        }
        return taxValues;
    }

    public Map<String, BigDecimal> getCurrentTaxDetails(Map<String, Map<String, BigDecimal>> propertyTaxDetails, Date currDate) {
        HashMap<String, BigDecimal> taxValues = new HashMap<String, BigDecimal>();
        Map<String, Installment> currYearInstMap = this.propertyTaxUtil.getInstallmentsForCurrYear(currDate);
        Installment currInstFirstHalf = currYearInstMap.get("Current 1st Half");
        if (DateUtils.between((Date)new Date(), (Date)currInstFirstHalf.getFromDate(), (Date)currInstFirstHalf.getToDate())) {
            this.getTaxDetails(propertyTaxDetails, taxValues, "Current 1st Half", currInstFirstHalf);
        } else {
            this.getTaxDetails(propertyTaxDetails, taxValues, "Current 2nd Half", null);
        }
        return taxValues;
    }

    private void getTaxDetails(Map<String, Map<String, BigDecimal>> propertyTaxDetails, Map<String, BigDecimal> taxValues, String installmentHalf, Installment currInstFirstHalf) {
        if (currInstFirstHalf != null) {
            taxValues.put("CURR_DMD", propertyTaxDetails.get(installmentHalf).get("CURR_FIRSTHALF_DMD"));
            taxValues.put("CURR_COLL", propertyTaxDetails.get(installmentHalf).get("CURR_FIRSTHALF_COLL"));
            taxValues.put("CURR_BAL", propertyTaxDetails.get(installmentHalf).get("CURR_FIRSTHALF_DMD").subtract(propertyTaxDetails.get(installmentHalf).get("CURR_FIRSTHALF_COLL")));
        } else {
            taxValues.put("CURR_DMD", propertyTaxDetails.get(installmentHalf).get("CURR_SECONDHALF_DMD"));
            taxValues.put("CURR_COLL", propertyTaxDetails.get(installmentHalf).get("CURR_SECONDHALF_COLL"));
            taxValues.put("CURR_BAL", propertyTaxDetails.get(installmentHalf).get("CURR_SECONDHALF_DMD").subtract(propertyTaxDetails.get(installmentHalf).get("CURR_SECONDHALF_COLL")));
        }
        if (propertyTaxDetails.get(installmentHalf).get("General Tax") != null) {
            taxValues.put("General Tax", propertyTaxDetails.get(installmentHalf).get("General Tax"));
        } else {
            taxValues.put("Vacant Land Tax", propertyTaxDetails.get(installmentHalf).get("Vacant Land Tax"));
        }
        taxValues.put("Library Cess", propertyTaxDetails.get(installmentHalf).get("Library Cess"));
        taxValues.put("Education Cess", propertyTaxDetails.get(installmentHalf).get("Education Cess"));
        taxValues.put("Unauthorized Penalty", propertyTaxDetails.get(installmentHalf).get("Unauthorized Penalty"));
        taxValues.put("ARR_DMD", propertyTaxDetails.get("Arrears").get("ARR_DMD"));
        taxValues.put("ARR_COLL", propertyTaxDetails.get("Arrears").get("ARR_COLL"));
        taxValues.put("ARR_BAL", propertyTaxDetails.get("Arrears").get("ARR_DMD").subtract(propertyTaxDetails.get("Arrears").get("ARR_COLL")));
    }

    public void calculateGrpPenalty(Property modProperty, Date propCompletionDate) {
        this.currentInstall = this.propertyTaxCommonUtils.getCurrentInstallment();
        Module module = this.moduleDao.getModuleByName("Property Tax");
        EgDemand currentDemand = null;
        for (EgDemand egDemand : modProperty.getPtDemandSet()) {
            if (!egDemand.getEgInstallmentMaster().equals((Object)this.currentInstall)) continue;
            currentDemand = egDemand;
            break;
        }
        Map<Installment, BigDecimal> installmentWiseDemand = this.getInstallmentWiseDemand(currentDemand);
        Map<Installment, EgDemandDetails> map = this.penaltyCalculationService.getInstallmentWisePenaltyDemandDetails(null, currentDemand);
        ArrayList<EgDemandDetails> penaltyList = new ArrayList<EgDemandDetails>();
        DateTime nagarPanchayatPenDate = DateTime.now().withDate(2016, 1, 1);
        Installment nagarPanchayatPenEndInstallment = this.installmentDao.getInsatllmentByModuleForGivenDate(module, nagarPanchayatPenDate.toDate());
        BigDecimal excessPenalty = BigDecimal.ZERO;
        for (Map.Entry<Installment, BigDecimal> mapEntry : installmentWiseDemand.entrySet()) {
            Installment installment = mapEntry.getKey();
            if (installment.getToDate().compareTo(propCompletionDate) < 0) continue;
            BigDecimal tax = mapEntry.getValue();
            EgDemandDetails existingPenaltyDemandDetail = map.get(installment);
            Date penaltyEffectiveDate = this.propertyTaxUtil.checkIsNagarPanchayat() && installment.compareTo(nagarPanchayatPenEndInstallment) <= 0 ? nagarPanchayatPenDate.toDate() : this.getPenaltyEffectiveDate(installment);
            if (!penaltyEffectiveDate.before(new Date())) continue;
            BigDecimal penaltyAmount = this.calculatePenalty(null, penaltyEffectiveDate, tax);
            if (existingPenaltyDemandDetail == null) {
                EgDemandDetails penaltyDemandDetails = this.ptBillServiceImpl.insertDemandDetails("PENALTY_FINES", penaltyAmount, installment);
                penaltyList.add(penaltyDemandDetails);
                continue;
            }
            if (existingPenaltyDemandDetail.getAmtCollected().compareTo(penaltyAmount) > 0) {
                excessPenalty = existingPenaltyDemandDetail.getAmtCollected().subtract(penaltyAmount);
                existingPenaltyDemandDetail.setAmtCollected(penaltyAmount);
            }
            existingPenaltyDemandDetail.setAmount(penaltyAmount);
        }
        currentDemand.getEgDemandDetails().addAll(penaltyList);
        ArrayList<Installment> installments = new ArrayList<Installment>(installmentWiseDemand.keySet());
        Collections.sort(installments);
        if (excessPenalty.compareTo(BigDecimal.ZERO) > 0) {
            this.adjustExcessPenalty(currentDemand, installments, excessPenalty);
        }
    }

    private void adjustExcessPenalty(EgDemand currentDemand, List<Installment> installments, BigDecimal excessPenalty) {
        LinkedHashSet<String> demandReasons = new LinkedHashSet<String>(Arrays.asList("PENALTY_FINES", "GEN_TAX", "VAC_LAND_TAX", "EDU_CESS", "LIB_CESS", "UNAUTH_PENALTY"));
        ArrayList<EgDemandDetails> demandDetailsList = new ArrayList<EgDemandDetails>(currentDemand.getEgDemandDetails());
        Map<Installment, Set<EgDemandDetails>> installmentWiseDemandDetails = this.getEgDemandDetailsSetAsMap(demandDetailsList, installments);
        for (Installment installment : installments) {
            Set<EgDemandDetails> demandDetailsSet = installmentWiseDemandDetails.get(installment);
            for (String demandReason : demandReasons) {
                BigDecimal balance;
                EgDemandDetails demandDetails = this.getEgDemandDetailsForReason(demandDetailsSet, demandReason);
                if (demandDetails != null && (balance = demandDetails.getAmount().subtract(demandDetails.getAmtCollected())).compareTo(BigDecimal.ZERO) > 0 && excessPenalty.compareTo(BigDecimal.ZERO) > 0) {
                    if (excessPenalty.compareTo(balance) <= 0) {
                        demandDetails.setAmtCollected(demandDetails.getAmtCollected().add(excessPenalty));
                        demandDetails.setModifiedDate(new Date());
                        excessPenalty = BigDecimal.ZERO;
                    } else {
                        demandDetails.setAmtCollected(demandDetails.getAmtCollected().add(balance));
                        demandDetails.setModifiedDate(new Date());
                        excessPenalty = excessPenalty.subtract(balance);
                    }
                }
                if (excessPenalty.compareTo(BigDecimal.ZERO) != 0) continue;
                break;
            }
            if (excessPenalty.compareTo(BigDecimal.ZERO) != 0) continue;
            break;
        }
        if (excessPenalty.compareTo(BigDecimal.ZERO) > 0) {
            EgDemandDetails advanceDemandDetails = this.ptBillServiceImpl.insertDemandDetails("ADVANCE", excessPenalty, this.currentInstall);
            currentDemand.getEgDemandDetails().add(advanceDemandDetails);
        }
    }

    private Map<Installment, BigDecimal> getInstallmentWiseDemand(EgDemand currentDemand) {
        TreeMap<Installment, BigDecimal> installmentWiseDemand = new TreeMap<Installment, BigDecimal>();
        String demandReason = "";
        Installment installment = null;
        List<String> demandReasonExcludeList = Arrays.asList("PENALTY_FINES", "ADVANCE");
        for (EgDemandDetails dmdDet : currentDemand.getEgDemandDetails()) {
            demandReason = dmdDet.getEgDemandReason().getEgDemandReasonMaster().getCode();
            if (demandReasonExcludeList.contains(demandReason)) continue;
            installment = dmdDet.getEgDemandReason().getEgInstallmentMaster();
            if (installmentWiseDemand.get(installment) == null) {
                installmentWiseDemand.put(installment, dmdDet.getAmount());
                continue;
            }
            installmentWiseDemand.put(installment, ((BigDecimal)installmentWiseDemand.get(installment)).add(dmdDet.getAmount()));
        }
        return installmentWiseDemand;
    }

    public BigDecimal calculatePenalty(Date latestCollReceiptDate, Date fromDate, BigDecimal amount) {
        int noOfMonths = PropertyTaxUtil.getMonthsBetweenDates(fromDate, new Date());
        BigDecimal penalty = amount.multiply(PropertyTaxConstants.PENALTY_PERCENTAGE.multiply(new BigDecimal(noOfMonths))).divide(PropertyTaxConstants.BIGDECIMAL_100);
        return MoneyUtils.roundOff((BigDecimal)penalty);
    }

    private Date getPenaltyEffectiveDate(Installment installment) {
        return this.penalyDateWithThreeMonths(installment.getFromDate());
    }

    private Date penalyDateWithThreeMonths(Date date) {
        Calendar penalyDate = Calendar.getInstance();
        penalyDate.setTime(date);
        penalyDate.add(2, 3);
        penalyDate.set(5, 1);
        return penalyDate.getTime();
    }

    public void updatePropertyDetail(Property property, Long floorTypeId, Long roofTypeId, Long wallTypeId, Long woodTypeId, String areaOfPlot, String propertyCategory, String nonResPlotArea, String propUsageId, String propOccId, String propTypeId) {
        PropertyDetail propertyDetail = property.getPropertyDetail();
        if (floorTypeId != null && floorTypeId != -1L) {
            FloorType floorType = (FloorType)((Object)this.getPropPerServ().find("From FloorType where id = ?", new Object[]{floorTypeId}));
            propertyDetail.setFloorType(floorType);
        }
        if (roofTypeId != null && roofTypeId != -1L) {
            RoofType roofType = (RoofType)((Object)this.getPropPerServ().find("From RoofType where id = ?", new Object[]{roofTypeId}));
            propertyDetail.setRoofType(roofType);
        }
        if (wallTypeId != null && wallTypeId != -1L) {
            WallType wallType = (WallType)((Object)this.getPropPerServ().find("From WallType where id = ?", new Object[]{wallTypeId}));
            propertyDetail.setWallType(wallType);
        }
        if (woodTypeId != null && woodTypeId != -1L) {
            WoodType woodType = (WoodType)((Object)this.getPropPerServ().find("From WoodType where id = ?", new Object[]{woodTypeId}));
            propertyDetail.setWoodType(woodType);
        }
        if (areaOfPlot != null && !areaOfPlot.isEmpty()) {
            propertyDetail.getSitalArea().setArea(new Float(areaOfPlot));
        }
        propertyDetail.setCategoryType(propertyDetail.getCategoryType());
        if (propertyDetail.getApartment() != null && propertyDetail.getApartment().getId() != null) {
            Apartment apartment = (Apartment)((Object)this.getPropPerServ().find("From Apartment where id = ?", new Object[]{property.getPropertyDetail().getApartment().getId()}));
            propertyDetail.setApartment(apartment);
        }
        if (nonResPlotArea != null && !nonResPlotArea.isEmpty()) {
            propertyDetail.getNonResPlotArea().setArea(new Float(nonResPlotArea));
        }
        propertyDetail.setFieldVerified(Character.valueOf('Y'));
        propertyDetail.setProperty(property);
        PropertyMutationMaster propMutMstr = (PropertyMutationMaster)this.getPropPerServ().find(FROM_PROPERTY_MUTATION_MASTER_WHERE_CODE, new Object[]{property.getBasicProperty().getPropertyMutationMaster().getCode()});
        PropertyTypeMaster propTypeMstr = (PropertyTypeMaster)((Object)this.getPropPerServ().find("from PropertyTypeMaster PTM where PTM.id = ?", new Object[]{Long.valueOf(propTypeId)}));
        if (propUsageId != null) {
            PropertyUsage usage = (PropertyUsage)((Object)this.getPropPerServ().find(FROM_PROPERTY_USAGE_WHERE_ID, new Object[]{Long.valueOf(propUsageId)}));
            propertyDetail.setPropertyUsage(usage);
        }
        if (propOccId != null) {
            PropertyOccupation occupancy = (PropertyOccupation)((Object)this.getPropPerServ().find(FROM_PROPERTY_OCCUPATION_WHERE_ID, new Object[]{Long.valueOf(propOccId)}));
            propertyDetail.setPropertyOccupation(occupancy);
        }
        if (propTypeMstr.getCode().equals("VAC_LAND")) {
            propertyDetail.setPropertyType("VacantProperty");
        } else {
            propertyDetail.setPropertyType("BuiltUpProperty");
        }
        propertyDetail.setPropertyTypeMaster(propTypeMstr);
        propertyDetail.setPropertyMutationMaster(propMutMstr);
        propertyDetail.setUpdatedTime(new Date());
        if (propertyDetail.getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND")) {
            propertyDetail.setNoofFloors(0);
            if (!property.getPropertyDetail().getFloorDetails().isEmpty()) {
                property.getPropertyDetail().getFloorDetails().clear();
            }
            property.getPropertyDetail().getTotalBuiltupArea().setArea(new Float(0.0f));
        }
    }

    public void updateFloorDetails(Property property, List<Floor> savedFloorDetails) {
        PropertyTypeMaster unitType = null;
        PropertyUsage usage = null;
        PropertyOccupation occupancy = null;
        StructureClassification structureClass = null;
        Area totBltUpArea = new Area();
        Float totBltUpAreaVal = new Float(0.0f);
        for (Floor floorProxy : property.getPropertyDetail().getFloorDetailsProxy()) {
            for (Floor savedFloor : savedFloorDetails) {
                if (floorProxy != null && savedFloor != null && floorProxy.getFloorUid().equals(savedFloor.getFloorUid())) {
                    totBltUpAreaVal = Float.valueOf(totBltUpAreaVal.floatValue() + floorProxy.getBuiltUpArea().getArea().floatValue());
                    if (floorProxy.getUnitType() != null) {
                        unitType = (PropertyTypeMaster)((Object)this.getPropPerServ().find("from PropertyTypeMaster utype where utype.id = ?", new Object[]{floorProxy.getUnitType().getId()}));
                    }
                    if (floorProxy.getPropertyUsage() != null) {
                        usage = (PropertyUsage)((Object)this.getPropPerServ().find(FROM_PROPERTY_USAGE_WHERE_ID, new Object[]{floorProxy.getPropertyUsage().getId()}));
                    }
                    if (floorProxy.getPropertyOccupation() != null) {
                        occupancy = (PropertyOccupation)((Object)this.getPropPerServ().find(FROM_PROPERTY_OCCUPATION_WHERE_ID, new Object[]{floorProxy.getPropertyOccupation().getId()}));
                    }
                    if (floorProxy.getStructureClassification() != null) {
                        structureClass = (StructureClassification)((Object)this.getPropPerServ().find("from StructureClassification sc where sc.id = ?", new Object[]{floorProxy.getStructureClassification().getId()}));
                    }
                    if (floorProxy.getOccupancyDate() != null && floorProxy.getConstructionDate() != null) {
                        savedFloor.setDepreciationMaster(this.propertyTaxUtil.getDepreciationByDate(floorProxy.getConstructionDate(), floorProxy.getOccupancyDate()));
                    }
                    if (unitType != null && unitType.getCode().equalsIgnoreCase("OPEN_PLOT")) {
                        savedFloor.setFloorNo(PropertyTaxConstants.OPEN_PLOT_UNIT_FLOORNUMBER);
                    }
                    savedFloor.setUnitType(unitType);
                    savedFloor.setPropertyUsage(usage);
                    savedFloor.setPropertyOccupation(occupancy);
                    savedFloor.setStructureClassification(structureClass);
                    savedFloor.setPropertyDetail(property.getPropertyDetail());
                    savedFloor.setModifiedDate(new Date());
                    User user = this.userService.getUserById(ApplicationThreadLocals.getUserId());
                    savedFloor.setModifiedBy(user);
                    savedFloor.getBuiltUpArea().setArea(floorProxy.getBuiltUpArea().getArea());
                    savedFloor.getBuiltUpArea().setLength(floorProxy.getBuiltUpArea().getLength());
                    savedFloor.getBuiltUpArea().setBreadth(floorProxy.getBuiltUpArea().getLength());
                    savedFloor.setFirmName(floorProxy.getFirmName());
                    totBltUpArea.setArea(totBltUpAreaVal);
                    totBltUpArea.setLength(floorProxy.getBuiltUpArea().getLength());
                    totBltUpArea.setBreadth(floorProxy.getBuiltUpArea().getBreadth());
                    property.getPropertyDetail().setTotalBuiltupArea(totBltUpArea);
                }
                property.getPropertyDetail().setNoofFloors(property.getPropertyDetail().getFloorDetailsProxy().size());
            }
        }
    }

    public Date convertStringToDate(String dateInString) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        return sdf.parse(dateInString);
    }

    public List<Assignment> getAssignmentsForDesignation(String designationName) {
        ArrayList<Assignment> assignmentsList = new ArrayList();
        assignmentsList = this.assignmentService.findPrimaryAssignmentForDesignationName(designationName);
        return assignmentsList;
    }

    public void updateReferenceBasicProperty(BasicProperty basicProperty, String parentPropId) {
        PropertyStatusValues propStatVal = (PropertyStatusValues)((Object)this.propPerServ.find("from PropertyStatusValues psv where psv.basicProperty=? order by createdDate desc", new Object[]{basicProperty}));
        BasicProperty referenceBasicProperty = (BasicProperty)this.propPerServ.find("from BasicPropertyImpl bp where bp.upicNo=?", new Object[]{parentPropId});
        if (referenceBasicProperty != null) {
            propStatVal.setReferenceBasicProperty(referenceBasicProperty);
        }
    }

    public List<Map<String, Object>> getWCDetails(String assessmentNo, HttpServletRequest request) {
        ArrayList<Map<String, Object>> waterConnDtls = new ArrayList<Map<String, Object>>();
        String url = request.getRequestURL().toString();
        String uri = request.getRequestURI();
        String host = url.substring(0, url.indexOf(uri));
        String wtmsRestURL = String.format("%s/wtms/rest/watertax/connectiondetails/byptno/%s", host, assessmentNo);
        String dtls = this.simpleRestClient.getRESTResponse(wtmsRestURL);
        JSONArray jsonArr = null;
        ArrayList<String> nameList = new ArrayList<String>();
        try {
            jsonArr = new JSONArray(dtls);
        }
        catch (JSONException e1) {
            LOGGER.error((Object)("Error in converting string into json array " + (Object)((Object)e1)));
        }
        for (int i = 0; i < jsonArr.length(); ++i) {
            try {
                HashMap<String, String> newMap = new HashMap<String, String>();
                JSONObject jsonObj = jsonArr.getJSONObject(i);
                JSONArray names = jsonObj.names();
                if (names != null) {
                    for (int n = 0; n < names.length(); ++n) {
                        nameList.add(names.get(n).toString());
                    }
                }
                for (String str : nameList) {
                    if ("propertyID".equals(str)) continue;
                    newMap.put(str, jsonObj.get(str).toString().toLowerCase());
                }
                waterConnDtls.add(newMap);
                continue;
            }
            catch (JSONException e) {
                LOGGER.error((Object)("Error in converting json array into json object " + (Object)((Object)e)));
            }
        }
        return waterConnDtls;
    }

    public BigDecimal getTotalPropertyTaxDue(BasicProperty basicProperty) {
        Map<String, BigDecimal> propertyTaxDetails = this.ptDemandDAO.getDemandCollMap(basicProperty.getProperty());
        Map<String, BigDecimal> currentTaxAndDue = this.getCurrentTaxAndBalance(propertyTaxDetails, new Date());
        BigDecimal currentPropertyTaxDue = currentTaxAndDue.get("CURR_BAL");
        BigDecimal arrearPropertyTaxDue = propertyTaxDetails.get("ARR_DMD").subtract(propertyTaxDetails.get("ARR_COLL"));
        return currentPropertyTaxDue.add(arrearPropertyTaxDue);
    }

    public Set<FileStoreMapper> addToFileStore(MultipartFile[] files) {
        if (ArrayUtils.isNotEmpty((Object[])files)) {
            return Arrays.asList(files).stream().filter(file -> !file.isEmpty()).map(file -> {
                try {
                    return this.fileStoreService.store(file.getInputStream(), file.getOriginalFilename(), file.getContentType(), "PTIS");
                }
                catch (Exception e) {
                    throw new ApplicationRuntimeException("err.input.stream", (Throwable)e);
                }
            }).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public BigDecimal getTotalPropertyTaxDueIncludingPenalty(BasicProperty basicProperty) {
        Map<String, BigDecimal> propertyTaxDetails = this.ptDemandDAO.getDemandIncludingPenaltyCollMap(basicProperty.getProperty());
        BigDecimal crntFirstHalfTaxDue = propertyTaxDetails.get("CURR_FIRSTHALF_DMD").subtract(propertyTaxDetails.get("CURR_FIRSTHALF_COLL"));
        BigDecimal crntSecondHalfTaxDue = propertyTaxDetails.get("CURR_SECONDHALF_DMD").subtract(propertyTaxDetails.get("CURR_SECONDHALF_COLL"));
        BigDecimal arrearPropertyTaxDue = propertyTaxDetails.get("ARR_DMD").subtract(propertyTaxDetails.get("ARR_COLL"));
        BigDecimal totalBalance = crntFirstHalfTaxDue.add(crntSecondHalfTaxDue).add(arrearPropertyTaxDue);
        return totalBalance;
    }

    public List<PropertyStatusValues> findChildrenForProperty(BasicProperty basicProperty) {
        return this.propertyStatusValuesDAO.getPropertyStatusValuesByReferenceBasicProperty(basicProperty);
    }

    public Assignment getUserOnRejection(StateAware stateAware) {
        List history = stateAware.getStateHistory();
        Collections.reverse(history);
        Assignment userAssignment = null;
        boolean exists = false;
        for (StateHistory state : history) {
            List assignments = this.assignmentService.getAssignmentsForPosition(state.getOwnerPosition().getId());
            for (Assignment assignment : assignments) {
                if (assignment == null || !assignment.getDesignation().getName().equals("UD Revenue Inspector") || !assignment.getEmployee().isActive()) continue;
                userAssignment = assignment;
                exists = true;
                break;
            }
            if (!exists) continue;
            break;
        }
        return userAssignment;
    }

    public String getDesignationForPositionAndUser(Long positionId, Long userId) {
        List assignment = this.assignmentService.getAssignmentByPositionAndUserAsOnDate(positionId, userId, new Date());
        return !assignment.isEmpty() ? ((Assignment)assignment.get(0)).getDesignation().getName() : null;
    }

    @Transactional
    public void saveDocumentTypeDetails(BasicProperty basicProperty, DocumentTypeDetails documentTypeDetails) {
        documentTypeDetails.setBasicPropertyId(basicProperty.getId());
        this.documentTypeDetailsService.persist((Object)documentTypeDetails);
    }

    @Transactional
    public void updateDocumentTypeDetails(BasicProperty basicProperty, DocumentTypeDetails documentTypeDetails) {
        documentTypeDetails.setBasicPropertyId(basicProperty.getId());
        this.documentTypeDetailsService.update((Object)documentTypeDetails);
    }

    public void clearOldDocumentAttachments(List<Document> documents, DocumentTypeDetails documentTypeDetails) {
        List<DocumentType> excludedDocumentTypes = this.excludeOldDocumentAttachments(documentTypeDetails);
        documents.forEach(document -> {
            if (excludedDocumentTypes.contains((Object)document.getType()) && !document.getFiles().isEmpty()) {
                document.getFiles().clear();
            }
        });
    }

    public List<DocumentType> excludeOldDocumentAttachments(DocumentTypeDetails documentTypeDetails) {
        List<DocumentType> documentTypes = this.getDocumentTypesForTransactionType(TransactionType.CREATE_ASMT_DOC);
        Iterator<DocumentType> documentTypeIterator = documentTypes.iterator();
        while (documentTypeIterator.hasNext()) {
            DocumentType dt = documentTypeIterator.next();
            if (documentTypeDetails.getDocumentName().equals("Patta Certificate (Issued by Revenue Department)")) {
                if (!dt.getName().equals("Patta Certificate") && !dt.getName().equals("MRO Proceedings")) continue;
                documentTypeIterator.remove();
                continue;
            }
            if (documentTypeDetails.getDocumentName().equals("Registered Will Document") || documentTypeDetails.getDocumentName().equals("Un-registered Will Document")) {
                if (!dt.getName().equals("Will Deed")) continue;
                documentTypeIterator.remove();
                continue;
            }
            if (documentTypeDetails.getDocumentName().equals("Decree by Civil Court")) {
                if (!dt.getName().equals("Decree Document")) continue;
                documentTypeIterator.remove();
                continue;
            }
            if (documentTypeDetails.getDocumentName().equals("Registered Document")) {
                if (!dt.getName().equals("Registered Document")) continue;
                documentTypeIterator.remove();
                continue;
            }
            if (!dt.getName().equals("Photo of Property With Holder")) continue;
            documentTypeIterator.remove();
        }
        return documentTypes;
    }

    public Map<Installment, Map<String, BigDecimal>> getExcessCollAmtMap() {
        return this.excessCollAmtMap;
    }

    public void setExcessCollAmtMap(Map<Installment, Map<String, BigDecimal>> excessCollAmtMap) {
        this.excessCollAmtMap = excessCollAmtMap;
    }

    public EisCommonsService getEisCommonsService() {
        return this.eisCommonsService;
    }

    public void setEisCommonsService(EisCommonsService eisCommonsService) {
        this.eisCommonsService = eisCommonsService;
    }

    public BigDecimal getTotalAlv() {
        return this.totalAlv;
    }

    public void setTotalAlv(BigDecimal totalAlv) {
        this.totalAlv = totalAlv;
    }
}

