/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.property;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.persistence.entity.Address;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.infstr.services.PersistenceService;
import org.egov.portal.entity.Citizen;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.report.bean.PropertyAckNoticeInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;

public class PropertyPersistenceService
extends PersistenceService<BasicProperty, Long> {
    private static final String FROM_USER_WHERE_NAME_AND_MOBILE_NUMBER_AND_GENDER = "From User where name = ? and mobileNumber = ? and gender = ? ";
    private static final Logger LOGGER = Logger.getLogger(PropertyPersistenceService.class);
    private static final String CREATE_ACK_TEMPLATE = "mainCreatePropertyAck";
    @Autowired
    private UserService userService;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private ReportService reportService;

    public PropertyPersistenceService() {
        super(BasicProperty.class);
    }

    public PropertyPersistenceService(Class<BasicProperty> type) {
        super(type);
    }

    public void createOwners(Property property, BasicProperty basicProperty, Address ownerAddress) {
        LOGGER.debug((Object)("createOwners for property: " + property + ", basicProperty: " + basicProperty + ", ownerAddress: " + ownerAddress));
        int orderNo = 0;
        basicProperty.getPropertyOwnerInfo().clear();
        for (PropertyOwnerInfo ownerInfo : property.getBasicProperty().getPropertyOwnerInfoProxy()) {
            ++orderNo;
            if (ownerInfo != null) {
                User user = StringUtils.isNotBlank((CharSequence)ownerInfo.getOwner().getAadhaarNumber()) ? this.userService.getUserByAadhaarNumber(ownerInfo.getOwner().getAadhaarNumber()) : (User)this.find(FROM_USER_WHERE_NAME_AND_MOBILE_NUMBER_AND_GENDER, new Object[]{ownerInfo.getOwner().getName(), ownerInfo.getOwner().getMobileNumber(), ownerInfo.getOwner().getGender()});
                if (user == null) {
                    Citizen newOwner = new Citizen();
                    this.createNewOwner(ownerInfo, newOwner);
                    this.persistUponPaymentResponse(basicProperty);
                    ownerInfo.setBasicProperty(basicProperty);
                    ownerInfo.setOwner((User)newOwner);
                    ownerInfo.setOrderNo(orderNo);
                    ownerInfo.getOwner().addAddress(ownerAddress);
                } else {
                    user.setEmailId(ownerInfo.getOwner().getEmailId());
                    user.setGuardian(ownerInfo.getOwner().getGuardian());
                    user.setGuardianRelation(ownerInfo.getOwner().getGuardianRelation());
                    ownerInfo.setOwner(user);
                    ownerInfo.setOrderNo(orderNo);
                    ownerInfo.setBasicProperty(basicProperty);
                }
            }
            basicProperty.addPropertyOwners(ownerInfo);
        }
    }

    public void createOwnersForAppurTenant(Property property, BasicProperty basicProperty, Address ownerAddress) {
        int orderNo = 0;
        basicProperty.getPropertyOwnerInfo().clear();
        for (PropertyOwnerInfo ownerInfo : property.getBasicProperty().getPropertyOwnerInfoProxy()) {
            PropertyOwnerInfo owner = new PropertyOwnerInfo();
            ++orderNo;
            if (ownerInfo != null) {
                User user = StringUtils.isNotBlank((CharSequence)ownerInfo.getOwner().getAadhaarNumber()) ? this.userService.getUserByAadhaarNumber(ownerInfo.getOwner().getAadhaarNumber()) : (User)this.find(FROM_USER_WHERE_NAME_AND_MOBILE_NUMBER_AND_GENDER, new Object[]{ownerInfo.getOwner().getName(), ownerInfo.getOwner().getMobileNumber(), ownerInfo.getOwner().getGender()});
                if (user == null) {
                    Citizen newOwner = new Citizen();
                    this.createNewOwner(ownerInfo, newOwner);
                    this.persistUponPaymentResponse(basicProperty);
                    owner.setBasicProperty(basicProperty);
                    owner.setOwner((User)newOwner);
                    owner.setOrderNo(orderNo);
                    owner.setOwnerType(ownerInfo.getOwnerType());
                    owner.setSource(ownerInfo.getSource());
                    LOGGER.debug((Object)("createOwners: OwnerAddress: " + ownerAddress));
                    owner.getOwner().addAddress(ownerAddress);
                } else {
                    user.setEmailId(ownerInfo.getOwner().getEmailId());
                    user.setGuardian(ownerInfo.getOwner().getGuardian());
                    user.setGuardianRelation(ownerInfo.getOwner().getGuardianRelation());
                    owner.setOwner(user);
                    owner.setOrderNo(orderNo);
                    owner.setBasicProperty(basicProperty);
                    owner.setOwnerType(ownerInfo.getOwnerType());
                    owner.setSource(ownerInfo.getSource());
                }
            }
            basicProperty.addPropertyOwners(owner);
        }
    }

    private void createNewOwner(PropertyOwnerInfo ownerInfo, Citizen newOwner) {
        newOwner.setAadhaarNumber(ownerInfo.getOwner().getAadhaarNumber());
        newOwner.setMobileNumber(ownerInfo.getOwner().getMobileNumber());
        newOwner.setEmailId(ownerInfo.getOwner().getEmailId());
        newOwner.setGender(ownerInfo.getOwner().getGender());
        newOwner.setGuardian(ownerInfo.getOwner().getGuardian());
        newOwner.setGuardianRelation(ownerInfo.getOwner().getGuardianRelation());
        newOwner.setName(ownerInfo.getOwner().getName());
        newOwner.setSalutation(ownerInfo.getOwner().getSalutation());
        newOwner.setPassword("NOT SET");
        newOwner.setUsername(this.propertyTaxUtil.generateUserName(ownerInfo.getOwner().getName()));
        this.userService.createUser((User)newOwner);
    }

    public BasicProperty persistUponPaymentResponse(BasicProperty basicProperty) {
        return basicProperty;
    }

    public BasicProperty createBasicProperty(BasicProperty basicProperty, HashMap meesevaParams) {
        return (BasicProperty)this.persist(basicProperty);
    }

    public ReportOutput propertyAcknowledgement(PropertyImpl property, String cityLogo, String cityName) {
        HashMap<String, String> reportParams = new HashMap<String, String>();
        PropertyAckNoticeInfo ackBean = new PropertyAckNoticeInfo();
        ackBean.setOwnerName(property.getBasicProperty().getFullOwnerName());
        ackBean.setOwnerAddress(property.getBasicProperty().getAddress().toString());
        ackBean.setApplicationDate(new SimpleDateFormat("dd/MM/yyyy").format(property.getBasicProperty().getCreatedDate()));
        ackBean.setApplicationNo(property.getApplicationNo());
        ackBean.setApprovedDate(new SimpleDateFormat("dd/MM/yyyy").format(property.getState().getCreatedDate()));
        Date tempNoticeDate = DateUtils.add((Date)property.getState().getCreatedDate(), (int)5, (int)15);
        ackBean.setNoticeDueDate(tempNoticeDate);
        reportParams.put("logoPath", cityLogo);
        reportParams.put("cityName", cityName);
        reportParams.put("loggedInUsername", this.userService.getUserById(ApplicationThreadLocals.getUserId()).getName());
        ReportRequest reportInput = new ReportRequest(CREATE_ACK_TEMPLATE, (Object)ackBean, reportParams);
        reportInput.setReportFormat(ReportConstants.FileFormat.PDF);
        return this.reportService.createReport(reportInput);
    }

    public String updateOwners(Property property, BasicProperty basicProperty, String doorNumber, BindingResult errors) {
        LOGGER.debug((Object)("Update Owner and door number for property: " + property + ", basicProperty: " + basicProperty + ", doorNumber: " + doorNumber));
        basicProperty.getAddress().setHouseNoBldgApt(doorNumber);
        StringBuilder errorMesg = new StringBuilder();
        for (PropertyOwnerInfo ownerInfo : basicProperty.getPropertyOwnerInfo()) {
            if (ownerInfo == null) continue;
            User user = null;
            for (Address address : ownerInfo.getOwner().getAddress()) {
                address.setHouseNoBldgApt(doorNumber);
            }
            if (StringUtils.isNotBlank((CharSequence)ownerInfo.getOwner().getAadhaarNumber())) {
                user = this.userService.getUserByAadhaarNumber(ownerInfo.getOwner().getAadhaarNumber());
            }
            if (user == null || user.getId().equals(ownerInfo.getOwner().getId())) {
                this.userService.updateUser(ownerInfo.getOwner());
                continue;
            }
            BasicProperty basicProp = (BasicProperty)this.find("select basicProperty from PropertyOwnerInfo where owner = ?", new Object[]{user.getId()});
            errorMesg.append("With entered aadhar number - ").append(ownerInfo.getOwner().getAadhaarNumber()).append(" there is already owner present with owner name: ").append(user.getName()).append(" for assessment number : ").append(basicProp.getUpicNo());
            break;
        }
        this.persist(basicProperty);
        LOGGER.debug((Object)"Exit from updateOwners");
        return errorMesg.toString();
    }

    public void updateOwners(Property property, BasicProperty basicProp, Address ownerAddress) {
        int orderNo = 0;
        basicProp.getPropertyOwnerInfo().clear();
        for (PropertyOwnerInfo ownerInfo : property.getBasicProperty().getPropertyOwnerInfoProxy()) {
            if (ownerInfo != null) {
                User user = StringUtils.isNotBlank((CharSequence)ownerInfo.getOwner().getAadhaarNumber()) ? this.userService.getUserByAadhaarNumber(ownerInfo.getOwner().getAadhaarNumber()) : (User)this.find(FROM_USER_WHERE_NAME_AND_MOBILE_NUMBER_AND_GENDER, new Object[]{ownerInfo.getOwner().getName(), ownerInfo.getOwner().getMobileNumber(), ownerInfo.getOwner().getGender()});
                if (user == null) {
                    Citizen newOwner = new Citizen();
                    this.createNewOwner(ownerInfo, newOwner);
                    ownerInfo.setBasicProperty(basicProp);
                    ownerInfo.setOwner((User)newOwner);
                    ownerInfo.setOrderNo(++orderNo);
                    LOGGER.debug((Object)("createOwners: OwnerAddress: " + ownerAddress));
                    ownerInfo.getOwner().addAddress(ownerAddress);
                } else {
                    user.setAadhaarNumber(ownerInfo.getOwner().getAadhaarNumber());
                    user.setMobileNumber(ownerInfo.getOwner().getMobileNumber());
                    user.setName(ownerInfo.getOwner().getName());
                    user.setGender(ownerInfo.getOwner().getGender());
                    user.setEmailId(ownerInfo.getOwner().getEmailId());
                    user.setGuardian(ownerInfo.getOwner().getGuardian());
                    user.setGuardianRelation(ownerInfo.getOwner().getGuardianRelation());
                    ownerInfo.setOwner(user);
                    ownerInfo.setBasicProperty(basicProp);
                }
            }
            basicProp.addPropertyOwners(ownerInfo);
        }
    }

    public BasicProperty updateBasicProperty(BasicProperty basicProperty, HashMap<String, String> meesevaParams) {
        return (BasicProperty)this.update(basicProperty);
    }
}

