/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.notice;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.notice.PtNotice;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class NoticeService
extends PersistenceService<PtNotice, Long> {
    @Autowired
    PersistenceService<BasicProperty, Long> basicPropertyService;
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private FinancialYearDAO financialYearDAO;

    public NoticeService() {
        super(PtNotice.class);
    }

    public NoticeService(Class<PtNotice> type) {
        super(type);
    }

    public PtNotice saveNotice(String applicationNumber, String noticeNo, String noticeType, BasicProperty basicProperty, InputStream fileStream) {
        PtNotice ptNotice = new PtNotice();
        Module module = this.moduleDao.getModuleByName("Property Tax");
        ptNotice.setModuleId(module.getId());
        ptNotice.setNoticeDate(new Date());
        ptNotice.setNoticeNo(noticeNo);
        ptNotice.setNoticeType(noticeType);
        ptNotice.setUserId(ApplicationThreadLocals.getUserId());
        ptNotice.setBasicProperty(basicProperty);
        ptNotice.setApplicationNumber(applicationNumber);
        String fileName = ptNotice.getNoticeNo() + ".pdf";
        FileStoreMapper fileStore = this.fileStoreService.store(fileStream, fileName, "application/pdf", "PTIS");
        ptNotice.setFileStore(fileStore);
        basicProperty.addNotice(ptNotice);
        this.basicPropertyService.update((Object)basicProperty);
        this.getSession().flush();
        return ptNotice;
    }

    public PtNotice updateNotice(PtNotice notice, InputStream fileStream) {
        String fileName = notice.getNoticeNo() + ".pdf";
        FileStoreMapper fileStore = this.fileStoreService.store(fileStream, fileName, "application/pdf", "PTIS");
        notice.setFileStore(fileStore);
        notice.setNoticeDate(new Date());
        this.basicPropertyService.update((Object)notice.getBasicProperty());
        this.getSession().flush();
        return notice;
    }

    public PtNotice getPtNoticeByNoticeNumberAndNoticeType(String noticeNo, String noticeType) {
        Query qry = this.getSession().createQuery("from PtNotice Pn where upper(Pn.noticeNo) = :noticeNumber and upper(noticeType)=:noticeType ");
        qry.setString("noticeNumber", noticeNo.toUpperCase());
        qry.setString("noticeType", noticeType.toUpperCase());
        return (PtNotice)qry.uniqueResult();
    }

    public PtNotice getNoticeByApplicationNumber(String applicationNo) {
        return (PtNotice)this.basicPropertyService.find("from PtNotice where applicationNumber = ?", new Object[]{applicationNo});
    }

    public PtNotice getNoticeByNoticeTypeAndApplicationNumber(String noticeType, String applicationNo) {
        return (PtNotice)this.basicPropertyService.find("from PtNotice where noticeType = ? and applicationNumber = ?", new Object[]{noticeType, applicationNo});
    }

    public PtNotice getNoticeByNoticeTypeAndAssessmentNumner(String noticeType, String assessementNumber) {
        return (PtNotice)this.basicPropertyService.find("from PtNotice where noticeType = ? and basicProperty.upicNo = ?", new Object[]{noticeType, assessementNumber});
    }

    public PersistenceService<BasicProperty, Long> getBasicPropertyService() {
        return this.basicPropertyService;
    }

    public void setbasicPropertyService(PersistenceService<BasicProperty, Long> basicPropertyService) {
        this.basicPropertyService = basicPropertyService;
    }

    public String getNoticeByApplicationNo(String applicationNo) {
        List notices;
        StringBuilder queryStr = new StringBuilder(500);
        String noticeNum = "";
        queryStr.append("select notice.noticeNo from PtNotice notice left join notice.basicProperty bp , PropertyMutation mt ");
        queryStr.append(" where notice.applicationNumber=:applicationNo");
        queryStr.append(" and notice.id = ( select max(id) from PtNotice where  applicationNumber = notice.applicationNumber and basicProperty = mt.basicProperty)");
        Query query = this.getSession().createQuery(queryStr.toString());
        if (StringUtils.isNotBlank((String)applicationNo)) {
            query.setString("applicationNo", applicationNo);
        }
        noticeNum = (notices = query.list()).size() != 0 ? (String)query.list().get(0) : "";
        return noticeNum;
    }

    public List<PropertyMutation> getListofMutations(String indexNumber) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select mt from PropertyMutation mt left join mt.basicProperty bp ");
        if (StringUtils.isNotBlank((String)indexNumber)) {
            queryStr.append(" where bp.upicNo=:assessmentNo ");
        }
        queryStr.append(" order by mt.mutationDate desc ");
        Query query = this.getSession().createQuery(queryStr.toString());
        if (StringUtils.isNotBlank((String)indexNumber)) {
            query.setString("assessmentNo", indexNumber);
        }
        List mutations = query.list();
        return mutations;
    }

    public PtNotice getNoticeByTypeUpicNoAndFinYear(String noticeType, String assessementNumber) {
        CFinancialYear currFinYear = this.financialYearDAO.getFinancialYearByDate(new Date());
        return (PtNotice)this.basicPropertyService.find("from PtNotice where noticeType = ? and basicProperty.upicNo = ?  and noticeDate between ? and ? ", new Object[]{noticeType, assessementNumber, currFinYear.getStartingDate(), currFinYear.getEndingDate()});
    }

    public PtNotice getPtNoticeByNoticeNumberAndBillType(String noticeNo, List<String> noticeType) {
        Query qry = this.getSession().createQuery("from PtNotice Pn where upper(Pn.noticeNo) = :noticeNumber and upper(noticeType) in (:noticeType) ");
        qry.setString("noticeNumber", noticeNo.toUpperCase());
        qry.setParameterList("noticeType", noticeType);
        return (PtNotice)qry.uniqueResult();
    }
}

