/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.intgdemandbill;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.egov.demand.model.EgBill;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.service.bill.BillService;
import org.egov.ptis.notice.PtNotice;
import org.egov.ptis.service.DemandBill.DemandBillService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.BindingResult;

@Service
public class IntgDemandBillService {
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private ApplicationContext beanProvider;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private BillService billService;
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    protected transient PersistenceService persistenceService;
    @Autowired
    protected FileStoreService fileStoreService;

    public void validate(EgBill egBill, BindingResult errors) {
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(egBill.getConsumerId());
        if (basicProperty == null) {
            errors.reject("property.invalid", "property.invalid");
        } else if (basicProperty.getProperty().getIsExemptedFromTax().booleanValue()) {
            errors.reject("error.msg.taxExempted", "error.msg.taxExempted");
        }
    }

    public ResponseEntity<byte[]> generateIntgDemandBill(String assessment) {
        ReportOutput reportOutput;
        String clientSpecificDmdBill = this.propertyTaxCommonUtils.getAppConfigValue("IS_CLIENT_SPECIFIC_DEMANDBILL", "Property Tax");
        if ("Y".equalsIgnoreCase(clientSpecificDmdBill)) {
            DemandBillService demandBillService = (DemandBillService)this.beanProvider.getBean("demandBillService");
            reportOutput = demandBillService.generateDemandBill(assessment, "Integrated Bill");
        } else {
            reportOutput = this.getBill(assessment);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=Integrated Bill_" + assessment + ".pdf");
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    private ReportOutput getBill(String assessment) {
        ReportOutput reportOutput;
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessment);
        EgBill egBill = (EgBill)this.persistenceService.find("FROM EgBill WHERE module = ? AND egBillType.code = ? AND consumerId = ? AND is_history = 'N'", new Object[]{this.moduleDao.getModuleByName("Property Tax"), "MANUAL", basicProperty.getUpicNo()});
        if (egBill == null) {
            reportOutput = this.billService.generateBill(basicProperty, ApplicationThreadLocals.getUserId().intValue());
        } else {
            String query = "SELECT notice FROM EgBill bill, PtNotice notice left join notice.basicProperty bp WHERE bill.is_History = 'N' AND bill.egBillType.code = ? AND bill.billNo = notice.noticeNo AND notice.noticeType = ? AND bp = ?";
            PtNotice ptNotice = (PtNotice)this.persistenceService.find("SELECT notice FROM EgBill bill, PtNotice notice left join notice.basicProperty bp WHERE bill.is_History = 'N' AND bill.egBillType.code = ? AND bill.billNo = notice.noticeNo AND notice.noticeType = ? AND bp = ?", new Object[]{"MANUAL", "Bill", basicProperty});
            reportOutput = new ReportOutput();
            if (ptNotice != null && ptNotice.getFileStore() != null) {
                FileStoreMapper fsm = ptNotice.getFileStore();
                File file = this.fileStoreService.fetch(fsm, "PTIS");
                try {
                    byte[] bFile = FileUtils.readFileToByteArray((File)file);
                    reportOutput.setReportOutputData(bFile);
                    reportOutput.setReportFormat(ReportConstants.FileFormat.PDF);
                }
                catch (IOException e) {
                    throw new ApplicationRuntimeException("IntgDemandBillService.getBill() : Integrated Bill Generation Exception : " + e);
                }
            }
        }
        return reportOutput;
    }
}

