/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.exemption;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemandDetails;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Position;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Floor;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyDetail;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.entity.property.TaxExemptionReason;
import org.egov.ptis.domain.service.property.PropertyPersistenceService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;

@Service
@Transactional
public class TaxExemptionService
extends PersistenceService<PropertyImpl, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaxExemptionService.class);
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private PropertyPersistenceService propertyPerService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<PropertyImpl> propertyWorkflowService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    PropertyImpl propertyModel = new PropertyImpl();
    @Autowired
    private ApplicationNumberGenerator applicationNumberGenerator;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource ptisMessageSource;
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private AssignmentService assignmentService;
    Property property = null;

    public TaxExemptionService() {
        super(PropertyImpl.class);
    }

    public TaxExemptionService(Class<PropertyImpl> type) {
        super(type);
    }

    @Transactional
    public BasicProperty saveProperty(Property newProperty, Property oldProperty, Character status, String approvalComment, String workFlowAction, Long approvalPosition, String taxExemptedReason, Boolean propertyByEmployee, String additionalRule) {
        BasicProperty basicProperty = oldProperty.getBasicProperty();
        PropertyDetail propertyDetail = oldProperty.getPropertyDetail();
        propertyDetail.getDateOfCompletion();
        this.propertyModel = (PropertyImpl)newProperty;
        this.propertyModel.setStatus(status);
        if (this.propertyModel.getApplicationNo() == null) {
            this.propertyModel.setApplicationNo(this.applicationNumberGenerator.generate());
        }
        Map<String, Installment> yearwiseInstMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
        Installment installmentFirstHalf = yearwiseInstMap.get("Current 1st Half");
        Installment installmentSecondHalf = yearwiseInstMap.get("Current 2nd Half");
        Date effectiveDate = null;
        if ("ONLINE".equalsIgnoreCase(this.propertyModel.getSource()) && ApplicationThreadLocals.getUserId() == null) {
            ApplicationThreadLocals.setUserId((Long)this.securityUtils.getCurrentUser().getId());
        }
        effectiveDate = DateUtils.between((Date)new Date(), (Date)installmentFirstHalf.getFromDate(), (Date)installmentFirstHalf.getToDate()) ? (StringUtils.isNotBlank((CharSequence)taxExemptedReason) && !taxExemptedReason.equals("-1") ? installmentSecondHalf.getFromDate() : installmentFirstHalf.getFromDate()) : (StringUtils.isNotBlank((CharSequence)taxExemptedReason) && !taxExemptedReason.equals("-1") ? org.apache.commons.lang3.time.DateUtils.addYears((Date)installmentFirstHalf.getFromDate(), (int)1) : installmentSecondHalf.getFromDate());
        if (!this.propertyModel.getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND")) {
            this.propertyService.getLowestDtOfCompFloorWise(propertyDetail.getFloorDetails());
        } else {
            propertyDetail.getDateOfCompletion();
        }
        for (Floor floor : this.propertyModel.getPropertyDetail().getFloorDetails()) {
            this.propertyPerService.applyAuditing(floor);
            floor.setPropertyDetail(this.propertyModel.getPropertyDetail());
        }
        if (StringUtils.isNotBlank((CharSequence)taxExemptedReason) && !taxExemptedReason.equals("-1")) {
            TaxExemptionReason taxExemptionReason = (TaxExemptionReason)((Object)this.propertyPerService.find("From TaxExemptionReason where id = ?", new Object[]{Long.valueOf(taxExemptedReason)}));
            this.propertyModel.setTaxExemptedReason(taxExemptionReason);
            this.propertyModel.setIsExemptedFromTax(Boolean.TRUE);
        } else {
            this.propertyModel.setTaxExemptedReason(null);
            this.propertyModel.setIsExemptedFromTax(Boolean.FALSE);
        }
        this.propertyModel.setEffectiveDate(effectiveDate);
        basicProperty.setUnderWorkflow(Boolean.TRUE);
        Set<Ptdemand> newPtdemandSet = this.propertyModel.getPtDemandSet();
        HashSet<EgDemandDetails> demandDetailSet = new HashSet<EgDemandDetails>();
        if ((!StringUtils.isNotBlank((CharSequence)taxExemptedReason) || taxExemptedReason.equals("-1")) && StringUtils.isNotBlank((CharSequence)workFlowAction) && !workFlowAction.equalsIgnoreCase("Reject")) {
            for (Ptdemand ptdemand : newPtdemandSet) {
                if (!ptdemand.getEgInstallmentMaster().equals((Object)installmentFirstHalf)) continue;
                for (EgDemandDetails demandDetails : ptdemand.getEgDemandDetails()) {
                    if (!demandDetails.getInstallmentStartDate().equals(effectiveDate) && !demandDetails.getInstallmentStartDate().after(effectiveDate)) continue;
                    demandDetailSet.add(demandDetails);
                }
                ptdemand.getEgDemandDetails().clear();
                ptdemand.getEgDemandDetails().addAll(demandDetailSet);
            }
        }
        for (Ptdemand ptdemand : newPtdemandSet) {
            this.propertyPerService.applyAuditing(ptdemand.getDmdCalculations());
        }
        this.propertyModel.setBasicProperty(basicProperty);
        basicProperty.addProperty(this.propertyModel);
        this.transitionWorkFlow(this.propertyModel, approvalComment, workFlowAction, approvalPosition, additionalRule, propertyByEmployee);
        return (BasicProperty)this.propertyPerService.update(basicProperty);
    }

    @Transactional
    public void updateProperty(Property newProperty, String comments, String workFlowAction, Long approverPosition, Boolean propertyByEmployee, String additionalRule) {
        this.transitionWorkFlow((PropertyImpl)newProperty, comments, workFlowAction, approverPosition, additionalRule, propertyByEmployee);
        this.propertyPerService.update(newProperty.getBasicProperty());
    }

    private void transitionWorkFlow(PropertyImpl property, String approvarComments, String workFlowAction, Long approverPosition, String additionalRule, Boolean propertyByEmployee) {
        String currentState;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("WorkFlow Transition For Demolition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Position pos = null;
        Assignment wfInitiator = null;
        Assignment assignment = null;
        String approverDesignation = "";
        String nextAction = "";
        if (!propertyByEmployee.booleanValue() || "Anonymous".equalsIgnoreCase(user.getName())) {
            currentState = "Created";
            wfInitiator = this.propertyService.isCscOperator(user) != false ? (assignment = this.propertyService.getMappedAssignmentForCscOperator(property.getBasicProperty())) : (assignment = this.propertyService.getUserPositionByZone(property.getBasicProperty(), false));
            if (null != assignment) {
                approverPosition = assignment.getPosition().getId();
            }
        } else {
            currentState = null;
            if (null != approverPosition && approverPosition != 0L) {
                assignment = (Assignment)this.assignmentService.getAssignmentsForPosition(approverPosition, new Date()).get(0);
                assignment.getEmployee().getName().concat("~").concat(assignment.getPosition().getName());
                approverDesignation = assignment.getDesignation().getName();
            }
        }
        String loggedInUserDesignation = "";
        if (property.getState() != null) {
            loggedInUserDesignation = this.getLoggedInUserDesignation(property.getCurrentState().getOwnerPosition().getId(), this.securityUtils.getCurrentUser());
        }
        if (loggedInUserDesignation.equals("Junior Assistant") || loggedInUserDesignation.equals("Senior Assistant")) {
            loggedInUserDesignation = null;
        }
        if ("Forward".equalsIgnoreCase(workFlowAction) && (approverDesignation.equalsIgnoreCase("Assistant commissioner") || approverDesignation.equalsIgnoreCase("Deputy commissioner") || approverDesignation.equalsIgnoreCase("Additional Commissioner") || approverDesignation.equalsIgnoreCase("Zonal Commissioner") || approverDesignation.equalsIgnoreCase("Commissioner"))) {
            String designation;
            nextAction = property.getCurrentState().getNextAction().equalsIgnoreCase("Digital Signature Pending") ? "Digital Signature Pending" : ((designation = approverDesignation.split(" ")[0]).equalsIgnoreCase("Commissioner") ? "Commissioner Approval Pending" : designation + " " + "Commissioner Approval Pending");
        }
        if (property.getId() != null && property.getState() != null) {
            wfInitiator = this.propertyService.getWorkflowInitiator(property);
        } else if (wfInitiator == null) {
            wfInitiator = this.propertyTaxCommonUtils.getWorkflowInitiatorAssignment(user.getId());
        }
        if ("Reject".equalsIgnoreCase(workFlowAction)) {
            if (wfInitiator.getPosition().equals((Object)property.getState().getOwnerPosition())) {
                property.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvarComments).withDateInfo(currentDate.toDate());
                property.setStatus(PropertyTaxConstants.STATUS_CANCELLED);
                property.getBasicProperty().setUnderWorkflow(Boolean.FALSE);
            } else {
                Assignment assignmentOnreject = this.getUserAssignmentOnReject(loggedInUserDesignation, property);
                if (assignmentOnreject != null) {
                    nextAction = "UD Revenue Inspector Approval Pending";
                    wfInitiator = assignmentOnreject;
                } else {
                    nextAction = "Assistant Approval Pending";
                }
                String stateValue = property.getCurrentState().getValue().split(":")[0] + ":" + "Rejected";
                property.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvarComments).withStateValue(stateValue).withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction(nextAction);
                this.buildSMS(property, workFlowAction);
            }
        } else {
            WorkFlowMatrix wfmatrix;
            if ("Approve".equalsIgnoreCase(workFlowAction)) {
                pos = property.getCurrentState().getOwnerPosition();
            } else if (null != approverPosition && approverPosition != -1L && !approverPosition.equals(0L)) {
                pos = this.positionMasterService.getPositionById(approverPosition);
            }
            if (null == property.getState()) {
                wfmatrix = this.propertyWorkflowService.getWfMatrix(property.getStateType(), null, null, additionalRule, currentState, null);
                property.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvarComments).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Tax Exemption").withInitiator(wfInitiator != null ? wfInitiator.getPosition() : null);
            } else if (property.getCurrentState().getNextAction().equalsIgnoreCase("END")) {
                property.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvarComments).withDateInfo(currentDate.toDate());
            } else {
                wfmatrix = this.propertyWorkflowService.getWfMatrix(property.getStateType(), null, null, additionalRule, property.getCurrentState().getValue(), property.getCurrentState().getNextAction(), null, loggedInUserDesignation);
                property.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvarComments).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(StringUtils.isNotBlank((CharSequence)nextAction) ? nextAction : wfmatrix.getNextAction());
                if (workFlowAction.equalsIgnoreCase("Approve")) {
                    this.buildSMS(property, workFlowAction);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(" WorkFlow Transition Completed for Demolition ...");
        }
    }

    public void addModelAttributes(Model model, BasicProperty basicProperty) {
        this.property = null != basicProperty.getWFProperty() ? basicProperty.getWFProperty() : basicProperty.getActiveProperty();
        Ptdemand ptDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(this.property);
        if (ptDemand != null && ptDemand.getDmdCalculations() != null && ptDemand.getDmdCalculations().getAlv() != null) {
            model.addAttribute("ARV", (Object)ptDemand.getDmdCalculations().getAlv());
        } else {
            model.addAttribute("ARV", (Object)BigDecimal.ZERO);
        }
        model.addAttribute("propertyByEmployee", (Object)(this.propertyService.isEmployee(this.securityUtils.getCurrentUser()) != false && !"Anonymous".equalsIgnoreCase(this.securityUtils.getCurrentUser().getName()) ? 1 : 0));
        if (!this.property.getIsExemptedFromTax().booleanValue()) {
            try {
                Map<String, Map<String, BigDecimal>> demandCollMap = this.propertyTaxUtil.prepareDemandDetForView(this.property, this.propertyTaxCommonUtils.getCurrentInstallment());
                Map<String, BigDecimal> currentTaxDetails = this.propertyService.getCurrentTaxDetails(demandCollMap, new Date());
                model.addAttribute("currTax", (Object)currentTaxDetails.get("CURR_DMD"));
                model.addAttribute("eduCess", (Object)currentTaxDetails.get("Education Cess"));
                model.addAttribute("currTaxDue", (Object)currentTaxDetails.get("CURR_DMD").subtract(currentTaxDetails.get("CURR_COLL")));
                model.addAttribute("libraryCess", (Object)currentTaxDetails.get("Library Cess"));
                model.addAttribute("totalArrDue", (Object)currentTaxDetails.get("ARR_DMD").subtract(currentTaxDetails.get("ARR_COLL")));
                BigDecimal propertyTax = BigDecimal.ZERO;
                propertyTax = null != currentTaxDetails.get("General Tax") ? currentTaxDetails.get("General Tax") : currentTaxDetails.get("Vacant Land Tax");
                BigDecimal totalTax = propertyTax.add(currentTaxDetails.get("Library Cess") == null ? BigDecimal.ZERO : currentTaxDetails.get("Library Cess")).add(currentTaxDetails.get("Education Cess") == null ? BigDecimal.ZERO : currentTaxDetails.get("Education Cess"));
                model.addAttribute("propertyTax", (Object)propertyTax);
                if (currentTaxDetails.get("Unauthorized Penalty") != null) {
                    model.addAttribute("unauthorisedPenalty", (Object)currentTaxDetails.get("Unauthorized Penalty"));
                    model.addAttribute("totalTax", (Object)totalTax.add(currentTaxDetails.get("Unauthorized Penalty")));
                    model.addAttribute("showUnauthorisedPenalty", (Object)"yes");
                } else {
                    model.addAttribute("totalTax", (Object)totalTax);
                    model.addAttribute("showUnauthorisedPenalty", (Object)"no");
                }
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException("Exception in addModelAttributes : " + e);
            }
        }
    }

    public Boolean isPropertyByEmployee(Property property) {
        return this.propertyService.isEmployee(property.getCreatedBy());
    }

    public BasicProperty saveProperty(Property newProperty, Property oldProperty, Character status, String approvalComment, String workFlowAction, Long approvalPosition, String taxExemptedReason, Boolean propertyByEmployee, String additionalRule, HashMap<String, String> meesevaParams) {
        return this.saveProperty(newProperty, oldProperty, status, approvalComment, workFlowAction, approvalPosition, taxExemptedReason, propertyByEmployee, "EXEMPTION");
    }

    public void buildSMS(Property property, String workFlowAction) {
        for (PropertyOwnerInfo ownerInfo : property.getBasicProperty().getPropertyOwnerInfo()) {
            if (!StringUtils.isNotBlank((CharSequence)ownerInfo.getOwner().getMobileNumber())) continue;
            this.buildSms(property, ownerInfo.getOwner(), workFlowAction);
        }
    }

    private void buildSms(Property property, User user, String workFlowAction) {
        String assessmentNo = property.getBasicProperty().getUpicNo();
        String mobileNumber = user.getMobileNumber();
        String applicantName = user.getName();
        String smsMsg = "";
        if (!workFlowAction.equals("Forward")) {
            if (workFlowAction.equals("Reject")) {
                smsMsg = this.ptisMessageSource.getMessage("msg.rejectexemption.sms", (Object[])new String[]{applicantName, assessmentNo, ApplicationThreadLocals.getMunicipalityName()}, null);
            } else if (workFlowAction.equals("Approve")) {
                Installment installment = this.propertyTaxUtil.getInstallmentListByStartDate(new Date()).get(0);
                Date effectiveDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)installment.getToDate(), (int)1);
                smsMsg = this.ptisMessageSource.getMessage("msg.approveexemption.sms", (Object[])new String[]{applicantName, assessmentNo, new SimpleDateFormat("dd/MM/yyyy").format(effectiveDate), ApplicationThreadLocals.getMunicipalityName()}, null);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)mobileNumber)) {
            this.messagingService.sendSMS(mobileNumber, smsMsg);
        }
    }

    public String getLoggedInUserDesignation(Long posId, User user) {
        List loggedInUserAssign = this.assignmentService.getAssignmentByPositionAndUserAsOnDate(posId, user.getId(), new Date());
        return !loggedInUserAssign.isEmpty() ? ((Assignment)loggedInUserAssign.get(0)).getDesignation().getName() : null;
    }

    public Assignment getUserAssignmentOnReject(String loggedInUserDesignation, PropertyImpl property) {
        Assignment assignmentOnreject = null;
        if (loggedInUserDesignation.equalsIgnoreCase("Revenue officer") || loggedInUserDesignation.equalsIgnoreCase("Assistant commissioner") || loggedInUserDesignation.equalsIgnoreCase("Additional Commissioner") || loggedInUserDesignation.equalsIgnoreCase("Deputy commissioner") || loggedInUserDesignation.equalsIgnoreCase("Commissioner") || loggedInUserDesignation.equalsIgnoreCase("Zonal Commissioner")) {
            assignmentOnreject = this.propertyService.getUserOnRejection(property);
        }
        return assignmentOnreject;
    }

    public Assignment getWfInitiator(PropertyImpl property) {
        return this.propertyService.getWorkflowInitiator(property);
    }

    public BigDecimal getWaterTaxDues(String assessmentNo, HttpServletRequest request) {
        return this.propertyService.getWaterTaxDues(assessmentNo, request).get("totalTaxDue") == null ? BigDecimal.ZERO : new BigDecimal((Double)this.propertyService.getWaterTaxDues(assessmentNo, request).get("totalTaxDue"));
    }

    public Boolean isUnderWtmsWF(String assessmentNo, HttpServletRequest request) {
        return this.propertyService.getWaterTaxDues(assessmentNo, request).get("isInWorkFlow") == null ? Boolean.FALSE : Boolean.valueOf((Boolean)this.propertyService.getWaterTaxDues(assessmentNo, request).get("isInWorkFlow"));
    }
}

