/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.demolition;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.demand.model.EgDemandDetails;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Position;
import org.egov.ptis.client.bill.PTBillServiceImpl;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.PropertyTypeMasterDAO;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyDetail;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.entity.property.VacantProperty;
import org.egov.ptis.domain.service.property.PropertyPersistenceService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.exceptions.TaxCalculatorExeption;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.hibernate.FlushMode;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;

public class PropertyDemolitionService
extends PersistenceService<PropertyImpl, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyDemolitionService.class);
    @Autowired
    private PropertyTypeMasterDAO propertyTypeMasterDAO;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private PropertyPersistenceService propertyPerService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private PTBillServiceImpl ptBillServiceImpl;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<PropertyImpl> propertyWorkflowService;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource ptisMessageSource;
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private AssignmentService assignmentService;

    public PropertyDemolitionService() {
        super(PropertyImpl.class);
    }

    public PropertyDemolitionService(Class<PropertyImpl> type) {
        super(type);
    }

    @Transactional
    public void saveProperty(Property oldProperty, Property newProperty, Character status, String comments, String workFlowAction, Long approverPosition, String additionalRule) throws TaxCalculatorExeption {
        BasicProperty basicProperty = oldProperty.getBasicProperty();
        PropertyTypeMaster propTypeMstr = this.propertyTypeMasterDAO.getPropertyTypeMasterByCode("VAC_LAND");
        PropertyImpl propertyModel = (PropertyImpl)newProperty;
        newProperty.getPropertyDetail().setPropertyTypeMaster(propTypeMstr);
        newProperty.getBasicProperty().setPropOccupationDate(newProperty.getPropertyDetail().getDateOfCompletion());
        String areaOfPlot = String.valueOf(propertyModel.getPropertyDetail().getSitalArea().getArea());
        propertyModel = this.propertyService.createProperty(propertyModel, areaOfPlot, "FULL DEMOLITION", propertyModel.getPropertyDetail().getPropertyTypeMaster().getId().toString(), null, null, status, null, null, null, null, null, null, null, null, null, null, Boolean.FALSE);
        if ("ONLINE".equalsIgnoreCase(propertyModel.getSource()) && ApplicationThreadLocals.getUserId() == null) {
            ApplicationThreadLocals.setUserId((Long)this.securityUtils.getCurrentUser().getId());
        }
        Map<String, Installment> yearwiseInstMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
        Installment installmentFirstHalf = yearwiseInstMap.get("Current 1st Half");
        Installment installmentSecondHalf = yearwiseInstMap.get("Current 2nd Half");
        Date effectiveDate = DateUtils.between((Date)new Date(), (Date)installmentFirstHalf.getFromDate(), (Date)installmentFirstHalf.getToDate()) ? installmentFirstHalf.getFromDate() : installmentSecondHalf.getFromDate();
        propertyModel.setBasicProperty(basicProperty);
        propertyModel.setEffectiveDate(effectiveDate);
        if (!propertyModel.getPropertyDetail().getPropertyTypeMaster().getCode().equals("VAC_LAND")) {
            this.propertyService.changePropertyDetail(propertyModel, new VacantProperty(), 0);
        }
        propertyModel.getPropertyDetail().setCategoryType("VACANTLAND");
        basicProperty.setUnderWorkflow(Boolean.TRUE);
        propertyModel.setBasicProperty(basicProperty);
        basicProperty.addProperty(propertyModel);
        this.getSession().setFlushMode(FlushMode.MANUAL);
        this.transitionWorkFlow(propertyModel, comments, workFlowAction, approverPosition, additionalRule);
        Installment currInstall = this.propertyTaxCommonUtils.getCurrentInstallment();
        Property modProperty = this.propertyService.createDemand(propertyModel, effectiveDate);
        Object currPtDmd = null;
        for (Object demand : modProperty.getPtDemandSet()) {
            if (!"N".equalsIgnoreCase(demand.getIsHistory()) || !demand.getEgInstallmentMaster().equals((Object)currInstall)) continue;
            currPtDmd = demand;
            break;
        }
        Ptdemand oldCurrPtDmd = null;
        for (Ptdemand ptDmd : oldProperty.getPtDemandSet()) {
            if (!"N".equalsIgnoreCase(ptDmd.getIsHistory()) || !ptDmd.getEgInstallmentMaster().equals((Object)currInstall)) continue;
            oldCurrPtDmd = ptDmd;
            break;
        }
        Module module = this.moduleDao.getModuleByName("Property Tax");
        Installment effectiveInstall = this.installmentDao.getInsatllmentByModuleForGivenDate(module, effectiveDate);
        this.propertyService.addArrDmdDetToCurrentDmd(oldCurrPtDmd, (Ptdemand)((Object)currPtDmd), effectiveInstall, true);
        basicProperty.addProperty(modProperty);
        for (Ptdemand ptDemand : modProperty.getPtDemandSet()) {
            this.propertyPerService.applyAuditing(ptDemand.getDmdCalculations());
        }
        this.adjustCollection(oldCurrPtDmd, (Ptdemand)((Object)currPtDmd), effectiveInstall);
        this.propertyPerService.update(basicProperty);
        this.getSession().flush();
    }

    private Ptdemand adjustCollection(Ptdemand oldCurrPtDmd, Ptdemand currPtDmd, Installment effectiveInstall) {
        BigDecimal totalColl = BigDecimal.ZERO;
        for (EgDemandDetails oldDmdDtls : oldCurrPtDmd.getEgDemandDetails()) {
            if (!oldDmdDtls.getInstallmentStartDate().equals(effectiveInstall.getFromDate()) && !oldDmdDtls.getInstallmentStartDate().after(effectiveInstall.getFromDate())) continue;
            totalColl = totalColl.add(oldDmdDtls.getAmtCollected());
        }
        if (totalColl.compareTo(BigDecimal.ZERO) > 0) {
            for (EgDemandDetails dmdDtls : currPtDmd.getEgDemandDetails()) {
                if (!dmdDtls.getInstallmentStartDate().equals(effectiveInstall.getFromDate()) && !dmdDtls.getInstallmentStartDate().after(effectiveInstall.getFromDate())) continue;
                if (dmdDtls.getAmount().compareTo(totalColl) >= 0) {
                    dmdDtls.setAmtCollected(totalColl);
                    totalColl = BigDecimal.ZERO;
                    continue;
                }
                dmdDtls.setAmtCollected(dmdDtls.getAmount());
                totalColl = totalColl.subtract(dmdDtls.getAmount());
            }
            if (totalColl.compareTo(BigDecimal.ZERO) > 0) {
                Map<String, Installment> yearwiseInstMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
                Installment installment = yearwiseInstMap.get("Current 2nd Half");
                EgDemandDetails newDtls = this.ptBillServiceImpl.insertDemandDetails("ADVANCE", totalColl, installment);
                currPtDmd.addEgDemandDetails(newDtls);
            }
        }
        return currPtDmd;
    }

    public void updateProperty(Property newProperty, String comments, String workFlowAction, Long approverPosition, String additionalRule) {
        this.transitionWorkFlow((PropertyImpl)newProperty, comments, workFlowAction, approverPosition, additionalRule);
        this.propertyPerService.update(newProperty.getBasicProperty());
        this.getSession().flush();
    }

    public Assignment getUserAssignment(User user, Property property) {
        Assignment assignment = this.propertyService.isCscOperator(user) != false ? this.propertyService.getMappedAssignmentForCscOperator(property.getBasicProperty()) : this.propertyService.getUserPositionByZone(property.getBasicProperty(), false);
        return assignment;
    }

    private void transitionWorkFlow(PropertyImpl property, String approvarComments, String workFlowAction, Long approverPosition, String additionalRule) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("WorkFlow Transition For Demolition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Position pos = null;
        Assignment wfInitiator = null;
        String approverDesignation = "";
        String nextAction = "";
        String currentState = "";
        if (this.isNotEmployee() || "Anonymous".equalsIgnoreCase(user.getName())) {
            currentState = "Created";
            Assignment assignment = this.getUserAssignment(user, property);
            if (null != assignment) {
                approverPosition = assignment.getPosition().getId();
                approverDesignation = assignment.getDesignation().getName();
                wfInitiator = assignment;
            }
        } else if (this.isApproverPosNotNull(approverPosition)) {
            currentState = null;
            Assignment assignment = (Assignment)this.assignmentService.getAssignmentsForPosition(approverPosition, new Date()).get(0);
            approverDesignation = assignment.getDesignation().getName();
        }
        if (property.getId() != null) {
            wfInitiator = this.propertyService.getWorkflowInitiator(property);
        } else if (wfInitiator == null) {
            wfInitiator = this.propertyTaxCommonUtils.getWorkflowInitiatorAssignment(user.getId());
        }
        if (this.isWFForwardOrROOrCommisionner(workFlowAction, approverDesignation)) {
            nextAction = this.wfForwardOrCommisionner(property, approverDesignation);
        }
        String loggedInUserDesignation = "";
        if (property.getState() != null) {
            loggedInUserDesignation = this.getLoggedInUserDesignation(property.getCurrentState().getOwnerPosition().getId(), this.securityUtils.getCurrentUser());
        }
        if (this.isJuniorOrSenAssistant(loggedInUserDesignation)) {
            loggedInUserDesignation = null;
        }
        if (this.isReject(workFlowAction)) {
            this.wFReject(property, approvarComments, workFlowAction, user, currentDate, wfInitiator, loggedInUserDesignation);
        } else {
            if (this.isWfApprove(workFlowAction)) {
                pos = property.getCurrentState().getOwnerPosition();
            } else if (this.isApproverPos(approverPosition)) {
                pos = this.positionMasterService.getPositionById(approverPosition);
            } else if (this.isWfSign(workFlowAction)) {
                pos = wfInitiator.getPosition();
            }
            if (null == property.getState()) {
                WorkFlowMatrix wfmatrix = this.propertyWorkflowService.getWfMatrix(property.getStateType(), null, null, additionalRule, currentState, null);
                property.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvarComments).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Demolition").withInitiator(wfInitiator != null ? wfInitiator.getPosition() : null);
            } else if (property.getCurrentState().getNextAction().equalsIgnoreCase("END")) {
                property.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvarComments).withDateInfo(currentDate.toDate());
            } else {
                WorkFlowMatrix wfmatrix = this.propertyWorkflowService.getWfMatrix(property.getStateType(), null, null, additionalRule, property.getCurrentState().getValue(), property.getCurrentState().getNextAction(), null, loggedInUserDesignation);
                property.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvarComments).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(StringUtils.isNotBlank((CharSequence)nextAction) ? nextAction : wfmatrix.getNextAction());
                if (workFlowAction.equalsIgnoreCase("Approve")) {
                    this.wFApprove(property, workFlowAction);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(" WorkFlow Transition Completed for Demolition ...");
        }
    }

    private boolean isJuniorOrSenAssistant(String loggedInUserDesignation) {
        return loggedInUserDesignation.equals("Junior Assistant") || loggedInUserDesignation.equals("Senior Assistant");
    }

    private boolean isApproverPosNotNull(Long approverPosition) {
        return null != approverPosition && approverPosition != 0L;
    }

    private boolean isNotEmployee() {
        return this.propertyService.isEmployee(this.securityUtils.getCurrentUser()) == false;
    }

    private boolean isWfSign(String workFlowAction) {
        return "Sign".equalsIgnoreCase(workFlowAction);
    }

    private boolean isApproverPos(Long approverPosition) {
        return null != approverPosition && approverPosition != -1L && !approverPosition.equals(0L);
    }

    private boolean isWfApprove(String workFlowAction) {
        return "Approve".equalsIgnoreCase(workFlowAction);
    }

    private boolean isReject(String workFlowAction) {
        return "Reject".equalsIgnoreCase(workFlowAction);
    }

    private void wFReject(PropertyImpl property, String approvarComments, String workFlowAction, User user, DateTime currentDate, Assignment wfInitiator, String loggedInUserDesignation) {
        if (wfInitiator != null && wfInitiator.getPosition().equals((Object)property.getState().getOwnerPosition())) {
            property.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvarComments).withDateInfo(currentDate.toDate());
            property.setStatus(PropertyTaxConstants.STATUS_CANCELLED);
            property.getBasicProperty().setUnderWorkflow(Boolean.FALSE);
        } else {
            String nextAction;
            Assignment assignmentOnreject = this.getUserAssignmentOnReject(loggedInUserDesignation, property);
            if (assignmentOnreject != null) {
                nextAction = "UD Revenue Inspector Approval Pending";
                wfInitiator = assignmentOnreject;
            } else {
                nextAction = "Assistant Approval Pending";
            }
            if (wfInitiator != null) {
                String stateValue = property.getCurrentState().getValue().split(":")[0] + ":" + "Rejected";
                property.transition().progressWithStateCopy().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvarComments).withStateValue(stateValue).withDateInfo(currentDate.toDate()).withOwner(wfInitiator.getPosition()).withNextAction(nextAction);
                this.buildSMS(property, workFlowAction);
            }
        }
    }

    private String wfForwardOrCommisionner(PropertyImpl property, String approverDesignation) {
        String designation;
        String nextAction = property.getCurrentState().getNextAction().equalsIgnoreCase("Digital Signature Pending") ? "Digital Signature Pending" : ((designation = approverDesignation.split(" ")[0]).equalsIgnoreCase("Commissioner") ? "Commissioner Approval Pending" : ("Revenue officer".equalsIgnoreCase(approverDesignation) ? "Revenue Officer Approval Pending" : designation + " " + "Commissioner Approval Pending"));
        return nextAction;
    }

    private boolean isWFForwardOrROOrCommisionner(String workFlowAction, String approverDesignation) {
        return "Forward".equalsIgnoreCase(workFlowAction) && this.isRoOrCommissioner(approverDesignation);
    }

    private void wFApprove(PropertyImpl property, String workFlowAction) {
        this.buildSMS(property, workFlowAction);
        String clientSpecificDmdBill = this.propertyTaxCommonUtils.getAppConfigValue("IS_CLIENT_SPECIFIC_DEMANDBILL", "Property Tax");
        if ("Y".equalsIgnoreCase(clientSpecificDmdBill)) {
            this.propertyTaxCommonUtils.makeExistingDemandBillInactive(property.getBasicProperty().getUpicNo());
        } else {
            this.propertyTaxUtil.makeTheEgBillAsHistory(property.getBasicProperty());
        }
    }

    private boolean isRoOrCommissioner(String loggedInUserDesignation) {
        boolean isany = !"Revenue officer".equalsIgnoreCase(loggedInUserDesignation) ? this.isCommissioner(loggedInUserDesignation) : true;
        return isany;
    }

    private boolean isCommissioner(String loggedInUserDesignation) {
        boolean isanyone = !"Assistant commissioner".equalsIgnoreCase(loggedInUserDesignation) || !"Additional Commissioner".equalsIgnoreCase(loggedInUserDesignation) ? this.isDeputyOrAbove(loggedInUserDesignation) : true;
        return isanyone;
    }

    private boolean isDeputyOrAbove(String loggedInUserDesignation) {
        boolean isanyone = false;
        if (PropertyTaxConstants.COMMISSIONER_DESIGNATIONS.contains(loggedInUserDesignation)) {
            isanyone = true;
        }
        return isanyone;
    }

    public void validateProperty(Property property, BindingResult errors, HttpServletRequest request) {
        PropertyDetail propertyDetail = property.getPropertyDetail();
        if (StringUtils.isBlank((CharSequence)propertyDetail.getPattaNumber())) {
            errors.rejectValue("propertyDetail.pattaNumber", "pattaNumber.required");
        }
        if (StringUtils.isBlank((CharSequence)propertyDetail.getSurveyNumber())) {
            errors.rejectValue("propertyDetail.surveyNumber", "surveyNumber.required");
        }
        if (null == propertyDetail.getSitalArea().getArea()) {
            errors.rejectValue("propertyDetail.sitalArea.area", "vacantLandArea.required");
        }
        if (null == propertyDetail.getMarketValue()) {
            errors.rejectValue("propertyDetail.marketValue", "marketValue.required");
        }
        if (null == propertyDetail.getCurrentCapitalValue()) {
            errors.rejectValue("propertyDetail.currentCapitalValue", "currCapitalValue.required");
        }
        if (StringUtils.isBlank((CharSequence)property.getBasicProperty().getPropertyID().getNorthBoundary())) {
            errors.rejectValue("basicProperty.propertyID.northBoundary", "northBoundary.required");
        }
        if (StringUtils.isBlank((CharSequence)property.getBasicProperty().getPropertyID().getEastBoundary())) {
            errors.rejectValue("basicProperty.propertyID.eastBoundary", "eastBoundary.required");
        }
        if (StringUtils.isBlank((CharSequence)property.getBasicProperty().getPropertyID().getWestBoundary())) {
            errors.rejectValue("basicProperty.propertyID.westBoundary", "westBoundary.required");
        }
        if (StringUtils.isBlank((CharSequence)property.getBasicProperty().getPropertyID().getSouthBoundary())) {
            errors.rejectValue("basicProperty.propertyID.southBoundary", "southBoundary.required");
        }
        if (StringUtils.isBlank((CharSequence)property.getDemolitionReason())) {
            errors.rejectValue("demolitionReason", "demolitionReason.required");
        }
        this.validateAssignmentForCscUser(property, errors);
    }

    public void validateAssignmentForCscUser(Property property, BindingResult errors) {
        if (this.isNotEmployee() && property.getBasicProperty() != null) {
            Assignment assignment;
            Assignment assignment2 = assignment = this.propertyService.isCscOperator(this.securityUtils.getCurrentUser()) != false ? this.propertyService.getAssignmentByDeptDesigElecWard(property.getBasicProperty()) : null;
            if (assignment == null && this.propertyService.getUserPositionByZone(property.getBasicProperty(), false) == null) {
                errors.reject("notexists.position", "notexists.position");
            }
        }
    }

    public void addModelAttributes(Model model, BasicProperty basicProperty) {
        Property property = null;
        property = null != basicProperty.getProperty() ? basicProperty.getProperty() : basicProperty.getActiveProperty();
        Ptdemand ptDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(property);
        if (ptDemand != null && ptDemand.getDmdCalculations() != null && ptDemand.getDmdCalculations().getAlv() != null) {
            model.addAttribute("ARV", (Object)ptDemand.getDmdCalculations().getAlv());
        } else {
            model.addAttribute("ARV", (Object)BigDecimal.ZERO);
        }
        if (!basicProperty.getActiveProperty().getIsExemptedFromTax().booleanValue()) {
            try {
                Map<String, Map<String, BigDecimal>> demandCollMap = this.propertyTaxUtil.prepareDemandDetForView(property, this.propertyTaxCommonUtils.getCurrentInstallment());
                Map<String, BigDecimal> currentTaxDetails = this.propertyService.getCurrentTaxDetails(demandCollMap, new Date());
                model.addAttribute("propertyTax", (Object)currentTaxDetails.get("General Tax"));
                model.addAttribute("eduCess", (Object)(currentTaxDetails.get("Education Cess") == null ? BigDecimal.ZERO : currentTaxDetails.get("Education Cess")));
                model.addAttribute("libraryCess", (Object)(currentTaxDetails.get("Library Cess") == null ? BigDecimal.ZERO : currentTaxDetails.get("Library Cess")));
                model.addAttribute("currTax", (Object)currentTaxDetails.get("CURR_DMD"));
                model.addAttribute("currTaxDue", (Object)currentTaxDetails.get("CURR_BAL"));
                model.addAttribute("totalTax", (Object)currentTaxDetails.get("CURR_DMD"));
                model.addAttribute("totalArrDue", (Object)currentTaxDetails.get("ARR_BAL"));
            }
            catch (Exception e) {
                LOGGER.error("Exception in addModelAttributes : ", (Throwable)e);
                throw new ApplicationRuntimeException("Exception in addModelAttributes : " + e);
            }
        }
    }

    public void buildSMS(Property property, String workFlowAction) {
        for (PropertyOwnerInfo ownerInfo : property.getBasicProperty().getPropertyOwnerInfo()) {
            if (!StringUtils.isNotBlank((CharSequence)ownerInfo.getOwner().getMobileNumber())) continue;
            this.buildSms(property, ownerInfo.getOwner(), workFlowAction);
        }
    }

    private void buildSms(Property property, User user, String workFlowAction) {
        String assessmentNo = property.getBasicProperty().getUpicNo();
        String mobileNumber = user.getMobileNumber();
        String applicantName = user.getName();
        String smsMsg = "";
        if (!workFlowAction.equals("Forward")) {
            if (workFlowAction.equals("Reject")) {
                smsMsg = this.ptisMessageSource.getMessage("demolition.rejection.sms", (Object[])new String[]{applicantName, assessmentNo, ApplicationThreadLocals.getMunicipalityName()}, null);
            } else if (workFlowAction.equals("Approve")) {
                Installment effectiveInstallment = null;
                Map<String, Installment> yearwiseInstMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
                Installment installmentFirstHalf = yearwiseInstMap.get("Current 1st Half");
                Installment installmentSecondHalf = yearwiseInstMap.get("Current 2nd Half");
                Map<String, BigDecimal> demandMap = null;
                if (DateUtils.between((Date)new Date(), (Date)installmentFirstHalf.getFromDate(), (Date)installmentFirstHalf.getToDate())) {
                    effectiveInstallment = installmentSecondHalf;
                } else {
                    Module module = this.moduleDao.getModuleByName("Property Tax");
                    Date effectiveDate = org.apache.commons.lang3.time.DateUtils.addDays((Date)installmentSecondHalf.getToDate(), (int)1);
                    effectiveInstallment = this.installmentDao.getInsatllmentByModuleForGivenDate(module, effectiveDate);
                }
                demandMap = this.propertyTaxUtil.getTaxDetailsForInstallment(property, effectiveInstallment, installmentFirstHalf);
                BigDecimal totalTax = demandMap.get("Vacant Land Tax") == null ? BigDecimal.ZERO : demandMap.get("Vacant Land Tax").add(demandMap.get("Library Cess") == null ? BigDecimal.ZERO : demandMap.get("Library Cess"));
                smsMsg = this.ptisMessageSource.getMessage("demolition.approval.sms", (Object[])new String[]{applicantName, assessmentNo, totalTax.toString(), new SimpleDateFormat("dd/MM/yyyy").format(effectiveInstallment.getFromDate()), ApplicationThreadLocals.getMunicipalityName()}, null);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)mobileNumber)) {
            this.messagingService.sendSMS(mobileNumber, smsMsg);
        }
    }

    public Assignment getUserAssignmentOnReject(String loggedInUserDesignation, PropertyImpl property) {
        Assignment assignmentOnreject = null;
        if (loggedInUserDesignation.equalsIgnoreCase("Revenue officer") || loggedInUserDesignation.equalsIgnoreCase("Assistant commissioner") || loggedInUserDesignation.equalsIgnoreCase("Additional Commissioner") || loggedInUserDesignation.equalsIgnoreCase("Deputy commissioner") || loggedInUserDesignation.equalsIgnoreCase("Commissioner") || loggedInUserDesignation.equalsIgnoreCase("Zonal Commissioner")) {
            assignmentOnreject = this.propertyService.getUserOnRejection(property);
        }
        return assignmentOnreject;
    }

    public String getLoggedInUserDesignation(Long posId, User user) {
        List loggedInUserAssign = this.assignmentService.getAssignmentByPositionAndUserAsOnDate(posId, user.getId(), new Date());
        return !loggedInUserAssign.isEmpty() ? ((Assignment)loggedInUserAssign.get(0)).getDesignation().getName() : null;
    }

    public Assignment getWfInitiator(PropertyImpl property) {
        return this.propertyService.getWorkflowInitiator(property);
    }
}

