/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.bill;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Installment;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.demand.model.EgBill;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.client.bill.PTBillServiceImpl;
import org.egov.ptis.client.model.calculator.DemandNoticeInfo;
import org.egov.ptis.client.util.PropertyTaxNumberGenerator;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.bill.PropertyTaxBillable;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.demand.BulkBillGeneration;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.service.notice.NoticeService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.egov.ptis.wtms.WaterChargesIntegrationService;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class BillService {
    private static final Logger LOGGER = Logger.getLogger(BillService.class);
    private static final String STR_BILL_SHORTCUT = "B";
    private ReportService reportService;
    private NoticeService noticeService;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    private PTBillServiceImpl ptBillServiceImpl;
    private PropertyTaxNumberGenerator propertyTaxNumberGenerator;
    private Map<String, Map<String, BigDecimal>> reasonwiseDues;
    private String billNo;
    InputStream billPDF;
    @Autowired
    private ModuleService moduleDao;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PropertyTaxBillable propertyTaxBillable;
    private PersistenceService persistenceService;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private WaterChargesIntegrationService waterChargesIntegrationService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private CityService cityService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    @Qualifier(value="bulkBillGenerationPersistenceService")
    private PersistenceService bulkBillGenerationPersistenceService;
    @Autowired
    private FinancialYearDAO financialYearDAO;

    public ReportOutput generateBill(BasicProperty basicProperty, Integer userId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Entered into generateBill BasicProperty : " + basicProperty));
        }
        ReportOutput reportOutput = null;
        try {
            this.setBillNo(this.propertyTaxNumberGenerator.generateManualBillNumber(basicProperty.getPropertyID()));
            int noOfBillGenerated = this.getNumberOfBills(basicProperty);
            if (noOfBillGenerated > 0) {
                this.setBillNo(this.getBillNo() + "/" + STR_BILL_SHORTCUT + noOfBillGenerated);
            }
            DemandNoticeInfo demandNoticeInfo = new DemandNoticeInfo();
            demandNoticeInfo.setCityService(this.cityService);
            demandNoticeInfo.setBasicProperty(basicProperty);
            demandNoticeInfo.setOldAssessmentNo(basicProperty.getOldMuncipalNum());
            demandNoticeInfo.setBillNo(this.getBillNo());
            demandNoticeInfo.setLocality(basicProperty.getPropertyID().getLocality().getName());
            demandNoticeInfo.setBillPeriod(this.propertyTaxCommonUtils.getCurrentInstallment().getDescription());
            if (basicProperty.getVacancyRemissions().isEmpty()) {
                demandNoticeInfo.setIsVacancyRemissionDone(false);
            } else {
                demandNoticeInfo.setIsVacancyRemissionDone(true);
            }
            Map<String, Object> reprortParams = this.prepareReportParams(basicProperty);
            ReportRequest reportRequest = null;
            reportRequest = new ReportRequest("propertybill", (Object)demandNoticeInfo, reprortParams);
            reportOutput = this.getReportService().createReport(reportRequest);
            if (reportOutput != null && reportOutput.getReportOutputData() != null) {
                this.billPDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
            }
            this.saveEgBill(basicProperty, userId);
            basicProperty.setIsBillCreated(PropertyTaxConstants.STATUS_BILL_CREATED);
            basicProperty.setBillCrtError(PropertyTaxConstants.STRING_EMPTY);
            boolean flag = this.waterChargesIntegrationService.updateBillNo(basicProperty.getId().toString(), this.getBillNo());
            if (flag) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)"Billno updated successfully in water tax");
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Failed to updated billno in water tax");
            }
            this.noticeService.saveNotice(basicProperty.getPropertyForBasicProperty().getApplicationNo(), this.getBillNo(), "Bill", basicProperty, this.billPDF);
            this.noticeService.getSession().flush();
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Bill Generation Exception : " + e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Exiting from generateBill");
        }
        return reportOutput;
    }

    private Map<String, Object> prepareReportParams(BasicProperty basicProperty) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        City city = this.cityService.getCityByCode(this.cityService.getCityCode());
        String owner = basicProperty.getProperty().getPropertyDetail().getPropertyTypeMaster().getType();
        String ownerType = "";
        if (owner.equalsIgnoreCase("Vacant Land")) {
            ownerType = "(On Land)";
        }
        String cityName = city.getPreferences().getMunicipalityName();
        String districtName = city.getDistrictName();
        String date = DateUtils.getDefaultFormattedDate((Date)new Date());
        CFinancialYear financialYear = this.financialYearDAO.getFinancialYearByDate(new Date());
        reportParams.put("cityName", cityName);
        reportParams.put("cityUrl", ((City)this.cityService.findAll().get(0)).getName().toLowerCase());
        reportParams.put("districtName", districtName);
        reportParams.put("currDate", date);
        reportParams.put("financialYear", financialYear.getFinYearRange());
        reportParams.put("ownerType", ownerType);
        return reportParams;
    }

    private int getNumberOfBills(BasicProperty basicProperty) {
        Installment currentInstallment = this.propertyTaxCommonUtils.getCurrentInstallment();
        Long count = (Long)((Session)this.entityManager.unwrap(Session.class)).createQuery("SELECT COUNT (*) FROM EgBill WHERE module = ? AND egBillType.code = ? AND consumerId = ? AND is_Cancelled = 'N' AND issueDate between ? and ? ").setEntity(0, (Object)currentInstallment.getModule()).setString(1, "MANUAL").setString(2, basicProperty.getUpicNo()).setDate(3, currentInstallment.getFromDate()).setDate(4, currentInstallment.getToDate()).list().get(0);
        return count.intValue();
    }

    private void saveEgBill(BasicProperty basicProperty, Integer userId) {
        LOGGER.debug((Object)"Entered into saveEgBill");
        LOGGER.debug((Object)("saveEgBill : BasicProperty: " + basicProperty));
        this.propertyTaxBillable.setBasicProperty(basicProperty);
        this.propertyTaxBillable.setUserId(userId.longValue());
        this.propertyTaxBillable.setReferenceNumber(this.getBillNo());
        this.propertyTaxBillable.setBillType(this.propertyTaxUtil.getBillTypeByCode("MANUAL"));
        this.propertyTaxBillable.setLevyPenalty(Boolean.TRUE);
        EgBill egBill = this.ptBillServiceImpl.generateBill(this.propertyTaxBillable);
        LOGGER.debug((Object)("Exit from saveEgBill, EgBill: " + egBill));
    }

    public void bulkBillGeneration(Integer modulo, Integer billsCount) {
        LOGGER.debug((Object)("Entered into executeJob" + modulo));
        Long currentTime = System.currentTimeMillis();
        Query query = this.getQuery(modulo, billsCount);
        List assessmentNumbers = query.list();
        LOGGER.info((Object)("executeJob" + modulo + " - got " + assessmentNumbers + "indexNumbers for bill generation"));
        Long timeTaken = currentTime - System.currentTimeMillis();
        LOGGER.debug((Object)("executeJob" + modulo + " took " + timeTaken / 1000L + " secs for BasicProperty selection"));
        LOGGER.debug((Object)("executeJob" + modulo + " - BasicProperties = " + assessmentNumbers.size()));
        LOGGER.info((Object)("executeJob" + modulo + " - Generating bills....."));
        currentTime = System.currentTimeMillis();
        int noOfBillsGenerated = 0;
        for (String assessmentNumber : assessmentNumbers) {
            BasicProperty basicProperty = null;
            try {
                basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNumber);
                this.generateBill(basicProperty, ApplicationThreadLocals.getUserId().intValue());
                ++noOfBillsGenerated;
            }
            catch (Exception e) {
                basicProperty.setIsBillCreated(Character.valueOf('F'));
                basicProperty.setBillCrtError(e.getMessage());
                String msg = " Error while generating Demand bill via BulkBillGeneration Job " + modulo.toString();
                String propertyType = " for " + (basicProperty.getSource().equals(PropertyTaxConstants.SOURCEOFDATA_APPLICATION) ? "  non-migrated property " : " migrated property");
                LOGGER.error((Object)(msg + propertyType + basicProperty.getUpicNo()), (Throwable)e);
            }
        }
        timeTaken = currentTime - System.currentTimeMillis();
        LOGGER.info((Object)("executeJob" + modulo + " - " + noOfBillsGenerated + "/" + assessmentNumbers.size() + " Bill(s) generated in " + timeTaken / 1000L + " (secs)"));
        LOGGER.debug((Object)("Exiting from executeJob" + modulo));
    }

    private Query getQuery(Integer modulo, Integer billsCount) {
        StringBuilder queryString = new StringBuilder(200);
        StringBuilder zoneParamString = new StringBuilder();
        StringBuilder wardParamString = new StringBuilder();
        Installment currentInstallment = this.propertyTaxCommonUtils.getCurrentInstallment();
        Module ptModule = this.moduleDao.getModuleByName("Property Tax");
        List bulkBillGeneration = this.getPersistenceService().findAllBy("from BulkBillGeneration where zone.id is not null and installment.id = ? order by id", new Object[]{currentInstallment.getId()});
        queryString = queryString.append("select bp.upicNo ").append("from BasicPropertyImpl bp ").append("where bp.active = true ").append("and bp.upicNo IS not NULL ").append("and (bp.isBillCreated is NULL or bp.isBillCreated='N' or bp.isBillCreated='false') ").append("and MOD(bp.id, ").append(PropertyTaxConstants.QUARTZ_BULKBILL_JOBS).append(") = :modulo ");
        if (bulkBillGeneration != null && !bulkBillGeneration.isEmpty()) {
            wardParamString.append("(");
            zoneParamString.append("(");
            int count = 1;
            for (BulkBillGeneration bbg : bulkBillGeneration) {
                if (bbg.getWard() != null) {
                    if (count == bulkBillGeneration.size()) {
                        wardParamString.append("'").append(bbg.getZone().getId()).append('-').append(bbg.getWard().getId()).append("')");
                    } else {
                        wardParamString.append("'").append(bbg.getZone().getId()).append('-').append(bbg.getWard().getId()).append("', ");
                    }
                } else if (count == bulkBillGeneration.size()) {
                    zoneParamString.append(bbg.getZone().getId()).append(")");
                } else {
                    zoneParamString.append(bbg.getZone().getId()).append(", ");
                }
                ++count;
            }
            if (wardParamString != null && wardParamString.charAt(wardParamString.length() - 2) == ',') {
                wardParamString.setCharAt(wardParamString.length() - 2, ')');
            }
            if (zoneParamString != null && zoneParamString.charAt(zoneParamString.length() - 2) == ',') {
                zoneParamString.setCharAt(zoneParamString.length() - 2, ')');
            }
            if (wardParamString != null && zoneParamString == null) {
                queryString.append(" AND ").append("bp.propertyID.ward.parent.id||'-'||bp.propertyID.ward.id").append(" IN ").append(wardParamString.toString());
            } else if (zoneParamString != null && wardParamString == null) {
                queryString.append(" AND ").append("bp.propertyID.zone.id").append(" IN ").append(zoneParamString.toString());
            } else if (wardParamString != null && zoneParamString != null) {
                queryString.append(" AND ").append("(bp.propertyID.ward.parent.id||'-'||bp.propertyID.ward.id").append(" IN ").append(wardParamString.toString()).append(" OR ").append("bp.propertyID.zone.id").append(" IN ").append(zoneParamString.toString()).append(')');
            }
        }
        queryString = queryString.append(" AND bp NOT IN (SELECT bp FROM BasicPropertyImpl bp, EgBill b ").append("WHERE bp.active = true ").append("AND bp.upicNo = substring(b.consumerId, 1, strpos(b.consumerId,'(')-1) ").append("AND b.module = :ptModule ").append("AND b.egBillType = :billType ").append("AND b.is_History = 'N' ").append("AND b.is_Cancelled = 'N' ").append("AND (b.issueDate BETWEEN :fromDate AND :toDate)) ");
        Query query = this.getPersistenceService().getSession().createQuery(queryString.toString()).setInteger("modulo", modulo.intValue()).setEntity("ptModule", (Object)ptModule).setEntity("billType", (Object)this.propertyTaxUtil.getBillTypeByCode("MANUAL")).setDate("fromDate", currentInstallment.getFromDate()).setDate("toDate", currentInstallment.getToDate());
        query.setMaxResults(billsCount.intValue());
        return query;
    }

    public List<BulkBillGeneration> getBulkBill(Long zoneId, Long wardId, Installment currentInstallment) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select bbg from BulkBillGeneration bbg ").append(" where bbg.zone.id=:zoneid and bbg.installment.id=:installment ");
        if (wardId != null && wardId != -1L) {
            queryStr.append("and bbg.ward.id=:wardid ");
        }
        Query query = this.getPersistenceService().getSession().createQuery(queryStr.toString());
        query.setLong("zoneid", zoneId.longValue());
        query.setLong("installment", (long)currentInstallment.getId().intValue());
        if (wardId != null && wardId != -1L) {
            query.setLong("wardid", wardId.longValue());
        }
        List bbgList = query.list();
        return bbgList;
    }

    public BulkBillGeneration saveBulkBill(Long zoneId, Long wardId, Installment currentInstallment) {
        BulkBillGeneration bulkBill = new BulkBillGeneration();
        bulkBill.setZone(this.boundaryService.getBoundaryById(zoneId));
        bulkBill.setWard(this.boundaryService.getBoundaryById(wardId));
        bulkBill.setInstallment(currentInstallment);
        this.bulkBillGenerationPersistenceService.persist((Object)bulkBill);
        return bulkBill;
    }

    public ReportService getReportService() {
        return this.reportService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public Map<String, Map<String, BigDecimal>> getReasonwiseDues() {
        return this.reasonwiseDues;
    }

    public void setReasonwiseDues(Map<String, Map<String, BigDecimal>> reasonwiseDues) {
        this.reasonwiseDues = reasonwiseDues;
    }

    public String getBillNo() {
        return this.billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public InputStream getBillPDF() {
        return this.billPDF;
    }

    public void setBillPDF(InputStream billPDF) {
        this.billPDF = billPDF;
    }

    public PropertyTaxNumberGenerator getPropertyTaxNumberGenerator() {
        return this.propertyTaxNumberGenerator;
    }

    public void setPropertyTaxNumberGenerator(PropertyTaxNumberGenerator propertyTaxNumberGenerator) {
        this.propertyTaxNumberGenerator = propertyTaxNumberGenerator;
    }

    public PropertyTaxUtil getPropertyTaxUtil() {
        return this.propertyTaxUtil;
    }

    public void setPropertyTaxUtil(PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
    }

    public void setNoticeService(NoticeService noticeService) {
        this.noticeService = noticeService;
    }

    public PTBillServiceImpl getPtBillServiceImpl() {
        return this.ptBillServiceImpl;
    }

    public void setPtBillServiceImpl(PTBillServiceImpl ptBillServiceImpl) {
        this.ptBillServiceImpl = ptBillServiceImpl;
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }
}

