/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.entity.property;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.Valid;
import org.apache.log4j.Logger;
import org.egov.commons.Installment;
import org.egov.exceptions.InvalidPropertyException;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.persistence.entity.Address;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.portal.entity.Citizen;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.demand.FloorwiseDemandCalculations;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.AbstractProperty;
import org.egov.ptis.domain.entity.property.AmalgamationOwner;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.BuiltUpProperty;
import org.egov.ptis.domain.entity.property.Document;
import org.egov.ptis.domain.entity.property.Floor;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyDetail;
import org.egov.ptis.domain.entity.property.PropertySource;
import org.egov.ptis.domain.entity.property.TaxExemptionReason;
import org.egov.ptis.domain.entity.property.UnitCalculationDetail;
import org.egov.ptis.domain.entity.property.VacantProperty;

public class PropertyImpl
extends StateAware
implements Property {
    private static final long serialVersionUID = -5353928708732980539L;
    private static final Logger LOGGER = Logger.getLogger(PropertyImpl.class);
    private Long id;
    private Citizen citizen;
    private PropertySource propertySource;
    private Boolean vacant;
    private transient BasicProperty basicProperty;
    private AbstractProperty abstractProperty;
    private Address address;
    private Character isDefaultProperty;
    private Character status = Character.valueOf('N');
    private Set<Ptdemand> ptDemandSet = new HashSet<Ptdemand>();
    private Character isChecked = Character.valueOf('N');
    private String remarks;
    private Date effectiveDate;
    private transient PropertyDetail propertyDetail;
    private String propertyModifyReason;
    private Installment installment;
    private BigDecimal manualAlv;
    private String occupierName;
    private Boolean isExemptedFromTax = false;
    private TaxExemptionReason taxExemptedReason;
    private String docNumber;
    private Boundary areaBndry;
    private BigDecimal alv;
    private List<Document> documents = new ArrayList<Document>();
    private String applicationNo;
    private String demolitionReason;
    private String meesevaApplicationNumber;
    private String meesevaServiceCode;
    private String source;
    @Valid
    private Set<UnitCalculationDetail> unitCalculationDetails = new HashSet<UnitCalculationDetail>();
    private List<AmalgamationOwner> amalgamationOwners = new ArrayList<AmalgamationOwner>();
    private List<AmalgamationOwner> amalgamationOwnersProxy = new ArrayList<AmalgamationOwner>();
    private List<Document> assessmentDocuments = new ArrayList<Document>();

    @Override
    public String getDocNumber() {
        return this.docNumber;
    }

    @Override
    public void setDocNumber(String docNumber) {
        this.docNumber = docNumber;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PropertyImpl)) {
            return false;
        }
        PropertyImpl other = (PropertyImpl)obj;
        if (this.getId() != null && other.getId() != null) {
            return this.getId().equals(other.getId());
        }
        if (!(this.getPropertySource() == null && other.getPropertySource() == null || this.getBasicProperty() == null && other.getBasicProperty() == null)) {
            return this.getPropertySource().equals(other.getPropertySource()) && this.getBasicProperty().equals(other.getBasicProperty()) && this.getInstallment().equals((Object)other.getInstallment()) && this.getStatus().equals(other.getStatus());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.getId() != null) {
            hashCode += this.getId().hashCode();
        }
        if (this.getPropertySource() != null && this.getBasicProperty() != null) {
            hashCode = hashCode + this.getPropertySource().hashCode() + this.getBasicProperty().hashCode() + this.getInstallment().hashCode() + this.getStatus().hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean validateProperty() throws InvalidPropertyException {
        if (this.getBasicProperty() == null) {
            throw new InvalidPropertyException("PropertyImpl.validate : BasicProperty is not Set, Please Check !!");
        }
        if (this.getCreatedBy() == null) {
            throw new InvalidPropertyException("PropertyImpl.validate : Created By is not Set, Please Check !!");
        }
        if (this.getPropertySource() == null) {
            throw new InvalidPropertyException("PropertyImpl.validate : PropertySource is not set, Please Check !!");
        }
        if (!this.getPropertySource().validate()) {
            throw new InvalidPropertyException("PropertyImpl.validate : PropertySource validate() failed, Please Check !!");
        }
        return true;
    }

    @Override
    public Character getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(Character status) {
        this.status = status;
    }

    @Override
    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    @Override
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    @Override
    public Character getIsDefaultProperty() {
        return this.isDefaultProperty;
    }

    @Override
    public void setIsDefaultProperty(Character isDefaultProperty) {
        this.isDefaultProperty = isDefaultProperty;
    }

    public AbstractProperty getAbstractProperty() {
        return this.abstractProperty;
    }

    public void setAbstractProperty(AbstractProperty abstractProperty) {
        this.abstractProperty = abstractProperty;
    }

    @Override
    public Address getPropertyAddress() {
        return this.address;
    }

    @Override
    public void setPropertyAddress(Address address) {
        this.address = address;
    }

    @Override
    public Boolean isVacant() {
        return this.vacant;
    }

    @Override
    public void setVacant(Boolean vacant) {
        this.vacant = vacant;
    }

    public Citizen getCitizen() {
        return this.citizen;
    }

    public void setCitizen(Citizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public void addPtDemand(Ptdemand ptDmd) {
        this.getPtDemandSet().add(ptDmd);
    }

    @Override
    public void removePtDemand(Ptdemand ptDmd) {
        this.getPtDemandSet().remove((Object)ptDmd);
    }

    @Override
    public Installment getInstallment() {
        return this.installment;
    }

    @Override
    public void setInstallment(Installment installment) {
        this.installment = installment;
    }

    public Boolean getVacant() {
        return this.vacant;
    }

    @Override
    public PropertySource getPropertySource() {
        return this.propertySource;
    }

    @Override
    public void setPropertySource(PropertySource propertySource) {
        this.propertySource = propertySource;
    }

    @Override
    public BasicProperty getBasicProperty() {
        return this.basicProperty;
    }

    @Override
    public void setBasicProperty(BasicProperty basicProperty) {
        this.basicProperty = basicProperty;
    }

    @Override
    public Set<Ptdemand> getPtDemandSet() {
        return this.ptDemandSet;
    }

    @Override
    public void setPtDemandSet(Set<Ptdemand> ptDemandSet) {
        this.ptDemandSet = ptDemandSet;
    }

    @Override
    public PropertyDetail getPropertyDetail() {
        return this.propertyDetail;
    }

    @Override
    public void setPropertyDetail(PropertyDetail propertyDetail) {
        this.propertyDetail = propertyDetail;
    }

    @Override
    public Character getIsChecked() {
        return this.isChecked;
    }

    @Override
    public void setIsChecked(Character isChecked) {
        this.isChecked = isChecked;
    }

    @Override
    public String getRemarks() {
        return this.remarks;
    }

    @Override
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    public String getPropertyModifyReason() {
        return this.propertyModifyReason;
    }

    @Override
    public void setPropertyModifyReason(String propertyModifyReason) {
        this.propertyModifyReason = propertyModifyReason;
    }

    @Override
    public Boolean getIsExemptedFromTax() {
        return this.isExemptedFromTax;
    }

    @Override
    public void setIsExemptedFromTax(Boolean isExemptedFromTax) {
        this.isExemptedFromTax = isExemptedFromTax;
    }

    @Override
    public TaxExemptionReason getTaxExemptedReason() {
        return this.taxExemptedReason;
    }

    @Override
    public void setTaxExemptedReason(TaxExemptionReason taxExemptedReason) {
        this.taxExemptedReason = taxExemptedReason;
    }

    @Override
    public Property createPropertyclone() {
        LOGGER.debug((Object)("Inside PropertyImpl clone method  " + this.toString()));
        PropertyImpl newProp = new PropertyImpl();
        newProp.setBasicProperty(this.getBasicProperty());
        newProp.setId(null);
        newProp.setApplicationNo(null);
        newProp.setEffectiveDate(this.getEffectiveDate());
        newProp.setInstallment(this.getInstallment());
        newProp.setIsChecked(this.getIsChecked());
        newProp.setIsDefaultProperty(this.getIsDefaultProperty());
        newProp.setStatus(this.getStatus());
        newProp.setPropertyDetail(this.clonePropertyDetail(newProp));
        newProp.setPropertyModifyReason(this.getPropertyModifyReason());
        newProp.setPropertySource(this.getPropertySource());
        newProp.setPtDemandSet(this.cloneDemand(newProp.getPropertyDetail().getFloorDetails()));
        newProp.setRemarks(this.getRemarks());
        newProp.setVacant(this.getVacant());
        newProp.setIsExemptedFromTax(this.getIsExemptedFromTax());
        newProp.setTaxExemptedReason(this.getTaxExemptedReason());
        newProp.setDocNumber(this.getDocNumber());
        newProp.setCreatedDate(new Date());
        newProp.setLastModifiedDate(new Date());
        newProp.addAllUnitCalculationDetails(this.cloneUnitCalculationDetails());
        return newProp;
    }

    public String toString() {
        StringBuilder sbf = new StringBuilder();
        sbf.append("Id: ").append(this.getId()).append("|BasicProperty: ");
        sbf = this.getBasicProperty() != null ? sbf.append(this.getBasicProperty().getUpicNo()) : sbf.append("");
        sbf.append("|IsDefaultProperty:").append(this.getIsDefaultProperty()).append("|Status:").append(this.getStatus()).append("|PropertySource: ").append(null != this.getPropertySource() ? this.getPropertySource().getName() : null).append("|Installment: ").append(this.getInstallment());
        return sbf.toString();
    }

    private Set<Ptdemand> cloneDemand(List<Floor> floors) {
        HashSet<Ptdemand> newdemandSet = new HashSet<Ptdemand>();
        for (Ptdemand demand : this.getPtDemandSet()) {
            newdemandSet.add((Ptdemand)((Object)demand.clone()));
        }
        for (Ptdemand clonedDemand : newdemandSet) {
            block2: for (FloorwiseDemandCalculations floorDmdCalc : clonedDemand.getDmdCalculations().getFlrwiseDmdCalculations()) {
                Floor oldFloor = floorDmdCalc.getFloor();
                for (Floor newFloor : floors) {
                    if (!newFloor.getFloorUid().equals(oldFloor.getFloorUid())) continue;
                    floorDmdCalc.setFloor(newFloor);
                    continue block2;
                }
            }
        }
        return newdemandSet;
    }

    private PropertyDetail clonePropertyDetail(Property newProperty) {
        AbstractProperty propDetails = null;
        if (this.getPropertyDetail().getPropertyType().toString().equals("BuiltUpProperty")) {
            BuiltUpProperty bup = (BuiltUpProperty)this.getPropertyDetail();
            propDetails = new BuiltUpProperty(this.getPropertyDetail().getSitalArea(), this.getPropertyDetail().getTotalBuiltupArea(), this.getPropertyDetail().getCommBuiltUpArea(), this.getPropertyDetail().getPlinthArea(), this.getPropertyDetail().getCommVacantLand(), this.getPropertyDetail().getNonResPlotArea(), bup.isIrregular(), this.getPropertyDetail().getSurveyNumber(), this.getPropertyDetail().getFieldVerified(), this.getPropertyDetail().getFieldVerificationDate(), this.cloneFlrDtls(), null, this.getPropertyDetail().getWater_Meter_Num(), this.getPropertyDetail().getElec_Meter_Num(), this.getPropertyDetail().getNoofFloors(), this.getPropertyDetail().getFieldIrregular(), newProperty, this.getPropertyDetail().getUpdatedTime(), this.getPropertyDetail().getPropertyUsage(), this.getPropertyDetail().getDateOfCompletion(), bup.getCreationReason(), this.getPropertyDetail().getPropertyTypeMaster(), this.getPropertyDetail().getPropertyType(), this.getPropertyDetail().getPropertyMutationMaster(), this.getPropertyDetail().getComZone(), this.getPropertyDetail().getCornerPlot(), this.getPropertyDetail().getPropertyOccupation(), this.getPropertyDetail().getExtentSite(), this.getPropertyDetail().getExtentAppartenauntLand(), this.getPropertyDetail().getFloorType(), this.getPropertyDetail().getRoofType(), this.getPropertyDetail().getWallType(), this.getPropertyDetail().getWoodType(), this.getPropertyDetail().isLift(), this.getPropertyDetail().isToilets(), this.getPropertyDetail().isWaterTap(), this.getPropertyDetail().isStructure(), this.getPropertyDetail().isElectricity(), this.getPropertyDetail().isAttachedBathRoom(), this.getPropertyDetail().isWaterHarvesting(), this.getPropertyDetail().isCable(), this.getPropertyDetail().getSiteOwner(), this.getPropertyDetail().getApartment(), this.getPropertyDetail().getPattaNumber(), this.getPropertyDetail().getCurrentCapitalValue(), this.getPropertyDetail().getMarketValue(), this.getPropertyDetail().getCategoryType(), this.getPropertyDetail().getOccupancyCertificationNo(), this.getPropertyDetail().isAppurtenantLandChecked(), this.getPropertyDetail().isCorrAddressDiff(), this.getPropertyDetail().getPropertyDepartment(), this.getPropertyDetail().getVacantLandPlotArea(), this.getPropertyDetail().getLayoutApprovalAuthority(), this.getPropertyDetail().getLayoutPermitNo(), this.getPropertyDetail().getLayoutPermitDate());
        } else if (this.getPropertyDetail().getPropertyType().toString().equals("VacantProperty")) {
            VacantProperty vcp = (VacantProperty)this.getPropertyDetail();
            propDetails = new VacantProperty(this.getPropertyDetail().getSitalArea(), this.getPropertyDetail().getTotalBuiltupArea(), this.getPropertyDetail().getCommBuiltUpArea(), this.getPropertyDetail().getPlinthArea(), this.getPropertyDetail().getCommVacantLand(), this.getPropertyDetail().getNonResPlotArea(), vcp.getIrregular(), this.getPropertyDetail().getSurveyNumber(), this.getPropertyDetail().getFieldVerified(), this.getPropertyDetail().getFieldVerificationDate(), this.cloneFlrDtls(), null, this.getPropertyDetail().getWater_Meter_Num(), this.getPropertyDetail().getElec_Meter_Num(), this.getPropertyDetail().getNoofFloors(), this.getPropertyDetail().getFieldIrregular(), this.getPropertyDetail().getDateOfCompletion(), newProperty, this.getPropertyDetail().getUpdatedTime(), this.getPropertyDetail().getPropertyUsage(), vcp.getCreationReason(), this.getPropertyDetail().getPropertyTypeMaster(), this.getPropertyDetail().getPropertyType(), this.getPropertyDetail().getInstallment(), this.getPropertyDetail().getPropertyOccupation(), this.getPropertyDetail().getPropertyMutationMaster(), this.getPropertyDetail().getComZone(), this.getPropertyDetail().getCornerPlot(), this.getPropertyDetail().getExtentSite(), this.getPropertyDetail().getExtentAppartenauntLand(), this.getPropertyDetail().getFloorType(), this.getPropertyDetail().getRoofType(), this.getPropertyDetail().getWallType(), this.getPropertyDetail().getWoodType(), this.getPropertyDetail().isLift(), this.getPropertyDetail().isToilets(), this.getPropertyDetail().isWaterTap(), this.getPropertyDetail().isStructure(), this.getPropertyDetail().isElectricity(), this.getPropertyDetail().isAttachedBathRoom(), this.getPropertyDetail().isWaterHarvesting(), this.getPropertyDetail().isCable(), this.getPropertyDetail().getSiteOwner(), this.getPropertyDetail().getPattaNumber(), this.getPropertyDetail().getCurrentCapitalValue(), this.getPropertyDetail().getMarketValue(), this.getPropertyDetail().getCategoryType(), this.getPropertyDetail().getOccupancyCertificationNo(), this.getPropertyDetail().isAppurtenantLandChecked(), this.getPropertyDetail().isCorrAddressDiff(), this.getPropertyDetail().getPropertyDepartment(), this.getPropertyDetail().getVacantLandPlotArea(), this.getPropertyDetail().getLayoutApprovalAuthority(), this.getPropertyDetail().getLayoutPermitNo(), this.getPropertyDetail().getLayoutPermitDate());
        }
        return propDetails;
    }

    private List<Floor> cloneFlrDtls() {
        Floor floor = null;
        ArrayList<Floor> flrDtlsSet = new ArrayList<Floor>();
        for (Floor flr : this.getPropertyDetail().getFloorDetails()) {
            floor = new Floor(flr.getConstructionTypeSet(), flr.getStructureClassification(), flr.getPropertyUsage(), flr.getPropertyOccupation(), flr.getFloorNo(), flr.getDepreciationMaster(), flr.getBuiltUpArea(), flr.getFloorArea(), flr.getWaterMeter(), flr.getElectricMeter(), null, null, flr.getRentPerMonth(), flr.getManualAlv(), flr.getUnitType(), flr.getUnitTypeCategory(), flr.getWaterRate(), flr.getAlv(), flr.getOccupancyDate(), flr.getOccupantName(), flr.getUnstructuredLand(), flr.getFloorDmdCalc(), flr.getFirmName(), flr.getBuildingPermissionNo(), flr.getBuildingPermissionDate(), flr.getBuildingPlanPlinthArea(), flr.getFloorUid(), flr.getConstructionDate());
            flrDtlsSet.add(floor);
        }
        return flrDtlsSet;
    }

    private Set<UnitCalculationDetail> cloneUnitCalculationDetails() {
        HashSet<UnitCalculationDetail> unitCalculationDetailClones = new HashSet<UnitCalculationDetail>();
        for (UnitCalculationDetail unitCalcDetail : this.getUnitCalculationDetails()) {
            unitCalculationDetailClones.add(new UnitCalculationDetail(unitCalcDetail));
        }
        return unitCalculationDetailClones;
    }

    public String getStateDetails() {
        StringBuffer stateDetails = new StringBuffer("");
        String upicNo = this.getBasicProperty().getUpicNo() != null && !this.getBasicProperty().getUpicNo().isEmpty() ? this.getBasicProperty().getUpicNo() : "";
        String applicationNo = this.getApplicationNo() != null && !this.getApplicationNo().isEmpty() ? this.getApplicationNo() : "";
        stateDetails.append(upicNo.isEmpty() ? applicationNo : upicNo).append(", ").append(this.getBasicProperty().getPrimaryOwner().getName()).append(", ").append(PropertyTaxConstants.PROPERTY_TYPE_CATEGORIES.get(this.getPropertyDetail().getCategoryType())).append(", ").append(this.getBasicProperty().getPropertyID().getLocality().getName());
        return stateDetails.toString();
    }

    @Override
    public BigDecimal getManualAlv() {
        return this.manualAlv;
    }

    @Override
    public void setManualAlv(BigDecimal manualAlv) {
        this.manualAlv = manualAlv;
    }

    @Override
    public String getOccupierName() {
        return this.occupierName;
    }

    @Override
    public void setOccupierName(String occupierName) {
        this.occupierName = occupierName;
    }

    @Override
    public Boundary getAreaBndry() {
        return this.areaBndry;
    }

    @Override
    public void setAreaBndry(Boundary areaBndry) {
        this.areaBndry = areaBndry;
    }

    @Override
    public BigDecimal getAlv() {
        return this.alv;
    }

    @Override
    public void setAlv(BigDecimal alv) {
        this.alv = alv;
    }

    @Override
    public Set<UnitCalculationDetail> getUnitCalculationDetails() {
        return this.unitCalculationDetails;
    }

    @Override
    public void setUnitCalculationDetails(Set<UnitCalculationDetail> unitCalculationDetails) {
        this.unitCalculationDetails = unitCalculationDetails;
    }

    @Override
    public void addUnitCalculationDetails(UnitCalculationDetail unitCalculationDetail) {
        unitCalculationDetail.setProperty(this);
        this.getUnitCalculationDetails().add(unitCalculationDetail);
    }

    @Override
    public void addAllUnitCalculationDetails(Set<UnitCalculationDetail> unitCalculationDetailsSet) {
        for (UnitCalculationDetail unitCalcDetail : unitCalculationDetailsSet) {
            this.addUnitCalculationDetails(unitCalcDetail);
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String myLinkId() {
        String url = "";
        if (this.getState() != null && this.getState().getValue() != null && (this.getState().getValue().startsWith("Alter") || this.getState().getValue().startsWith("Bifurcate") || this.getState().getValue().startsWith("GRP"))) {
            url = "/ptis/modify/modifyProperty-view.action?modelId=" + this.getId();
        } else if (this.getState() != null && this.getState().getValue() != null && this.getState().getValue().startsWith("Create")) {
            url = "/ptis/create/createProperty-view.action?modelId=" + this.getId();
        } else if (this.getState() != null && this.getState().getValue() != null && this.getState().getValue().startsWith("Demolition")) {
            url = "/ptis/demolition/update/" + this.getId();
        } else if (this.getState() != null && this.getState().getValue() != null && this.getState().getValue().startsWith("Exemption")) {
            url = "/ptis/exemption/update/" + this.getId();
        } else if (this.getState() != null && this.getState().getValue() != null && this.getState().getValue().startsWith("Amalgamation")) {
            url = "/ptis/amalgamation/amalgamation-view.action?modelId=" + this.getId();
        }
        return url;
    }

    @Override
    public List<Document> getDocuments() {
        return this.documents;
    }

    @Override
    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    @Override
    public String getApplicationNo() {
        return this.applicationNo;
    }

    @Override
    public void setApplicationNo(String applicationNo) {
        this.applicationNo = applicationNo;
    }

    @Override
    public String getDemolitionReason() {
        return this.demolitionReason;
    }

    @Override
    public void setDemolitionReason(String demolitionReason) {
        this.demolitionReason = demolitionReason;
    }

    public String getMeesevaApplicationNumber() {
        return this.meesevaApplicationNumber;
    }

    public void setMeesevaApplicationNumber(String meesevaApplicationNumber) {
        this.meesevaApplicationNumber = meesevaApplicationNumber;
    }

    public String getMeesevaServiceCode() {
        return this.meesevaServiceCode;
    }

    public void setMeesevaServiceCode(String meesevaServiceCode) {
        this.meesevaServiceCode = meesevaServiceCode;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public List<AmalgamationOwner> getAmalgamationOwners() {
        return this.amalgamationOwners;
    }

    @Override
    public void setAmalgamationOwners(List<AmalgamationOwner> amalgamationOwners) {
        this.amalgamationOwners = amalgamationOwners;
    }

    @Override
    public List<AmalgamationOwner> getAmalgamationOwnersProxy() {
        return this.amalgamationOwnersProxy;
    }

    @Override
    public void setAmalgamationOwnersProxy(List<AmalgamationOwner> amalgamationOwnersProxy) {
        this.amalgamationOwnersProxy = amalgamationOwnersProxy;
    }

    @Override
    public void addAmalgamationOwners(AmalgamationOwner ownerInfo) {
        this.getAmalgamationOwners().add(ownerInfo);
    }

    @Override
    public List<Document> getAssessmentDocuments() {
        return this.assessmentDocuments;
    }

    @Override
    public void setAssessmentDocuments(List<Document> assessmentDocuments) {
        this.assessmentDocuments = assessmentDocuments;
    }
}

