/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.autonumber.impl;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.ptis.autonumber.NoticeNumberGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NoticeNumberGeneratorImpl
implements NoticeNumberGenerator {
    private static final String SEQ_EGPT_NOTICE_NUMBER = "SEQ_EGPT_NOTICE_NUMBER";
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;

    @Override
    public String generateNoticeNumber(String noticeType) {
        String noticeNumber = "";
        if (StringUtils.isNotBlank((CharSequence)noticeType)) {
            String noticeTypeCode = "";
            if ("Special Notice".equalsIgnoreCase(noticeType)) {
                noticeTypeCode = "SN";
            } else if ("Mutation Certificate".equalsIgnoreCase(noticeType)) {
                noticeTypeCode = "MC";
            } else if ("ESD Notice".equalsIgnoreCase(noticeType)) {
                noticeTypeCode = "ESD";
            } else if ("RP Proceedings".equalsIgnoreCase(noticeType)) {
                noticeTypeCode = "RP";
            } else if ("GRP Proceedings".equalsIgnoreCase(noticeType)) {
                noticeTypeCode = "GRP";
            } else if ("Revision Petition Hearing Notice".equalsIgnoreCase(noticeType)) {
                noticeTypeCode = "HN";
            } else if ("VR Proceedings".equalsIgnoreCase(noticeType)) {
                noticeTypeCode = "VR";
            } else if ("Inventory Notice".equalsIgnoreCase(noticeType)) {
                noticeTypeCode = "IN";
            } else if ("Distress Notice".equalsIgnoreCase(noticeType)) {
                noticeTypeCode = "DN";
            } else if ("exemption".equalsIgnoreCase(noticeType)) {
                noticeTypeCode = "EX";
            } else if ("Valuation Certificate".equalsIgnoreCase(noticeType)) {
                noticeTypeCode = "VC";
            } else if ("Ownership Certificate".equalsIgnoreCase(noticeType)) {
                noticeTypeCode = "OC";
            } else if ("Occupier Notice".equalsIgnoreCase(noticeType)) {
                noticeTypeCode = "ON";
            }
            String sequenceName = SEQ_EGPT_NOTICE_NUMBER;
            Serializable nextSequence = this.applicationSequenceNumberGenerator.getNextSequence(SEQ_EGPT_NOTICE_NUMBER);
            noticeNumber = String.format("%s/%s%06d", noticeTypeCode, ApplicationThreadLocals.getCityCode(), nextSequence);
        }
        return noticeNumber;
    }
}

