/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.master.service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.egov.ptis.domain.model.MutationFeeDetails;
import org.egov.ptis.domain.repository.master.mutationfee.MutationFeeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class MutationFeeService {
    private final MutationFeeRepository mutationFeeRepository;

    @Autowired
    public MutationFeeService(MutationFeeRepository mutationFeeRepository) {
        this.mutationFeeRepository = mutationFeeRepository;
    }

    public void generateSlabName(MutationFeeDetails mutationFeeDetails) {
        if (mutationFeeDetails.getHighLimit() == null) {
            mutationFeeDetails.setSlabName(mutationFeeDetails.getLowLimit().toString().concat("_").concat("ABOVE"));
        } else {
            mutationFeeDetails.setSlabName(mutationFeeDetails.getLowLimit().toString().concat("_").concat(mutationFeeDetails.getHighLimit().toString()));
        }
    }

    public BigDecimal getMaxHighLimit() {
        if (this.mutationFeeRepository.maxByHighLimit() != null) {
            return this.mutationFeeRepository.maxByHighLimit();
        }
        return BigDecimal.ZERO;
    }

    public boolean validateForHighLimitNull() {
        return this.mutationFeeRepository.findLowLimitForHighLimitNullValue() != null;
    }

    public boolean getToDateBySlabName(String slabName) {
        Date today = new Date();
        int result = today.compareTo(this.mutationFeeRepository.findToDateBySlabName(slabName));
        return result >= 0;
    }

    public boolean findExistingSlabName(String slabName) {
        return !this.mutationFeeRepository.findIfSlabNameExists(slabName).isEmpty();
    }

    public Date getLatestToDateForSlabName(String slabName) {
        return this.mutationFeeRepository.findLatestToDateForSlabName(slabName);
    }

    public List<MutationFeeDetails> findSlabName() {
        return this.mutationFeeRepository.getDistinctSlabNamesList();
    }

    public List<MutationFeeDetails> findDuplicateSlabName(String slabname) {
        return this.mutationFeeRepository.findBySlabNames(slabname);
    }

    public MutationFeeDetails getMutationFeeById(Long id) {
        return (MutationFeeDetails)((Object)this.mutationFeeRepository.findOne(id));
    }

    public boolean validateForMaxHighLimit(BigDecimal lowlimit) {
        BigDecimal result = lowlimit.subtract(this.getMaxHighLimit());
        return result.compareTo(BigDecimal.ONE) == 0;
    }

    @Transactional
    public void createMutationFee(MutationFeeDetails mutation) {
        this.mutationFeeRepository.save((Object)mutation);
    }

    public List<MutationFeeDetails> getAllMutationFee() {
        return this.mutationFeeRepository.selectAllOrderBySlabName();
    }

    @Transactional
    public MutationFeeDetails getDetailsById(Long id) {
        return this.mutationFeeRepository.getAllDetailsById(id);
    }
}

