/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.deactivation;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.egov.ptis.domain.dao.property.PropertyMutationMasterHibDAO;
import org.egov.ptis.domain.entity.enums.TransactionType;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.DocumentType;
import org.egov.ptis.domain.entity.property.PropertyDeactivation;
import org.egov.ptis.domain.entity.property.PropertyMutationMaster;
import org.egov.ptis.domain.repository.deactivation.DeactivationRepository;
import org.egov.ptis.domain.service.property.PropertyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PropertyDeactivationService {
    private static final String ACTIVE = "ACTIVE";
    @Autowired
    private PropertyMutationMasterHibDAO propertyMutationMasterHibDAO;
    @Autowired
    private DeactivationRepository deactivationRepository;
    @Autowired
    private PropertyService propService;
    @Autowired
    private PropertyService propertyService;

    public List<String> getDeactivationReasons() {
        ArrayList<String> rsnList = new ArrayList<String>();
        List<PropertyMutationMaster> reasons = this.propertyMutationMasterHibDAO.getAllPropertyMutationMastersByType("DEACTIVATE");
        for (PropertyMutationMaster rsn : reasons) {
            rsnList.add(rsn.getMutationDesc());
        }
        return rsnList;
    }

    public Map<String, String> getPropertyDetails(BasicProperty basicProperty) {
        LinkedHashMap<String, String> propdetails = new LinkedHashMap<String, String>();
        propdetails.put("AssessmentNo", basicProperty.getUpicNo());
        propdetails.put("OwnerName", basicProperty.getFullOwnerName());
        propdetails.put("PropertyTaxDue", this.getCurrentPTTaxDue(basicProperty).toString());
        propdetails.put("PropertyType", basicProperty.getActiveProperty().getPropertyDetail().getCategoryType().toLowerCase());
        propdetails.put("Address", basicProperty.getAddress().toString());
        return propdetails;
    }

    public List<DocumentType> getDocuments(TransactionType transactionType) {
        return this.propService.getDocumentTypesForTransactionType(transactionType);
    }

    private BigDecimal getCurrentPTTaxDue(BasicProperty basicproperty) {
        Map<String, BigDecimal> propertyTaxDetails = this.propertyService.getCurrentPropertyTaxDetails(basicproperty.getActiveProperty());
        Map<String, BigDecimal> currentTaxAndDue = this.propertyService.getCurrentTaxAndBalance(propertyTaxDetails, new Date());
        BigDecimal currentPropertyTaxDue = currentTaxAndDue.get("CURR_BAL");
        BigDecimal arrearPropertyTaxDue = propertyTaxDetails.get("ARR_DMD").subtract(propertyTaxDetails.get("ARR_COLL"));
        return currentPropertyTaxDue.add(arrearPropertyTaxDue);
    }

    public boolean checkActiveWC(List<Map<String, Object>> wcDetails) {
        boolean connStatus = false;
        for (Map<String, Object> status : wcDetails) {
            for (Object state : status.values()) {
                if (!ACTIVE.equalsIgnoreCase(state.toString())) continue;
                connStatus = true;
            }
        }
        return connStatus;
    }

    @Transactional
    public void save(PropertyDeactivation propertyDeactivation) {
        this.deactivationRepository.save((Object)propertyDeactivation);
    }

    public DocumentType getDocType(String docname) {
        return this.deactivationRepository.findDocumentTypeByName(docname);
    }
}

