/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.builder.entity.property;

import org.egov.builder.entities.ModuleBuilder;
import org.egov.commons.Installment;
import org.egov.commons.entity.InstallmentBuilder;
import org.egov.ptis.builder.entity.property.PropertyDetailBuilder;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.PropertyDetail;
import org.egov.ptis.domain.entity.property.PropertyImpl;

public class PropertyBuilder {
    private final PropertyImpl property = new PropertyImpl();

    public PropertyImpl build() {
        return this.property;
    }

    public PropertyBuilder withInstallment(Installment installment) {
        this.property.setInstallment(installment);
        return this;
    }

    public PropertyBuilder withActiveStatus() {
        this.property.setStatus(Character.valueOf('A'));
        return this;
    }

    public PropertyBuilder withBasicProperty(BasicProperty basicProperty) {
        this.property.setBasicProperty(basicProperty);
        return this;
    }

    public PropertyBuilder withPropertyDetail(PropertyDetail propertyDetail) {
        this.property.setPropertyDetail(propertyDetail);
        return this;
    }

    public PropertyBuilder withDefaults() {
        this.property.setStatus(Character.valueOf('A'));
        this.property.setIsDefaultProperty(Character.valueOf('Y'));
        this.property.setInstallment(new InstallmentBuilder().withCurrentHalfPeriod(new ModuleBuilder().withName("Property Tax").build()).build());
        this.property.setPropertyDetail(new PropertyDetailBuilder("BuiltUp").withDefaults().build());
        return this;
    }
}

