/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.service.es;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.CFinancialYearService;
import org.egov.infra.utils.DateUtils;
import org.egov.ptis.bean.dashboard.CollectionDetails;
import org.egov.ptis.bean.dashboard.CollectionDetailsRequest;
import org.egov.ptis.bean.dashboard.DCBDetails;
import org.egov.ptis.bean.dashboard.PropertyTaxDefaultersRequest;
import org.egov.ptis.bean.dashboard.TaxDefaulters;
import org.egov.ptis.bean.dashboard.TaxPayerDetails;
import org.egov.ptis.bean.dashboard.TaxPayerResponseDetails;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.es.BillCollectorIndex;
import org.egov.ptis.domain.entity.es.PropertyTaxIndex;
import org.egov.ptis.repository.es.PropertyTaxIndexRepository;
import org.egov.ptis.service.es.CollectionIndexElasticSearchService;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.ResultsExtractor;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class PropertyTaxElasticSearchIndexService {
    private static final String REBATE_STR = "rebate";
    private static final String TOTAL_COLL_STR = "totalColl";
    private static final String ADVANCE_COLL_STR = "advanceColl";
    private static final String CURRENT_INT_COLL = "currentIntColl";
    private static final String ARREAR_INT_COLL = "arrearIntColl";
    private static final String CURRENT_COLL_STR = "currentColl";
    private static final String ARREAR_COLL_STR = "arrearColl";
    private static final String TOTAL_DMD_STR = "totalDmd";
    private static final String CURRENT_INT_DMD = "currentIntDmd";
    private static final String ARREAR_INT_DMD = "arrearIntDmd";
    private static final String CURRENT_DMD = "currentDmd";
    private static final String ARREAR_DMD = "arrearDmd";
    private static final String CURR_INTEREST_DMD = "curr_interest_dmd";
    private static final String ARREAR_INTEREST_DMD = "arrear_interest_dmd";
    private static final String CURR_DMD = "curr_dmd";
    private static final String ARREAR_DMD_STR = "arrear_dmd";
    private static final String CURRENT_INTEREST_COLLECTION = "currentInterestCollection";
    private static final String ARREAR_INTEREST_COLLECTION = "arrearInterestCollection";
    private static final String ANNUAL_COLLECTION = "annualCollection";
    private static final String ARREAR_COLLECTION = "arrearCollection";
    private static final String CONSUMER_TYPE = "consumerType";
    private static final String IS_ACTIVE = "isActive";
    private static final String IS_EXEMPTED = "isExempted";
    private static final String CITY_GRADE = "cityGrade";
    private static final String CITY_CODE = "cityCode";
    private static final String DISTRICT_NAME = "districtName";
    private static final String REGION_NAME = "regionName";
    private static final String BY_AGGREGATION_FIELD = "by_aggregationField";
    private static final String CITY_NAME = "cityName";
    private static final String REVENUE_WARD = "revenueWard";
    private static final String TOTAL_COLLECTION = "total_collection";
    private static final String MILLISECS = " (millisecs) ";
    private static final String TOTAL_DEMAND = "totalDemand";
    private static final String TOTALDEMAND = "totaldemand";
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyTaxElasticSearchIndexService.class);
    private PropertyTaxIndexRepository propertyTaxIndexRepository;
    @Autowired
    private CFinancialYearService cFinancialYearService;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    private CollectionIndexElasticSearchService collectionIndexElasticSearchService;

    @Autowired
    public PropertyTaxElasticSearchIndexService(PropertyTaxIndexRepository propertyTaxIndexRepository) {
        this.propertyTaxIndexRepository = propertyTaxIndexRepository;
    }

    public Page<PropertyTaxIndex> findByConsumercode(String consumerCode) {
        return this.propertyTaxIndexRepository.findByConsumerCode(consumerCode, (Pageable)new PageRequest(0, 10));
    }

    public BigDecimal getTotalDemand() {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_ACTIVE, (Object)true)).filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_EXEMPTED, (Object)false));
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"propertytax"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)TOTALDEMAND).field(TOTAL_DEMAND)).build();
        Aggregations aggregations = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, (ResultsExtractor)new ResultsExtractor<Aggregations>(){

            public Aggregations extract(SearchResponse response) {
                return response.getAggregations();
            }
        });
        Sum aggr = (Sum)aggregations.get(TOTALDEMAND);
        return BigDecimal.valueOf(aggr.getValue()).setScale(0, 4);
    }

    public void getConsolidatedDemandInfo(CollectionDetailsRequest collectionDetailsRequest, CollectionDetails collectionIndexDetails) {
        Date toDate;
        Date fromDate;
        CFinancialYear currFinYear = this.cFinancialYearService.getFinancialYearByDate(new Date());
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = DateUtils.startOfDay((Date)currFinYear.getStartingDate());
            toDate = DateUtils.addDays((Date)new Date(), (int)1);
        }
        Long startTime = System.currentTimeMillis();
        BigDecimal totalDemand = this.getTotalDemandBasedOnInputFilters(collectionDetailsRequest);
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by getTotalDemandBasedOnInputFilters() is : " + timeTaken + MILLISECS);
        startTime = System.currentTimeMillis();
        int noOfMonths = DateUtils.noOfMonths((Date)fromDate, (Date)toDate) + 1;
        collectionIndexDetails.setTotalDmd(totalDemand);
        BigDecimal proportionalDemand = totalDemand.divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(noOfMonths));
        collectionIndexDetails.setCytdDmd(proportionalDemand.setScale(0, 4));
        collectionIndexDetails.setTotalAssessments(this.collectionIndexElasticSearchService.getTotalAssessmentsCount(collectionDetailsRequest, null));
        if (proportionalDemand.compareTo(BigDecimal.ZERO) > 0) {
            collectionIndexDetails.setPerformance(collectionIndexDetails.getCytdColl().multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(proportionalDemand, 1, 4));
        }
        BigDecimal variation = collectionIndexDetails.getLytdColl().compareTo(BigDecimal.ZERO) == 0 ? PropertyTaxConstants.BIGDECIMAL_100 : collectionIndexDetails.getCytdColl().subtract(collectionIndexDetails.getLytdColl()).multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(collectionIndexDetails.getLytdColl(), 1, 4);
        collectionIndexDetails.setLyVar(variation);
        timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken for setting values in getConsolidatedDemandInfo() is : " + timeTaken + MILLISECS);
    }

    public BigDecimal getTotalDemandBasedOnInputFilters(CollectionDetailsRequest collectionDetailsRequest) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest).filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_ACTIVE, (Object)true)).filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_EXEMPTED, (Object)false));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"propertytax"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)TOTALDEMAND).field(TOTAL_DEMAND)).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, (ResultsExtractor)new ResultsExtractor<Aggregations>(){

            public Aggregations extract(SearchResponse response) {
                return response.getAggregations();
            }
        });
        Sum aggr = (Sum)collAggr.get(TOTALDEMAND);
        return BigDecimal.valueOf(aggr.getValue()).setScale(0, 4);
    }

    public TaxPayerResponseDetails getTopTenTaxPerformers(CollectionDetailsRequest collectionDetailsRequest) {
        List<TaxPayerDetails> taxAchievers;
        List<TaxPayerDetails> taxProducers;
        TaxPayerResponseDetails topTaxPerformers = new TaxPayerResponseDetails();
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getType()) && collectionDetailsRequest.getType().equalsIgnoreCase("billcollector")) {
            List<TaxPayerDetails> wardWiseTaxProducers = this.returnUlbWiseAggregationResults(collectionDetailsRequest, "propertytax", false, TOTAL_COLLECTION, 250, true);
            HashMap<String, TaxPayerDetails> wardWiseTaxPayersDetails = new HashMap<String, TaxPayerDetails>();
            LinkedHashMap<String, List<TaxPayerDetails>> billCollectorWiseMap = new LinkedHashMap<String, List<TaxPayerDetails>>();
            ArrayList<TaxPayerDetails> taxPayerDetailsList = new ArrayList<TaxPayerDetails>();
            ArrayList<TaxPayerDetails> billCollectorWiseTaxPayerDetails = new ArrayList<TaxPayerDetails>();
            this.prepareWardWiseTaxPayerDetails(wardWiseTaxProducers, wardWiseTaxPayersDetails);
            this.prepareBillCollectorWiseMapData(collectionDetailsRequest, wardWiseTaxPayersDetails, billCollectorWiseMap, taxPayerDetailsList);
            this.prepareTaxersInfoForBillCollectors(collectionDetailsRequest, billCollectorWiseMap, billCollectorWiseTaxPayerDetails);
            taxProducers = this.getTaxPayersForBillCollector(collectionDetailsRequest, false, wardWiseTaxProducers, billCollectorWiseTaxPayerDetails, true);
            taxAchievers = this.getTaxPayersForBillCollector(collectionDetailsRequest, false, wardWiseTaxProducers, billCollectorWiseTaxPayerDetails, false);
        } else {
            taxProducers = this.returnUlbWiseAggregationResults(collectionDetailsRequest, "propertytax", false, TOTAL_COLLECTION, 10, false);
            taxAchievers = this.returnUlbWiseAggregationResults(collectionDetailsRequest, "propertytax", false, TOTAL_COLLECTION, 120, false);
        }
        topTaxPerformers.setProducers(taxProducers);
        topTaxPerformers.setAchievers(taxAchievers);
        return topTaxPerformers;
    }

    public TaxPayerResponseDetails getBottomTenTaxPerformers(CollectionDetailsRequest collectionDetailsRequest) {
        List<TaxPayerDetails> taxAchievers;
        List<TaxPayerDetails> taxProducers;
        TaxPayerResponseDetails topTaxPerformers = new TaxPayerResponseDetails();
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getType()) && collectionDetailsRequest.getType().equalsIgnoreCase("billcollector")) {
            List<TaxPayerDetails> wardWiseTaxProducers = this.returnUlbWiseAggregationResults(collectionDetailsRequest, "propertytax", false, TOTAL_COLLECTION, 250, true);
            HashMap<String, TaxPayerDetails> wardWiseTaxPayersDetails = new HashMap<String, TaxPayerDetails>();
            LinkedHashMap<String, List<TaxPayerDetails>> billCollectorWiseMap = new LinkedHashMap<String, List<TaxPayerDetails>>();
            ArrayList<TaxPayerDetails> taxPayerDetailsList = new ArrayList<TaxPayerDetails>();
            ArrayList<TaxPayerDetails> billCollectorWiseTaxPayerDetails = new ArrayList<TaxPayerDetails>();
            this.prepareWardWiseTaxPayerDetails(wardWiseTaxProducers, wardWiseTaxPayersDetails);
            this.prepareBillCollectorWiseMapData(collectionDetailsRequest, wardWiseTaxPayersDetails, billCollectorWiseMap, taxPayerDetailsList);
            this.prepareTaxersInfoForBillCollectors(collectionDetailsRequest, billCollectorWiseMap, billCollectorWiseTaxPayerDetails);
            taxProducers = this.getTaxPayersForBillCollector(collectionDetailsRequest, true, wardWiseTaxProducers, billCollectorWiseTaxPayerDetails, true);
            taxAchievers = this.getTaxPayersForBillCollector(collectionDetailsRequest, true, wardWiseTaxProducers, billCollectorWiseTaxPayerDetails, false);
        } else {
            taxProducers = this.returnUlbWiseAggregationResults(collectionDetailsRequest, "propertytax", true, TOTAL_COLLECTION, 10, false);
            taxAchievers = this.returnUlbWiseAggregationResults(collectionDetailsRequest, "propertytax", true, TOTAL_COLLECTION, 120, false);
        }
        topTaxPerformers.setProducers(taxProducers);
        topTaxPerformers.setAchievers(taxAchievers);
        return topTaxPerformers;
    }

    public List<TaxPayerDetails> returnUlbWiseAggregationResults(CollectionDetailsRequest collectionDetailsRequest, String indexName, Boolean order, String orderingAggregationName, int size, boolean isBillCollectorWise) {
        NativeSearchQuery searchQueryColl;
        TermsBuilder aggregation;
        ArrayList<TaxPayerDetails> taxPayers = new ArrayList<TaxPayerDetails>();
        Map<Object, Object> wardWiseBillCollectors = new HashMap();
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest).filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_ACTIVE, (Object)true)).filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_EXEMPTED, (Object)false));
        CFinancialYear currFinYear = this.cFinancialYearService.getFinancialYearByDate(new Date());
        String groupingField = StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getUlbCode()) || StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getType()) && (collectionDetailsRequest.getType().equals("ward") || collectionDetailsRequest.getType().equals("billcollector")) ? REVENUE_WARD : CITY_NAME;
        Long startTime = System.currentTimeMillis();
        if (!isBillCollectorWise) {
            aggregation = this.prepareAggregationForTaxPayers(orderingAggregationName, size, groupingField).order(Terms.Order.aggregation((String)orderingAggregationName, (boolean)order));
            searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{indexName}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)aggregation).build();
        } else {
            aggregation = this.prepareAggregationForTaxPayers(orderingAggregationName, 250, groupingField);
            searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{indexName}).withQuery((QueryBuilder)boolQuery).withPageable((Pageable)new PageRequest(0, 250)).addAggregation((AbstractAggregationBuilder)aggregation).build();
        }
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, (ResultsExtractor)new ResultsExtractor<Aggregations>(){

            public Aggregations extract(SearchResponse response) {
                return response.getAggregations();
            }
        });
        Date fromDate = DateUtils.startOfDay((Date)currFinYear.getStartingDate());
        Date toDate = DateUtils.addDays((Date)new Date(), (int)1);
        Date lastYearFromDate = DateUtils.addYears((Date)fromDate, (int)-1);
        Date lastYearToDate = DateUtils.addYears((Date)toDate, (int)-1);
        if ("ward".equalsIgnoreCase(collectionDetailsRequest.getType())) {
            wardWiseBillCollectors = this.collectionIndexElasticSearchService.getWardWiseBillCollectors(collectionDetailsRequest);
        }
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by ulbWiseAggregations is : " + timeTaken + MILLISECS);
        startTime = System.currentTimeMillis();
        StringTerms totalAmountAggr = (StringTerms)collAggr.get(BY_AGGREGATION_FIELD);
        for (Terms.Bucket entry : totalAmountAggr.getBuckets()) {
            BigDecimal variation = BigDecimal.ZERO;
            TaxPayerDetails taxDetail = new TaxPayerDetails();
            taxDetail.setRegionName(collectionDetailsRequest.getRegionName());
            taxDetail.setDistrictName(collectionDetailsRequest.getDistrictName());
            taxDetail.setUlbGrade(collectionDetailsRequest.getUlbGrade());
            String fieldName = String.valueOf(entry.getKey());
            if (groupingField.equals(REVENUE_WARD)) {
                taxDetail.setWardName(fieldName);
                if ("ward".equalsIgnoreCase(collectionDetailsRequest.getType()) && !wardWiseBillCollectors.isEmpty()) {
                    taxDetail.setBillCollector(wardWiseBillCollectors.get(fieldName) == null ? "" : ((BillCollectorIndex)wardWiseBillCollectors.get(fieldName)).getBillCollector());
                    taxDetail.setMobileNumber(wardWiseBillCollectors.get(fieldName) == null ? "" : ((BillCollectorIndex)wardWiseBillCollectors.get(fieldName)).getMobileNumber());
                }
            } else {
                taxDetail.setUlbName(fieldName);
            }
            int noOfMonths = DateUtils.noOfMonths((Date)fromDate, (Date)toDate) + 1;
            Sum totalDemandAggregation = (Sum)entry.getAggregations().get(TOTALDEMAND);
            Sum totalCollectionAggregation = (Sum)entry.getAggregations().get(TOTAL_COLLECTION);
            Sum arrearDmd = (Sum)entry.getAggregations().get(ARREAR_DMD_STR);
            Sum currentDmd = (Sum)entry.getAggregations().get(CURR_DMD);
            Sum arrearInterestDmd = (Sum)entry.getAggregations().get(ARREAR_INTEREST_DMD);
            Sum currentInterestDmd = (Sum)entry.getAggregations().get(CURR_INTEREST_DMD);
            Sum arrearCollAmt = (Sum)entry.getAggregations().get(ARREAR_COLLECTION);
            Sum currentCollAmt = (Sum)entry.getAggregations().get(ANNUAL_COLLECTION);
            Sum arrearIntColl = (Sum)entry.getAggregations().get(ARREAR_INTEREST_COLLECTION);
            Sum currentIntColl = (Sum)entry.getAggregations().get(CURRENT_INTEREST_COLLECTION);
            BigDecimal totalDemandValue = BigDecimal.valueOf(totalDemandAggregation.getValue()).setScale(0, 4);
            BigDecimal totalCollections = BigDecimal.valueOf(totalCollectionAggregation.getValue()).setScale(0, 4);
            BigDecimal proportionalDemand = totalDemandValue.divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(noOfMonths));
            taxDetail.setTotalDmd(totalDemandValue);
            taxDetail.setCytdColl(totalCollections);
            taxDetail.setCytdDmd(proportionalDemand);
            taxDetail.setAchievement(totalCollections.multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(proportionalDemand, 1, 4));
            taxDetail.setCytdBalDmd(proportionalDemand.subtract(totalCollections));
            BigDecimal lastYearCollection = this.collectionIndexElasticSearchService.getCollectionBetweenDates(collectionDetailsRequest, lastYearFromDate, lastYearToDate, fieldName, "totalAmount");
            taxDetail.setLytdColl(lastYearCollection);
            taxDetail.setArrearColl(BigDecimal.valueOf(arrearCollAmt.getValue()).setScale(0, 4));
            taxDetail.setCurrentColl(BigDecimal.valueOf(currentCollAmt.getValue()).setScale(0, 4));
            taxDetail.setInterestColl(BigDecimal.valueOf(arrearIntColl.getValue()).setScale(0, 4).add(BigDecimal.valueOf(currentIntColl.getValue()).setScale(0, 4)));
            taxDetail.setArrearDemand(BigDecimal.valueOf(arrearDmd.getValue()).setScale(0, 4));
            taxDetail.setCurrentDemand(BigDecimal.valueOf(currentDmd.getValue()).setScale(0, 4));
            taxDetail.setArrearInterestDemand(BigDecimal.valueOf(arrearInterestDmd.getValue()).setScale(0, 4));
            taxDetail.setCurrentInterestDemand(BigDecimal.valueOf(currentInterestDmd.getValue()).setScale(0, 4));
            BigDecimal proportionalArrearDmd = taxDetail.getArrearDemand().divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(noOfMonths));
            BigDecimal proportionalCurrDmd = taxDetail.getCurrentDemand().divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(noOfMonths));
            taxDetail.setProportionalArrearDemand(proportionalArrearDmd);
            taxDetail.setProportionalCurrentDemand(proportionalCurrDmd);
            variation = lastYearCollection.compareTo(BigDecimal.ZERO) == 0 ? PropertyTaxConstants.BIGDECIMAL_100 : totalCollections.subtract(lastYearCollection).multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(lastYearCollection, 1, 4);
            taxDetail.setLyVar(variation);
            taxPayers.add(taxDetail);
        }
        timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken for setting values in returnUlbWiseAggregationResults() is : " + timeTaken + MILLISECS);
        if (isBillCollectorWise) {
            return taxPayers;
        }
        return this.returnTopResults(taxPayers, size, order);
    }

    private TermsBuilder prepareAggregationForTaxPayers(String orderingAggregationName, int size, String groupingField) {
        return (TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)BY_AGGREGATION_FIELD).field(groupingField)).size(size).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)TOTALDEMAND).field(TOTAL_DEMAND))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)TOTAL_COLLECTION).field("totalCollection"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)ARREAR_COLLECTION).field(ARREAR_COLLECTION))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)ANNUAL_COLLECTION).field(ANNUAL_COLLECTION))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)ARREAR_INTEREST_COLLECTION).field(ARREAR_INTEREST_COLLECTION))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)CURRENT_INTEREST_COLLECTION).field(CURRENT_INTEREST_COLLECTION))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)ARREAR_DMD_STR).field("arrearDemand"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)CURR_DMD).field("annualDemand"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)ARREAR_INTEREST_DMD).field("arrearInterestDemand"))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)CURR_INTEREST_DMD).field("currentInterestDemand"));
    }

    private List<TaxPayerDetails> returnTopResults(List<TaxPayerDetails> taxPayers, int size, Boolean order) {
        if (size > 10) {
            if (order.booleanValue()) {
                Collections.sort(taxPayers);
            } else {
                Collections.sort(taxPayers, Collections.reverseOrder());
            }
            return taxPayers.subList(0, taxPayers.size() < 10 ? taxPayers.size() : 10);
        }
        return taxPayers;
    }

    public List<TaxDefaulters> getTopDefaulters(PropertyTaxDefaultersRequest propertyTaxDefaultersRequest) {
        Long startTime = System.currentTimeMillis();
        BoolQueryBuilder boolQuery = this.filterBasedOnRequest(propertyTaxDefaultersRequest);
        boolQuery = boolQuery.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)CITY_NAME, (Object)"Guntur")).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)CITY_NAME, (Object)"Vijayawada")).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)CITY_NAME, (Object)"Visakhapatnam")).filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_ACTIVE, (Object)true)).filter((QueryBuilder)QueryBuilders.matchQuery((String)IS_EXEMPTED, (Object)false));
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"propertytax"}).withQuery((QueryBuilder)boolQuery).withSort((SortBuilder)new FieldSortBuilder("totalBalance").order(SortOrder.DESC)).withPageable((Pageable)new PageRequest(0, 100)).build();
        Page propertyTaxRecords = this.elasticsearchTemplate.queryForPage((SearchQuery)searchQuery, PropertyTaxIndex.class);
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by defaulters aggregation is : " + timeTaken + MILLISECS);
        ArrayList<TaxDefaulters> taxDefaulters = new ArrayList<TaxDefaulters>();
        startTime = System.currentTimeMillis();
        for (PropertyTaxIndex property : propertyTaxRecords) {
            TaxDefaulters taxDefaulter = new TaxDefaulters();
            taxDefaulter.setOwnerName(property.getConsumerName());
            taxDefaulter.setPropertyType(property.getConsumerType());
            taxDefaulter.setUlbName(property.getCityName());
            taxDefaulter.setBalance(BigDecimal.valueOf(property.getTotalBalance()));
            taxDefaulter.setPeriod(StringUtils.isBlank((CharSequence)property.getDuePeriod()) ? "" : property.getDuePeriod());
            taxDefaulters.add(taxDefaulter);
        }
        timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken for setting values in getTopDefaulters() is : " + timeTaken + MILLISECS);
        return taxDefaulters;
    }

    private BoolQueryBuilder filterBasedOnRequest(PropertyTaxDefaultersRequest propertyTaxDefaultersRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)TOTAL_DEMAND).from(0).to(null));
        if (StringUtils.isNotBlank((CharSequence)propertyTaxDefaultersRequest.getRegionName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)REGION_NAME, (Object)propertyTaxDefaultersRequest.getRegionName()));
        }
        if (StringUtils.isNotBlank((CharSequence)propertyTaxDefaultersRequest.getDistrictName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)DISTRICT_NAME, (Object)propertyTaxDefaultersRequest.getDistrictName()));
        }
        if (StringUtils.isNotBlank((CharSequence)propertyTaxDefaultersRequest.getUlbCode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CITY_CODE, (Object)propertyTaxDefaultersRequest.getUlbCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)propertyTaxDefaultersRequest.getUlbGrade())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CITY_GRADE, (Object)propertyTaxDefaultersRequest.getUlbGrade()));
        }
        if (StringUtils.isNotBlank((CharSequence)propertyTaxDefaultersRequest.getWardName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)REVENUE_WARD, (Object)propertyTaxDefaultersRequest.getWardName()));
        }
        if (StringUtils.isNotBlank((CharSequence)propertyTaxDefaultersRequest.getType())) {
            if (propertyTaxDefaultersRequest.getType().equalsIgnoreCase("region") && StringUtils.isNotBlank((CharSequence)propertyTaxDefaultersRequest.getRegionName())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)REGION_NAME, (Object)propertyTaxDefaultersRequest.getRegionName()));
            } else if (propertyTaxDefaultersRequest.getType().equalsIgnoreCase("district") && StringUtils.isNotBlank((CharSequence)propertyTaxDefaultersRequest.getDistrictName())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)DISTRICT_NAME, (Object)propertyTaxDefaultersRequest.getDistrictName()));
            } else if (propertyTaxDefaultersRequest.getType().equalsIgnoreCase("city") && StringUtils.isNotBlank((CharSequence)propertyTaxDefaultersRequest.getUlbCode())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CITY_CODE, (Object)propertyTaxDefaultersRequest.getUlbCode()));
            } else if (propertyTaxDefaultersRequest.getType().equalsIgnoreCase("grade") && StringUtils.isNotBlank((CharSequence)propertyTaxDefaultersRequest.getUlbGrade())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CITY_GRADE, (Object)propertyTaxDefaultersRequest.getUlbGrade()));
            }
        }
        return boolQuery;
    }

    private BoolQueryBuilder prepareWhereClause(CollectionDetailsRequest collectionDetailsRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)TOTAL_DEMAND).from(0).to(null));
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getRegionName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)REGION_NAME, (Object)collectionDetailsRequest.getRegionName()));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getDistrictName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)DISTRICT_NAME, (Object)collectionDetailsRequest.getDistrictName()));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getUlbGrade())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CITY_GRADE, (Object)collectionDetailsRequest.getUlbGrade()));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getUlbCode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CITY_CODE, (Object)collectionDetailsRequest.getUlbCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getPropertyType())) {
            boolQuery = this.collectionIndexElasticSearchService.queryForPropertyType(collectionDetailsRequest, boolQuery, "propertytax");
        }
        return boolQuery;
    }

    private void prepareWardWiseTaxPayerDetails(List<TaxPayerDetails> wardWiseTaxProducers, Map<String, TaxPayerDetails> wardWiseTaxPayersDetails) {
        for (TaxPayerDetails taxPayers : wardWiseTaxProducers) {
            wardWiseTaxPayersDetails.put(taxPayers.getWardName(), taxPayers);
        }
    }

    private void prepareBillCollectorWiseMapData(CollectionDetailsRequest collectionDetailsRequest, Map<String, TaxPayerDetails> wardWiseTaxPayersDetails, Map<String, List<TaxPayerDetails>> billCollectorWiseMap, List<TaxPayerDetails> taxPayerDetailsList) {
        List<BillCollectorIndex> billCollectorsList = this.collectionIndexElasticSearchService.getBillCollectorDetails(collectionDetailsRequest);
        for (BillCollectorIndex billCollIndex : billCollectorsList) {
            if (wardWiseTaxPayersDetails.get(billCollIndex.getRevenueWard()) == null || !StringUtils.isNotBlank((CharSequence)billCollIndex.getRevenueWard())) continue;
            String billCollectorNameNumber = billCollIndex.getBillCollector().concat("~").concat(StringUtils.isBlank((CharSequence)billCollIndex.getMobileNumber()) ? "" : billCollIndex.getMobileNumber());
            if (billCollectorWiseMap.isEmpty()) {
                taxPayerDetailsList.add(wardWiseTaxPayersDetails.get(billCollIndex.getRevenueWard()));
                billCollectorWiseMap.put(billCollectorNameNumber, taxPayerDetailsList);
                continue;
            }
            if (!billCollectorWiseMap.containsKey(billCollectorNameNumber)) {
                taxPayerDetailsList = new ArrayList<TaxPayerDetails>();
                taxPayerDetailsList.add(wardWiseTaxPayersDetails.get(billCollIndex.getRevenueWard()));
                billCollectorWiseMap.put(billCollectorNameNumber, taxPayerDetailsList);
                continue;
            }
            billCollectorWiseMap.get(billCollectorNameNumber).add(wardWiseTaxPayersDetails.get(billCollIndex.getRevenueWard()));
        }
    }

    private List<TaxPayerDetails> getTaxPayersForBillCollector(CollectionDetailsRequest collectionDetailsRequest, boolean order, List<TaxPayerDetails> wardWiseTaxProducers, List<TaxPayerDetails> billCollectorWiseTaxPayerDetails, boolean isForProducers) {
        HashMap<BigDecimal, TaxPayerDetails> sortedTaxersMap = new HashMap<BigDecimal, TaxPayerDetails>();
        if (isForProducers) {
            for (TaxPayerDetails payerDetails : billCollectorWiseTaxPayerDetails) {
                sortedTaxersMap.put(payerDetails.getCytdColl(), payerDetails);
            }
        } else {
            for (TaxPayerDetails payerDetails : billCollectorWiseTaxPayerDetails) {
                sortedTaxersMap.put(payerDetails.getAchievement(), payerDetails);
            }
        }
        ArrayList sortedList = new ArrayList(sortedTaxersMap.keySet());
        if (order) {
            Collections.sort(sortedList);
        } else {
            Collections.sort(sortedList, Collections.reverseOrder());
        }
        ArrayList<TaxPayerDetails> taxersResult = new ArrayList<TaxPayerDetails>();
        for (BigDecimal amount : sortedList) {
            taxersResult.add((TaxPayerDetails)sortedTaxersMap.get(amount));
        }
        if (taxersResult.size() > 10) {
            return taxersResult.subList(0, taxersResult.size() < 10 ? taxersResult.size() : 10);
        }
        return taxersResult;
    }

    private void prepareTaxersInfoForBillCollectors(CollectionDetailsRequest collectionDetailsRequest, Map<String, List<TaxPayerDetails>> billCollectorWiseMap, List<TaxPayerDetails> billCollectorWiseTaxPayerDetails) {
        for (Map.Entry<String, List<TaxPayerDetails>> entry : billCollectorWiseMap.entrySet()) {
            TaxPayerDetails taxPayerDetails = new TaxPayerDetails();
            BigDecimal cytdColl = BigDecimal.ZERO;
            BigDecimal lytdColl = BigDecimal.ZERO;
            BigDecimal cytdDmd = BigDecimal.ZERO;
            BigDecimal totalDmd = BigDecimal.ZERO;
            BigDecimal variance = BigDecimal.ZERO;
            String[] billCollectorNameNumberArr = entry.getKey().split("~");
            for (TaxPayerDetails taxPayer : entry.getValue()) {
                totalDmd = totalDmd.add(taxPayer.getTotalDmd() == null ? BigDecimal.ZERO : taxPayer.getTotalDmd());
                cytdColl = cytdColl.add(taxPayer.getCytdColl() == null ? BigDecimal.ZERO : taxPayer.getCytdColl());
                cytdDmd = cytdDmd.add(taxPayer.getCytdDmd() == null ? BigDecimal.ZERO : taxPayer.getCytdDmd());
                lytdColl = lytdColl.add(taxPayer.getLytdColl() == null ? BigDecimal.ZERO : taxPayer.getLytdColl());
            }
            taxPayerDetails.setBillCollector(billCollectorNameNumberArr[0]);
            taxPayerDetails.setMobileNumber(billCollectorNameNumberArr.length > 1 ? billCollectorNameNumberArr[1] : "");
            taxPayerDetails.setRegionName(collectionDetailsRequest.getRegionName());
            taxPayerDetails.setDistrictName(collectionDetailsRequest.getDistrictName());
            taxPayerDetails.setUlbGrade(collectionDetailsRequest.getUlbGrade());
            taxPayerDetails.setCytdColl(cytdColl);
            taxPayerDetails.setCytdDmd(cytdDmd);
            taxPayerDetails.setCytdBalDmd(cytdDmd.subtract(cytdColl));
            taxPayerDetails.setTotalDmd(totalDmd);
            taxPayerDetails.setLytdColl(lytdColl);
            taxPayerDetails.setAchievement(cytdColl.multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(cytdDmd, 1, 4));
            variance = lytdColl.compareTo(BigDecimal.ZERO) == 0 ? PropertyTaxConstants.BIGDECIMAL_100 : cytdColl.subtract(lytdColl).multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(lytdColl, 1, 4);
            billCollectorWiseTaxPayerDetails.add(taxPayerDetails);
        }
    }

    private void prepareDCBDetailsMap(StringTerms individualDmdDetails, Map<String, Map<String, BigDecimal>> demandDivisionMap) {
        if (individualDmdDetails != null) {
            for (Terms.Bucket entry : individualDmdDetails.getBuckets()) {
                HashMap<String, BigDecimal> individualDmdMap = new HashMap<String, BigDecimal>();
                Sum arrearDmd = (Sum)entry.getAggregations().get(ARREAR_DMD_STR);
                Sum currentDmd = (Sum)entry.getAggregations().get(CURR_DMD);
                Sum arrearInterestDmd = (Sum)entry.getAggregations().get(ARREAR_INTEREST_DMD);
                Sum currentInterestDmd = (Sum)entry.getAggregations().get(CURR_INTEREST_DMD);
                Sum totalDmd = (Sum)entry.getAggregations().get("total_dmd");
                Sum adjustment = (Sum)entry.getAggregations().get("adjustment");
                Sum arrearColl = (Sum)entry.getAggregations().get("arrear_coll");
                Sum currentColl = (Sum)entry.getAggregations().get("curr_coll");
                Sum arrearInterestColl = (Sum)entry.getAggregations().get("arrear_interest_coll");
                Sum currentInterestColl = (Sum)entry.getAggregations().get("curr_interest_coll");
                Sum advanceColl = (Sum)entry.getAggregations().get("advance");
                Sum rebate = (Sum)entry.getAggregations().get(REBATE_STR);
                Sum totalColl = (Sum)entry.getAggregations().get("total_coll");
                individualDmdMap.put(ARREAR_DMD, BigDecimal.valueOf(arrearDmd.getValue()).setScale(0, 4));
                individualDmdMap.put(CURRENT_DMD, BigDecimal.valueOf(currentDmd.getValue()).setScale(0, 4));
                individualDmdMap.put(ARREAR_INT_DMD, BigDecimal.valueOf(arrearInterestDmd.getValue()).setScale(0, 4));
                individualDmdMap.put(CURRENT_INT_DMD, BigDecimal.valueOf(currentInterestDmd.getValue()).setScale(0, 4));
                individualDmdMap.put(TOTAL_DMD_STR, BigDecimal.valueOf(totalDmd.getValue()).setScale(0, 4));
                individualDmdMap.put("adjustment", BigDecimal.valueOf(adjustment.getValue()).setScale(0, 4));
                individualDmdMap.put(ARREAR_COLL_STR, BigDecimal.valueOf(arrearColl.getValue()).setScale(0, 4));
                individualDmdMap.put(CURRENT_COLL_STR, BigDecimal.valueOf(currentColl.getValue()).setScale(0, 4));
                individualDmdMap.put(ARREAR_INT_COLL, BigDecimal.valueOf(arrearInterestColl.getValue()).setScale(0, 4));
                individualDmdMap.put(CURRENT_INT_COLL, BigDecimal.valueOf(currentInterestColl.getValue()).setScale(0, 4));
                individualDmdMap.put(ADVANCE_COLL_STR, BigDecimal.valueOf(advanceColl.getValue()).setScale(0, 4));
                individualDmdMap.put(REBATE_STR, BigDecimal.valueOf(rebate.getValue()).setScale(0, 4));
                individualDmdMap.put(TOTAL_COLL_STR, BigDecimal.valueOf(totalColl.getValue()).setScale(0, 4));
                demandDivisionMap.put(String.valueOf(entry.getKey()), individualDmdMap);
            }
        }
    }

    public List<DCBDetails> getDCBDetails(CollectionDetailsRequest collectionDetailsRequest) {
        ArrayList<DCBDetails> dcbDetailsList = new ArrayList<DCBDetails>();
        HashMap<String, Map<String, BigDecimal>> demandDivisionMap = new HashMap<String, Map<String, BigDecimal>>();
        Map<String, BigDecimal> assessmentsCountMap = this.collectionIndexElasticSearchService.getCollectionAndDemandCountResults(collectionDetailsRequest, null, null, "propertytax", "consumerCode", CITY_NAME);
        StringTerms individualDmdDetails = this.collectionIndexElasticSearchService.getIndividualDemands(collectionDetailsRequest, "propertytax", CITY_NAME, true);
        this.prepareDCBDetailsMap(individualDmdDetails, demandDivisionMap);
        for (Map.Entry entry : demandDivisionMap.entrySet()) {
            DCBDetails dCBDetails = new DCBDetails();
            String name = (String)entry.getKey();
            dCBDetails.setUlbName(name);
            if (!assessmentsCountMap.isEmpty() && assessmentsCountMap.get(name) != null) {
                dCBDetails.setTotalAssessments(assessmentsCountMap.get(name) == null ? BigDecimal.ZERO : assessmentsCountMap.get(name));
            }
            dCBDetails.setArrearDemand(((Map)demandDivisionMap.get(name)).get(ARREAR_DMD) == null ? BigDecimal.ZERO : (BigDecimal)((Map)demandDivisionMap.get(name)).get(ARREAR_DMD));
            dCBDetails.setArrearPenalty(((Map)demandDivisionMap.get(name)).get(ARREAR_INT_DMD) == null ? BigDecimal.ZERO : (BigDecimal)((Map)demandDivisionMap.get(name)).get(ARREAR_INT_DMD));
            dCBDetails.setCurrentDemand(((Map)demandDivisionMap.get(name)).get(CURRENT_DMD) == null ? BigDecimal.ZERO : (BigDecimal)((Map)demandDivisionMap.get(name)).get(CURRENT_DMD));
            dCBDetails.setCurrentPenalty(((Map)demandDivisionMap.get(name)).get(CURRENT_INT_DMD) == null ? BigDecimal.ZERO : (BigDecimal)((Map)demandDivisionMap.get(name)).get(CURRENT_INT_DMD));
            dCBDetails.setTotalDemand(((Map)demandDivisionMap.get(name)).get(TOTAL_DMD_STR) == null ? BigDecimal.ZERO : (BigDecimal)((Map)demandDivisionMap.get(name)).get(TOTAL_DMD_STR));
            dCBDetails.setAdjustment(BigDecimal.ZERO);
            dCBDetails.setArrearColl(((Map)demandDivisionMap.get(name)).get(ARREAR_COLL_STR) == null ? BigDecimal.ZERO : (BigDecimal)((Map)demandDivisionMap.get(name)).get(ARREAR_COLL_STR));
            dCBDetails.setCurrentColl(((Map)demandDivisionMap.get(name)).get(CURRENT_COLL_STR) == null ? BigDecimal.ZERO : (BigDecimal)((Map)demandDivisionMap.get(name)).get(CURRENT_COLL_STR));
            dCBDetails.setArrearPenaltyColl(((Map)demandDivisionMap.get(name)).get(ARREAR_INT_COLL) == null ? BigDecimal.ZERO : (BigDecimal)((Map)demandDivisionMap.get(name)).get(ARREAR_INT_COLL));
            dCBDetails.setCurrentPenaltyColl(((Map)demandDivisionMap.get(name)).get(CURRENT_INT_COLL) == null ? BigDecimal.ZERO : (BigDecimal)((Map)demandDivisionMap.get(name)).get(CURRENT_INT_COLL));
            dCBDetails.setAdvanceColl(((Map)demandDivisionMap.get(name)).get(ADVANCE_COLL_STR) == null ? BigDecimal.ZERO : (BigDecimal)((Map)demandDivisionMap.get(name)).get(ADVANCE_COLL_STR));
            dCBDetails.setRebate(((Map)demandDivisionMap.get(name)).get(REBATE_STR) == null ? BigDecimal.ZERO : (BigDecimal)((Map)demandDivisionMap.get(name)).get(REBATE_STR));
            dCBDetails.setTotalColl(((Map)demandDivisionMap.get(name)).get(TOTAL_COLL_STR) == null ? BigDecimal.ZERO : (BigDecimal)((Map)demandDivisionMap.get(name)).get(TOTAL_COLL_STR));
            if (dCBDetails.getTotalDemand().compareTo(BigDecimal.ZERO) > 0) {
                dCBDetails.setPercentage(dCBDetails.getTotalColl().multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(dCBDetails.getTotalDemand(), 6));
            }
            dcbDetailsList.add(dCBDetails);
        }
        return dcbDetailsList;
    }
}

