/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.master.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.ptis.domain.dao.property.PropertyUsageDAO;
import org.egov.ptis.domain.entity.property.PropertyUsage;
import org.egov.ptis.domain.repository.master.usage.PropertyUsageRepository;
import org.egov.ptis.report.bean.PropertyUsageSearchResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PropertyUsageService {
    private final PropertyUsageDAO propertyUsageHibernateDAO;
    @Autowired
    private UserService userService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PropertyUsageRepository propertyUsageRepository;

    @Autowired
    public PropertyUsageService(PropertyUsageDAO propertyUsageHibernateDAO) {
        this.propertyUsageHibernateDAO = propertyUsageHibernateDAO;
    }

    public PropertyUsage create(PropertyUsage propertyUsage) {
        if (propertyUsage.getIsResidential().booleanValue()) {
            propertyUsage.setUsageCode("RESD");
        } else {
            propertyUsage.setUsageCode("NON_RESD");
        }
        propertyUsage.setIsEnabled(1);
        this.propertyUsageHibernateDAO.create(propertyUsage);
        return propertyUsage;
    }

    public List<PropertyUsage> getAllActivePropertyUsages() {
        return this.propertyUsageHibernateDAO.getAllActivePropertyUsage();
    }

    public PropertyUsage findById(Long id) {
        return this.propertyUsageHibernateDAO.findById(id, false);
    }

    public String getRolesForUserId(Long userId) {
        ArrayList<String> roleNameList = new ArrayList<String>();
        User user = this.userService.getUserById(userId);
        for (Role role : user.getRoles()) {
            String roleName = role.getName() != null ? role.getName() : "";
            roleNameList.add(roleName);
        }
        return ((Object)roleNameList).toString().toUpperCase();
    }

    public List<PropertyUsageSearchResult> getPropertyUsageByTypeUsgAndfromDate(PropertyUsage propertyUsage) {
        StringBuffer queryString = new StringBuffer(200);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        ArrayList<PropertyUsageSearchResult> propertyUsageSearchList = new ArrayList<PropertyUsageSearchResult>();
        queryString.append(" from PropertyUsage PU where PU.isEnabled = 1 and PU.isResidential = :isResidential ");
        if (StringUtils.isNotBlank((String)propertyUsage.getUsageName())) {
            queryString.append(" and upper(PU.usageName) like :usageName ");
        }
        if (propertyUsage.getFromDate() != null) {
            queryString.append(" and PU.fromDate >= :fromDate ");
        }
        queryString.append(" order by usageName ");
        Query qry = this.entityManager.createQuery(queryString.toString());
        qry.setParameter("isResidential", (Object)propertyUsage.getIsResidential());
        if (StringUtils.isNotBlank((String)propertyUsage.getUsageName())) {
            qry.setParameter("usageName", (Object)("%" + propertyUsage.getUsageName().toUpperCase() + "%"));
        }
        if (propertyUsage.getFromDate() != null) {
            qry.setParameter("fromDate", (Object)propertyUsage.getFromDate());
        }
        List propertyUsageList = qry.getResultList();
        for (PropertyUsage propertyUsageObj : propertyUsageList) {
            PropertyUsageSearchResult propertyUsageSearchObj = new PropertyUsageSearchResult();
            propertyUsageSearchObj.setUsageName(propertyUsageObj.getUsageName());
            propertyUsageSearchObj.setUsageType(propertyUsageObj.getIsResidential() != false ? "Residential" : "Non-Residential");
            propertyUsageSearchObj.setFromDate(dateFormat.format(propertyUsageObj.getFromDate()));
            propertyUsageSearchObj.setToDate(dateFormat.format(propertyUsageObj.getToDate()));
            propertyUsageSearchList.add(propertyUsageSearchObj);
        }
        return propertyUsageSearchList;
    }

    public List<PropertyUsage> getResidentialPropertyUsages() {
        return this.propertyUsageRepository.findByIsResidentialTrueAndIsActiveTrueOrderByUsageName();
    }

    public List<PropertyUsage> getNonResidentialPropertyUsages() {
        return this.propertyUsageRepository.findByIsResidentialFalseAndIsActiveTrueOrderByUsageName();
    }
}

