/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.master.service;

import java.util.ArrayList;
import java.util.List;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.ptis.domain.entity.property.FloorType;
import org.egov.ptis.domain.repository.master.floortype.FloorTypeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class FloorTypeService {
    private final FloorTypeRepository floorTypeRepository;
    @Autowired
    private UserService userService;

    @Autowired
    public FloorTypeService(FloorTypeRepository floorTypeRepository) {
        this.floorTypeRepository = floorTypeRepository;
    }

    @Transactional
    public FloorType create(FloorType floorType) {
        this.floorTypeRepository.save((Object)floorType);
        return floorType;
    }

    public FloorType getFloorTypeByName(String name) {
        return this.floorTypeRepository.findByName(name);
    }

    public FloorType getFloorTypeById(Long id) {
        return (FloorType)((Object)this.floorTypeRepository.findOne(id));
    }

    public List<FloorType> getAllFloors() {
        return this.floorTypeRepository.findAll();
    }

    public String getRolesForUserId(Long userId) {
        ArrayList<String> roleNameList = new ArrayList<String>();
        User user = this.userService.getUserById(userId);
        for (Role role : user.getRoles()) {
            String roleName = role.getName() != null ? role.getName() : "";
            roleNameList.add(roleName);
        }
        return ((Object)roleNameList).toString().toUpperCase();
    }
}

