/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.revisionPetition;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.entity.Source;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.elasticsearch.entity.ApplicationIndex;
import org.egov.infra.elasticsearch.service.ApplicationIndexService;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.egov.infra.web.utils.WebUtils;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.PropertyStatusDAO;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.domain.service.property.SMSEmailService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

public class RevisionPetitionService
extends PersistenceService<RevisionPetition, Long> {
    @Autowired
    private ApplicationNumberGenerator applicationNumberGenerator;
    @Autowired
    private PropertyStatusDAO propertyStatusDAO;
    @Autowired
    DesignationService designationService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;
    @Autowired
    @Qualifier(value="workflowService")
    protected SimpleWorkflowService<RevisionPetition> revisionPetitionWorkFlowService;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private ApplicationIndexService applicationIndexService;
    private static final String REVISION_PETITION_CREATED = "CREATED";
    @Autowired
    private MessagingService messagingService;
    private SMSEmailService sMSEmailService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private ReportService reportService;
    @Autowired
    private PtDemandDao ptDemandDAO;

    public RevisionPetitionService() {
        super(RevisionPetition.class);
    }

    public RevisionPetitionService(Class<RevisionPetition> type) {
        super(type);
    }

    @Transactional
    public RevisionPetition createRevisionPetition(RevisionPetition objection) {
        this.propertyService.processAndStoreDocument(objection.getDocuments());
        RevisionPetition revisionPetition = objection.getId() == null ? (RevisionPetition)((Object)this.persist((Object)objection)) : (RevisionPetition)((Object)this.merge((Object)objection));
        return revisionPetition;
    }

    @Transactional
    public RevisionPetition createRevisionPetitionForRest(RevisionPetition objection) {
        Position position = null;
        WorkFlowMatrix wfmatrix = null;
        User user = null;
        if (objection.getId() == null) {
            if (objection.getObjectionNumber() == null) {
                objection.setObjectionNumber(this.applicationNumberGenerator.generate());
            }
            objection.getBasicProperty().setStatus(this.propertyStatusDAO.getPropertyStatusByCode("OBJECTED"));
            objection.getBasicProperty().setUnderWorkflow(Boolean.TRUE);
            if (objection.getState() == null) {
                wfmatrix = this.revisionPetitionWorkFlowService.getWfMatrix(objection.getStateType(), null, null, null, "Revision Petition:CREATED", null);
                Designation desig = this.designationService.getDesignationByName("Revenue Clerk");
                List assignment = this.assignmentService.findByDesignationAndBoundary(desig.getId(), objection.getBasicProperty().getPropertyID().getZone().getId());
                if (assignment.size() > 0) {
                    position = ((Assignment)assignment.get(0)).getPosition();
                } else {
                    assignment = this.assignmentService.findPrimaryAssignmentForDesignationName("Revenue Clerk");
                    if (assignment.size() > 0) {
                        position = ((Assignment)assignment.get(0)).getPosition();
                    }
                }
                this.updateRevisionPetitionStatus(wfmatrix, objection, null);
                if (position != null) {
                    user = this.eisCommonService.getUserForPosition(position.getId(), new Date());
                }
                objection.start().withNextAction(wfmatrix.getPendingActions()).withStateValue(wfmatrix.getCurrentState()).withOwner(position).withSenderName(user != null && user.getName() != null ? user.getName() : "").withOwner(user).withComments("");
            }
            this.applyAuditing((AbstractAuditable)objection.getState());
            objection = (RevisionPetition)((Object)this.persist((Object)objection));
            this.updateIndex(objection);
            this.sendEmailandSms(objection, REVISION_PETITION_CREATED);
        } else {
            objection = (RevisionPetition)((Object)this.merge((Object)objection));
        }
        return objection;
    }

    private void updateIndex(RevisionPetition objection) {
        ApplicationIndex applicationIndex = this.applicationIndexService.findByApplicationNumber(objection.getObjectionNumber());
        User user = this.securityUtils.getCurrentUser();
        if (null == applicationIndex) {
            applicationIndex = ApplicationIndex.builder().withModuleName("Property Tax").withApplicationNumber(objection.getObjectionNumber()).withApplicationDate(objection.getCreatedDate() != null ? objection.getCreatedDate() : new Date()).withApplicationType("Revision_Petition").withApplicantName(objection.getBasicProperty().getFullOwnerName()).withStatus(objection.getState().getValue()).withUrl(String.format("/ptis/view/viewProperty-viewForm.action?applicationNo=%s&applicationType=%s", objection.getObjectionNumber(), "")).withApplicantAddress(objection.getBasicProperty().getAddress().toString()).withOwnername(user.getUsername() + "::" + user.getName()).withChannel(Source.SYSTEM.toString()).build();
            this.applicationIndexService.createApplicationIndex(applicationIndex);
        } else {
            applicationIndex.setStatus(objection.getState().getValue());
            this.applicationIndexService.updateApplicationIndex(applicationIndex);
        }
    }

    private void updateRevisionPetitionStatus(WorkFlowMatrix wfmatrix, RevisionPetition objection, String status) {
        EgwStatus egwStatus = null;
        if (status != null && !"".equals(status)) {
            egwStatus = this.egwStatusDAO.getStatusByModuleAndCode("PTObejction", status);
        } else if (wfmatrix != null && wfmatrix.getNextStatus() != null && objection != null) {
            egwStatus = this.egwStatusDAO.getStatusByModuleAndCode("PTObejction", wfmatrix.getNextStatus());
        }
        if (egwStatus != null) {
            objection.setEgwStatus(egwStatus);
        }
    }

    @Transactional
    public RevisionPetition updateRevisionPetition(RevisionPetition objection) {
        RevisionPetition revisionPetition = objection.getId() == null ? (RevisionPetition)((Object)this.persist((Object)objection)) : (RevisionPetition)((Object)this.update((Object)objection));
        return revisionPetition;
    }

    public RevisionPetition getRevisionPetitionByApplicationNumber(String applicationNumber) {
        Criteria appCriteria = this.getSession().createCriteria(RevisionPetition.class, "revPetiton");
        appCriteria.add((Criterion)Restrictions.eq((String)"revPetiton.objectionNumber", (Object)applicationNumber));
        RevisionPetition revPetitionObject = (RevisionPetition)((Object)appCriteria.uniqueResult());
        return revPetitionObject;
    }

    public void sendEmailandSms(RevisionPetition objection, String applicationType) {
        if (objection != null) {
            for (PropertyOwnerInfo ownerInfo : objection.getBasicProperty().getPropertyOwnerInfo()) {
                this.sendEmailAndSms(objection, ownerInfo.getOwner(), applicationType);
            }
        }
    }

    private void sendEmailAndSms(RevisionPetition objection, User user, String applicationType) {
        String mobileNumber = user.getMobileNumber();
        String emailid = user.getEmailId();
        String applicantName = user.getName();
        ArrayList<String> args = new ArrayList<String>();
        args.add(applicantName);
        String smsMsg = "";
        String emailSubject = "";
        String emailBody = "";
        if (applicationType != null && applicationType.equalsIgnoreCase(REVISION_PETITION_CREATED)) {
            args.add(objection.getObjectionNumber());
            if (mobileNumber != null) {
                smsMsg = "Revision petition created. Use " + objection.getObjectionNumber() + " for future reference";
            }
            if (emailid != null) {
                emailSubject = "Revision petition created.";
                emailBody = "Revision petition created. Use " + objection.getObjectionNumber() + " for future reference";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)mobileNumber) && StringUtils.isNotBlank((CharSequence)smsMsg)) {
            this.messagingService.sendSMS(mobileNumber, smsMsg);
        }
        if (StringUtils.isNotBlank((CharSequence)emailid) && StringUtils.isNotBlank((CharSequence)emailBody)) {
            this.messagingService.sendEmail(emailid, emailSubject, emailBody);
        }
    }

    public SMSEmailService getsMSEmailService() {
        return this.sMSEmailService;
    }

    public void setsMSEmailService(SMSEmailService sMSEmailService) {
        this.sMSEmailService = sMSEmailService;
    }

    public RevisionPetition createRevisionPetition(RevisionPetition objection, HashMap<String, String> meesevaParams) {
        this.createRevisionPetition(objection);
        return objection;
    }

    public Assignment getWorkflowInitiator(RevisionPetition objection) {
        Assignment wfInitiator = this.propertyService.isEmployee(objection.getCreatedBy()).booleanValue() ? (objection.getState() != null && objection.getState().getInitiatorPosition() != null ? this.propertyTaxCommonUtils.getUserAssignmentByPassingPositionAndUser(objection.getCreatedBy(), objection.getState().getInitiatorPosition()) : this.assignmentService.getPrimaryAssignmentForUser(objection.getCreatedBy().getId())) : (!objection.getStateHistory().isEmpty() ? this.assignmentService.getPrimaryAssignmentForPositon(((StateHistory)objection.getStateHistory().get(0)).getOwnerPosition().getId()) : this.assignmentService.getPrimaryAssignmentForPositon(objection.getState().getOwnerPosition().getId()));
        return wfInitiator;
    }

    public RevisionPetition getExistingObjections(BasicProperty basicProperty) {
        return (RevisionPetition)((Object)this.find("from RevisionPetition rp where rp.basicProperty = ?", new Object[]{basicProperty}));
    }

    public ReportOutput createHearingNoticeReport(ReportOutput reportOutput, RevisionPetition objection, String noticeNo) {
        reportOutput.setReportFormat(ReportConstants.FileFormat.PDF);
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        SimpleDateFormat dateformat = new SimpleDateFormat("dd/MM/yyyy");
        if (objection != null) {
            HttpServletRequest request = ServletActionContext.getRequest();
            String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
            String cityGrade = request.getSession().getAttribute("cityGrade") != null ? request.getSession().getAttribute("cityGrade").toString() : null;
            Boolean isCorporation = cityGrade != null && cityGrade != "" && cityGrade.equalsIgnoreCase("Corp") ? Boolean.valueOf(true) : Boolean.valueOf(false);
            String natureOfWork = "RP".equalsIgnoreCase(objection.getType()) ? "Revision Petition" : "General Revision Petition";
            reportParams.put("isCorporation", isCorporation);
            reportParams.put("cityName", cityName);
            reportParams.put("recievedBy", objection.getBasicProperty().getFullOwnerName());
            reportParams.put("natureOfWork", natureOfWork);
            if (objection.getHearings() != null && !objection.getHearings().isEmpty() && objection.getHearings().get(objection.getHearings().size() - 1).getPlannedHearingDt() != null) {
                reportParams.put("hearingNoticeDate", dateformat.format(objection.getHearings().get(objection.getHearings().size() - 1).getPlannedHearingDt()));
            } else {
                reportParams.put("hearingNoticeDate", "");
            }
            reportParams.put("currentDate", dateformat.format(new Date()));
            reportParams.put("recievedOn", dateformat.format(objection.getRecievedOn()));
            reportParams.put("docNumberObjection", noticeNo);
            reportParams.put("houseNo", objection.getBasicProperty().getAddress().getHouseNoBldgApt());
            reportParams.put("locality", objection.getBasicProperty().getPropertyID().getLocality().getName());
            reportParams.put("assessmentNo", objection.getBasicProperty().getUpicNo());
            reportParams.put("hearingTime", objection.getHearings().get(objection.getHearings().size() - 1).getHearingTime());
            reportParams.put("hearingVenue", objection.getHearings().get(objection.getHearings().size() - 1).getHearingVenue());
            ReportRequest reportRequest = new ReportRequest("mainHearingNotice", (Object)objection, reportParams);
            reportOutput = this.reportService.createReport(reportRequest);
        }
        return reportOutput;
    }

    public ReportOutput createEndoresement(ReportOutput reportOutput, RevisionPetition objection) {
        reportOutput.setReportFormat(ReportConstants.FileFormat.PDF);
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        SimpleDateFormat dateformat = new SimpleDateFormat("dd/MM/yyyy");
        if (objection != null) {
            Map<String, BigDecimal> currentDemand = this.ptDemandDAO.getDemandCollMap(objection.getProperty());
            Map<String, BigDecimal> earlierDemand = this.ptDemandDAO.getDemandCollMap(objection.getBasicProperty().getProperty());
            HttpServletRequest request = ServletActionContext.getRequest();
            String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
            String cityLogo = url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo"));
            String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
            String natureOfWork = "RP".equalsIgnoreCase(objection.getType()) ? "Revision Petition" : "General Revision Petition";
            reportParams.put("logoPath", cityLogo);
            reportParams.put("cityName", cityName);
            reportParams.put("natureOfWork", natureOfWork);
            reportParams.put("recievedBy", objection.getBasicProperty().getFullOwnerName());
            reportParams.put("docNumberObjection", objection.getObjectionNumber());
            reportParams.put("currentDate", dateformat.format(new Date()));
            reportParams.put("receivedOn", dateformat.format(objection.getRecievedOn()));
            reportParams.put("HouseNo", objection.getBasicProperty().getUpicNo());
            reportParams.put("wardNumber", objection.getBasicProperty().getBoundary() != null ? objection.getBasicProperty().getBoundary().getName() : "");
            reportParams.put("HalfYearPropertyTaxTo", currentDemand.get("CURR_SECONDHALF_DMD").divide(BigDecimal.valueOf(2L)).setScale(2));
            reportParams.put("HalfYearPropertyTaxFrom", earlierDemand.get("CURR_SECONDHALF_DMD").divide(BigDecimal.valueOf(2L)).setScale(2));
            reportParams.put("AnnualPropertyTaxTo", currentDemand.get("CURR_SECONDHALF_DMD").setScale(2).toString());
            reportParams.put("AnnualPropertyTaxFrom", earlierDemand.get("CURR_SECONDHALF_DMD").setScale(2).toString());
            ReportRequest reportRequest = new ReportRequest("revPetitionEndorsement", (Object)objection, reportParams);
            reportOutput = this.reportService.createReport(reportRequest);
        }
        return reportOutput;
    }
}

