/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.notice;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.Installment;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.demand.model.EgBill;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.NumberUtil;
import org.egov.infra.utils.PdfUtils;
import org.egov.ptis.bean.NoticeRequest;
import org.egov.ptis.client.util.PropertyTaxNumberGenerator;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.notice.RecoveryNoticesInfo;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Floor;
import org.egov.ptis.domain.entity.property.PropertyAddress;
import org.egov.ptis.domain.repository.notice.RecoveryNoticesInfoRepository;
import org.egov.ptis.domain.service.notice.NoticeService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.notice.PtNotice;
import org.egov.ptis.service.DemandBill.DemandBillService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class RecoveryNoticeService {
    private static final String DEMAND_BILL_SERVICE = "demandBillService";
    private static final String CONSUMER_ID = "consumerId";
    private static final String ADDRESS = "address";
    private static final String LOCALITY = "locality";
    private static final String UPIC_NO = "upicNo";
    private static final String NOTICE_NUMBER = "noticeNumber";
    private static final String DOOR_NO = "doorNo";
    private static final String LOCATION = "Location";
    private static final String FINANCIAL_YEAR = "financialYear";
    private static final String DISTRESS_NOTICE_DATE = "distressNoticeDate";
    private static final String DISTRESS_NOTICE_NUMBER = "distressNoticeNumber";
    private static final String FIN_HALF_STRAT_MONTH = "FinHalfStratMonth";
    private static final String NOTICE_YEAR = "noticeYear";
    private static final String NOTICE_MONTH = "noticeMonth";
    private static final String NOTICE_DAY = "noticeDay";
    private static final String TOTAL_TAX_DUE = "totalTaxDue";
    private static final String SECTION_ACT = "sectionAct";
    private static final String BILL_NUMBER = "billNumber";
    private static final String BILL_DATE = "billDate";
    private static final String ESD_NOTICE_DATE = "eSDNoticeDate";
    private static final String ESD_NOTICE_NUMBER = "eSDNoticeNumber";
    private static final String FUTURE_DATE = "futureDate";
    private static final String FIN_YEAR = "finYear";
    private static final String CITY_NAME = "cityName";
    private static final String INST_MON_YEAR = "instMonYear";
    private static final String INST_LAST_DATE = "instLastDate";
    private static final String REPORT_MON_YEAR = "reportMonYear";
    private static final String REPORT_DATE = "reportDate";
    private static final String OWNER_NAME = "ownerName";
    private static final String OWNERSHIP_CERTIFICATE_DATE = "ownershipCertificateDate";
    private static final String OWNERSHIP_CERTIFICATE_NO = "ownershipCertificateNo";
    private static final String OCCUPIER_NOTICE_NAGAR_PANCHAYET = "OccupierNotice_NagarPanchayet";
    private static final String OCCUPIER_NOTICE_CORPORATION = "OccupierNotice_Corporation";
    private static final String TAX_DUE_IN_WORDS = "taxDueInWords";
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private ReportService reportService;
    @Autowired
    private NoticeService noticeService;
    @Autowired
    private PropertyTaxNumberGenerator propertyTaxNumberGenerator;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private ApplicationContext beanProvider;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private PropertyService propertyService;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    @Autowired
    private RecoveryNoticesInfoRepository recoveryNoticesInfoRepository;
    @Autowired
    private FinancialYearDAO financialYearDAO;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public boolean getDemandBillByAssessmentNo(BasicProperty basicProperty) {
        String value;
        boolean billExists = false;
        AppConfigValues appConfigValues = this.appConfigValuesService.getAppConfigValueByDate("Property Tax", "IS_CLIENT_SPECIFIC_DEMANDBILL", new Date());
        String string = value = appConfigValues != null ? appConfigValues.getValue() : "";
        if ("Y".equalsIgnoreCase(value)) {
            DemandBillService demandBillService = (DemandBillService)this.beanProvider.getBean(DEMAND_BILL_SERVICE);
            billExists = demandBillService.getDemandBillByAssessmentNumber(basicProperty.getUpicNo());
        } else {
            EgBill egBill = this.getBillByAssessmentNumber(basicProperty);
            if (egBill != null) {
                billExists = true;
            }
        }
        return billExists;
    }

    public List<String> validateRecoveryNotices(String assessmentNo, String noticeType) {
        ArrayList<String> errors = new ArrayList<String>();
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        if (basicProperty == null) {
            errors.add("property.invalid");
        } else if ("ESD Notice".equals(noticeType)) {
            this.validateDemandBill(basicProperty, errors);
        } else if ("Distress Notice".equals(noticeType)) {
            this.validateDistressNotice(errors, basicProperty);
        } else if ("Inventory Notice".equals(noticeType)) {
            this.validateInventoryNotice(errors, basicProperty);
        } else if ("Valuation Certificate".equals(noticeType) || "Ownership Certificate".equals(noticeType)) {
            this.validateCertificate(errors, basicProperty);
        } else {
            this.validateOccupierNotice(errors, basicProperty);
        }
        return errors;
    }

    public EgBill getBillByAssessmentNumber(BasicProperty basicProperty) {
        StringBuilder queryStr = new StringBuilder(200);
        queryStr.append("FROM EgBill WHERE module =:module AND egBillType.code =:billType AND consumerId =:assessmentNo AND is_history = 'N'");
        Query qry = this.entityManager.createQuery(queryStr.toString());
        qry.setParameter("module", (Object)this.moduleDao.getModuleByName("Property Tax"));
        qry.setParameter("billType", (Object)"MANUAL");
        qry.setParameter("assessmentNo", (Object)basicProperty.getUpicNo());
        return qry.getResultList() != null && !qry.getResultList().isEmpty() ? (EgBill)qry.getResultList().get(0) : null;
    }

    public BigDecimal getTotalPropertyTaxDue(BasicProperty basicProperty) {
        return this.propertyService.getTotalPropertyTaxDue(basicProperty);
    }

    public BigDecimal getTotalPropertyTaxDueIncludingPenalty(BasicProperty basicProperty) {
        return this.propertyService.getTotalPropertyTaxDueIncludingPenalty(basicProperty);
    }

    public ResponseEntity<byte[]> generateNotice(String assessmentNo, String noticeType) {
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        PtNotice notice = this.noticeService.getNoticeByTypeUpicNoAndFinYear(noticeType, basicProperty.getUpicNo());
        ReportOutput reportOutput = notice == null ? this.generateNotice(noticeType, basicProperty) : this.getNotice(notice, noticeType);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=" + noticeType + "_" + basicProperty.getUpicNo() + ".pdf");
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    public ReportOutput generateNotice(String noticeType, BasicProperty basicProperty) {
        ReportOutput reportOutput = null;
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        ByteArrayInputStream noticePDF = null;
        ReportRequest reportInput = null;
        StringBuilder queryString = new StringBuilder();
        queryString.append("from City");
        Query query = this.entityManager.createQuery(queryString.toString());
        City city = (City)query.getSingleResult();
        this.populateReportParams(reportParams, city, basicProperty);
        String noticeNo = this.propertyTaxNumberGenerator.generateNoticeNumber(noticeType);
        SimpleDateFormat formatter = new SimpleDateFormat("MMM yyyy");
        if ("ESD Notice".equals(noticeType)) {
            reportInput = this.generateEsdNotice(basicProperty, reportParams, city, noticeNo, formatter);
        } else if ("Inventory Notice".equals(noticeType)) {
            reportInput = this.generateInventoryNotice(basicProperty, reportParams, city, formatter);
        } else if ("Valuation Certificate".equals(noticeType)) {
            reportInput = this.generateValuationCertificate(basicProperty, reportParams, city, noticeNo);
        } else if ("Ownership Certificate".equals(noticeType)) {
            reportInput = this.generateOwnershipCertificate(basicProperty, reportParams, city, noticeNo);
        } else if ("Occupier Notice".equals(noticeType)) {
            reportOutput = this.prepareOccupierNotice(basicProperty, reportParams, city, noticeNo);
        } else {
            reportInput = this.generateDistressNotice(basicProperty, reportParams, city, noticeNo);
        }
        if (!"Occupier Notice".equals(noticeType)) {
            reportInput.setPrintDialogOnOpenReport(true);
            reportInput.setReportFormat(ReportConstants.FileFormat.PDF);
            reportOutput = this.reportService.createReport(reportInput);
        }
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            noticePDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        this.noticeService.saveNotice(basicProperty.getPropertyForBasicProperty().getApplicationNo(), noticeNo, noticeType, basicProperty, noticePDF);
        return reportOutput;
    }

    public ReportOutput prepareOccupierNotice(BasicProperty basicProperty, Map<String, Object> reportParams, City city, String noticeNo) {
        ReportOutput reportOutput = null;
        ArrayList<ByteArrayInputStream> pdfs = new ArrayList<ByteArrayInputStream>();
        ReportRequest reportInput = this.generateOccupierNotice(basicProperty, reportParams, city, noticeNo);
        reportInput.setPrintDialogOnOpenReport(true);
        reportInput.setReportFormat(ReportConstants.FileFormat.PDF);
        for (Floor floor : basicProperty.getProperty().getPropertyDetail().getFloorDetails()) {
            if (!"TENANT".equalsIgnoreCase(floor.getPropertyOccupation().getOccupancyCode()) || (reportOutput = this.reportService.createReport(reportInput)) == null || reportOutput.getReportOutputData() == null) continue;
            pdfs.add(new ByteArrayInputStream(reportOutput.getReportOutputData()));
        }
        if (!pdfs.isEmpty()) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] mergedPdfs = PdfUtils.appendFiles(pdfs, (OutputStream)output);
            if (reportOutput != null) {
                reportOutput.setReportOutputData(mergedPdfs);
            }
        }
        return reportOutput;
    }

    public List<String> generateRecoveryNotices(NoticeRequest noticeRequest) {
        Query qry = this.getSearchQuery(noticeRequest);
        List properties = qry.getResultList();
        ArrayList<RecoveryNoticesInfo> noticesInfos = new ArrayList<RecoveryNoticesInfo>();
        Long jobNumber = this.getLatestJobNumber();
        if (jobNumber == null) {
            jobNumber = 0L;
        }
        jobNumber = jobNumber + 1L;
        for (String propertyId : properties) {
            RecoveryNoticesInfo info = new RecoveryNoticesInfo();
            info.setPropertyId(propertyId);
            info.setNoticeType(noticeRequest.getNoticeType());
            info.setGenerated(Boolean.FALSE);
            info.setJobNumber(jobNumber);
            noticesInfos.add(info);
        }
        this.recoveryNoticesInfoRepository.save(noticesInfos);
        return properties;
    }

    public Long getLatestJobNumber() {
        return this.recoveryNoticesInfoRepository.getLatestJobNumber();
    }

    public RecoveryNoticesInfo getRecoveryNoticeInfoByAssessmentAndNoticeType(String propertyId, String noticeType) {
        return this.recoveryNoticesInfoRepository.findByPropertyIdAndNoticeType(propertyId, noticeType);
    }

    public void saveRecoveryNoticeInfo(RecoveryNoticesInfo noticeInfo) {
        this.recoveryNoticesInfoRepository.save((Object)noticeInfo);
    }

    private Map<String, Object> populateReportParams(Map<String, Object> reportParams, City city, BasicProperty basicProperty) {
        reportParams.put(CITY_NAME, city.getPreferences().getMunicipalityName());
        reportParams.put(OWNER_NAME, basicProperty.getFullOwnerName());
        return reportParams;
    }

    private ReportOutput getNotice(PtNotice notice, String noticeType) {
        byte[] bFile;
        ReportOutput reportOutput = new ReportOutput();
        FileStoreMapper fsm = notice.getFileStore();
        File file = this.fileStoreService.fetch(fsm, "PTIS");
        try {
            bFile = FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            throw new ApplicationRuntimeException("Exception while retrieving " + noticeType + " : " + e);
        }
        reportOutput.setReportOutputData(bFile);
        reportOutput.setReportFormat(ReportConstants.FileFormat.PDF);
        return reportOutput;
    }

    private void validateInventoryNotice(List<String> errors, BasicProperty basicProperty) {
        this.validateDemandBill(basicProperty, errors);
        PtNotice distressNotice = this.noticeService.getNoticeByTypeUpicNoAndFinYear("Distress Notice", basicProperty.getUpicNo());
        if (distressNotice != null) {
            DateTime currDate = new DateTime();
            DateTime noticeDate = new DateTime((Object)distressNotice.getNoticeDate());
            if (!currDate.isAfter((ReadableInstant)noticeDate.plusDays(16))) {
                errors.add("invntry.distress.notice.not.exists");
            }
        } else {
            errors.add("invntry.distress.notice.not.exists");
        }
    }

    private void validateDistressNotice(List<String> errors, BasicProperty basicProperty) {
        BigDecimal totalDue = this.getTotalPropertyTaxDueIncludingPenalty(basicProperty);
        if (totalDue.compareTo(BigDecimal.ZERO) == 0) {
            errors.add("invalid.no.due");
        } else if (basicProperty.getProperty().getIsExemptedFromTax().booleanValue()) {
            errors.add("invalid.exempted");
        } else {
            PtNotice esdNotice = this.noticeService.getNoticeByTypeUpicNoAndFinYear("ESD Notice", basicProperty.getUpicNo());
            if (esdNotice == null) {
                errors.add("invalid.esd.not.generated");
            } else if (DateUtils.noOfDays((Date)esdNotice.getNoticeDate(), (Date)new Date()) < 15) {
                errors.add("invalid.time.not.lapsed");
            }
        }
    }

    private void validateCertificate(List<String> errors, BasicProperty basicProperty) {
        BigDecimal totalDue = this.getTotalPropertyTaxDue(basicProperty);
        if (totalDue.compareTo(BigDecimal.ZERO) > 0) {
            errors.add("assessment.has.pt.due");
        }
    }

    private List<String> validateDemandBill(BasicProperty basicProperty, List<String> errors) {
        BigDecimal totalDue = this.getTotalPropertyTaxDue(basicProperty);
        if (totalDue.compareTo(BigDecimal.ZERO) == 0) {
            errors.add("common.no.property.due");
        } else {
            boolean billExists = this.getDemandBillByAssessmentNo(basicProperty);
            if (!billExists) {
                errors.add("common.demandbill.not.exists");
            }
        }
        return errors;
    }

    private List<String> validateOccupierNotice(List<String> errors, BasicProperty basicProperty) {
        Boolean hasTenant = Boolean.FALSE;
        for (Floor floor : basicProperty.getProperty().getPropertyDetail().getFloorDetails()) {
            if (!"TENANT".equalsIgnoreCase(floor.getPropertyOccupation().getOccupancyCode())) continue;
            hasTenant = Boolean.TRUE;
        }
        if (!hasTenant.booleanValue()) {
            errors.add("error.tenant.not.exist");
        }
        return errors;
    }

    private ReportRequest generateDistressNotice(BasicProperty basicProperty, Map<String, Object> reportParams, City city, String noticeNo) {
        ReportRequest reportInput;
        PropertyAddress ownerAddress = basicProperty.getAddress();
        reportParams.put(TOTAL_TAX_DUE, this.getTotalPropertyTaxDueIncludingPenalty(basicProperty));
        DateTime noticeDate = new DateTime();
        reportParams.put(DOOR_NO, org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ownerAddress.getHouseNoBldgApt()) ? ownerAddress.getHouseNoBldgApt().trim() : "N/A");
        reportParams.put(CONSUMER_ID, basicProperty.getUpicNo());
        reportParams.put(NOTICE_DAY, this.propertyTaxCommonUtils.getDateWithSufix(noticeDate.getDayOfMonth()));
        reportParams.put(NOTICE_MONTH, noticeDate.monthOfYear().getAsShortText());
        reportParams.put(NOTICE_YEAR, noticeDate.getYear());
        if (noticeDate.getMonthOfYear() >= 4 && noticeDate.getMonthOfYear() <= 10) {
            reportParams.put(FIN_HALF_STRAT_MONTH, "April");
        } else {
            reportParams.put(FIN_HALF_STRAT_MONTH, "October");
        }
        reportParams.put(DISTRESS_NOTICE_NUMBER, noticeNo);
        reportParams.put(DISTRESS_NOTICE_DATE, DateUtils.getDefaultFormattedDate((Date)new Date()));
        String cityGrade = city.getGrade();
        if (StringUtils.isNotEmpty((String)cityGrade) && cityGrade.equalsIgnoreCase("Corp")) {
            reportParams.put(SECTION_ACT, "(Issued under Section 269(2) of Municipal Corporations Act,1955 (formerly GHMC Act, 1955)");
            reportInput = new ReportRequest("DistressWarrant_Corporation", reportParams, reportParams);
        } else {
            reportParams.put(SECTION_ACT, "(Issued under Rule 30(3) of Taxation & Finance Rules appended to the A.P. Municipalities Act, 1965)");
            reportInput = new ReportRequest("DistressWarrant_Municipality", reportParams, reportParams);
        }
        return reportInput;
    }

    private ReportRequest generateInventoryNotice(BasicProperty basicProperty, Map<String, Object> reportParams, City city, SimpleDateFormat formatter) {
        ReportRequest reportInput;
        Installment currentInstall = this.propertyTaxCommonUtils.getCurrentPeriodInstallment();
        DateTime dateTime = new DateTime();
        DateTime currInstToDate = new DateTime((Object)currentInstall.getToDate());
        reportParams.put(TOTAL_TAX_DUE, String.valueOf(this.getTotalPropertyTaxDue(basicProperty)));
        reportParams.put(REPORT_DATE, this.propertyTaxCommonUtils.getDateWithSufix(dateTime.getDayOfMonth()));
        reportParams.put(REPORT_MON_YEAR, dateTime.monthOfYear().getAsShortText() + "," + dateTime.getYear());
        String cityGrade = city.getGrade();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)cityGrade) && cityGrade.equalsIgnoreCase("Corp")) {
            reportParams.put(INST_LAST_DATE, this.propertyTaxCommonUtils.getDateWithSufix(currInstToDate.getDayOfMonth()));
            reportParams.put(INST_MON_YEAR, currInstToDate.monthOfYear().getAsShortText() + "," + currInstToDate.getYear());
            reportInput = new ReportRequest("InventoryNotice_Corporation", reportParams, reportParams);
        } else {
            reportParams.put(INST_LAST_DATE, formatter.format(currentInstall.getToDate()));
            reportInput = new ReportRequest("InventoryNotice_Municipality", reportParams, reportParams);
        }
        return reportInput;
    }

    private ReportRequest generateEsdNotice(BasicProperty basicProperty, Map<String, Object> reportParams, City city, String noticeNo, SimpleDateFormat formatter) {
        ReportRequest reportInput;
        this.prepareEsdReportParams(basicProperty, reportParams, noticeNo, formatter);
        String cityGrade = city.getGrade();
        if (cityGrade != null && cityGrade != "" && cityGrade.equalsIgnoreCase("Corp")) {
            reportParams.put(SECTION_ACT, "(Issued under Section 269(2) of Municipal Corporations Act,1955 (formerly GHMC Act, 1955)");
            reportInput = new ReportRequest("ESDNotice_Corporation", reportParams, reportParams);
        } else {
            reportParams.put(SECTION_ACT, "(Issued under Section 91 of A.P. Municipalities Act 1965)");
            reportInput = new ReportRequest("ESDNotice_Municipality", reportParams, reportParams);
        }
        return reportInput;
    }

    private void prepareEsdReportParams(BasicProperty basicProperty, Map<String, Object> reportParams, String noticeNo, SimpleDateFormat formatter) {
        String value;
        PropertyAddress ownerAddress = basicProperty.getAddress();
        DateTime noticeDate = new DateTime((Object)new Date());
        AppConfigValues appConfigValues = this.appConfigValuesService.getAppConfigValueByDate("Property Tax", "IS_CLIENT_SPECIFIC_DEMANDBILL", new Date());
        reportParams.put(DOOR_NO, org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ownerAddress.getHouseNoBldgApt()) ? ownerAddress.getHouseNoBldgApt() : "N/A");
        reportParams.put(FIN_YEAR, formatter.format(new Date()));
        reportParams.put(CONSUMER_ID, basicProperty.getUpicNo());
        reportParams.put(TOTAL_TAX_DUE, this.getTotalPropertyTaxDueIncludingPenalty(basicProperty));
        reportParams.put(FUTURE_DATE, DateUtils.getDefaultFormattedDate((Date)noticeDate.plusDays(2).toDate()));
        reportParams.put(ESD_NOTICE_NUMBER, noticeNo);
        reportParams.put(ESD_NOTICE_DATE, DateUtils.getDefaultFormattedDate((Date)new Date()));
        String string = value = appConfigValues != null ? appConfigValues.getValue() : "";
        if ("Y".equalsIgnoreCase(value)) {
            DemandBillService demandBillService = (DemandBillService)this.beanProvider.getBean(DEMAND_BILL_SERVICE);
            reportParams.putAll(demandBillService.getDemandBillDetails(basicProperty));
        } else {
            EgBill egBill = this.getBillByAssessmentNumber(basicProperty);
            reportParams.put(BILL_DATE, DateUtils.getDefaultFormattedDate((Date)egBill.getCreateDate()));
            reportParams.put(BILL_NUMBER, egBill.getBillNo());
        }
    }

    private ReportRequest generateOwnershipCertificate(BasicProperty basicProperty, Map<String, Object> reportParams, City city, String noticeNo) {
        this.prepareOwnershipCertificateParams(basicProperty, reportParams, city, noticeNo);
        String[] ownerName = basicProperty.getFullOwnerName().split(",");
        ReportRequest reportInput = ownerName.length > 1 ? new ReportRequest("OwnershipCertificate_MultipleOwner", reportParams, reportParams) : new ReportRequest("OwnershipCertificate_SingleOwner", reportParams, reportParams);
        return reportInput;
    }

    private void prepareOwnershipCertificateParams(BasicProperty basicProperty, Map<String, Object> reportParams, City city, String noticeNo) {
        PropertyAddress ownerAddress = basicProperty.getAddress();
        reportParams.put(DOOR_NO, org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ownerAddress.getHouseNoBldgApt()) ? ownerAddress.getHouseNoBldgApt() : "N/A");
        reportParams.put(OWNERSHIP_CERTIFICATE_NO, noticeNo);
        reportParams.put(OWNERSHIP_CERTIFICATE_DATE, DateUtils.getDefaultFormattedDate((Date)new Date()));
        reportParams.put(CONSUMER_ID, basicProperty.getUpicNo());
        reportParams.put(LOCALITY, ownerAddress.getAreaLocalitySector());
        reportParams.put(OWNER_NAME, basicProperty.getFullOwnerName());
        reportParams.put(ADDRESS, basicProperty.getAddress().toString());
        String cityGrade = city.getGrade();
        if (StringUtils.isNotEmpty((String)cityGrade) && cityGrade.equalsIgnoreCase("Corp")) {
            reportParams.put("cityGrade", "Municipal Corporation");
        } else {
            reportParams.put("cityGrade", "Municipality/NP");
        }
        StringBuilder ownerList = new StringBuilder(500);
        String[] ownerName = basicProperty.getFullOwnerName().split(",");
        if (ownerName.length > 1) {
            for (int i = 0; i < ownerName.length; ++i) {
                ownerList.append(i + 1 + "." + ownerName[i] + "\n");
            }
            reportParams.put("ownerNameList", ownerList.toString());
        } else {
            reportParams.put(OWNER_NAME, basicProperty.getFullOwnerName());
        }
        this.prepareDemandBillDetails(reportParams, basicProperty);
    }

    private Query getSearchQuery(NoticeRequest noticeRequest) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder query = new StringBuilder(500);
        query.append("select mv.propertyId from PropertyMaterlizeView mv where mv.propertyId is not null ");
        this.appendWard(noticeRequest, params, query);
        this.appendBlock(noticeRequest, params, query);
        this.appendPropertyType(noticeRequest, params, query);
        this.appendCategoryType(noticeRequest, params, query);
        this.appendPropertyId(noticeRequest, params, query);
        this.appendFinancialYear(noticeRequest, params, query);
        return this.getQuery(params, query);
    }

    private void appendFinancialYear(NoticeRequest noticeRequest, Map<String, Object> params, StringBuilder query) {
        CFinancialYear currFinYear = this.financialYearDAO.getFinancialYearByDate(new Date());
        query.append(" and mv.propertyId not in (select propertyId from RecoveryNoticesInfo where noticeType = :noticeType and createdDate between :startDate and :endDate )");
        params.put("noticeType", noticeRequest.getNoticeType());
        params.put("startDate", currFinYear.getStartingDate());
        params.put("endDate", currFinYear.getEndingDate());
    }

    private void appendPropertyId(NoticeRequest noticeRequest, Map<String, Object> params, StringBuilder query) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)noticeRequest.getPropertyId())) {
            query.append(" and mv.propertyId = :propertyId");
            params.put("propertyId", noticeRequest.getPropertyId());
        }
    }

    private void appendCategoryType(NoticeRequest noticeRequest, Map<String, Object> params, StringBuilder query) {
        if (noticeRequest.getCategoryType() != null && !"-1".equals(noticeRequest.getCategoryType())) {
            query.append(" and mv.categoryType = :categoryType");
            params.put("categoryType", noticeRequest.getCategoryType());
        }
    }

    private void appendPropertyType(NoticeRequest noticeRequest, Map<String, Object> params, StringBuilder query) {
        if (noticeRequest.getPropertyType() != null && !noticeRequest.getPropertyType().equals(-1L)) {
            query.append(" and mv.propTypeMstrID.id = :propertyType");
            params.put("propertyType", noticeRequest.getPropertyType());
        }
    }

    private void appendBlock(NoticeRequest noticeRequest, Map<String, Object> params, StringBuilder query) {
        if (noticeRequest.getBlock() != null && !noticeRequest.getBlock().equals(-1L)) {
            query.append(" and mv.block.id = :blockId");
            params.put("blockId", noticeRequest.getBlock());
        }
    }

    private void appendWard(NoticeRequest noticeRequest, Map<String, Object> params, StringBuilder query) {
        if (noticeRequest.getWard() != null && !noticeRequest.getWard().equals(-1L)) {
            query.append(" and mv.ward.id = :wardId");
            params.put("wardId", noticeRequest.getWard());
        }
    }

    private Query getQuery(Map<String, Object> params, StringBuilder query) {
        Query qry = this.entityManager.createQuery(query.toString());
        for (Map.Entry<String, Object> param : params.entrySet()) {
            qry.setParameter(param.getKey(), param.getValue());
        }
        return qry;
    }

    private ReportRequest generateValuationCertificate(BasicProperty basicProperty, Map<String, Object> reportParams, City city, String noticeNo) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        PropertyAddress ownerAddress = basicProperty.getAddress();
        reportParams.put(NOTICE_NUMBER, noticeNo);
        reportParams.put(REPORT_DATE, formatter.format(new Date()));
        reportParams.put(DOOR_NO, org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)ownerAddress.getHouseNoBldgApt()) ? ownerAddress.getHouseNoBldgApt() : "N/A");
        reportParams.put(UPIC_NO, basicProperty.getUpicNo());
        reportParams.put(LOCALITY, ownerAddress.getAreaLocalitySector());
        reportParams.put(ADDRESS, ownerAddress.toString());
        String cityGrade = city.getGrade();
        ReportRequest reportInput = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)cityGrade) && cityGrade.equalsIgnoreCase("Corp") ? new ReportRequest("ValuationCertificate_Corporation", reportParams, reportParams) : new ReportRequest("ValuationCertificate_Municipality", reportParams, reportParams);
        return reportInput;
    }

    private ReportRequest generateOccupierNotice(BasicProperty basicProperty, Map<String, Object> reportParams, City city, String noticeNo) {
        Date asOnDate = new Date();
        CFinancialYear currFinYear = this.financialYearDAO.getFinancialYearByDate(asOnDate);
        reportParams.put(DOOR_NO, basicProperty.getAddress().getHouseNoBldgApt() == null ? "N/A" : basicProperty.getAddress().getHouseNoBldgApt());
        reportParams.put(LOCATION, basicProperty.getAddress().getAreaLocalitySector() == null ? "N/A" : basicProperty.getAddress().getAreaLocalitySector().trim());
        reportParams.put(CITY_NAME, city.getPreferences().getMunicipalityName() == null ? "N/A" : city.getPreferences().getMunicipalityName());
        reportParams.put(FINANCIAL_YEAR, currFinYear.getFinYearRange());
        BigDecimal totalTaxDue = this.getTotalPropertyTaxDueIncludingPenalty(basicProperty);
        reportParams.put(TOTAL_TAX_DUE, String.valueOf(totalTaxDue));
        reportParams.put(REPORT_DATE, new SimpleDateFormat("dd/MM/yyyy").format(asOnDate));
        reportParams.put(NOTICE_NUMBER, noticeNo);
        reportParams.put(TAX_DUE_IN_WORDS, NumberUtil.amountInWords((BigDecimal)totalTaxDue));
        reportParams.put(CONSUMER_ID, basicProperty.getUpicNo());
        this.prepareDemandBillDetails(reportParams, basicProperty);
        String cityGrade = city.getGrade();
        ReportRequest reportInput = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)cityGrade) && cityGrade.equalsIgnoreCase("Corp") ? new ReportRequest(OCCUPIER_NOTICE_CORPORATION, reportParams, reportParams) : new ReportRequest(OCCUPIER_NOTICE_NAGAR_PANCHAYET, reportParams, reportParams);
        return reportInput;
    }

    public Map<String, Object> prepareDemandBillDetails(Map<String, Object> reportParams, BasicProperty basicProperty) {
        String value;
        AppConfigValues appConfigValues = this.appConfigValuesService.getAppConfigValueByDate("Property Tax", "IS_CLIENT_SPECIFIC_DEMANDBILL", new Date());
        String string = value = appConfigValues != null ? appConfigValues.getValue() : "";
        if ("Y".equalsIgnoreCase(value)) {
            DemandBillService demandBillService = (DemandBillService)this.beanProvider.getBean(DEMAND_BILL_SERVICE);
            reportParams.putAll(demandBillService.getDemandBillDetails(basicProperty));
        } else {
            EgBill egBill = this.getBillByAssessmentNumber(basicProperty);
            reportParams.put(BILL_DATE, DateUtils.getDefaultFormattedDate((Date)egBill.getCreateDate()));
            reportParams.put(BILL_NUMBER, egBill.getBillNo());
        }
        return reportParams;
    }
}

