/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.repository.master.mutationfee;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.egov.ptis.domain.model.MutationFeeDetails;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface MutationFeeRepository
extends JpaRepository<MutationFeeDetails, Long> {
    @Query(value="select max(highLimit) from MutationFeeDetails where toDate>now()")
    public BigDecimal maxByHighLimit();

    @Query(value="select lowLimit from MutationFeeDetails where highLimit is null and toDate > now()")
    public BigDecimal findLowLimitForHighLimitNullValue();

    @Query(value="select max(mfd.toDate) from MutationFeeDetails mfd where mfd.slabName=:slabName ")
    public Date findToDateBySlabName(@Param(value="slabName") String var1);

    @Query(value="select mfd1.slabName from MutationFeeDetails mfd1 where mfd1.slabName=:slabName")
    public List<String> findIfSlabNameExists(@Param(value="slabName") String var1);

    @Query(value="select max(mfd1.toDate) from MutationFeeDetails mfd1 where mfd1.slabName=:slabName")
    public Date findLatestToDateForSlabName(@Param(value="slabName") String var1);

    @Query(value="select distinct on(slab_name) * from egpt_mutation_fee_details order by slab_name ", nativeQuery=true)
    public List<MutationFeeDetails> getDistinctSlabNamesList();

    @Query(value="select md from MutationFeeDetails md where md.slabName=:slabName")
    public List<MutationFeeDetails> findBySlabNames(@Param(value="slabName") String var1);

    @Query(value="select mfd2 from MutationFeeDetails mfd2 where mfd2.id=:id")
    public MutationFeeDetails getAllDetailsById(@Param(value="id") Long var1);

    @Query(value="select mfd3 from MutationFeeDetails mfd3 order by mfd3.lowLimit asc")
    public List<MutationFeeDetails> selectAllOrderBySlabName();
}

