/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.entity.property;

import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.ptis.domain.entity.property.DocumentType;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="EGPT_APPLICATION_TYPE")
@SequenceGenerator(name="SEQ_EGPT_APPLICATION_TYPE", sequenceName="SEQ_EGPT_APPLICATION_TYPE", allocationSize=1)
@NamedQuery(name="BY_CODE", query="Select apt from PtApplicationType apt where apt.code=?")
public class PtApplicationType
extends AbstractAuditable {
    protected static final String SEQ_APPLICATION_TYPE = "SEQ_EGPT_APPLICATION_TYPE";
    private static final long serialVersionUID = 1L;
    public static final String BY_CODE = "BY_CODE";
    @Id
    @GeneratedValue(generator="SEQ_EGPT_APPLICATION_TYPE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @SafeHtml
    @Column(name="code", unique=true)
    private String code;
    @NotNull
    @SafeHtml
    @Column(name="name", unique=true)
    private String name;
    @NotNull
    @Column(name="resolutiontime")
    private Long resolutionTime;
    @SafeHtml
    private String description;
    @OneToMany(mappedBy="applicationType", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<DocumentType> documentTypes;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<DocumentType> getDocumentTypes() {
        return this.documentTypes;
    }

    public void setDocumentTypes(Set<DocumentType> documentTypes) {
        this.documentTypes = documentTypes;
    }

    public Long getResolutionTime() {
        return this.resolutionTime;
    }

    public void setResolutionTime(Long resolutionTime) {
        this.resolutionTime = resolutionTime;
    }
}

