/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.entity.property;

import java.math.BigDecimal;
import java.util.Date;
import org.egov.commons.Area;
import org.egov.demand.model.DepreciationMaster;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.Auditable;
import org.egov.infstr.models.BaseModel;
import org.egov.ptis.domain.entity.demand.FloorwiseDemandCalculations;
import org.egov.ptis.domain.entity.property.ConstructionTypeSet;
import org.egov.ptis.domain.entity.property.PropertyDetail;
import org.egov.ptis.domain.entity.property.PropertyOccupation;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.entity.property.PropertyUsage;
import org.egov.ptis.domain.entity.property.StructureClassification;

public class Floor
extends BaseModel
implements Auditable {
    private ConstructionTypeSet constructionTypeSet = null;
    private StructureClassification structureClassification = null;
    private PropertyUsage propertyUsage = null;
    private PropertyOccupation propertyOccupation = null;
    private DepreciationMaster depreciationMaster = null;
    private Integer floorNo = null;
    private Area builtUpArea = null;
    private Area floorArea = null;
    private String waterMeter = null;
    private String electricMeter = null;
    private PropertyTypeMaster unitType;
    private String unitTypeCategory;
    private BigDecimal rentPerMonth;
    private BigDecimal manualAlv;
    private BigDecimal alv;
    private String waterRate;
    private PropertyDetail propertyDetail;
    private Date occupancyDate;
    private String occupantName;
    private String firmName;
    private FloorwiseDemandCalculations floorDmdCalc;
    private Boolean unstructuredLand = false;
    private String buildingPermissionNo;
    private Date buildingPermissionDate;
    private Area buildingPlanPlinthArea;
    private Integer floorUid;
    private Date constructionDate;

    public Floor(ConstructionTypeSet constructionTypeSet, StructureClassification structureClassification, PropertyUsage propertyUsage, PropertyOccupation propertyOccupation, Integer floorNo, DepreciationMaster depreciationMaster, Area builtUpArea, Area floorArea, String waterMeter, String electricMeter, Date lastUpdatedTimeStamp, Date createdTimeStamp, BigDecimal rentPerMonth, BigDecimal manualAlv, PropertyTypeMaster unitType, String unitTypeCategory, String waterRate, BigDecimal alv, Date occupancyDate, String occupierName, Boolean unstructuredLand, FloorwiseDemandCalculations floorDmdCalc, String firmName, String buildingPermissionNo, Date buildingPermissionDate, Area buildingPlanPlinthArea, Integer floorUid, Date constructionDate) {
        this.constructionTypeSet = constructionTypeSet;
        this.structureClassification = structureClassification;
        this.propertyUsage = propertyUsage;
        this.propertyOccupation = propertyOccupation;
        this.floorNo = floorNo;
        this.depreciationMaster = depreciationMaster;
        this.builtUpArea = builtUpArea;
        this.floorArea = floorArea;
        this.waterMeter = waterMeter;
        this.electricMeter = electricMeter;
        this.rentPerMonth = rentPerMonth;
        this.manualAlv = manualAlv;
        this.unitType = unitType;
        this.unitTypeCategory = unitTypeCategory;
        this.waterRate = waterRate;
        this.alv = alv;
        this.occupancyDate = occupancyDate;
        this.occupantName = occupierName;
        this.unstructuredLand = unstructuredLand;
        this.floorDmdCalc = floorDmdCalc;
        this.firmName = firmName;
        this.buildingPermissionNo = buildingPermissionNo;
        this.buildingPermissionDate = buildingPermissionDate;
        this.buildingPlanPlinthArea = buildingPlanPlinthArea;
        this.floorUid = floorUid;
        this.constructionDate = constructionDate;
    }

    public Floor() {
    }

    public Floor(ConstructionTypeSet constructionTypeSet, StructureClassification structureClassification, PropertyUsage propertyUsage, PropertyOccupation propertyOccupation, Integer floorNo, DepreciationMaster depreciationMaster, Area builtUpArea, Area floorArea, String waterMeter, String electricMeter) {
        this.constructionTypeSet = constructionTypeSet;
        this.structureClassification = structureClassification;
        this.propertyUsage = propertyUsage;
        this.propertyOccupation = propertyOccupation;
        this.floorNo = floorNo;
        this.depreciationMaster = depreciationMaster;
        this.builtUpArea = builtUpArea;
        this.floorArea = floorArea;
        this.waterMeter = waterMeter;
        this.electricMeter = electricMeter;
    }

    public Area getBuiltUpArea() {
        return this.builtUpArea;
    }

    public void setBuiltUpArea(Area builtUpArea) {
        this.builtUpArea = builtUpArea;
    }

    public ConstructionTypeSet getConstructionTypeSet() {
        return this.constructionTypeSet;
    }

    public void setConstructionTypeSet(ConstructionTypeSet constructionTypeSet) {
        this.constructionTypeSet = constructionTypeSet;
    }

    public String getElectricMeter() {
        return this.electricMeter;
    }

    public void setElectricMeter(String electricMeter) {
        this.electricMeter = electricMeter;
    }

    public PropertyTypeMaster getUnitType() {
        return this.unitType;
    }

    public void setUnitType(PropertyTypeMaster unitType) {
        this.unitType = unitType;
    }

    public String getUnitTypeCategory() {
        return this.unitTypeCategory;
    }

    public void setUnitTypeCategory(String unitTypeCategory) {
        this.unitTypeCategory = unitTypeCategory;
    }

    public Area getFloorArea() {
        return this.floorArea;
    }

    public void setFloorArea(Area floorArea) {
        this.floorArea = floorArea;
    }

    public Integer getFloorNo() {
        return this.floorNo;
    }

    public void setFloorNo(Integer floorNo) {
        this.floorNo = floorNo;
    }

    public PropertyOccupation getPropertyOccupation() {
        return this.propertyOccupation;
    }

    public void setPropertyOccupation(PropertyOccupation propertyOccupation) {
        this.propertyOccupation = propertyOccupation;
    }

    public PropertyUsage getPropertyUsage() {
        return this.propertyUsage;
    }

    public void setPropertyUsage(PropertyUsage propertyUsage) {
        this.propertyUsage = propertyUsage;
    }

    public StructureClassification getStructureClassification() {
        return this.structureClassification;
    }

    public void setStructureClassification(StructureClassification structureClassification) {
        this.structureClassification = structureClassification;
    }

    public String getWaterMeter() {
        return this.waterMeter;
    }

    public void setWaterMeter(String waterMeter) {
        this.waterMeter = waterMeter;
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        if (that.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        Floor thatFlrImpl = (Floor)((Object)that);
        if (this.getId() != null && thatFlrImpl.getId() != null) {
            return this.getId().equals(thatFlrImpl.getId());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.getId() != null) {
            hashCode += this.getId().hashCode();
        }
        return hashCode;
    }

    public boolean validateFloor() {
        if (this.getFloorNo() == null) {
            throw new ApplicationRuntimeException("In Floor Validate : FloorNumber is Not Set, Please Check !!");
        }
        return true;
    }

    public BigDecimal getRentPerMonth() {
        return this.rentPerMonth;
    }

    public void setRentPerMonth(BigDecimal rentPerMonth) {
        this.rentPerMonth = rentPerMonth;
    }

    public DepreciationMaster getDepreciationMaster() {
        return this.depreciationMaster;
    }

    public void setDepreciationMaster(DepreciationMaster depreciationMaster) {
        this.depreciationMaster = depreciationMaster;
    }

    public BigDecimal getManualAlv() {
        return this.manualAlv;
    }

    public void setManualAlv(BigDecimal manualAlv) {
        this.manualAlv = manualAlv;
    }

    public String getWaterRate() {
        return this.waterRate;
    }

    public void setWaterRate(String waterRate) {
        this.waterRate = waterRate;
    }

    public BigDecimal getAlv() {
        return this.alv;
    }

    public void setAlv(BigDecimal alv) {
        this.alv = alv;
    }

    public Date getOccupancyDate() {
        return this.occupancyDate;
    }

    public void setOccupancyDate(Date occupancyDate) {
        this.occupancyDate = occupancyDate;
    }

    public String getOccupantName() {
        return this.occupantName;
    }

    public void setOccupantName(String occupantName) {
        this.occupantName = occupantName;
    }

    public String toString() {
        return new StringBuilder(256).append("Floor [Id: ").append(this.getId()).append(", FloorNo=").append(this.getFloorNo()).append(", FloorArea=").append(this.getFloorArea() != null ? this.getFloorArea().getArea() : "null").append(", PropertyUsage=").append((Object)this.getPropertyUsage()).append(", StructCl=").append((Object)this.getStructureClassification()).append(", Occupancy=").append((Object)this.getPropertyOccupation()).append(", Depreciation=").append(this.getDepreciationMaster()).append(", WaterRate=").append(this.getWaterRate()).append(", alv=").append(this.getAlv()).append("]").toString();
    }

    public PropertyDetail getPropertyDetail() {
        return this.propertyDetail;
    }

    public void setPropertyDetail(PropertyDetail propertyDetail) {
        this.propertyDetail = propertyDetail;
    }

    public FloorwiseDemandCalculations getFloorDmdCalc() {
        return this.floorDmdCalc;
    }

    public void setFloorDmdCalc(FloorwiseDemandCalculations floorDmdCalc) {
        this.floorDmdCalc = floorDmdCalc;
    }

    public String getFirmName() {
        return this.firmName;
    }

    public void setFirmName(String firmName) {
        this.firmName = firmName;
    }

    public Boolean getUnstructuredLand() {
        return this.unstructuredLand;
    }

    public void setUnstructuredLand(Boolean unstructuredLand) {
        this.unstructuredLand = unstructuredLand;
    }

    public String getBuildingPermissionNo() {
        return this.buildingPermissionNo;
    }

    public void setBuildingPermissionNo(String buildingPermissionNo) {
        this.buildingPermissionNo = buildingPermissionNo;
    }

    public Date getBuildingPermissionDate() {
        return this.buildingPermissionDate;
    }

    public void setBuildingPermissionDate(Date buildingPermissionDate) {
        this.buildingPermissionDate = buildingPermissionDate;
    }

    public Area getBuildingPlanPlinthArea() {
        return this.buildingPlanPlinthArea;
    }

    public void setBuildingPlanPlinthArea(Area buildingPlanPlinthArea) {
        this.buildingPlanPlinthArea = buildingPlanPlinthArea;
    }

    public Integer getFloorUid() {
        return this.floorUid;
    }

    public void setFloorUid(Integer floorUid) {
        this.floorUid = floorUid;
    }

    public Date getConstructionDate() {
        return this.constructionDate;
    }

    public void setConstructionDate(Date constructionDate) {
        this.constructionDate = constructionDate;
    }
}

