/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.client.util;

import java.util.Comparator;
import org.egov.ptis.domain.model.calculator.UnitTaxCalculationInfo;

public enum UnitTaxInfoComparator implements Comparator<UnitTaxCalculationInfo>
{
    UNIT_SORT{

        @Override
        public int compare(UnitTaxCalculationInfo o1, UnitTaxCalculationInfo o2) {
            return o1.getFloorNumber().compareTo(o2.getFloorNumber());
        }
    }
    ,
    FLOOR_SORT{

        @Override
        public int compare(UnitTaxCalculationInfo o1, UnitTaxCalculationInfo o2) {
            return o1.getFloorNumber().compareTo(o2.getFloorNumber());
        }
    }
    ,
    INST_SORT{

        @Override
        public int compare(UnitTaxCalculationInfo o1, UnitTaxCalculationInfo o2) {
            return o1.getOccpancyDate().compareTo(o2.getOccpancyDate());
        }
    };


    public static Comparator<UnitTaxCalculationInfo> getUnitComparator(final UnitTaxInfoComparator ... multipleOptions) {
        return new Comparator<UnitTaxCalculationInfo>(){

            @Override
            public int compare(UnitTaxCalculationInfo o1, UnitTaxCalculationInfo o2) {
                for (UnitTaxInfoComparator option : multipleOptions) {
                    int result = option.compare(o1, o2);
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            }
        };
    }
}

