/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.entity.objection;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.validation.Valid;
import org.egov.commons.EgwStatus;
import org.egov.infra.persistence.entity.Auditable;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.objection.Hearing;
import org.egov.ptis.domain.entity.objection.Inspection;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Document;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.hibernate.validator.constraints.Length;

public class RevisionPetition
extends StateAware
implements Auditable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private EgwStatus egwStatus;
    private BasicProperty basicProperty;
    @Length(max=50, message="objection.objectionNumber.length")
    private String objectionNumber;
    private Date recievedOn;
    @Length(max=256, message="objection.objectionNumber.length")
    private String recievedBy;
    private String details;
    private String docNumberObjection;
    private String docNumberOutcome;
    private PropertyImpl property;
    @Valid
    private List<Hearing> hearings = new LinkedList<Hearing>();
    @Valid
    private List<Inspection> inspections = new LinkedList<Inspection>();
    private Date dateOfOutcome;
    private String remarks;
    private Boolean objectionRejected;
    private Boolean generateSpecialNotice;
    private String meesevaApplicationNumber;
    private String applicationNo;
    public static final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy", Locale.ENGLISH);
    private List<Document> documents = new ArrayList<Document>();
    private String type;
    private String source;

    public String getStateDetails() {
        StringBuilder stateDetails = new StringBuilder("");
        stateDetails.append(this.getBasicProperty().getUpicNo()).append(", ").append(this.getBasicProperty().getPrimaryOwner().getName()).append(", ").append(PropertyTaxConstants.PROPERTY_TYPE_CATEGORIES.get(this.getBasicProperty().getProperty().getPropertyDetail().getCategoryType())).append(", ").append(this.getBasicProperty().getPropertyID().getLocality().getName());
        return stateDetails.toString();
    }

    public EgwStatus getEgwStatus() {
        return this.egwStatus;
    }

    public String getObjectionNumber() {
        return this.objectionNumber;
    }

    @Required(message="objection.receiviedOn.null")
    public Date getRecievedOn() {
        return this.recievedOn;
    }

    @Required(message="objection.receiviedBy.null")
    public String getRecievedBy() {
        return this.recievedBy;
    }

    @Required(message="objection.details.null")
    @Length(max=1024, message="objection.details.length")
    public String getDetails() {
        return this.details;
    }

    public void setEgwStatus(EgwStatus egwStatus) {
        this.egwStatus = egwStatus;
    }

    public void setObjectionNumber(String objectionNumber) {
        this.objectionNumber = objectionNumber;
    }

    public void setRecievedOn(Date recievedOn) {
        this.recievedOn = recievedOn;
    }

    public void setRecievedBy(String recievedBy) {
        this.recievedBy = recievedBy;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public List<Hearing> getHearings() {
        return this.hearings;
    }

    public void setHearings(List<Hearing> hearings) {
        this.hearings = hearings;
    }

    public List<Inspection> getInspections() {
        return this.inspections;
    }

    public Date getDateOfOutcome() {
        return this.dateOfOutcome;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public Boolean getObjectionRejected() {
        return this.objectionRejected;
    }

    public void setInspections(List<Inspection> inspections) {
        this.inspections = inspections;
    }

    public void setDateOfOutcome(Date dateOfOutcome) {
        this.dateOfOutcome = dateOfOutcome;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public void setObjectionRejected(Boolean objectionRejected) {
        this.objectionRejected = objectionRejected;
    }

    public BasicProperty getBasicProperty() {
        return this.basicProperty;
    }

    public void setBasicProperty(BasicProperty basicProperty) {
        this.basicProperty = basicProperty;
    }

    public String getDocNumberObjection() {
        return this.docNumberObjection;
    }

    public String getDocNumberOutcome() {
        return this.docNumberOutcome;
    }

    public void setDocNumberObjection(String docNumberObjection) {
        this.docNumberObjection = docNumberObjection;
    }

    public void setDocNumberOutcome(String docNumberOutcome) {
        this.docNumberOutcome = docNumberOutcome;
    }

    public String getFmtdReceivedOn() {
        if (this.recievedOn != null) {
            return dateFormat.format(this.recievedOn);
        }
        return "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UcipNo :").append(null != this.basicProperty ? this.basicProperty.getUpicNo() : " ");
        sb.append("status :").append(null != this.egwStatus ? this.egwStatus.getDescription() : " ");
        sb.append("objectionNumber :").append(null != this.objectionNumber ? this.objectionNumber : " ");
        return sb.toString();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PropertyImpl getProperty() {
        return this.property;
    }

    public void setProperty(PropertyImpl property) {
        this.property = property;
    }

    public Boolean getGenerateSpecialNotice() {
        return this.generateSpecialNotice;
    }

    public void setGenerateSpecialNotice(Boolean generateSpecialNotice) {
        this.generateSpecialNotice = generateSpecialNotice;
    }

    public String getMeesevaApplicationNumber() {
        return this.meesevaApplicationNumber;
    }

    public void setMeesevaApplicationNumber(String meesevaApplicationNumber) {
        this.meesevaApplicationNumber = meesevaApplicationNumber;
    }

    public String getApplicationNo() {
        return this.applicationNo;
    }

    public void setApplicationNo(String applicationNo) {
        this.applicationNo = applicationNo;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}

