/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.entity.demand;

import java.math.BigDecimal;
import java.util.Date;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.ptis.domain.entity.demand.PTDemandCalculations;
import org.egov.ptis.domain.entity.property.Floor;

public class FloorwiseDemandCalculations {
    private Integer id = null;
    private Floor floor = null;
    private PTDemandCalculations pTDemandCalculations = null;
    private Date lastUpdatedTimeStamp;
    private Date createTimeStamp;
    private BigDecimal categoryAmt;
    private BigDecimal occupancyRebate;
    private BigDecimal constructionRebate;
    private BigDecimal depreciation;
    private BigDecimal usageRebate;
    private BigDecimal tax1 = BigDecimal.ZERO;
    private BigDecimal tax2 = BigDecimal.ZERO;
    private BigDecimal tax3 = BigDecimal.ZERO;
    private BigDecimal tax4 = BigDecimal.ZERO;
    private BigDecimal tax5 = BigDecimal.ZERO;
    private BigDecimal tax6 = BigDecimal.ZERO;
    private BigDecimal tax7 = BigDecimal.ZERO;
    private BigDecimal tax8 = BigDecimal.ZERO;
    private BigDecimal tax9 = BigDecimal.ZERO;
    private BigDecimal tax10 = BigDecimal.ZERO;
    private BigDecimal alv;
    private BigDecimal mrv;
    private BigDecimal totalTaxPayble;

    public FloorwiseDemandCalculations() {
    }

    public FloorwiseDemandCalculations(Integer id, Floor floor, PTDemandCalculations demandCalculations, Date lastUpdatedTimeStamp, Date createTimeStamp, BigDecimal categoryAmt, BigDecimal occupancyRebate, BigDecimal constructionRebate, BigDecimal depreciation, BigDecimal usageRebate) {
        this.id = id;
        this.floor = floor;
        this.pTDemandCalculations = demandCalculations;
        this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
        this.createTimeStamp = createTimeStamp;
        this.categoryAmt = categoryAmt;
        this.occupancyRebate = occupancyRebate;
        this.constructionRebate = constructionRebate;
        this.depreciation = depreciation;
        this.usageRebate = usageRebate;
    }

    public FloorwiseDemandCalculations(FloorwiseDemandCalculations thatFloorDmdCalc) {
        this.floor = thatFloorDmdCalc.floor;
        this.lastUpdatedTimeStamp = new Date();
        this.createTimeStamp = new Date();
        this.categoryAmt = thatFloorDmdCalc.categoryAmt;
        this.occupancyRebate = thatFloorDmdCalc.occupancyRebate;
        this.constructionRebate = thatFloorDmdCalc.constructionRebate;
        this.depreciation = thatFloorDmdCalc.depreciation;
        this.usageRebate = thatFloorDmdCalc.usageRebate;
        this.tax1 = thatFloorDmdCalc.getTax1();
        this.tax2 = thatFloorDmdCalc.getTax2();
        this.tax3 = thatFloorDmdCalc.getTax3();
        this.tax4 = thatFloorDmdCalc.getTax4();
        this.tax5 = thatFloorDmdCalc.getTax5();
        this.tax6 = thatFloorDmdCalc.getTax6();
        this.tax7 = thatFloorDmdCalc.getTax7();
        this.tax8 = thatFloorDmdCalc.getTax8();
        this.tax9 = thatFloorDmdCalc.getTax9();
        this.tax10 = thatFloorDmdCalc.getTax10();
        this.alv = thatFloorDmdCalc.getAlv();
        this.mrv = thatFloorDmdCalc.getMrv();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Floor getFloor() {
        return this.floor;
    }

    public void setFloor(Floor floor) {
        this.floor = floor;
    }

    public PTDemandCalculations getPTDemandCalculations() {
        return this.pTDemandCalculations;
    }

    public void setPTDemandCalculations(PTDemandCalculations demandCalculations) {
        this.pTDemandCalculations = demandCalculations;
    }

    public Date getLastUpdatedTimeStamp() {
        return this.lastUpdatedTimeStamp;
    }

    public void setLastUpdatedTimeStamp(Date lastUpdatedTimeStamp) {
        this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
    }

    public Date getCreateTimeStamp() {
        return this.createTimeStamp;
    }

    public void setCreateTimeStamp(Date createTimeStamp) {
        this.createTimeStamp = createTimeStamp;
    }

    public BigDecimal getCategoryAmt() {
        return this.categoryAmt;
    }

    public void setCategoryAmt(BigDecimal categoryAmt) {
        this.categoryAmt = categoryAmt;
    }

    public BigDecimal getOccupancyRebate() {
        return this.occupancyRebate;
    }

    public void setOccupancyRebate(BigDecimal occupancyRebate) {
        this.occupancyRebate = occupancyRebate;
    }

    public BigDecimal getConstructionRebate() {
        return this.constructionRebate;
    }

    public void setConstructionRebate(BigDecimal constructionRebate) {
        this.constructionRebate = constructionRebate;
    }

    public BigDecimal getDepreciation() {
        return this.depreciation;
    }

    public void setDepreciation(BigDecimal depreciation) {
        this.depreciation = depreciation;
    }

    public BigDecimal getUsageRebate() {
        return this.usageRebate;
    }

    public void setUsageRebate(BigDecimal usageRebate) {
        this.usageRebate = usageRebate;
    }

    public BigDecimal getTax1() {
        return this.tax1;
    }

    public void setTax1(BigDecimal tax1) {
        this.tax1 = tax1;
    }

    public BigDecimal getTax2() {
        return this.tax2;
    }

    public void setTax2(BigDecimal tax2) {
        this.tax2 = tax2;
    }

    public BigDecimal getTax3() {
        return this.tax3;
    }

    public void setTax3(BigDecimal tax3) {
        this.tax3 = tax3;
    }

    public BigDecimal getTax4() {
        return this.tax4;
    }

    public void setTax4(BigDecimal tax4) {
        this.tax4 = tax4;
    }

    public BigDecimal getTax5() {
        return this.tax5;
    }

    public void setTax5(BigDecimal tax5) {
        this.tax5 = tax5;
    }

    public BigDecimal getTax6() {
        return this.tax6;
    }

    public void setTax6(BigDecimal tax6) {
        this.tax6 = tax6;
    }

    public BigDecimal getTax7() {
        return this.tax7;
    }

    public void setTax7(BigDecimal tax7) {
        this.tax7 = tax7;
    }

    public BigDecimal getTax8() {
        return this.tax8;
    }

    public void setTax8(BigDecimal tax8) {
        this.tax8 = tax8;
    }

    public BigDecimal getTax9() {
        return this.tax9;
    }

    public void setTax9(BigDecimal tax9) {
        this.tax9 = tax9;
    }

    public BigDecimal getTax10() {
        return this.tax10;
    }

    public void setTax10(BigDecimal tax10) {
        this.tax10 = tax10;
    }

    public BigDecimal getAlv() {
        return this.alv;
    }

    public void setAlv(BigDecimal alv) {
        this.alv = alv;
    }

    public BigDecimal getMrv() {
        return this.mrv;
    }

    public void setMrv(BigDecimal mrv) {
        this.mrv = mrv;
    }

    public BigDecimal getTotalTaxPayble() {
        return this.totalTaxPayble;
    }

    public void setTotalTaxPayble(BigDecimal totalTaxPayble) {
        this.totalTaxPayble = totalTaxPayble;
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        if (that.getClass() != this.getClass()) {
            return false;
        }
        FloorwiseDemandCalculations thatFlWsDemand = (FloorwiseDemandCalculations)that;
        if (this.getId() != null && thatFlWsDemand.getId() != null) {
            return this.getId().equals(thatFlWsDemand.getId());
        }
        if (this.getFloor() != null && thatFlWsDemand.getFloor() != null) {
            return this.getFloor().equals((Object)thatFlWsDemand.getFloor());
        }
        if (this.getPTDemandCalculations() != null && thatFlWsDemand.getPTDemandCalculations() != null) {
            return this.getPTDemandCalculations().equals((Object)thatFlWsDemand.getPTDemandCalculations());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.getId() != null) {
            hashCode += this.getId().hashCode();
        }
        if (this.getFloor() != null) {
            hashCode += this.getFloor().hashCode();
        }
        return hashCode;
    }

    public boolean validate() {
        if (this.getFloor() == null) {
            throw new ApplicationRuntimeException("In  Validate : Property is Not Set, Please Check !!");
        }
        if (this.getPTDemandCalculations() == null) {
            throw new ApplicationRuntimeException("In  Validate : PTDemandCalculations is Not Set, Please Check !!");
        }
        return true;
    }

    public String toString() {
        StringBuilder objStr = new StringBuilder();
        objStr.append("Id: ").append(this.getId()).append("|OccupRebate: ").append(this.getOccupancyRebate()).append("|ConstrucRebate : ").append(this.getConstructionRebate()).append("|Depreciation: ").append(this.getDepreciation()).append("|UsageRebate: ").append(this.getUsageRebate());
        return objStr.toString();
    }
}

