/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.dao.property;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.ptis.domain.dao.property.PropertyTypeMasterDAO;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="propertyTypeMasterDAO")
@Transactional(readOnly=true)
public class PropertyTypeMasterHibernateDAO
implements PropertyTypeMasterDAO {
    @PersistenceContext
    private EntityManager entityManager;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public PropertyTypeMaster getPropertyTypeMasterByName(String type) {
        Query qry = this.getCurrentSession().createQuery("from PropertyTypeMaster P where P.type =:type ");
        qry.setString("type", type);
        return (PropertyTypeMaster)((Object)qry.uniqueResult());
    }

    @Override
    public PropertyTypeMaster getPropertyTypeMasterByCode(String code) {
        Query qry = this.getCurrentSession().createQuery("from PropertyTypeMaster P where P.code =:Code ");
        qry.setString("Code", code);
        return (PropertyTypeMaster)((Object)qry.uniqueResult());
    }

    @Override
    public PropertyTypeMaster findById(Integer id, boolean lock) {
        Query qry = this.getCurrentSession().createQuery("from PropertyTypeMaster P where P.id =:id ");
        qry.setInteger("id", id.intValue());
        return (PropertyTypeMaster)((Object)qry.uniqueResult());
    }

    @Override
    public List<PropertyTypeMaster> findAll() {
        return this.getCurrentSession().createQuery("from PropertyTypeMaster").list();
    }

    @Override
    public List<PropertyTypeMaster> findAllExcludeEWSHS() {
        return this.getCurrentSession().createQuery("from PropertyTypeMaster where type != 'EWSHS' ").list();
    }

    @Override
    public List<PropertyTypeMaster> findBuiltUpOwnerShipTypes() {
        return this.getCurrentSession().createQuery("from PropertyTypeMaster where code not in ('EWSHS','VAC_LAND') ").list();
    }

    @Override
    public PropertyTypeMaster create(PropertyTypeMaster propertyTypeMaster) {
        return null;
    }

    @Override
    public void delete(PropertyTypeMaster propertyTypeMaster) {
    }

    @Override
    public PropertyTypeMaster update(PropertyTypeMaster propertyTypeMaster) {
        return null;
    }
}

