/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.client.workflow;

import java.util.List;
import org.apache.log4j.Logger;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.client.workflow.StepApprove;
import org.egov.ptis.client.workflow.StepForward;
import org.egov.ptis.client.workflow.StepReject;
import org.egov.ptis.client.workflow.StepSave;
import org.egov.ptis.client.workflow.WorkflowActionStep;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.WorkflowBean;

public abstract class WorkflowDetails {
    private static final Logger LOGGER = Logger.getLogger(WorkflowDetails.class);
    protected WorkflowActionStep workflowActionStep;
    private PropertyImpl propertyModel;
    private WorkflowBean workflowBean;
    private Long loggedInUserId;

    public WorkflowDetails() {
    }

    public WorkflowDetails(PropertyImpl propertyModel, WorkflowBean workflowBean, Long loggedInUserId) {
        this.propertyModel = propertyModel;
        this.workflowBean = workflowBean;
        this.loggedInUserId = loggedInUserId;
    }

    public abstract String getActionName();

    public abstract String getStateValue();

    public void setWorkflowActionStep(PropertyTaxUtil propertyTaxUtil, EisCommonService eisCommonService) {
        LOGGER.debug((Object)"Entered into setWorkflowActionStep");
        String[] beanActionName = null;
        String actionStep = null;
        String comments = null;
        if (this.workflowBean == null) {
            LOGGER.debug((Object)"setWorkflowActionStep - workflowBean is NULL");
        } else {
            beanActionName = this.workflowBean.getActionName().split(":");
            if (beanActionName.length > 1) {
                actionStep = beanActionName[1];
            }
            comments = this.workflowBean.getComments();
        }
        LOGGER.debug((Object)("setWorkflowActionStep - actionStep=" + actionStep));
        Long nextStateUserId = this.getNextStateUserId(this.propertyModel, this.workflowBean);
        if (nextStateUserId == null) {
            LOGGER.debug((Object)"setWorkflowActionStep - nextStateUserId is NULL");
        } else {
            if ("Approve".equalsIgnoreCase(actionStep)) {
                this.workflowActionStep = new StepApprove(this.propertyModel, nextStateUserId, comments);
            } else if ("Save".equalsIgnoreCase(actionStep)) {
                this.workflowActionStep = new StepSave(this.propertyModel, nextStateUserId, comments);
            } else if ("Forward".equalsIgnoreCase(actionStep)) {
                this.workflowActionStep = new StepForward(this.propertyModel, nextStateUserId, comments);
            } else if ("Reject".equalsIgnoreCase(actionStep)) {
                this.workflowActionStep = new StepReject(this.propertyModel, nextStateUserId, comments);
            }
            this.workflowActionStep.setActionName(beanActionName[0] + ":");
            this.workflowActionStep.setPropertyTaxUtil(propertyTaxUtil);
            this.workflowActionStep.setEisCommonService(eisCommonService);
        }
        LOGGER.debug((Object)"Exiting from setWorkflowActionStep");
    }

    private Long getNextStateUserId(PropertyImpl propertyModel, WorkflowBean workflowBean) {
        LOGGER.debug((Object)("Entered into getNextStateUserId, propertyModel=" + propertyModel));
        if (workflowBean == null) {
            LOGGER.debug((Object)"getNextStateUserId - workflowBean is NULL");
        } else {
            LOGGER.debug((Object)("getNextStateUserId - workflowBean.getActionName=" + workflowBean.getActionName()));
        }
        String step = workflowBean.getActionName().split(":")[1];
        String action = workflowBean.getActionName().split(":")[0];
        Property oldProperty = PropertyTaxUtil.getLatestProperty(propertyModel.getBasicProperty(), PropertyTaxConstants.STATUS_ISHISTORY);
        LOGGER.debug((Object)("getNextStateUserId - workflow step=" + step));
        User workflowInitiater = this.getWorkflowInitiator(propertyModel);
        Long nextUserId = null;
        if ("Mutation".equalsIgnoreCase(action) && "Approve".equalsIgnoreCase(step)) {
            nextUserId = this.loggedInUserId;
        } else if ("Approve".equalsIgnoreCase(step) || "Reject".equalsIgnoreCase(step)) {
            nextUserId = workflowInitiater == null ? this.loggedInUserId : (long)Integer.valueOf(workflowInitiater.getId().intValue()).intValue();
        } else if ("Forward".equalsIgnoreCase(step)) {
            nextUserId = this.isApproverUserIdAvail() ? Long.valueOf(workflowBean.getApproverUserId()) : null;
        } else if ("Save".equalsIgnoreCase(step)) {
            nextUserId = this.loggedInUserId;
        }
        LOGGER.debug((Object)("getNextStateUserId - nextUserId=" + nextUserId));
        LOGGER.debug((Object)"Exiting from getNextStateUserId");
        return nextUserId;
    }

    public User getWorkflowInitiator(StateAware stateAware) {
        User wfInitiatorUser = null;
        List states = stateAware.getStateHistory();
        if (states.size() >= 2) {
            for (StateHistory state : states) {
                if (!state.getValue().equalsIgnoreCase("New")) continue;
                wfInitiatorUser = state.getOwnerUser();
            }
        }
        return wfInitiatorUser;
    }

    public boolean isApproveOrSave() {
        return "Approve".equalsIgnoreCase(this.getWorkflowActionStep().getStepName()) || "Save".equals(this.getWorkflowActionStep().getStepName());
    }

    public boolean isStepRejectAndOwnerNextPositionSame() {
        return this.getWorkflowActionStep().getStepName().equalsIgnoreCase("Reject") && this.propertyModel.getState().getOwnerPosition().equals((Object)this.getWorkflowActionStep().getPosition());
    }

    private boolean isApproverUserIdAvail() {
        return this.workflowBean.getApproverUserId() != null && !this.workflowBean.getApproverUserId().equals(new Integer(-1));
    }

    public void changeState() {
        this.workflowActionStep.changeState();
    }

    public boolean isNoWorkflow() {
        return this.propertyModel.getState() == null;
    }

    public boolean isNoticeGenerated() {
        return "Notice Generated".equalsIgnoreCase(this.workflowBean.getActionName().split(":")[1]);
    }

    public WorkflowActionStep getWorkflowActionStep() {
        return this.workflowActionStep;
    }

    public void setWorkflowActionStep(WorkflowActionStep workflowActionStep) {
        this.workflowActionStep = workflowActionStep;
    }

    public PropertyImpl getPropertyModel() {
        return this.propertyModel;
    }

    public void setPropertyModel(PropertyImpl propertyModel) {
        this.propertyModel = propertyModel;
    }
}

