/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.bill;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.egov.builder.entities.BoundaryBuilder;
import org.egov.builder.entities.ModuleBuilder;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.commons.entity.InstallmentBuilder;
import org.egov.demand.model.EgDemand;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.ptis.builder.entity.property.BasicPropertyBuilder;
import org.egov.ptis.client.model.PenaltyAndRebate;
import org.egov.ptis.client.service.PenaltyCalculationService;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.bill.PropertyTaxBillable;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.service.property.RebateService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class PropertyTaxBillableTest {
    @Mock
    private PenaltyCalculationService penaltyCalculationService;
    @Mock
    private PtDemandDao ptDemandDAO;
    @Mock
    private InstallmentDao installmentDao;
    @Mock
    private ModuleService moduleDao;
    @Mock
    private PropertyTaxUtil propertyTaxUtil;
    @Mock
    private RebateService rebateService;
    private PropertyTaxBillable billable = new PropertyTaxBillable();
    private Boundary locality;
    private Module module;
    private Installment currentInstallment;
    private Property property;
    private BasicProperty basicProperty;
    private Map<Installment, PenaltyAndRebate> installmentPenaltyAndRebate = new TreeMap<Installment, PenaltyAndRebate>();
    private Map<String, Map<Installment, BigDecimal>> installmentDemandAndCollection = new TreeMap<String, Map<Installment, BigDecimal>>();
    private Ptdemand egDemand = new Ptdemand();
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private Calendar fromDate;
    private Calendar toDate;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
        MockitoAnnotations.initMocks((Object)this);
        this.initMasters();
    }

    private void initMasters() {
        this.locality = new BoundaryBuilder().withDefaults().build();
        this.module = new ModuleBuilder().withName("Property Tax").build();
        this.currentInstallment = new InstallmentBuilder().withCurrentHalfPeriod(this.module).build();
    }

    private void initServicesForPTBillable() {
        this.billable.setLevyPenalty(Boolean.valueOf(true));
        this.billable.setBasicProperty(this.basicProperty);
        this.billable.setPtDemandDAO(this.ptDemandDAO);
        this.billable.setPenaltyCalculationService(this.penaltyCalculationService);
        this.billable.setModuleDao(this.moduleDao);
        this.billable.setPropertyTaxUtil(this.propertyTaxUtil);
        this.billable.setRebateService(this.rebateService);
    }

    private void initBasicProperty(String assessmentEffectiveDate) {
        this.basicProperty = new BasicPropertyBuilder().withDefaults().build();
        this.property = this.basicProperty.getProperty();
        try {
            Date date = this.dateFormat.parse(assessmentEffectiveDate);
            this.basicProperty.setAssessmentdate(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void initDataForCurInstallment() {
        TreeMap<Installment, BigDecimal> temp = new TreeMap<Installment, BigDecimal>();
        temp.put(this.currentInstallment, new BigDecimal(2000));
        this.installmentDemandAndCollection.put("DEMAND", temp);
        temp = new TreeMap();
        temp.put(this.currentInstallment, new BigDecimal(0));
        this.installmentDemandAndCollection.put("COLLECTION", temp);
    }

    public void setInstallmentDates(int today_minus_year) {
        this.fromDate = Calendar.getInstance();
        this.toDate = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        now.add(1, -today_minus_year);
        int month = now.get(2) + 1;
        int year = now.get(1);
        if (month >= 4 && month <= 9) {
            this.fromDate.set(5, 1);
            this.fromDate.set(2, 3);
            this.fromDate.set(1, year);
            this.toDate.set(5, 30);
            this.toDate.set(2, 8);
            this.toDate.set(1, year);
        } else {
            this.fromDate.set(5, 1);
            this.fromDate.set(2, 9);
            this.fromDate.set(1, year - 1);
            this.toDate.set(5, 31);
            this.toDate.set(2, 2);
            this.toDate.set(1, year);
        }
    }

    @Test
    public void calculatePenalty_noPenalty() {
        this.initBasicProperty(this.dateFormat.format(new Date()));
        this.initServicesForPTBillable();
        this.initDataForCurInstallment();
    }

    @Test
    public void calculatePenalty_for2Months() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, -4);
        Date assessmentDate = cal.getTime();
        this.initBasicProperty(this.dateFormat.format(assessmentDate));
        this.initServicesForPTBillable();
        this.initDataForCurInstallment();
        this.egDemand.setEgInstallmentMaster(this.currentInstallment);
        Mockito.when((Object)this.ptDemandDAO.getNonHistoryCurrDmdForProperty((Property)Matchers.any())).thenReturn((Object)this.egDemand);
        Mockito.when((Object)this.penaltyCalculationService.getInstallmentDemandAndCollection((BasicProperty)Matchers.any(), (EgDemand)Matchers.any())).thenReturn(this.installmentDemandAndCollection);
        Mockito.when((Object)this.installmentDao.getInsatllmentByModuleForGivenDate((Module)Matchers.any(), (Date)Matchers.any())).thenReturn((Object)this.currentInstallment);
        Mockito.when((Object)this.rebateService.isEarlyPayRebateActive()).thenReturn((Object)false);
        this.installmentPenaltyAndRebate = this.billable.getCalculatedPenalty();
        if (this.installmentPenaltyAndRebate != null && !this.installmentPenaltyAndRebate.isEmpty()) {
            Assert.assertEquals((Object)this.installmentPenaltyAndRebate.get(this.currentInstallment).getPenalty(), (Object)new BigDecimal(80));
        }
    }

    @Test
    public void calculatePenalty_acrossInstallments() {
        this.setInstallmentDates(1);
        this.initBasicProperty(this.dateFormat.format(this.fromDate.getTime()));
        this.initServicesForPTBillable();
        TreeMap<Installment, BigDecimal> demandMap = new TreeMap<Installment, BigDecimal>();
        TreeMap<Installment, BigDecimal> collectionMap = new TreeMap<Installment, BigDecimal>();
        Installment arrearInstallment = new InstallmentBuilder().withModule(this.module).withFromDate(this.fromDate.getTime()).withToDate(this.toDate.getTime()).build();
        Mockito.when((Object)this.installmentDao.getInsatllmentByModuleForGivenDate((Module)Matchers.any(), (Date)Matchers.any())).thenReturn((Object)arrearInstallment);
        demandMap.put(arrearInstallment, new BigDecimal(3074));
        collectionMap.put(arrearInstallment, new BigDecimal(0));
        this.fromDate = Calendar.getInstance();
        this.fromDate.setTime(this.toDate.getTime());
        this.fromDate.add(2, 1);
        this.fromDate.set(5, 1);
        arrearInstallment = new InstallmentBuilder().withModule(this.module).withFromDate(this.fromDate.getTime()).build();
        demandMap.put(arrearInstallment, new BigDecimal(3074));
        collectionMap.put(arrearInstallment, new BigDecimal(0));
        demandMap.put(this.currentInstallment, new BigDecimal(6148));
        collectionMap.put(this.currentInstallment, new BigDecimal(0));
        this.installmentDemandAndCollection.put("DEMAND", demandMap);
        this.installmentDemandAndCollection.put("COLLECTION", collectionMap);
        this.egDemand.setEgInstallmentMaster(this.currentInstallment);
        Mockito.when((Object)this.ptDemandDAO.getNonHistoryCurrDmdForProperty((Property)Matchers.any())).thenReturn((Object)this.egDemand);
        Mockito.when((Object)this.penaltyCalculationService.getInstallmentDemandAndCollection((BasicProperty)Matchers.any(), (EgDemand)Matchers.any())).thenReturn(this.installmentDemandAndCollection);
        Mockito.when((Object)this.rebateService.isEarlyPayRebateActive()).thenReturn((Object)false);
        this.installmentPenaltyAndRebate = this.billable.getCalculatedPenalty();
        for (Map.Entry<Installment, PenaltyAndRebate> entry : this.installmentPenaltyAndRebate.entrySet()) {
            Assert.assertTrue((entry.getValue().getPenalty().compareTo(new BigDecimal(0)) == 1 || entry.getValue().getPenalty().compareTo(new BigDecimal(0)) == 0 ? 1 : 0) != 0);
        }
    }
}

