/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.service.utils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.commons.Installment;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;

public class PropertyTaxCommonUtils {
    private static final Logger LOGGER = Logger.getLogger(PropertyTaxCommonUtils.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;

    public Installment getCurrentInstallment() {
        Query query = ((Session)this.entityManager.unwrap(Session.class)).createQuery("select installment from Installment installment,CFinancialYear finYear where installment.module.name =:moduleName  and (cast(:currDate as date)) between finYear.startingDate and finYear.endingDate  and cast(installment.fromDate as date) >= cast(finYear.startingDate as date) and cast(installment.toDate as date) <= cast(finYear.endingDate as date) order by installment.fromDate asc ");
        query.setString("moduleName", "Property Tax");
        query.setDate("currDate", new Date());
        List installments = query.list();
        return (Installment)installments.get(0);
    }

    public String getAppConfigValue(String key, String moduleName) {
        AppConfigValues appConfigValues;
        String value = "";
        if (key != null && moduleName != null && (appConfigValues = this.appConfigValuesService.getAppConfigValueByDate(moduleName, key, new Date())) != null) {
            value = appConfigValues.getValue();
        }
        return value;
    }

    public Map<String, Object> getTaxDetailsForWorkflowProperty(BasicProperty basicProperty) {
        Map<Object, Object> demandCollMap = new TreeMap();
        HashMap<String, Object> wfPropTaxDetailsMap = new HashMap<String, Object>();
        Property property = basicProperty.getWFProperty();
        try {
            demandCollMap = this.propertyTaxUtil.prepareDemandDetForView(property, this.getCurrentInstallment());
            if (!demandCollMap.isEmpty()) {
                for (Map.Entry<Object, Object> entry : demandCollMap.entrySet()) {
                    String key = (String)entry.getKey();
                    Map reasonDmd = (Map)entry.getValue();
                    if (key.equals("Current 1st Half")) {
                        wfPropTaxDetailsMap.put("firstHalf", "Current 1st Half");
                        wfPropTaxDetailsMap.put("firstHalfGT", reasonDmd.get("General Tax") != null ? reasonDmd.get("General Tax") : demandCollMap.get("Vacant Land Tax"));
                        wfPropTaxDetailsMap.put("firstHalfEC", reasonDmd.get("Education Cess") != null ? reasonDmd.get("Education Cess") : BigDecimal.ZERO);
                        wfPropTaxDetailsMap.put("firstHalfLC", reasonDmd.get("Library Cess"));
                        wfPropTaxDetailsMap.put("firstHalfUAP", reasonDmd.get("Unauthorized Penalty") != null ? reasonDmd.get("Unauthorized Penalty") : BigDecimal.ZERO);
                        wfPropTaxDetailsMap.put("firstHalfTotal", ((BigDecimal)reasonDmd.get("CURR_FIRSTHALF_DMD")).add(reasonDmd.get("Unauthorized Penalty") != null ? (BigDecimal)reasonDmd.get("Unauthorized Penalty") : BigDecimal.ZERO));
                        wfPropTaxDetailsMap.put("firstHalfTaxDue", ((BigDecimal)reasonDmd.get("CURR_FIRSTHALF_DMD")).add(reasonDmd.get("Unauthorized Penalty") != null ? (BigDecimal)reasonDmd.get("Unauthorized Penalty") : BigDecimal.ZERO).subtract((BigDecimal)reasonDmd.get("CURR_FIRSTHALF_COLL")));
                        continue;
                    }
                    if (key.equals("Current 2nd Half")) {
                        wfPropTaxDetailsMap.put("secondHalf", "Current 2nd Half");
                        wfPropTaxDetailsMap.put("secondHalfGT", reasonDmd.get("General Tax") != null ? reasonDmd.get("General Tax") : demandCollMap.get("Vacant Land Tax"));
                        wfPropTaxDetailsMap.put("secondHalfEC", reasonDmd.get("Education Cess") != null ? reasonDmd.get("Education Cess") : BigDecimal.ZERO);
                        wfPropTaxDetailsMap.put("secondHalfLC", reasonDmd.get("Library Cess"));
                        wfPropTaxDetailsMap.put("secondHalfUAP", reasonDmd.get("Unauthorized Penalty") != null ? reasonDmd.get("Unauthorized Penalty") : BigDecimal.ZERO);
                        wfPropTaxDetailsMap.put("secondHalfTotal", ((BigDecimal)reasonDmd.get("CURR_SECONDHALF_DMD")).add(reasonDmd.get("Unauthorized Penalty") != null ? (BigDecimal)reasonDmd.get("Unauthorized Penalty") : BigDecimal.ZERO));
                        wfPropTaxDetailsMap.put("secondHalfTaxDue", ((BigDecimal)reasonDmd.get("CURR_SECONDHALF_DMD")).add(reasonDmd.get("Unauthorized Penalty") != null ? (BigDecimal)reasonDmd.get("Unauthorized Penalty") : BigDecimal.ZERO).subtract((BigDecimal)reasonDmd.get("CURR_SECONDHALF_COLL")));
                        continue;
                    }
                    wfPropTaxDetailsMap.put("arrears", "Arrears");
                    wfPropTaxDetailsMap.put("arrearTax", reasonDmd.get("ARR_DMD"));
                    wfPropTaxDetailsMap.put("totalArrDue", ((BigDecimal)reasonDmd.get("ARR_DMD")).subtract((BigDecimal)reasonDmd.get("ARR_COLL")));
                }
            }
        }
        catch (ParseException e) {
            LOGGER.error((Object)"Exception in getTaxDetailsForWorkflowProperty: ", (Throwable)e);
            throw new ApplicationRuntimeException("Exception in getTaxDetailsForWorkflowProperty : " + e);
        }
        return wfPropTaxDetailsMap;
    }

    public boolean isDigitalSignatureEnabled() {
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("Property Tax", "PTIS_DIGITAL_SIGNATURE_REQUIRED");
        return !appConfigValues.isEmpty() && "Y".equals(((AppConfigValues)appConfigValues.get(0)).getValue());
    }

    public List<Installment> getAdvanceInstallmentsList(Date startDate) {
        ArrayList<Installment> advanceInstallments = new ArrayList();
        String query = "select inst from Installment inst where inst.module.name = 'Property Tax' and inst.fromDate >= :startdate order by inst.fromDate asc ";
        advanceInstallments = ((Session)this.entityManager.unwrap(Session.class)).createQuery(query).setParameter("startdate", (Object)startDate).setMaxResults(PropertyTaxConstants.MAX_ADVANCES_ALLOWED.intValue()).list();
        return advanceInstallments;
    }
}

