/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.service.collection;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.ReceiptAmountInfo;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.integration.TaxCollection;
import org.egov.demand.model.EgBill;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.service.transfer.PropertyTransferService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class MutationFeeCollection
extends TaxCollection {
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private PropertyTransferService propertyTransferService;
    @Autowired
    private PersistenceService<PropertyMutation, Long> propertyMutationService;
    @Autowired
    private EgBillDao egBillDAO;

    @Transactional
    public void updateDemandDetails(BillReceiptInfo bri) {
        PropertyMutation propertyMutation = this.propertyTransferService.getPropertyMutationByApplicationNo(this.getEgBill(bri.getBillReferenceNum()).getConsumerId());
        propertyMutation.setReceiptDate(bri.getReceiptDate());
        propertyMutation.setReceiptNum(bri.getReceiptNum());
        propertyMutation.transition(true).withSenderName(propertyMutation.getState().getSenderName()).withDateInfo(new Date()).withOwner(propertyMutation.getState().getOwnerPosition()).withStateValue("Transfer Fee Collected").withNextAction("Revenue Officer Approval Pending");
        this.propertyMutationService.persist((Object)propertyMutation);
        this.propertyMutationService.getSession().flush();
    }

    protected Module module() {
        return this.moduleDao.getModuleByName("Property Tax");
    }

    private EgBill getEgBill(String billRefNo) {
        return this.egBillDAO.findById(Long.valueOf(billRefNo), false);
    }

    public List<ReceiptDetail> reconstructReceiptDetail(String billReferenceNumber, BigDecimal actualAmountPaid, List<ReceiptDetail> receiptDetailList) {
        return null;
    }

    public String constructAdditionalInfoForReceipt(BillReceiptInfo billReceiptInfo) {
        return null;
    }

    public ReceiptAmountInfo receiptAmountBifurcation(BillReceiptInfo billReceiptInfo) {
        return new ReceiptAmountInfo();
    }
}

