/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.scheduler;

import org.apache.log4j.Logger;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.scheduler.quartz.AbstractQuartzJob;
import org.egov.ptis.service.DemandBill.DemandBillService;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BulkBillGenerationJob
extends AbstractQuartzJob {
    private static final Logger LOGGER = Logger.getLogger(BulkBillGenerationJob.class);
    private Integer billsCount;
    private Integer modulo;
    private DemandBillService demandBillService;
    @Autowired
    private ApplicationContext beanProvider;
    @Autowired
    private UserService userService;

    public void executeJob() {
        LOGGER.debug((Object)("Entered into executeJob" + this.modulo));
        super.prepareCityThreadLocal();
        DemandBillService demandBillService = null;
        try {
            demandBillService = (DemandBillService)this.beanProvider.getBean("demandBillService");
        }
        catch (NoSuchBeanDefinitionException e) {
            LOGGER.warn((Object)"DemandBillService implementation not found");
        }
        if (demandBillService != null) {
            demandBillService.bulkBillGeneration(this.modulo, this.billsCount);
        }
    }

    public Integer getBillsCount() {
        return this.billsCount;
    }

    public void setBillsCount(Integer billsCount) {
        this.billsCount = billsCount;
    }

    public Integer getModulo() {
        return this.modulo;
    }

    public void setModulo(Integer modulo) {
        this.modulo = modulo;
    }

    public DemandBillService getDemandBillService() {
        return this.demandBillService;
    }

    public void setDemandBillService(DemandBillService demandBillService) {
        this.demandBillService = demandBillService;
    }
}

