/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.master.service;

import java.util.ArrayList;
import java.util.List;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.ptis.domain.dao.property.PropertyUsageDAO;
import org.egov.ptis.domain.entity.property.PropertyUsage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PropertyUsageService {
    private final PropertyUsageDAO propertyUsageHibernateDAO;
    @Autowired
    private UserService userService;

    @Autowired
    public PropertyUsageService(PropertyUsageDAO propertyUsageHibernateDAO) {
        this.propertyUsageHibernateDAO = propertyUsageHibernateDAO;
    }

    public PropertyUsage create(PropertyUsage propertyUsage) {
        if (propertyUsage.getIsResidential().booleanValue()) {
            propertyUsage.setUsageCode("RESD");
        } else {
            propertyUsage.setUsageCode("NON_RESD");
        }
        propertyUsage.setIsEnabled(1);
        this.propertyUsageHibernateDAO.create(propertyUsage);
        return propertyUsage;
    }

    public List<PropertyUsage> getAllActivePropertyUsages() {
        return this.propertyUsageHibernateDAO.getAllActivePropertyUsage();
    }

    public PropertyUsage findById(Long id) {
        return this.propertyUsageHibernateDAO.findById(id, false);
    }

    public String getRolesForUserId(Long userId) {
        ArrayList<String> roleNameList = new ArrayList<String>();
        User user = this.userService.getUserById(userId);
        for (Role role : user.getRoles()) {
            String roleName = role.getName() != null ? role.getName() : "";
            roleNameList.add(roleName);
        }
        return ((Object)roleNameList).toString().toUpperCase();
    }
}

