/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.revisionPetition;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.entity.Source;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.search.elastic.entity.ApplicationIndex;
import org.egov.infra.search.elastic.entity.ApplicationIndexBuilder;
import org.egov.infra.search.elastic.service.ApplicationIndexService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.ptis.domain.dao.property.PropertyStatusDAO;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.egov.ptis.domain.service.property.SMSEmailService;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.annotation.Transactional;

public class RevisionPetitionService
extends PersistenceService<RevisionPetition, Long> {
    private static final Logger LOGGER = Logger.getLogger(RevisionPetitionService.class);
    @Autowired
    private ApplicationNumberGenerator applicationNumberGenerator;
    @Autowired
    private PropertyStatusDAO propertyStatusDAO;
    @Autowired
    DesignationService designationService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;
    @Autowired
    @Qualifier(value="workflowService")
    protected SimpleWorkflowService<RevisionPetition> revisionPetitionWorkFlowService;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private ApplicationIndexService applicationIndexService;
    private static final String REVISION_PETITION_CREATED = "CREATED";
    @Autowired
    private MessagingService messagingService;
    private SMSEmailService sMSEmailService;

    @Transactional
    public RevisionPetition createRevisionPetition(RevisionPetition objection) {
        objection = objection.getId() == null ? (RevisionPetition)((Object)this.persist((Object)objection)) : (RevisionPetition)((Object)this.merge((Object)objection));
        return objection;
    }

    @Transactional
    public RevisionPetition createRevisionPetitionForRest(RevisionPetition objection) {
        Position position = null;
        WorkFlowMatrix wfmatrix = null;
        User user = null;
        if (objection.getId() == null) {
            if (objection.getObjectionNumber() == null) {
                objection.setObjectionNumber(this.applicationNumberGenerator.generate());
            }
            objection.getBasicProperty().setStatus(this.propertyStatusDAO.getPropertyStatusByCode("OBJECTED"));
            objection.getBasicProperty().setUnderWorkflow(Boolean.TRUE);
            if (objection.getState() == null) {
                wfmatrix = this.revisionPetitionWorkFlowService.getWfMatrix(objection.getStateType(), null, null, null, "Revision Petition:CREATED", null);
                Designation desig = this.designationService.getDesignationByName("Revenue Clerk");
                List assignment = this.assignmentService.findByDesignationAndBoundary(desig.getId(), objection.getBasicProperty().getPropertyID().getZone().getId());
                if (assignment.size() > 0) {
                    position = ((Assignment)assignment.get(0)).getPosition();
                } else {
                    assignment = this.assignmentService.findPrimaryAssignmentForDesignationName("Revenue Clerk");
                    if (assignment.size() > 0) {
                        position = ((Assignment)assignment.get(0)).getPosition();
                    }
                }
                this.updateRevisionPetitionStatus(wfmatrix, objection, null);
                if (position != null) {
                    user = this.eisCommonService.getUserForPosition(position.getId(), new Date());
                }
                objection.start().withNextAction(wfmatrix.getPendingActions()).withStateValue(wfmatrix.getCurrentState()).withOwner(position).withSenderName(user != null && user.getName() != null ? user.getName() : "").withOwner(user).withComments("");
            }
            this.applyAuditing((AbstractAuditable)objection.getState());
            objection = (RevisionPetition)((Object)this.persist((Object)objection));
            this.updateIndex(objection);
            this.sendEmailandSms(objection, REVISION_PETITION_CREATED);
        } else {
            objection = (RevisionPetition)((Object)this.merge((Object)objection));
        }
        return objection;
    }

    private void updateIndex(RevisionPetition objection) {
        ApplicationIndex applicationIndex = this.applicationIndexService.findByApplicationNumber(objection.getObjectionNumber());
        User user = this.securityUtils.getCurrentUser();
        String url = "/ptis/view/viewProperty-viewForm.action?applicationNo=" + objection.getObjectionNumber();
        if (null == applicationIndex) {
            ApplicationIndexBuilder applicationIndexBuilder = new ApplicationIndexBuilder("Property Tax", objection.getObjectionNumber(), objection.getCreatedDate() != null ? objection.getCreatedDate() : new Date(), "Revision_Petition", objection.getBasicProperty().getFullOwnerName(), objection.getState().getValue(), url, objection.getBasicProperty().getAddress().toString(), user.getUsername() + "::" + user.getName(), Source.SYSTEM.toString());
            this.applicationIndexService.createApplicationIndex(applicationIndexBuilder.build());
        } else {
            applicationIndex.setStatus(objection.getState().getValue());
            this.applicationIndexService.updateApplicationIndex(applicationIndex);
        }
    }

    private void updateRevisionPetitionStatus(WorkFlowMatrix wfmatrix, RevisionPetition objection, String status) {
        EgwStatus egwStatus = null;
        if (status != null && !"".equals(status)) {
            egwStatus = this.egwStatusDAO.getStatusByModuleAndCode("PTObejction", status);
        } else if (wfmatrix != null && wfmatrix.getNextStatus() != null && objection != null) {
            egwStatus = this.egwStatusDAO.getStatusByModuleAndCode("PTObejction", wfmatrix.getNextStatus());
        }
        if (egwStatus != null) {
            objection.setEgwStatus(egwStatus);
        }
    }

    @Transactional
    public RevisionPetition updateRevisionPetition(RevisionPetition objection) {
        objection = objection.getId() == null ? (RevisionPetition)((Object)this.persist((Object)objection)) : (RevisionPetition)((Object)this.update((Object)objection));
        return objection;
    }

    public RevisionPetition getRevisionPetitionByApplicationNumber(String applicationNumber) {
        RevisionPetition revPetitionObject = null;
        Criteria appCriteria = this.getSession().createCriteria(RevisionPetition.class, "revPetiton");
        appCriteria.add((Criterion)Restrictions.eq((String)"revPetiton.objectionNumber", (Object)applicationNumber));
        revPetitionObject = (RevisionPetition)((Object)appCriteria.uniqueResult());
        return revPetitionObject;
    }

    public void sendEmailandSms(RevisionPetition objection, String applicationType) {
        if (objection != null) {
            User user = objection.getBasicProperty().getPrimaryOwner();
            String mobileNumber = user.getMobileNumber();
            String emailid = user.getEmailId();
            String applicantName = user.getName();
            ArrayList<String> args = new ArrayList<String>();
            args.add(applicantName);
            String smsMsg = "";
            String emailSubject = "";
            String emailBody = "";
            if (applicationType != null && applicationType.equalsIgnoreCase(REVISION_PETITION_CREATED)) {
                args.add(objection.getObjectionNumber());
                if (mobileNumber != null) {
                    smsMsg = "Revision petition created. Use " + objection.getObjectionNumber() + " for future reference";
                }
                if (emailid != null) {
                    emailSubject = "Revision petition created.";
                    emailBody = "Revision petition created. Use " + objection.getObjectionNumber() + " for future reference";
                }
            }
            if (mobileNumber != null && !smsMsg.equals("")) {
                this.messagingService.sendSMS(mobileNumber, smsMsg);
            }
            if (emailid != null && !emailBody.equals("")) {
                this.messagingService.sendEmail(emailid, emailSubject, emailBody);
            }
        }
    }

    public SMSEmailService getsMSEmailService() {
        return this.sMSEmailService;
    }

    public void setsMSEmailService(SMSEmailService sMSEmailService) {
        this.sMSEmailService = sMSEmailService;
    }
}

