/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.demolition;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Position;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.PropertyTypeMasterDAO;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyDetail;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.entity.property.VacantProperty;
import org.egov.ptis.domain.service.property.PropertyPersistenceService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.exceptions.TaxCalculatorExeption;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.hibernate.FlushMode;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;

public class PropertyDemolitionService
extends PersistenceService<PropertyImpl, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyDemolitionService.class);
    @Autowired
    private PropertyTypeMasterDAO propertyTypeMasterDAO;
    @Autowired
    private PropertyService propService;
    @Autowired
    private PropertyPersistenceService propertyPerService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<PropertyImpl> propertyWorkflowService;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private ResourceBundleMessageSource messageSource;
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;

    @Transactional
    public void saveProperty(Property oldProperty, Property newProperty, Character status, String comments, String workFlowAction, Long approverPosition, String additionalRule) throws TaxCalculatorExeption {
        Date propCompletionDate = null;
        BasicProperty basicProperty = oldProperty.getBasicProperty();
        PropertyTypeMaster propTypeMstr = this.propertyTypeMasterDAO.getPropertyTypeMasterByCode("VAC_LAND");
        PropertyImpl propertyModel = (PropertyImpl)newProperty;
        newProperty.getPropertyDetail().setPropertyTypeMaster(propTypeMstr);
        newProperty.getBasicProperty().setPropOccupationDate(newProperty.getPropertyDetail().getDateOfCompletion());
        propCompletionDate = newProperty.getPropertyDetail().getDateOfCompletion();
        String areaOfPlot = String.valueOf(propertyModel.getPropertyDetail().getSitalArea().getArea());
        propertyModel = this.propService.createProperty(propertyModel, areaOfPlot, "FULL DEMOLITION", propertyModel.getPropertyDetail().getPropertyTypeMaster().getId().toString(), null, null, status, null, null, null, null, null, null, null);
        propertyModel.setBasicProperty(basicProperty);
        propertyModel.setEffectiveDate(propCompletionDate);
        if (!propertyModel.getPropertyDetail().getPropertyTypeMaster().getCode().equals("VAC_LAND")) {
            this.propService.changePropertyDetail(propertyModel, new VacantProperty(), 0);
        }
        propertyModel.getPropertyDetail().setCategoryType("VACANTLAND");
        basicProperty.setUnderWorkflow(Boolean.TRUE);
        propertyModel.setBasicProperty(basicProperty);
        basicProperty.addProperty(propertyModel);
        this.getSession().setFlushMode(FlushMode.MANUAL);
        this.transitionWorkFlow(propertyModel, comments, workFlowAction, approverPosition, additionalRule);
        Map<String, Installment> yearwiseInstMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
        Installment installmentFirstHalf = yearwiseInstMap.get("Current 1st Half");
        Installment installmentSecondHalf = yearwiseInstMap.get("Current 2nd Half");
        Installment currInstall = this.propertyTaxCommonUtils.getCurrentInstallment();
        Date effectiveDate = null;
        boolean calculateForNextFinYear = false;
        if (DateUtils.between((Date)new Date(), (Date)installmentFirstHalf.getFromDate(), (Date)installmentFirstHalf.getToDate())) {
            effectiveDate = installmentSecondHalf.getFromDate();
        } else {
            effectiveDate = DateUtils.addYears((Date)installmentFirstHalf.getFromDate(), (int)1);
            calculateForNextFinYear = true;
        }
        Property modProperty = this.propService.createDemand(propertyModel, effectiveDate);
        Object currPtDmd = null;
        for (Object demand : modProperty.getPtDemandSet()) {
            if (!demand.getIsHistory().equalsIgnoreCase("N") || !demand.getEgInstallmentMaster().equals((Object)currInstall)) continue;
            currPtDmd = demand;
            break;
        }
        Ptdemand oldCurrPtDmd = null;
        for (Ptdemand ptDmd : oldProperty.getPtDemandSet()) {
            if (!ptDmd.getIsHistory().equalsIgnoreCase("N") || !ptDmd.getEgInstallmentMaster().equals((Object)currInstall)) continue;
            oldCurrPtDmd = ptDmd;
            break;
        }
        Installment effectiveInstall = null;
        if (calculateForNextFinYear) {
            Module module = this.moduleDao.getModuleByName("Property Tax");
            effectiveInstall = this.installmentDao.getInsatllmentByModuleForGivenDate(module, effectiveDate);
            this.propService.addArrDmdDetToCurrentDmd(oldCurrPtDmd, (Ptdemand)((Object)currPtDmd), effectiveInstall, true);
        } else {
            this.propService.addArrDmdDetToCurrentDmd(oldCurrPtDmd, (Ptdemand)((Object)currPtDmd), installmentSecondHalf, true);
        }
        basicProperty.addProperty(modProperty);
        for (Ptdemand ptDemand : modProperty.getPtDemandSet()) {
            this.propertyPerService.applyAuditing(ptDemand.getDmdCalculations());
        }
        this.propertyPerService.update(basicProperty);
        this.getSession().flush();
    }

    public void updateProperty(Property newProperty, String comments, String workFlowAction, Long approverPosition, String additionalRule) {
        this.transitionWorkFlow((PropertyImpl)newProperty, comments, workFlowAction, approverPosition, additionalRule);
        this.propertyPerService.update(newProperty.getBasicProperty());
        this.getSession().flush();
    }

    private void transitionWorkFlow(PropertyImpl property, String approvarComments, String workFlowAction, Long approverPosition, String additionalRule) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("WorkFlow Transition For Demolition Started  ...");
        }
        User user = this.securityUtils.getCurrentUser();
        DateTime currentDate = new DateTime();
        Assignment userAssignment = this.assignmentService.getPrimaryAssignmentForUser(user.getId());
        Position pos = null;
        if ("Reject".equalsIgnoreCase(workFlowAction)) {
            Assignment wfInitiator = this.propService.getWorkflowInitiator(property);
            if (wfInitiator.equals(userAssignment)) {
                property.transition(true).end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvarComments).withDateInfo(currentDate.toDate());
                property.setStatus(PropertyTaxConstants.STATUS_CANCELLED);
                property.getBasicProperty().setUnderWorkflow(Boolean.FALSE);
            } else {
                String stateValue = property.getCurrentState().getValue().split(":")[0] + ":" + "Rejected";
                property.transition(true).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvarComments).withStateValue(stateValue).withDateInfo(currentDate.toDate()).withOwner(this.assignmentService.getPrimaryAssignmentForUser(property.getCreatedBy().getId()).getPosition()).withNextAction("Assistant Approval Pending");
                this.buildSMS(property, workFlowAction);
            }
        } else {
            if (null != approverPosition && approverPosition != -1L && !approverPosition.equals(0L)) {
                pos = this.positionMasterService.getPositionById(approverPosition);
            } else if ("Approve".equalsIgnoreCase(workFlowAction)) {
                pos = this.positionMasterService.getPositionByUserId(this.securityUtils.getCurrentUser().getId());
            } else if ("Sign".equalsIgnoreCase(workFlowAction)) {
                pos = this.assignmentService.getPrimaryAssignmentForUser(property.getCreatedBy().getId()).getPosition();
            }
            WorkFlowMatrix wfmatrix = null;
            if (null == property.getState()) {
                wfmatrix = this.propertyWorkflowService.getWfMatrix(property.getStateType(), null, null, additionalRule, null, null);
                property.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvarComments).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner(pos).withNextAction(wfmatrix.getNextAction()).withNatureOfTask("Demolition");
            } else {
                wfmatrix = this.propertyWorkflowService.getWfMatrix(property.getStateType(), null, null, additionalRule, property.getCurrentState().getValue(), null);
                if (wfmatrix != null) {
                    if (wfmatrix.getNextAction().equalsIgnoreCase("END")) {
                        property.transition().end().withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvarComments).withDateInfo(currentDate.toDate());
                    } else {
                        property.transition(false).withSenderName(user.getUsername() + "::" + user.getName()).withComments(approvarComments).withStateValue(wfmatrix.getNextState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction(wfmatrix.getNextAction());
                    }
                    if (workFlowAction.equalsIgnoreCase("Approve")) {
                        this.buildSMS(property, workFlowAction);
                    }
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(" WorkFlow Transition Completed for Demolition ...");
        }
    }

    public void validateProperty(Property property, BindingResult errors, HttpServletRequest request) {
        PropertyDetail propertyDetail = property.getPropertyDetail();
        if (StringUtils.isBlank((CharSequence)propertyDetail.getPattaNumber())) {
            errors.rejectValue("propertyDetail.pattaNumber", "pattaNumber.required");
        }
        if (StringUtils.isBlank((CharSequence)propertyDetail.getSurveyNumber())) {
            errors.rejectValue("propertyDetail.surveyNumber", "surveyNumber.required");
        }
        if (null == propertyDetail.getSitalArea().getArea()) {
            errors.rejectValue("propertyDetail.sitalArea.area", "vacantLandArea.required");
        }
        if (null == propertyDetail.getMarketValue()) {
            errors.rejectValue("propertyDetail.marketValue", "marketValue.required");
        }
        if (null == propertyDetail.getCurrentCapitalValue()) {
            errors.rejectValue("propertyDetail.currentCapitalValue", "currCapitalValue.required");
        }
        if (StringUtils.isBlank((CharSequence)property.getBasicProperty().getPropertyID().getNorthBoundary())) {
            errors.rejectValue("basicProperty.propertyID.northBoundary", "northBoundary.required");
        }
        if (StringUtils.isBlank((CharSequence)property.getBasicProperty().getPropertyID().getEastBoundary())) {
            errors.rejectValue("basicProperty.propertyID.eastBoundary", "eastBoundary.required");
        }
        if (StringUtils.isBlank((CharSequence)property.getBasicProperty().getPropertyID().getWestBoundary())) {
            errors.rejectValue("basicProperty.propertyID.westBoundary", "westBoundary.required");
        }
        if (StringUtils.isBlank((CharSequence)property.getBasicProperty().getPropertyID().getSouthBoundary())) {
            errors.rejectValue("basicProperty.propertyID.southBoundary", "southBoundary.required");
        }
        if (StringUtils.isBlank((CharSequence)property.getDemolitionReason())) {
            errors.rejectValue("demolitionReason", "demolitionReason.required");
        }
    }

    public void addModelAttributes(Model model, BasicProperty basicProperty) {
        Property property = null;
        property = null != basicProperty.getProperty() ? basicProperty.getProperty() : basicProperty.getActiveProperty();
        Ptdemand ptDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(property);
        if (ptDemand != null && ptDemand.getDmdCalculations() != null && ptDemand.getDmdCalculations().getAlv() != null) {
            model.addAttribute("ARV", (Object)ptDemand.getDmdCalculations().getAlv());
        } else {
            model.addAttribute("ARV", (Object)BigDecimal.ZERO);
        }
        if (!basicProperty.getActiveProperty().getIsExemptedFromTax().booleanValue()) {
            try {
                Map<String, Map<String, BigDecimal>> demandCollMap = this.propertyTaxUtil.prepareDemandDetForView(property, this.propertyTaxCommonUtils.getCurrentInstallment());
                Map<String, BigDecimal> currentTaxDetails = this.propService.getCurrentTaxDetails(demandCollMap, new Date());
                model.addAttribute("propertyTax", (Object)currentTaxDetails.get("General Tax"));
                model.addAttribute("eduCess", (Object)(currentTaxDetails.get("Education Cess") == null ? BigDecimal.ZERO : currentTaxDetails.get("Education Cess")));
                model.addAttribute("libraryCess", (Object)(currentTaxDetails.get("Library Cess") == null ? BigDecimal.ZERO : currentTaxDetails.get("Library Cess")));
                model.addAttribute("currTax", (Object)currentTaxDetails.get("CURR_DMD"));
                model.addAttribute("currTaxDue", (Object)currentTaxDetails.get("CURR_BAL"));
                model.addAttribute("totalTax", (Object)currentTaxDetails.get("CURR_DMD"));
                model.addAttribute("totalArrDue", (Object)currentTaxDetails.get("ARR_BAL"));
            }
            catch (Exception e) {
                LOGGER.error("Exception in addModelAttributes : ", (Throwable)e);
                throw new ApplicationRuntimeException("Exception in addModelAttributes : " + e);
            }
        }
    }

    public void buildSMS(Property property, String workFlowAction) {
        User user = property.getBasicProperty().getPrimaryOwner();
        String assessmentNo = property.getBasicProperty().getUpicNo();
        String mobileNumber = user.getMobileNumber();
        String applicantName = user.getName();
        String smsMsg = "";
        if (!workFlowAction.equals("Forward")) {
            if (workFlowAction.equals("Reject")) {
                smsMsg = this.messageSource.getMessage("demolition.rejection.sms", (Object[])new String[]{applicantName, assessmentNo, ApplicationThreadLocals.getMunicipalityName()}, null);
            } else if (workFlowAction.equals("Approve")) {
                Installment effectiveInstallment = null;
                Map<String, Installment> yearwiseInstMap = this.propertyTaxUtil.getInstallmentsForCurrYear(new Date());
                Installment installmentFirstHalf = yearwiseInstMap.get("Current 1st Half");
                Installment installmentSecondHalf = yearwiseInstMap.get("Current 2nd Half");
                Date effectiveDate = null;
                Map<String, BigDecimal> demandMap = null;
                BigDecimal totalTax = BigDecimal.ZERO;
                if (DateUtils.between((Date)new Date(), (Date)installmentFirstHalf.getFromDate(), (Date)installmentFirstHalf.getToDate())) {
                    effectiveInstallment = installmentSecondHalf;
                } else {
                    Module module = this.moduleDao.getModuleByName("Property Tax");
                    effectiveDate = DateUtils.addDays((Date)installmentSecondHalf.getToDate(), (int)1);
                    effectiveInstallment = this.installmentDao.getInsatllmentByModuleForGivenDate(module, effectiveDate);
                }
                demandMap = this.propertyTaxUtil.getTaxDetailsForInstallment(property, effectiveInstallment, installmentFirstHalf);
                totalTax = demandMap.get("Vacant Land Tax") == null ? BigDecimal.ZERO : demandMap.get("Vacant Land Tax").add(demandMap.get("Library Cess") == null ? BigDecimal.ZERO : demandMap.get("Library Cess"));
                smsMsg = this.messageSource.getMessage("demolition.approval.sms", (Object[])new String[]{applicantName, assessmentNo, totalTax.toString(), new SimpleDateFormat("dd/MM/yyyy").format(effectiveInstallment.getFromDate()), ApplicationThreadLocals.getMunicipalityName()}, null);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)mobileNumber)) {
            this.messagingService.sendSMS(mobileNumber, smsMsg);
        }
    }
}

