/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.dao.property;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.ptis.domain.dao.property.PropertyStatusValuesDAO;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.PropertyStatusValues;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="propertyStatusValuesDAO")
@Transactional(readOnly=true)
public class PropertyStatusValuesHibernateDAO
implements PropertyStatusValuesDAO {
    @PersistenceContext
    private EntityManager entityManager;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public PropertyStatusValues getLatestPropertyStatusValuesByPropertyIdAndCode(String PropertyId, List Code) {
        Query qry = this.getCurrentSession().createQuery("from PropertyStatusValues PSV left join fetch PSV.basicProperty BP left join fetch PSV.propertyStatus PS where PSV.isActive ='Y' and BP.upicNo =:PropertyId and PS.statusCode in (:Code) order by PSV.createdDate desc").setMaxResults(1);
        qry.setString("PropertyId", PropertyId);
        qry.setParameterList("Code", (Collection)Code);
        return (PropertyStatusValues)((Object)qry.uniqueResult());
    }

    @Override
    public PropertyStatusValues getLatestPropertyStatusValuesByPropertyIdAndreferenceNo(String PropertyId, String referenceNumber) {
        Query qry = this.getCurrentSession().createQuery("from PropertyStatusValues PSV  where PSV.basicProperty.upicNo =:PropertyId and PSV.referenceNo in (:referenceNumber)  order by PSV.createdDate desc").setMaxResults(1);
        qry.setString("PropertyId", PropertyId);
        qry.setString("referenceNumber", referenceNumber);
        return (PropertyStatusValues)((Object)qry.uniqueResult());
    }

    @Override
    public List<PropertyStatusValues> getParentBasicPropsForChild(BasicProperty basicProperty) {
        List<PropertyStatusValues> propStatValueList = new ArrayList<PropertyStatusValues>();
        if (basicProperty != null) {
            Query qry = this.getCurrentSession().createQuery("from PropertyStatusValues PSV left join fetch PSV.propertyStatus PS where PSV.basicProperty =:BasicPropertyId and PS.statusCode = 'CREATE' and PSV.isActive='Y' ");
            qry.setString("BasicPropertyId", basicProperty.getId().toString());
            propStatValueList = qry.list();
        }
        return propStatValueList;
    }

    @Override
    public List<PropertyStatusValues> getPropertyStatusValuesByReferenceBasicProperty(BasicProperty basicProperty) {
        Query qry = this.getCurrentSession().createQuery("from PropertyStatusValues PSV left join fetch PSV.propertyStatus PS where PSV.referenceBasicProperty.id =:BasicPropertyId and PS.statusCode = 'CREATE' and PSV.isActive='Y' ");
        qry.setParameter("BasicPropertyId", (Object)basicProperty.getId());
        return qry.list();
    }

    @Override
    public PropertyStatusValues findById(Integer id, boolean lock) {
        return null;
    }

    @Override
    public List<PropertyStatusValues> findAll() {
        return null;
    }

    @Override
    public PropertyStatusValues create(PropertyStatusValues propertyStatusValues) {
        return null;
    }

    @Override
    public void delete(PropertyStatusValues propertyStatusValues) {
    }

    @Override
    public PropertyStatusValues update(PropertyStatusValues propertyStatusValues) {
        return null;
    }
}

