/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.client.util;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class FinancialUtil {
    private static final Logger LOGGER = Logger.getLogger(FinancialUtil.class);
    private static final String VOUCHERNAME = "JVoucher";
    private static final String VOUCHERTYPE = "Journal Voucher";
    private static final String URL_FOR_DCB = "/ptis/view/viewDCBProperty!displayPropInfo.action?propertyId=";
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private CreateVoucher createVoucher;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtil;

    public void createVoucher(String indexNum, Map<Installment, Map<String, BigDecimal>> amounts, String transaction) {
        LOGGER.info((Object)("createVoucher: IndexNumber==>" + indexNum + " amounts==>" + amounts + "actionName==>" + transaction));
        Map<String, Map<String, BigDecimal>> resultMap = this.prepareDemandForGlcode(amounts);
        Map<String, BigDecimal> arrearsDemandMap = resultMap.get("ARREARS_DEMAND");
        Map<String, BigDecimal> currentDemandMap = resultMap.get("CURRENT_DEMAND");
        HashMap<String, Object> headerdetails = this.createHeaderDetails(indexNum, transaction);
        ArrayList<HashMap<String, Object>> accountDetList = new ArrayList<HashMap<String, Object>>();
        try {
            for (Map.Entry<String, BigDecimal> arrearsDemand : arrearsDemandMap.entrySet()) {
                if (arrearsDemand.getValue().compareTo(BigDecimal.ZERO) == 1) {
                    accountDetList.add(this.createAccDetailmap(PropertyTaxConstants.GLCODEMAP_FOR_ARREARTAX.get(arrearsDemand.getKey()), arrearsDemand.getValue().abs(), BigDecimal.ZERO));
                    accountDetList.add(this.createAccDetailmap(PropertyTaxConstants.GLCODEMAP_FOR_TAX_PAYABLE.get(arrearsDemand.getKey()), BigDecimal.ZERO, arrearsDemand.getValue().abs()));
                    continue;
                }
                if (arrearsDemand.getValue().compareTo(BigDecimal.ZERO) != -1) continue;
                accountDetList.add(this.createAccDetailmap(PropertyTaxConstants.GLCODEMAP_FOR_ARREARTAX.get(arrearsDemand.getKey()), BigDecimal.ZERO, arrearsDemand.getValue().abs()));
                accountDetList.add(this.createAccDetailmap(PropertyTaxConstants.GLCODEMAP_FOR_TAX_PAYABLE.get(arrearsDemand.getKey()), arrearsDemand.getValue().abs(), BigDecimal.ZERO));
            }
            for (Map.Entry<String, BigDecimal> currentDemand : currentDemandMap.entrySet()) {
                if (currentDemand.getValue().compareTo(BigDecimal.ZERO) == 1) {
                    accountDetList.add(this.createAccDetailmap(PropertyTaxConstants.GLCODEMAP_FOR_CURRENTTAX.get(currentDemand.getKey()), currentDemand.getValue().abs(), BigDecimal.ZERO));
                    accountDetList.add(this.createAccDetailmap(PropertyTaxConstants.GLCODEMAP_FOR_TAX_PAYABLE.get(currentDemand.getKey()), BigDecimal.ZERO, currentDemand.getValue().abs()));
                    continue;
                }
                if (currentDemand.getValue().compareTo(BigDecimal.ZERO) != -1) continue;
                if (currentDemand.getKey().equalsIgnoreCase("ADVANCE")) {
                    accountDetList.add(this.createAccDetailmap("3504102", BigDecimal.ZERO, currentDemand.getValue().abs()));
                    accountDetList.add(this.createAccDetailmap("3504102", currentDemand.getValue().abs(), BigDecimal.ZERO));
                    continue;
                }
                accountDetList.add(this.createAccDetailmap(PropertyTaxConstants.GLCODEMAP_FOR_CURRENTTAX.get(currentDemand.getKey()), BigDecimal.ZERO, currentDemand.getValue().abs()));
                accountDetList.add(this.createAccDetailmap(PropertyTaxConstants.GLCODEMAP_FOR_TAX_PAYABLE.get(currentDemand.getKey()), currentDemand.getValue().abs(), BigDecimal.ZERO));
            }
            CVoucherHeader cvh = this.createVoucher.createVoucher(headerdetails, accountDetList, new ArrayList());
            if (cvh == null) {
                LOGGER.error((Object)"Voucher Creation failed. CVoucherHeader is null.");
                throw new ApplicationRuntimeException("Voucher Creation failed.");
            }
            LOGGER.info((Object)("createVoucherForPTIS(): Voucher is created for PTIS with the voucher number : " + cvh.getVoucherNumber()));
        }
        catch (Throwable t) {
            LOGGER.error((Object)t.getMessage(), t);
            throw new ApplicationRuntimeException("Unable to create a voucher.", t);
        }
    }

    private HashMap<String, Object> createAccDetailmap(String glcode, BigDecimal debitAmount, BigDecimal creditAmount) {
        HashMap<String, Object> accountdetailmap = new HashMap<String, Object>();
        accountdetailmap.put("glcode", glcode);
        accountdetailmap.put("debitamount", debitAmount);
        accountdetailmap.put("creditamount", creditAmount);
        accountdetailmap.put("functioncode", this.getFunctionaryCode());
        return accountdetailmap;
    }

    private HashMap<String, Object> createHeaderDetails(String indexNumber, String transaction) {
        SimpleDateFormat sdf = new SimpleDateFormat("MMM-dd-yyyy HH:mm:ss");
        String description = "PTIS / " + indexNumber + " / " + transaction + " / " + sdf.format(new Date());
        String sourceURL = URL_FOR_DCB + indexNumber;
        HashMap<String, Object> headerdetails = new HashMap<String, Object>();
        headerdetails.put("vouchername", VOUCHERNAME);
        headerdetails.put("vouchertype", VOUCHERTYPE);
        headerdetails.put("description", description);
        headerdetails.put("vouchernumber", "vouchernumber");
        headerdetails.put("voucherdate", new Date());
        headerdetails.put("status", 0);
        headerdetails.put("moduleid", "2");
        headerdetails.put("departmentcode", "DEPARTMENT_CODE");
        headerdetails.put("fundcode", this.getFundCode());
        headerdetails.put("sourcepath", sourceURL);
        return headerdetails;
    }

    private Map<String, Map<String, BigDecimal>> prepareDemandForGlcode(Map<Installment, Map<String, BigDecimal>> amounts) {
        Module module = this.moduleDao.getModuleByName("Property Tax");
        Installment currentInstall = this.installmentDao.getInsatllmentByModuleForGivenDate(module, new Date());
        HashMap<String, Map<String, BigDecimal>> demandForGlcode = new HashMap<String, Map<String, BigDecimal>>();
        HashMap<String, BigDecimal> arrearsDemand = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> currentDemand = new HashMap<String, BigDecimal>();
        BigDecimal taxAmount = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        String demandReason = "";
        for (Map.Entry<Installment, Map<String, BigDecimal>> amountsRecord : amounts.entrySet()) {
            String instDesc = amountsRecord.getKey().getDescription();
            Map<String, BigDecimal> demandReasonMap = amountsRecord.getValue();
            if (!instDesc.equalsIgnoreCase(currentInstall.toString())) {
                for (Map.Entry<String, BigDecimal> demandReasonRecord : demandReasonMap.entrySet()) {
                    demandReason = demandReasonRecord.getKey();
                    amount = demandReasonRecord.getValue();
                    taxAmount = BigDecimal.ZERO;
                    if (arrearsDemand.get(demandReason) == null) {
                        arrearsDemand.put(demandReason, amount);
                        continue;
                    }
                    taxAmount = (BigDecimal)arrearsDemand.get(demandReason);
                    arrearsDemand.put(demandReason, taxAmount.add(amount));
                }
                continue;
            }
            for (Map.Entry<String, BigDecimal> demandReasonRecord : demandReasonMap.entrySet()) {
                demandReason = demandReasonRecord.getKey();
                amount = demandReasonRecord.getValue();
                taxAmount = BigDecimal.ZERO;
                if (currentDemand.get(demandReason) == null) {
                    currentDemand.put(demandReason, amount);
                    continue;
                }
                taxAmount = (BigDecimal)currentDemand.get(demandReason);
                currentDemand.put(demandReason, taxAmount.add(amount));
            }
        }
        demandForGlcode.put("ARREARS_DEMAND", arrearsDemand);
        demandForGlcode.put("CURRENT_DEMAND", currentDemand);
        return demandForGlcode;
    }

    public BigDecimal getFunctionaryCode() {
        return new BigDecimal(this.propertyTaxCommonUtil.getAppConfigValue("FUNCTIONARY_CODE", "Property Tax"));
    }

    public String getFundCode() {
        return new String(this.propertyTaxCommonUtil.getAppConfigValue("FUND_CODE", "Property Tax"));
    }

    public String getFundSourceCode() {
        return new String(this.propertyTaxCommonUtil.getAppConfigValue("FUND_SOURCE_CODE", "Property Tax"));
    }

    public String getDepartmentCode() {
        return new String(this.propertyTaxCommonUtil.getAppConfigValue("DEPARTMENT_CODE", "Property Tax"));
    }

    public String getFunctionCode() {
        return new String(this.propertyTaxCommonUtil.getAppConfigValue("FUNCTION_CODE", "Property Tax"));
    }
}

