/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.client.model;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgdmCollectedReceipt;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.MoneyUtils;
import org.egov.infra.utils.NumberToWord;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.model.calculator.TaxCalculationInfo;
import org.egov.ptis.domain.model.calculator.UnitTaxCalculationInfo;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

public class PropertyBillInfo {
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;
    private Map<String, Map<String, BigDecimal>> reasonwiseDues;
    private BasicProperty basicProperty;
    private String billNo;
    private int isCentralGovtProp = 0;
    private String arrearsPeriod;
    private String currentPeriod;
    private TaxCalculationInfo taxCalcInfo;
    private BigDecimal currentGeneralTax;
    private BigDecimal currentEduCess;
    private BigDecimal currentLibCess;
    private BigDecimal currentUnauthPenalty;
    private String firstSixMonthsPeriod;
    private String secondSixMonthsPeriod;
    private Installment currentInstallment;

    public PropertyBillInfo() {
    }

    public PropertyBillInfo(Map<String, Map<String, BigDecimal>> reasonwiseDues, BasicProperty basicProperty, String billNo) {
        this.reasonwiseDues = reasonwiseDues;
        this.basicProperty = basicProperty;
        this.billNo = billNo;
        String propType = this.getBasicProperty().getProperty().getPropertyDetail().getPropertyTypeMaster().getType();
        if (propType != null && "CENTRAL_GOVT_50".equals(propType)) {
            this.isCentralGovtProp = 1;
        }
        this.currentInstallment = this.propertyTaxCommonUtils.getCurrentInstallment();
        for (Ptdemand ptDemand : basicProperty.getProperty().getPtDemandSet()) {
            if (!ptDemand.getEgInstallmentMaster().equals((Object)this.currentInstallment)) continue;
            this.taxCalcInfo = new PropertyTaxUtil().getTaxCalInfo(ptDemand);
            break;
        }
        this.setCurrentHalfYearTaxes();
    }

    private void setCurrentHalfYearTaxes() {
        BigDecimal[] halfYearTaxes = new BigDecimal[2];
        halfYearTaxes = this.getHalfYearTaxes(this.reasonwiseDues.get("CURRENT").get("GEN_TAX"));
        this.currentGeneralTax = halfYearTaxes[0];
        halfYearTaxes = this.getHalfYearTaxes(this.reasonwiseDues.get("CURRENT").get("EDU_CESS"));
        this.currentEduCess = halfYearTaxes[0];
        halfYearTaxes = this.getHalfYearTaxes(this.reasonwiseDues.get("CURRENT").get("LIB_CESS"));
        this.currentLibCess = halfYearTaxes[0];
        halfYearTaxes = this.getHalfYearTaxes(this.reasonwiseDues.get("CURRENT").get("UNAUTH_PENALTY"));
        this.currentUnauthPenalty = halfYearTaxes[0];
    }

    private BigDecimal[] getHalfYearTaxes(BigDecimal taxForYear) {
        BigDecimal[] returnValue = new BigDecimal[2];
        BigDecimal rnddTaxForYear = taxForYear.setScale(2, 4);
        long[] weights = new long[]{50L, 50L};
        if (this.isEven(rnddTaxForYear, 2).booleanValue()) {
            returnValue[0] = rnddTaxForYear.divide(new BigDecimal(2)).setScale(2);
            returnValue[1] = rnddTaxForYear.divide(new BigDecimal(2)).setScale(2);
        } else {
            returnValue = MoneyUtils.allocate((BigDecimal)rnddTaxForYear, (long[])weights);
        }
        return returnValue;
    }

    public String getWardNo() {
        return this.getBasicProperty().getPropertyID().getWard().getBoundaryNum().toString();
    }

    public String getHouseNo() {
        return this.getBasicProperty().getAddress().getHouseNoBldgApt();
    }

    public String getIndexNo() {
        return this.getBasicProperty().getUpicNo();
    }

    public String getName() {
        return this.basicProperty.getFullOwnerName();
    }

    public BigDecimal getArrGeneralTax() {
        return this.reasonwiseDues.get("ARREARS").get("GEN_TAX").setScale(2);
    }

    public BigDecimal getArrEduCess() {
        return this.reasonwiseDues.get("ARREARS").get("EDU_CESS").setScale(2);
    }

    public BigDecimal getArrLibCess() {
        return this.reasonwiseDues.get("ARREARS").get("LIB_CESS").setScale(2);
    }

    public BigDecimal getArrCurrentUnauthPenalty() {
        return this.reasonwiseDues.get("ARREARS").get("UNAUTH_PENALTY").setScale(2);
    }

    public BigDecimal getCurrGeneralTax() {
        return this.reasonwiseDues.get("CURRENT").get("GEN_TAX").setScale(2);
    }

    public BigDecimal getCurrEduCess() {
        return this.reasonwiseDues.get("CURRENT").get("EDU_CESS").setScale(2);
    }

    public BigDecimal getCurrLibCess() {
        return this.reasonwiseDues.get("CURRENT").get("LIB_CESS").setScale(2);
    }

    public BigDecimal getCurrentUnauthPenalty() {
        return this.reasonwiseDues.get("CURRENT").get("UNAUTH_PENALTY").setScale(2);
    }

    public BigDecimal getGrandTotal() {
        BigDecimal sumOfArrCurr = BigDecimal.ZERO;
        for (String typeOfDue : this.reasonwiseDues.keySet()) {
            for (String dmdReason : this.reasonwiseDues.get(typeOfDue).keySet()) {
                sumOfArrCurr = sumOfArrCurr.add(this.reasonwiseDues.get(typeOfDue).get(dmdReason));
            }
        }
        return sumOfArrCurr.setScale(2, 4);
    }

    public String getTotalAmntInWords() {
        return NumberToWord.amountInWords((Double)this.getGrandTotal().doubleValue());
    }

    public Map<String, Map<String, BigDecimal>> getReasonwiseDues() {
        return this.reasonwiseDues;
    }

    public void setReasonwiseDues(Map<String, Map<String, BigDecimal>> reasonwiseDues) {
        this.reasonwiseDues = reasonwiseDues;
    }

    public String getBillDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        return dateFormat.format(new Date());
    }

    public String getBillDueDate() {
        Date billDate;
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        try {
            billDate = dateFormat.parse(this.getBillDate());
        }
        catch (ParseException e) {
            throw new ApplicationRuntimeException("Error in Bill due date", (Throwable)e);
        }
        Calendar billDueDate = Calendar.getInstance();
        billDueDate.setTime(billDate);
        billDueDate.add(5, 15);
        return dateFormat.format(billDueDate.getTime()).toString();
    }

    public String getWaterMeterStatus() {
        String waterRateCode = this.basicProperty.getProperty().getPropertyDetail().getWater_Meter_Num();
        return PropertyTaxConstants.waterRates.get(waterRateCode) == null ? "N/A" : PropertyTaxConstants.waterRates.get(waterRateCode);
    }

    public String getLastPayDate() {
        EgdmCollectedReceipt lastCollectedReceipt = this.getLastCollectedReceipt();
        if (lastCollectedReceipt != null) {
            SimpleDateFormat sf = new SimpleDateFormat("dd/MM/yyyy");
            return sf.format(lastCollectedReceipt.getReceiptDate());
        }
        return null;
    }

    public BigDecimal getAmount() {
        EgdmCollectedReceipt lastCollectedReceipt = this.getLastCollectedReceipt();
        if (lastCollectedReceipt != null) {
            return lastCollectedReceipt.getAmount();
        }
        return null;
    }

    public String getAssessmentDate() {
        SimpleDateFormat sf = new SimpleDateFormat("dd/MM/yyyy");
        return sf.format(this.basicProperty.getProperty().getCreatedDate());
    }

    public EgdmCollectedReceipt getLastCollectedReceipt() {
        Ptdemand egDemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(this.basicProperty.getProperty());
        Date lastPayDate = null;
        Date newDate = null;
        EgdmCollectedReceipt lastColReceipt = null;
        for (EgDemandDetails dmdDet : egDemand.getEgDemandDetails()) {
            for (EgdmCollectedReceipt colRec : dmdDet.getEgdmCollectedReceipts()) {
                if (lastPayDate != null) {
                    newDate = colRec.getReceiptDate();
                    if (newDate.compareTo(lastPayDate) != 1) continue;
                    lastColReceipt = colRec;
                    lastPayDate = newDate;
                    continue;
                }
                lastColReceipt = colRec;
                lastPayDate = colRec.getReceiptDate();
            }
        }
        return lastColReceipt;
    }

    private Boolean isEven(BigDecimal decimal, int precision) {
        BigDecimal tempValue = decimal;
        int i = 0;
        while (++i <= precision) {
            tempValue = tempValue.multiply(new BigDecimal(10));
        }
        return (tempValue.intValue() & 1) == 0;
    }

    public BasicProperty getBasicProperty() {
        return this.basicProperty;
    }

    public void setBasicProperty(BasicProperty basicProperty) {
        this.basicProperty = basicProperty;
    }

    public String getBillNo() {
        return this.billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public String getArea() {
        return this.getBasicProperty().getPropertyID().getArea().getName();
    }

    public String getPropertyType() {
        return this.getBasicProperty().getProperty().getPropertyDetail().getPropertyTypeMaster().getType();
    }

    public int getIsCentralGovtProp() {
        return this.isCentralGovtProp;
    }

    public void setIsCentralGovtProp(int isCentralGovtProp) {
        this.isCentralGovtProp = isCentralGovtProp;
    }

    public String getArrearsPeriod() {
        return this.arrearsPeriod;
    }

    public void setArrearsPeriod(String arrearsPeriod) {
        this.arrearsPeriod = arrearsPeriod;
    }

    public String getCurrentPeriod() {
        return this.currentPeriod;
    }

    public void setCurrentPeriod(String currentPeriod) {
        this.currentPeriod = currentPeriod;
    }

    public BigDecimal getResidentialALV() {
        BigDecimal resALVTotal = BigDecimal.ZERO;
        if (this.taxCalcInfo != null) {
            String propType = this.taxCalcInfo.getPropertyType();
            if (propType.equals("PRIVATE")) {
                return this.taxCalcInfo.getTotalNetARV();
            }
            resALVTotal = this.sumALVOnUnitUsage("C1, D1, D2, E1, E2, E3");
        }
        return resALVTotal.setScale(2);
    }

    public BigDecimal getNonResidentialALV() {
        BigDecimal nonResALVTotal = BigDecimal.ZERO;
        if (this.taxCalcInfo != null) {
            String propType = this.taxCalcInfo.getPropertyType();
            if (propType.equals("PRIVATE")) {
                return this.taxCalcInfo.getTotalNetARV();
            }
            nonResALVTotal = this.sumALVOnUnitUsage("A1, A2, A3, A4, A5, A6, B1, B2, C2, C3, C4");
        }
        return nonResALVTotal.setScale(2);
    }

    private BigDecimal sumALVOnUnitUsage(String usages) {
        BigDecimal totalALV = BigDecimal.ZERO;
        if (this.taxCalcInfo.getUnitTaxCalculationInfos().get(0) instanceof List) {
            for (UnitTaxCalculationInfo unitTaxInfo : this.taxCalcInfo.getUnitTaxCalculationInfos()) {
                if (!usages.contains(unitTaxInfo.getUnitUsage())) continue;
                totalALV = totalALV.add(unitTaxInfo.getNetARV());
            }
        } else {
            for (int i = 0; i < this.taxCalcInfo.getUnitTaxCalculationInfos().size(); ++i) {
                UnitTaxCalculationInfo unitTax = this.taxCalcInfo.getUnitTaxCalculationInfos().get(i);
                if (!usages.contains(unitTax.getUnitUsage())) continue;
                totalALV = totalALV.add(unitTax.getNetARV());
            }
        }
        return totalALV;
    }

    public BigDecimal getOpenPlotALV() {
        BigDecimal openPlotTotalALV = BigDecimal.ZERO;
        if (this.taxCalcInfo != null) {
            String propType = this.taxCalcInfo.getPropertyType();
            openPlotTotalALV = !propType.equals("VAC_LAND") ? this.sumALVOnUnitUsage("C5, D3, E4") : this.taxCalcInfo.getTotalNetARV();
        }
        return openPlotTotalALV.setScale(2);
    }

    public String getMailingAddress() {
        return this.basicProperty.getAddress().toString();
    }

    public BigDecimal getArrearsPenalty() {
        return this.reasonwiseDues.get("ARREARS").get("PENALTY_FINES");
    }

    public BigDecimal getCurrentPenalty() {
        return this.reasonwiseDues.get("CURRENT").get("PENALTY_FINES");
    }

    public BigDecimal getTotalPenalty() {
        return this.getArrearsPenalty().add(this.getCurrentPenalty()).setScale(2);
    }

    public String getFirstSixMonthsPeriod() {
        return this.firstSixMonthsPeriod;
    }

    public void setFirstSixMonthsPeriod(String firstSixMonthsPeriod) {
        this.firstSixMonthsPeriod = firstSixMonthsPeriod;
    }

    public String getSecondSixMonthsPeriod() {
        return this.secondSixMonthsPeriod;
    }

    public void setSecondSixMonthsPeriod(String secondSixMonthsPeriod) {
        this.secondSixMonthsPeriod = secondSixMonthsPeriod;
    }

    public String getFinancialYear() {
        DateTime fromDate = new DateTime((Object)this.currentInstallment.getFromDate());
        DateTime toDate = new DateTime((Object)this.currentInstallment.getToDate());
        return fromDate.getYear() + "-" + toDate.getYear();
    }
}

