/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.repository.dashboard;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.ptis.config.PTISApplicationProperties;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class RevenueDashboardRepository {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PTISApplicationProperties ptisApplicationProperties;

    private Session getSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<Map<String, Object>> getRevenueZonewisePerformance() {
        List overallData = this.getQuery("revenue.ptis.zonewise.overall.performance").list();
        HashMap revenueDataHolder = new HashMap();
        for (Object revenueObj : overallData) {
            HashMap<String, Object> revnData = new HashMap<String, Object>();
            revnData.put("zone", String.valueOf(revenueObj[0]));
            BigDecimal collectionPerc = (BigDecimal)revenueObj[1];
            revnData.put("collectionPerc", collectionPerc != null ? Double.valueOf(collectionPerc.doubleValue()) : "0");
            revenueDataHolder.put(String.valueOf(revenueObj[0]), revnData);
        }
        List monthlyData = this.getQuery("revenue.ptis.zonewise.monthly.performance").list();
        for (Object[] revenuData : monthlyData) {
            Map revnData = (Map)revenueDataHolder.get(String.valueOf(revenuData[0]));
            BigDecimal amtTargeted = (BigDecimal)revenuData[1];
            revnData.put("amtTargeted", amtTargeted != null ? Double.valueOf(amtTargeted.doubleValue()) : "0");
            BigDecimal amt_collectd = (BigDecimal)revenuData[2];
            revnData.put("amt_collectd", amt_collectd != null ? Double.valueOf(amt_collectd.doubleValue()) : "0");
            BigDecimal percCollections = (BigDecimal)revenuData[3];
            revnData.put("percCollections", percCollections != null ? Double.valueOf(percCollections.setScale(2, RoundingMode.CEILING).doubleValue()) : "0");
        }
        ArrayList<Map<String, Object>> revenueAggrData = new ArrayList<Map<String, Object>>(revenueDataHolder.values());
        RevenueDashboardRepository.sortData(revenueAggrData, "percCollections");
        RevenueDashboardRepository.assignRank(revenueAggrData, "rank");
        RevenueDashboardRepository.sortData(revenueAggrData, "collectionPerc");
        RevenueDashboardRepository.assignRank(revenueAggrData, "overallrank");
        return revenueAggrData;
    }

    public Map<String, Object> getRevenueZonewiseBar() {
        List overAllData = this.getQuery("revenue.ptis.zonewise.overall.performance").list();
        DecimalFormat df = new DecimalFormat("####0.00");
        LinkedList<Map<String, Object>> overAllDataHolder = new LinkedList<Map<String, Object>>();
        HashMap<String, BigDecimal> overallCollPercHolder = new HashMap<String, BigDecimal>();
        for (Object[] revenueObj : overAllData) {
            HashMap<String, String> revnOverAllData = new HashMap<String, String>();
            revnOverAllData.put("name", String.valueOf(revenueObj[0]));
            BigDecimal collectionPerc = (BigDecimal)revenueObj[1];
            overallCollPercHolder.put(String.valueOf(revenueObj[0]), collectionPerc != null ? collectionPerc : BigDecimal.ZERO);
            revnOverAllData.put("y", (String)((Object)(collectionPerc != null ? new BigDecimal(df.format(collectionPerc.doubleValue())) : Integer.valueOf(0))));
            overAllDataHolder.add((Map<String, Object>)revnOverAllData);
        }
        List monthlyData = this.getQuery("revenue.ptis.zonewise.monthly.performance").list();
        LinkedList<Map<String, Object>> monthlyDataHolder = new LinkedList<Map<String, Object>>();
        for (Object[] revenueObj : monthlyData) {
            HashMap<String, Object> revnMonthlyData = new HashMap<String, Object>();
            revnMonthlyData.put("name", String.valueOf(revenueObj[0]));
            BigDecimal mnthlyCollectionPerc = (BigDecimal)revenueObj[3];
            revnMonthlyData.put("y", mnthlyCollectionPerc != null ? new BigDecimal(df.format(mnthlyCollectionPerc.doubleValue())) : Integer.valueOf(0));
            revnMonthlyData.put("overAllPerc", new BigDecimal(df.format(((BigDecimal)overallCollPercHolder.get(String.valueOf(revenueObj[0]))).doubleValue())));
            monthlyDataHolder.add(revnMonthlyData);
        }
        RevenueDashboardRepository.sortData(monthlyDataHolder, "y");
        RevenueDashboardRepository.sortData(overAllDataHolder, "y");
        RevenueDashboardRepository.sortData(monthlyDataHolder, "overAllPerc");
        HashMap<String, Object> revenueAggrData = new HashMap<String, Object>();
        revenueAggrData.put("overallPerc", overAllDataHolder);
        revenueAggrData.put("monthlyPerc", monthlyDataHolder);
        return revenueAggrData;
    }

    public List<Map<String, Object>> getWardwisePerformanceTab(String zoneName) {
        SQLQuery overAllQry = this.getQuery("revenue.ptis.wardwise.overall.performance");
        overAllQry.setParameter("zoneName", (Object)zoneName);
        List overAllData = overAllQry.list();
        HashMap<String, Object> revenueDataHolder = new HashMap<String, Object>();
        for (Object[] revenueObj : overAllData) {
            HashMap<String, String> revnData = new HashMap<String, String>();
            revnData.put("ward", String.valueOf(revenueObj[0]));
            BigDecimal collectionPerc = (BigDecimal)revenueObj[2];
            revnData.put("collectionPerc", (String)(collectionPerc != null ? Double.valueOf(collectionPerc.doubleValue()) : "0"));
            revenueDataHolder.put(String.valueOf(revenueObj[0]), revnData);
        }
        SQLQuery monthlyQry = this.getQuery("revenue.ptis.wardwise.monthly.performance");
        monthlyQry.setParameter("zoneName", (Object)zoneName);
        List monthlyData = monthlyQry.list();
        for (Object[] revenueObj : monthlyData) {
            Map revnData = (Map)revenueDataHolder.get(String.valueOf(revenueObj[0]));
            BigDecimal amtTargeted = (BigDecimal)revenueObj[1];
            revnData.put("amtTargeted", amtTargeted != null ? Double.valueOf(amtTargeted.doubleValue()) : "0");
            BigDecimal amt_collectd = (BigDecimal)revenueObj[2];
            revnData.put("amt_collectd", amt_collectd != null ? Double.valueOf(amt_collectd.doubleValue()) : "0");
            BigDecimal percCollections = (BigDecimal)revenueObj[3];
            revnData.put("percCollections", percCollections != null ? Double.valueOf(percCollections.setScale(2, RoundingMode.CEILING).doubleValue()) : "0");
        }
        ArrayList<Map<String, Object>> revenueAggrData = new ArrayList<Map<String, Object>>(revenueDataHolder.values());
        RevenueDashboardRepository.sortData(revenueAggrData, "percCollections");
        RevenueDashboardRepository.assignRank(revenueAggrData, "rank");
        RevenueDashboardRepository.sortData(revenueAggrData, "collectionPerc");
        RevenueDashboardRepository.assignRank(revenueAggrData, "overallrank");
        return revenueAggrData;
    }

    public List<Map<String, Object>> revenueTrendForTheWeek() {
        SQLQuery qry = this.getQuery("revenue.ptis.collectiontrend");
        DateTime currentDate = new DateTime();
        qry.setParameter("fromDate", (Object)DateUtils.startOfGivenDate((DateTime)currentDate.minusDays(6)).toDate());
        qry.setParameter("toDate", (Object)DateUtils.endOfGivenDate((DateTime)currentDate).toDate());
        List revenueData = qry.list();
        List<Map<String, Object>> currentYearTillDays = RevenueDashboardRepository.constructDayPlaceHolder(currentDate.minusDays(6), currentDate, "E-dd", "EEEE, dd MMM yyyy");
        for (Object[] revnueObj : revenueData) {
            for (Map<String, Object> mapdata : currentYearTillDays) {
                if (!mapdata.containsValue(StringUtils.capitalize((String)String.valueOf(revnueObj[0]).toLowerCase()))) continue;
                mapdata.put("y", Double.valueOf(String.valueOf(revnueObj[1])));
            }
        }
        return currentYearTillDays;
    }

    public Map<String, Collection<Double>> targetVsAchieved() {
        DateTime currentDate = new DateTime();
        List targets = this.getQuery("revenue.ptis.target").list();
        List finyear = this.getCurrentFinYear().list();
        DateTime finYearStartDate = new DateTime(((Object[])finyear.get(0))[0]);
        DateTime finYearEndDate = new DateTime(((Object[])finyear.get(0))[1]);
        DateTime lastFinYearStartDate = finYearStartDate.minusMonths(12);
        DateTime lastFinYearEndDate = finYearEndDate.minusMonths(12);
        Map<String, Double> currentTarget = RevenueDashboardRepository.constructDatePlaceHolderForDouble(finYearStartDate, finYearEndDate, "MM-yyyy");
        Map<String, Double> cumilativeTarget = RevenueDashboardRepository.constructDatePlaceHolderForDouble(finYearStartDate, finYearEndDate, "MM-yyyy");
        for (Object[] target : targets) {
            currentTarget.put(String.valueOf(target[0]), Double.valueOf(String.valueOf(target[1])));
            cumilativeTarget.put(String.valueOf(target[0]), Double.valueOf(String.valueOf(target[2])));
        }
        Map<String, Double> currentAcheived = RevenueDashboardRepository.constructDatePlaceHolderForDouble(finYearStartDate, currentDate, "MM-yyyy");
        Map<String, Double> cumilativeAcheived = RevenueDashboardRepository.constructDatePlaceHolderForDouble(finYearStartDate, currentDate, "MM-yyyy");
        List achieved = this.getQuery("revenue.ptis.achieved").list();
        for (Object[] achieve : achieved) {
            currentAcheived.put(String.valueOf(achieve[0]), Double.valueOf(String.valueOf(achieve[1])));
            cumilativeAcheived.put(String.valueOf(achieve[0]), Double.valueOf(String.valueOf(achieve[2])));
        }
        Map<String, Double> lastAcheived = RevenueDashboardRepository.constructDatePlaceHolderForDouble(lastFinYearStartDate, lastFinYearEndDate, "MM-yyyy");
        Map<String, Double> lastcumilativeAcheived = RevenueDashboardRepository.constructDatePlaceHolderForDouble(lastFinYearStartDate, lastFinYearEndDate, "MM-yyyy");
        SQLQuery qry = this.getQuery("revenue.ptis.last.achieved");
        qry.setParameter("finStartDate", (Object)DateUtils.startOfGivenDate((DateTime)lastFinYearStartDate).toDate());
        qry.setParameter("finEndDate", (Object)DateUtils.startOfGivenDate((DateTime)lastFinYearEndDate).toDate());
        List lastAchieved = qry.list();
        for (Object[] lastachieved : lastAchieved) {
            lastAcheived.put(String.valueOf(lastachieved[0]), Double.valueOf(String.valueOf(lastachieved[1])));
            lastcumilativeAcheived.put(String.valueOf(lastachieved[0]), Double.valueOf(String.valueOf(lastachieved[2])));
        }
        HashMap<String, Collection<Double>> targetVsAchieved = new HashMap<String, Collection<Double>>();
        targetVsAchieved.put("target", currentTarget.values());
        targetVsAchieved.put("achieved", currentAcheived.values());
        targetVsAchieved.put("lastAcheived", lastAcheived.values());
        targetVsAchieved.put("cumilativetarget", cumilativeTarget.values());
        targetVsAchieved.put("cumilativeachieved", cumilativeAcheived.values());
        targetVsAchieved.put("lastcumilativeachieved", lastcumilativeAcheived.values());
        return targetVsAchieved;
    }

    public Map<String, Object> collectionsPaymentMode() {
        List typeCollection = this.getQuery("revenue.ptis.collecion.payment.type").list();
        BigDecimal totalTransactions = BigDecimal.valueOf((Double)this.getQuery("revenue.ptis.collecion.total").uniqueResult());
        DecimalFormat df = new DecimalFormat("####0.00");
        LinkedList<Map<String, Object>> overAllCollHolder = new LinkedList<Map<String, Object>>();
        HashMap<String, Object> overallCollPercHolder = new HashMap<String, Object>();
        for (Object[] collObj : typeCollection) {
            HashMap<String, Object> collPaymentType = new HashMap<String, Object>();
            collPaymentType.put("name", String.valueOf(collObj[0]));
            Object collectionPerc = collObj[1] != null ? new BigDecimal(collObj[1].toString()) : BigDecimal.ZERO;
            collectionPerc = ((BigDecimal)collectionPerc).multiply(BigDecimal.valueOf(100L)).divide(totalTransactions, 2, RoundingMode.HALF_UP);
            overallCollPercHolder.put(String.valueOf(collObj[0]), collectionPerc != null ? collectionPerc : BigDecimal.ZERO);
            collPaymentType.put("y", collectionPerc != null ? new BigDecimal(df.format(((BigDecimal)collectionPerc).doubleValue())) : Integer.valueOf(0));
            overAllCollHolder.add(collPaymentType);
        }
        List totalNoTransactions = this.getQuery("revenue.ptis.collecion.total.type").list();
        LinkedList<Map<String, Object>> totalPercTrans = new LinkedList<Map<String, Object>>();
        BigDecimal totalCount = new BigDecimal(this.getQuery("revenue.ptis.collecion.total.count").uniqueResult().toString());
        for (Object[] revenueObj : totalNoTransactions) {
            HashMap<String, Object> revnTotalTransData = new HashMap<String, Object>();
            revnTotalTransData.put("name", String.valueOf(revenueObj[0]));
            BigDecimal numberTransactions = revenueObj[1] != null ? new BigDecimal(revenueObj[1].toString()) : BigDecimal.ZERO;
            numberTransactions = numberTransactions.multiply(BigDecimal.valueOf(100L)).divide(totalCount, 2, RoundingMode.HALF_UP);
            revnTotalTransData.put("y", numberTransactions != null ? new BigDecimal(df.format(numberTransactions.doubleValue())) : Integer.valueOf(0));
            revnTotalTransData.put("overAllPerc", new BigDecimal(df.format(((BigDecimal)overallCollPercHolder.get(String.valueOf(revenueObj[0]))).doubleValue())));
            totalPercTrans.add(revnTotalTransData);
        }
        RevenueDashboardRepository.sortData(totalPercTrans, "y");
        RevenueDashboardRepository.sortData(overAllCollHolder, "y");
        RevenueDashboardRepository.sortData(totalPercTrans, "overAllPerc");
        HashMap<String, Object> revenueAggrData = new HashMap<String, Object>();
        revenueAggrData.put("overallColl", overAllCollHolder);
        revenueAggrData.put("totalTransPerc", totalPercTrans);
        return revenueAggrData;
    }

    public Map<String, Object> coverageEfficiency() {
        List overallData = this.getQuery("revenue.ptis.coverage.efficiency").list();
        HashMap coverageDataHolder = new HashMap();
        for (Object[] revenueObj : overallData) {
            HashMap<String, Object> revnData = new HashMap<String, Object>();
            revnData.put("name", String.valueOf(revenueObj[0]));
            BigDecimal noOfProps = revenueObj[1] != null ? new BigDecimal(revenueObj[1].toString()) : BigDecimal.ZERO;
            revnData.put("noOfProps", noOfProps != null ? Double.valueOf(noOfProps.doubleValue()) : "0");
            BigDecimal noOfTaxProps = revenueObj[2] != null ? new BigDecimal(revenueObj[2].toString()) : BigDecimal.ZERO;
            revnData.put("noOfTaxProps", noOfTaxProps != null ? Double.valueOf(noOfTaxProps.doubleValue()) : "0");
            BigDecimal coverageEfficiency = (BigDecimal)revenueObj[3];
            revnData.put("y", coverageEfficiency != null ? Double.valueOf(coverageEfficiency.doubleValue()) : "0");
            coverageDataHolder.put(String.valueOf(revenueObj[0]), revnData);
        }
        ArrayList<Map<String, Object>> revenueCovEfficiency = new ArrayList<Map<String, Object>>(coverageDataHolder.values());
        RevenueDashboardRepository.sortData(revenueCovEfficiency, "y");
        HashMap<String, Object> revenueAggrData = new HashMap<String, Object>();
        revenueAggrData.put("overallCoverage", revenueCovEfficiency);
        return revenueAggrData;
    }

    public Map<String, Object> coverageEfficiencyWard(String zoneName) {
        SQLQuery overAllQry = this.getQuery("revenue.ptis.coverage.efficiency.ward");
        overAllQry.setParameter("zoneName", (Object)zoneName);
        List overAllData = overAllQry.list();
        HashMap coverageDataHolder = new HashMap();
        for (Object[] revenueObj : overAllData) {
            HashMap<String, Object> revnData = new HashMap<String, Object>();
            revnData.put("name", String.valueOf(revenueObj[0]));
            BigDecimal noOfProps = revenueObj[1] != null ? new BigDecimal(revenueObj[1].toString()) : BigDecimal.ZERO;
            revnData.put("noOfProps", noOfProps != null ? Double.valueOf(noOfProps.doubleValue()) : "0");
            BigDecimal noOfTaxProps = revenueObj[2] != null ? new BigDecimal(revenueObj[2].toString()) : BigDecimal.ZERO;
            revnData.put("noOfTaxProps", noOfTaxProps != null ? Double.valueOf(noOfTaxProps.doubleValue()) : "0");
            BigDecimal coverageEfficiency = revenueObj[3] != null ? new BigDecimal(revenueObj[3].toString()) : BigDecimal.ZERO;
            revnData.put("y", coverageEfficiency != null ? Double.valueOf(coverageEfficiency.doubleValue()) : "0");
            coverageDataHolder.put(String.valueOf(revenueObj[0]), revnData);
        }
        ArrayList<Map<String, Object>> revenueCovEfficiency = new ArrayList<Map<String, Object>>(coverageDataHolder.values());
        RevenueDashboardRepository.sortData(revenueCovEfficiency, "y");
        HashMap<String, Object> revenueAggrData = new HashMap<String, Object>();
        revenueAggrData.put("overallCoverage", revenueCovEfficiency);
        return revenueAggrData;
    }

    public Map<String, List<Object>> getAnnualZonewiseBar() {
        List annualData = this.getQuery("revenue.annual.performance").list();
        LinkedList dataholder1 = new LinkedList();
        LinkedList dataholder2 = new LinkedList();
        HashMap<String, List<Object>> revenueAggrData = new HashMap<String, List<Object>>();
        for (Object[] revenueObj : annualData) {
            LinkedHashMap<String, Object> targetData = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> actualData = new LinkedHashMap<String, Object>();
            targetData.put("name", String.valueOf(revenueObj[0]));
            actualData.put("name", String.valueOf(revenueObj[0]));
            BigDecimal targeted = (BigDecimal)revenueObj[1];
            BigDecimal actual = (BigDecimal)revenueObj[2];
            targetData.put("y", targeted != null ? Double.valueOf(targeted.doubleValue()) : "0");
            actualData.put("y", actual != null ? Double.valueOf(actual.doubleValue()) : "0");
            dataholder1.add(targetData);
            dataholder2.add(actualData);
        }
        revenueAggrData.put("targeted", dataholder1);
        revenueAggrData.put("actual", dataholder2);
        return revenueAggrData;
    }

    private static void sortData(List<Map<String, Object>> dataList, String key) {
        Collections.sort(dataList, (map1, map2) -> Double.valueOf(map1.get(key).toString()) <= Double.valueOf(map2.get(key).toString()) ? 1 : -1);
    }

    private static void assignRank(List<Map<String, Object>> dataList, String key) {
        int counter = 1;
        for (Map<String, Object> map : dataList) {
            map.put(key, counter++);
        }
    }

    private SQLQuery getQuery(String sqlKey) {
        return ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(this.ptisApplicationProperties.getValue(sqlKey));
    }

    public static Map<String, Double> constructDatePlaceHolderForDouble(DateTime startDate, DateTime endDate, String pattern) {
        LinkedHashMap<String, Double> currentYearTillDays = new LinkedHashMap<String, Double>();
        DateTime date = startDate;
        while (date.isBefore((ReadableInstant)endDate)) {
            currentYearTillDays.put(date.toString(pattern), 0.0);
            date = date.plusDays(1);
        }
        currentYearTillDays.put(endDate.toString(pattern), 0.0);
        return currentYearTillDays;
    }

    public static List<Map<String, Object>> constructDayPlaceHolder(DateTime startDate, DateTime endDate, String pattern, String toolTipPattern) {
        LinkedHashMap<String, Object> currentYearEndDays = new LinkedHashMap<String, Object>();
        LinkedList<Map<String, Object>> dataHolder = new LinkedList<Map<String, Object>>();
        DateTime date = startDate;
        while (date.isBefore((ReadableInstant)endDate)) {
            LinkedHashMap<String, Object> currentYearTillDays = new LinkedHashMap<String, Object>();
            currentYearTillDays.put("name", date.toString(pattern));
            currentYearTillDays.put("y", 0.0);
            currentYearTillDays.put("tooltipFormat", date.toString(toolTipPattern));
            dataHolder.add(currentYearTillDays);
            date = date.plusDays(1);
        }
        currentYearEndDays.put("name", endDate.toString(pattern));
        currentYearEndDays.put("y", 0.0);
        currentYearEndDays.put("tooltipFormat", endDate.toString(toolTipPattern));
        dataHolder.add(currentYearEndDays);
        return dataHolder;
    }

    protected SQLQuery getCurrentFinYear() {
        return this.getSession().createSQLQuery(this.ptisApplicationProperties.getValue("revenue.ptis.finyear"));
    }
}

