/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.service.property;

import com.sun.jersey.core.header.FormDataContentDisposition;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.services.CollectionIntegrationService;
import org.egov.commons.Area;
import org.egov.commons.Bank;
import org.egov.commons.Installment;
import org.egov.commons.dao.BankHibernateDAO;
import org.egov.dcb.bean.ChequePayment;
import org.egov.dcb.bean.Payment;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgDemandDetails;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.CrossHierarchy;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.entity.Address;
import org.egov.infra.persistence.entity.CorrespondenceAddress;
import org.egov.infra.persistence.entity.enums.Gender;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Position;
import org.egov.ptis.client.bill.PTBillServiceImpl;
import org.egov.ptis.client.integration.utils.CollectionHelper;
import org.egov.ptis.client.model.PenaltyAndRebate;
import org.egov.ptis.client.util.PropertyTaxNumberGenerator;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.bill.PropertyTaxBillable;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.dao.property.PropertyMutationDAO;
import org.egov.ptis.domain.dao.property.PropertyTypeMasterDAO;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.enums.TransactionType;
import org.egov.ptis.domain.entity.property.Apartment;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.BasicPropertyImpl;
import org.egov.ptis.domain.entity.property.BuiltUpProperty;
import org.egov.ptis.domain.entity.property.Document;
import org.egov.ptis.domain.entity.property.DocumentType;
import org.egov.ptis.domain.entity.property.Floor;
import org.egov.ptis.domain.entity.property.FloorType;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyAddress;
import org.egov.ptis.domain.entity.property.PropertyDetail;
import org.egov.ptis.domain.entity.property.PropertyDocs;
import org.egov.ptis.domain.entity.property.PropertyID;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.entity.property.PropertyMutationMaster;
import org.egov.ptis.domain.entity.property.PropertyOccupation;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.entity.property.PropertyStatus;
import org.egov.ptis.domain.entity.property.PropertyStatusValues;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.entity.property.PropertyUsage;
import org.egov.ptis.domain.entity.property.RoofType;
import org.egov.ptis.domain.entity.property.StructureClassification;
import org.egov.ptis.domain.entity.property.TaxExeptionReason;
import org.egov.ptis.domain.entity.property.VacantProperty;
import org.egov.ptis.domain.entity.property.WallType;
import org.egov.ptis.domain.entity.property.WoodType;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.BoundaryDetails;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.model.FloorDetails;
import org.egov.ptis.domain.model.LocalityDetails;
import org.egov.ptis.domain.model.MasterCodeNamePairDetails;
import org.egov.ptis.domain.model.NewPropertyDetails;
import org.egov.ptis.domain.model.OwnerDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.model.PayPropertyTaxDetails;
import org.egov.ptis.domain.model.PropertyDetails;
import org.egov.ptis.domain.model.PropertyTaxDetails;
import org.egov.ptis.domain.model.ReceiptDetails;
import org.egov.ptis.domain.model.RestAssessmentDetails;
import org.egov.ptis.domain.model.RestPropertyTaxDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyPersistenceService;
import org.egov.ptis.domain.service.property.PropertyService;
import org.egov.ptis.exceptions.TaxCalculatorExeption;
import org.egov.ptis.master.service.FloorTypeService;
import org.egov.ptis.master.service.RoofTypeService;
import org.egov.ptis.master.service.WallTypeService;
import org.egov.ptis.master.service.WoodTypeService;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.web.multipart.MultipartFile;

public class PropertyExternalService {
    private static final String ASSESSMENT = "Assessment";
    public static final Integer FLAG_MOBILE_EMAIL = 0;
    public static final Integer FLAG_TAX_DETAILS = 1;
    public static final Integer FLAG_FULL_DETAILS = 2;
    public static final int FLAG_NONE = 0;
    private BasicProperty basicProperty;
    private PropertyImpl property;
    private AssessmentDetails assessmentDetail;
    private RestAssessmentDetails assessmentDetails;
    private final List<File> uploads = new ArrayList<File>(0);
    private final List<String> uploadContentTypes = new ArrayList<String>(0);
    private final List<String> uploadFileNames = new ArrayList<String>(0);
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private ApplicationContext beanProvider;
    @Autowired
    private PropertyTaxNumberGenerator propertyTaxNumberGenerator;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private PTBillServiceImpl ptBillServiceImpl;
    @Autowired
    @Qualifier(value="propertyTaxBillable")
    private PropertyTaxBillable propertyTaxBillable;
    @Autowired
    private PropertyTypeMasterDAO propertyTypeMasterDAO;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private CollectionIntegrationService collectionService;
    @Autowired
    private PropertyPersistenceService basicPropertyService;
    @Autowired
    private BoundaryTypeService boundaryTypeService;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<PropertyImpl> propertyWorkflowService;
    @Autowired
    private UserService userService;
    @Autowired
    private BankHibernateDAO bankHibernateDAO;
    @Autowired
    private PropertyMutationDAO propertyMutationDAO;
    @Autowired
    private FloorTypeService floorTypeService;
    @Autowired
    private RoofTypeService roofTypeService;
    @Autowired
    private WallTypeService wallTypeService;
    @Autowired
    private WoodTypeService woodTypeService;

    public AssessmentDetails loadAssessmentDetails(String propertyId, Integer flag, BasicPropertyStatus status) {
        this.assessmentDetail = new AssessmentDetails();
        this.assessmentDetail.setPropertyID(propertyId);
        this.assessmentDetail.setFlag(flag);
        this.validate();
        this.initiateBasicProperty(status);
        if (this.basicProperty != null) {
            this.property = (PropertyImpl)this.basicProperty.getProperty();
            if (this.basicProperty.getLatitude() != null && this.basicProperty.getLongitude() != null) {
                this.assessmentDetail.setLatitude(this.basicProperty.getLatitude());
                this.assessmentDetail.setLongitude(this.basicProperty.getLongitude());
            }
            if (flag.equals(FLAG_MOBILE_EMAIL)) {
                this.loadPrimaryMobileAndEmail();
            }
            if (this.property != null) {
                PropertyDetails propertyDetails = new PropertyDetails();
                this.assessmentDetail.setPropertyDetails(propertyDetails);
                if (flag.equals(FLAG_FULL_DETAILS)) {
                    this.getAsssessmentDetails();
                    this.loadPropertyDues();
                }
                if (flag.equals(FLAG_TAX_DETAILS)) {
                    this.loadPropertyDues();
                }
                if (this.assessmentDetail.isExempted()) {
                    this.assessmentDetail.getPropertyDetails().setTaxDue(BigDecimal.ZERO);
                    this.assessmentDetail.getPropertyDetails().setCurrentTax(BigDecimal.ZERO);
                    this.assessmentDetail.getPropertyDetails().setArrearTax(BigDecimal.ZERO);
                }
            }
        }
        return this.assessmentDetail;
    }

    private void validate() {
        if (this.assessmentDetail.getPropertyID() == null || this.assessmentDetail.getPropertyID().trim().equals("")) {
            throw new ApplicationRuntimeException("PropertyID is null or empty!");
        }
        if (this.assessmentDetail.getFlag() == null || this.assessmentDetail.getFlag() > 3) {
            throw new ApplicationRuntimeException("Invalid Flag");
        }
    }

    private void initiateBasicProperty(BasicPropertyStatus status) {
        this.basicProperty = this.basicPropertyDAO.getAllBasicPropertyByPropertyID(this.assessmentDetail.getPropertyID());
        ErrorDetails errorDetails = new ErrorDetails();
        if (null != this.basicProperty) {
            this.assessmentDetail.setStatus(this.basicProperty.isActive());
            if (status.equals((Object)BasicPropertyStatus.ACTIVE)) {
                if (this.basicProperty.isActive().booleanValue()) {
                    this.checkStatusValues(this.basicProperty, errorDetails);
                } else {
                    errorDetails.setErrorCode("PTAX103");
                    errorDetails.setErrorMessage("Active property does not exists for the given assessment number");
                    this.assessmentDetail.setErrorDetails(errorDetails);
                }
            } else if (status.equals((Object)BasicPropertyStatus.INACTIVE)) {
                if (!this.basicProperty.isActive().booleanValue()) {
                    this.checkStatusValues(this.basicProperty, errorDetails);
                } else {
                    errorDetails.setErrorCode("PTAX104");
                    errorDetails.setErrorMessage("Property is not active for the given assessment number");
                    this.assessmentDetail.setErrorDetails(errorDetails);
                }
            } else {
                this.checkStatusValues(this.basicProperty, errorDetails);
            }
        } else {
            errorDetails.setErrorCode("PTAX100");
            errorDetails.setErrorMessage("Property with assessment no " + this.assessmentDetail.getPropertyID() + " does not exist");
        }
        this.assessmentDetail.setErrorDetails(errorDetails);
    }

    private void checkStatusValues(BasicProperty basicProperty, ErrorDetails errorDetails) {
        Set<PropertyStatusValues> statusValues = basicProperty.getPropertyStatusValuesSet();
        if (null != statusValues && !statusValues.isEmpty()) {
            for (PropertyStatusValues statusValue : statusValues) {
                if (statusValue.getPropertyStatus().getStatusCode() != "MARK_DEACTIVE") continue;
                errorDetails.setErrorCode("PTAX102");
                errorDetails.setErrorMessage("Property is marked for deactivation");
            }
        }
    }

    private void loadPrimaryMobileAndEmail() {
        User primaryOwner = this.basicProperty.getPrimaryOwner();
        this.assessmentDetail.setPrimaryEmail(primaryOwner.getEmailId());
        this.assessmentDetail.setPrimaryMobileNo(primaryOwner.getMobileNumber());
    }

    private void loadPropertyDues() {
        Map<String, BigDecimal> resultmap = this.ptDemandDAO.getDemandCollMap(this.property);
        if (null != resultmap && !resultmap.isEmpty()) {
            BigDecimal currDmd = resultmap.get("CURR_FIRSTHALF_DMD");
            BigDecimal arrDmd = resultmap.get("ARR_DMD");
            BigDecimal currCollection = resultmap.get("CURR_FIRSTHALF_COLL");
            BigDecimal arrColelection = resultmap.get("ARR_COLL");
            BigDecimal taxDue = currDmd.add(arrDmd).subtract(currCollection).subtract(arrColelection);
            this.assessmentDetail.getPropertyDetails().setTaxDue(taxDue);
            this.assessmentDetail.getPropertyDetails().setCurrentTax(currDmd);
            this.assessmentDetail.getPropertyDetails().setArrearTax(arrDmd);
        }
    }

    private void getAsssessmentDetails() {
        this.assessmentDetail.setBoundaryDetails(this.prepareBoundaryInfo(this.basicProperty));
        this.assessmentDetail.setHouseNo(this.basicProperty.getAddress().getHouseNoBldgApt());
        this.assessmentDetail.setPropertyAddress(this.basicProperty.getAddress().toString());
        if (null != this.property) {
            this.assessmentDetail.setOwnerNames(this.prepareOwnerInfo(this.property));
            this.assessmentDetail.setExempted(this.property.getIsExemptedFromTax());
            PropertyDetail propertyDetail = this.property.getPropertyDetail();
            if (null != propertyDetail) {
                this.assessmentDetail.getPropertyDetails().setPropertyType(propertyDetail.getPropertyTypeMaster().getType());
                if (propertyDetail.getPropertyUsage() != null) {
                    this.assessmentDetail.getPropertyDetails().setPropertyUsage(propertyDetail.getPropertyUsage().getUsageName());
                }
                if (null != propertyDetail.getNoofFloors()) {
                    this.assessmentDetail.getPropertyDetails().setNoOfFloors(propertyDetail.getNoofFloors());
                } else {
                    this.assessmentDetail.getPropertyDetails().setNoOfFloors(0);
                }
            }
        }
    }

    private BoundaryDetails prepareBoundaryInfo(BasicProperty basicProperty) {
        BoundaryDetails boundaryDetails = new BoundaryDetails();
        PropertyID propertyID = basicProperty.getPropertyID();
        if (null != propertyID) {
            if (null != propertyID.getZone()) {
                boundaryDetails.setZoneId(propertyID.getZone().getId());
                boundaryDetails.setZoneNumber(propertyID.getZone().getBoundaryNum());
                boundaryDetails.setZoneName(propertyID.getZone().getName());
                boundaryDetails.setZoneBoundaryType(propertyID.getZone().getBoundaryType().getName());
            }
            if (null != propertyID.getWard()) {
                boundaryDetails.setWardId(propertyID.getWard().getId());
                boundaryDetails.setWardNumber(propertyID.getWard().getBoundaryNum());
                boundaryDetails.setWardName(propertyID.getWard().getName());
                boundaryDetails.setWardBoundaryType(propertyID.getWard().getBoundaryType().getName());
            }
            if (null != propertyID.getElectionBoundary()) {
                boundaryDetails.setAdminWardId(propertyID.getElectionBoundary().getId());
                boundaryDetails.setAdminWardNumber(propertyID.getElectionBoundary().getBoundaryNum());
                boundaryDetails.setAdminWardName(propertyID.getElectionBoundary().getName());
                boundaryDetails.setAdminWardBoundaryType(propertyID.getElectionBoundary().getBoundaryType().getName());
            }
            if (null != propertyID.getArea()) {
                boundaryDetails.setBlockId(propertyID.getArea().getId());
                boundaryDetails.setBlockNumber(propertyID.getArea().getBoundaryNum());
                boundaryDetails.setBlockName(propertyID.getArea().getName());
            }
            if (null != propertyID.getLocality()) {
                boundaryDetails.setLocalityId(propertyID.getLocality().getId());
                boundaryDetails.setLocalityName(propertyID.getLocality().getName());
            }
            if (null != propertyID.getStreet()) {
                boundaryDetails.setStreetId(propertyID.getStreet().getId());
                boundaryDetails.setStreetName(propertyID.getStreet().getName());
            }
        }
        return boundaryDetails;
    }

    private Set<OwnerName> prepareOwnerInfo(Property property) {
        List<PropertyOwnerInfo> propertyOwners = property.getBasicProperty().getPropertyOwnerInfo();
        HashSet<OwnerName> ownerNames = new HashSet<OwnerName>(0);
        if (propertyOwners != null && !propertyOwners.isEmpty()) {
            for (PropertyOwnerInfo propertyOwner : propertyOwners) {
                OwnerName ownerName = new OwnerName();
                ownerName.setAadhaarNumber(propertyOwner.getOwner().getAadhaarNumber());
                ownerName.setOwnerName(propertyOwner.getOwner().getName());
                ownerName.setMobileNumber(propertyOwner.getOwner().getMobileNumber());
                ownerName.setEmailId(propertyOwner.getOwner().getEmailId());
                ownerNames.add(ownerName);
            }
        }
        return ownerNames;
    }

    public PropertyTaxDetails getPropertyTaxDetails(String assessmentNo, String category) {
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
        PropertyTaxDetails propertyTaxDetails = null;
        ErrorDetails errorDetails = new ErrorDetails();
        if (null != basicProperty) {
            Property property = basicProperty.getProperty();
            if (property != null && property.getIsExemptedFromTax().booleanValue()) {
                propertyTaxDetails = new PropertyTaxDetails();
                errorDetails.setErrorCode("PTAX105");
                errorDetails.setErrorMessage("Property is exempted");
                propertyTaxDetails.setErrorDetails(errorDetails);
            } else {
                propertyTaxDetails = this.getPropertyTaxDetails(basicProperty, category);
                if (propertyTaxDetails.getErrorDetails() == null) {
                    errorDetails.setErrorCode("PTIS-REST-0");
                    errorDetails.setErrorMessage("SUCCESS");
                    propertyTaxDetails.setErrorDetails(errorDetails);
                }
            }
        } else {
            propertyTaxDetails = new PropertyTaxDetails();
            errorDetails.setErrorCode("PTAX100");
            errorDetails.setErrorMessage("Property with assessment no " + assessmentNo + " does not exist");
            propertyTaxDetails.setErrorDetails(errorDetails);
        }
        return propertyTaxDetails;
    }

    public List<PropertyTaxDetails> getPropertyTaxDetails(String assessmentNo, String ownerName, String mobileNumber, String category, String doorNo) {
        List<BasicProperty> basicProperties = this.basicPropertyDAO.getBasicPropertiesForTaxDetails(assessmentNo, ownerName, mobileNumber, category, doorNo);
        ArrayList<PropertyTaxDetails> propTxDetailsList = new ArrayList<PropertyTaxDetails>();
        if (null != basicProperties && !basicProperties.isEmpty()) {
            for (BasicProperty basicProperty : basicProperties) {
                PropertyTaxDetails propertyTaxDetails = this.getPropertyTaxDetails(basicProperty, category);
                propTxDetailsList.add(propertyTaxDetails);
            }
        } else {
            PropertyTaxDetails propertyTaxDetails = new PropertyTaxDetails();
            ErrorDetails errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTAX100");
            errorDetails.setErrorMessage("Assessment does not exist");
            propertyTaxDetails.setErrorDetails(errorDetails);
            propTxDetailsList.add(propertyTaxDetails);
        }
        return propTxDetailsList;
    }

    public List<PropertyTaxDetails> getPropertyTaxDetails(String circleName, String zoneName, String wardName, String blockName, String ownerName, String doorNo, String aadhaarNumber, String mobileNumber) {
        ArrayList<PropertyTaxDetails> propTxDetailsList = null;
        List<BasicProperty> basicPropertyList = this.basicPropertyDAO.getBasicPropertiesForTaxDetails(circleName, zoneName, wardName, blockName, ownerName, doorNo, aadhaarNumber, mobileNumber);
        if (null != basicPropertyList) {
            propTxDetailsList = new ArrayList<PropertyTaxDetails>();
            for (BasicProperty basicProperty : basicPropertyList) {
                PropertyTaxDetails propertyTaxDetails = this.getPropertyTaxDetails(basicProperty, null);
                propTxDetailsList.add(propertyTaxDetails);
            }
        }
        return propTxDetailsList;
    }

    public Boolean authenticateUser(String username, String password) {
        Boolean isAuthenticated = false;
        if (username.equals("mahesh") && password.equals("demo")) {
            isAuthenticated = true;
        }
        return isAuthenticated;
    }

    private PropertyTaxDetails getPropertyTaxDetails(BasicProperty basicProperty, String category) {
        PropertyTaxDetails propertyTaxDetails = new PropertyTaxDetails();
        ErrorDetails errorDetails = new ErrorDetails();
        if (null != basicProperty) {
            String assessmentNo = basicProperty.getUpicNo();
            if (!basicProperty.isActive().booleanValue()) {
                errorDetails.setErrorCode("PTAX101");
                errorDetails.setErrorMessage("Property is decativated");
                propertyTaxDetails.setErrorDetails(errorDetails);
            } else {
                Set<PropertyStatusValues> statusValues = basicProperty.getPropertyStatusValuesSet();
                if (null != statusValues && !statusValues.isEmpty()) {
                    for (PropertyStatusValues statusValue : statusValues) {
                        if (statusValue.getPropertyStatus().getStatusCode() != "MARK_DEACTIVE") continue;
                        errorDetails.setErrorCode("PTAX102");
                        errorDetails.setErrorMessage("Property is marked for deactivation");
                    }
                }
            }
            Property property = basicProperty.getProperty();
            this.ptDemandDAO.getDemandCollMap(property);
            if (!StringUtils.isBlank((CharSequence)category)) {
                String propType = property.getPropertyDetail().getPropertyTypeMaster().getCode();
                if ("PT".equals(category)) {
                    if (propType.equals("VAC_LAND")) {
                        errorDetails.setErrorCode("PTIS-REST-43");
                        errorDetails.setErrorMessage("There is no Property Tax record found for this assessment");
                        propertyTaxDetails.setErrorDetails(errorDetails);
                        return propertyTaxDetails;
                    }
                } else if ("VLT".equals(category)) {
                    if (!propType.equals("VAC_LAND")) {
                        errorDetails.setErrorCode("PTIS-REST-44");
                        errorDetails.setErrorMessage("There is no Vacant Land record found for this assessment");
                        propertyTaxDetails.setErrorDetails(errorDetails);
                        return propertyTaxDetails;
                    }
                } else {
                    errorDetails.setErrorCode("PTIS-REST-45");
                    errorDetails.setErrorMessage("Invalid Category");
                    propertyTaxDetails.setErrorDetails(errorDetails);
                    return propertyTaxDetails;
                }
            }
            List<PropertyOwnerInfo> propOwnerInfos = property.getBasicProperty().getPropertyOwnerInfo();
            propertyTaxDetails.setOwnerDetails(new ArrayList<OwnerDetails>(0));
            for (int i = 0; i < propOwnerInfos.size(); ++i) {
                PropertyOwnerInfo propOwnerInfo = propOwnerInfos.get(i);
                String ownerName = propOwnerInfo.getOwner().getName();
                if (null == ownerName || ownerName.trim().length() == 0) continue;
                OwnerDetails ow = new OwnerDetails();
                ow.setOwnerName(ownerName);
                ow.setMobileNo(propOwnerInfo.getOwner().getMobileNumber());
                propertyTaxDetails.getOwnerDetails().add(ow);
            }
            propertyTaxDetails.setPropertyAddress(property.getBasicProperty().getAddress().toString());
            propertyTaxDetails.setAssessmentNo(property.getBasicProperty().getUpicNo());
            propertyTaxDetails.setLocalityName(property.getBasicProperty().getPropertyID().getLocality().getName());
            this.propertyTaxBillable.setBasicProperty(basicProperty);
            this.propertyTaxBillable.setLevyPenalty(Boolean.TRUE);
            Map<Installment, PenaltyAndRebate> calculatedPenalty = this.propertyTaxBillable.getCalculatedPenalty();
            List<Object> list = this.ptDemandDAO.getPropertyTaxDetails(assessmentNo);
            if (list.size() <= 0) {
                return propertyTaxDetails;
            }
            propertyTaxDetails.setTaxDetails(new ArrayList<RestPropertyTaxDetails>(0));
            String loopInstallment = "";
            RestPropertyTaxDetails arrearDetails = null;
            BigDecimal total = BigDecimal.ZERO;
            for (Object record : list) {
                Object[] data = (Object[])record;
                String taxType = (String)data[0];
                String installment = (String)data[1];
                Double dmd = (Double)data[2];
                Double col = (Double)data[3];
                BigDecimal demand = BigDecimal.valueOf(dmd);
                BigDecimal collection = BigDecimal.valueOf(col);
                if (loopInstallment.isEmpty()) {
                    loopInstallment = installment;
                    arrearDetails = new RestPropertyTaxDetails();
                    arrearDetails.setInstallment(installment);
                }
                if (loopInstallment.equals(installment)) {
                    if ("PENALTY_FINES".equalsIgnoreCase(taxType)) {
                        arrearDetails.setPenalty(demand.subtract(collection));
                        continue;
                    }
                    if ("CHQ_BUNC_PENALTY".equalsIgnoreCase(taxType)) {
                        arrearDetails.setChqBouncePenalty(demand.subtract(collection));
                        continue;
                    }
                    total = total.add(demand.subtract(collection));
                    continue;
                }
                arrearDetails.setTaxAmount(total);
                arrearDetails.setTotalAmount(total.add(arrearDetails.getChqBouncePenalty()));
                propertyTaxDetails.getTaxDetails().add(arrearDetails);
                loopInstallment = installment;
                arrearDetails = new RestPropertyTaxDetails();
                arrearDetails.setInstallment(installment);
                total = BigDecimal.ZERO;
                if ("PENALTY_FINES".equalsIgnoreCase(taxType)) {
                    arrearDetails.setPenalty(demand.subtract(collection));
                    continue;
                }
                if ("CHQ_BUNC_PENALTY".equalsIgnoreCase(taxType)) {
                    arrearDetails.setChqBouncePenalty(demand.subtract(collection));
                    continue;
                }
                total = total.add(demand.subtract(collection));
            }
            if (arrearDetails != null) {
                arrearDetails.setTaxAmount(total);
                arrearDetails.setTotalAmount(total.add(arrearDetails.getChqBouncePenalty()));
                propertyTaxDetails.getTaxDetails().add(arrearDetails);
            }
            Set<Installment> keySet = calculatedPenalty.keySet();
            block3: for (RestPropertyTaxDetails details : propertyTaxDetails.getTaxDetails()) {
                for (Installment inst : keySet) {
                    if (!inst.getDescription().equalsIgnoreCase(details.getInstallment())) continue;
                    details.setPenalty(calculatedPenalty.get(inst).getPenalty());
                    details.setRebate(calculatedPenalty.get(inst).getRebate());
                    details.setTotalAmount(details.getTotalAmount().add(calculatedPenalty.get(inst).getPenalty()));
                    if (details.getRebate() == null) continue block3;
                    details.setTotalAmount(details.getTotalAmount().subtract(details.getRebate()));
                    continue block3;
                }
            }
        }
        return propertyTaxDetails;
    }

    public ReceiptDetails payPropertyTax(PayPropertyTaxDetails payPropertyTaxDetails) {
        Payment payment;
        BillReceiptInfo billReceiptInfo;
        ReceiptDetails receiptDetails = null;
        ErrorDetails errorDetails = null;
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(payPropertyTaxDetails.getAssessmentNo());
        this.propertyTaxBillable.setBasicProperty(basicProperty);
        this.propertyTaxBillable.setUserId(2L);
        ApplicationThreadLocals.setUserId((Long)2L);
        this.propertyTaxBillable.setReferenceNumber(this.propertyTaxNumberGenerator.generateBillNumber(basicProperty.getPropertyID().getWard().getBoundaryNum().toString()));
        this.propertyTaxBillable.setBillType(this.egBillDAO.getBillTypeByCode("AUTO"));
        this.propertyTaxBillable.setLevyPenalty(Boolean.TRUE);
        this.propertyTaxBillable.setTransanctionReferenceNumber(payPropertyTaxDetails.getTransactionId());
        EgBill egBill = this.ptBillServiceImpl.generateBill(this.propertyTaxBillable);
        CollectionHelper collectionHelper = new CollectionHelper(egBill);
        HashMap<String, String> paymentDetailsMap = new HashMap<String, String>();
        paymentDetailsMap.put("amount", payPropertyTaxDetails.getPaymentAmount().toString());
        paymentDetailsMap.put("paidBy", payPropertyTaxDetails.getPaidBy());
        if ("CHEQUE".equalsIgnoreCase(payPropertyTaxDetails.getPaymentMode().toLowerCase()) || "DD".equalsIgnoreCase(payPropertyTaxDetails.getPaymentMode().toLowerCase())) {
            paymentDetailsMap.put("instrumentNumber", payPropertyTaxDetails.getChqddNo());
            paymentDetailsMap.put("instrumentDate", ChequePayment.CHEQUE_DATE_FORMAT.format(payPropertyTaxDetails.getChqddDate()));
            paymentDetailsMap.put("branchName", payPropertyTaxDetails.getBranchName());
            Long validatesBankId = this.validateBank(payPropertyTaxDetails.getBankName());
            paymentDetailsMap.put("bankId", validatesBankId.toString());
        }
        if (null != (billReceiptInfo = collectionHelper.executeCollection(payment = Payment.create((String)payPropertyTaxDetails.getPaymentMode().toLowerCase(), paymentDetailsMap), payPropertyTaxDetails.getSource()))) {
            receiptDetails = new ReceiptDetails();
            receiptDetails.setReceiptNo(billReceiptInfo.getReceiptNum());
            receiptDetails.setReceiptDate(this.formatDate(billReceiptInfo.getReceiptDate()));
            receiptDetails.setPayeeName(billReceiptInfo.getPayeeName());
            receiptDetails.setPayeeAddress(billReceiptInfo.getPayeeAddress());
            receiptDetails.setBillReferenceNo(billReceiptInfo.getBillReferenceNum());
            receiptDetails.setServiceName(billReceiptInfo.getServiceName());
            receiptDetails.setDescription(billReceiptInfo.getDescription());
            receiptDetails.setPaidBy(billReceiptInfo.getPaidBy());
            receiptDetails.setPaymentAmount(billReceiptInfo.getTotalAmount());
            receiptDetails.setPaymentMode(payPropertyTaxDetails.getPaymentMode());
            receiptDetails.setTransactionId(billReceiptInfo.getManualReceiptNumber());
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-0");
            errorDetails.setErrorMessage("SUCCESS");
            receiptDetails.setErrorDetails(errorDetails);
        }
        return receiptDetails;
    }

    private Long validateBank(String bankCodeOrName) {
        Bank bank = this.bankHibernateDAO.getBankByCode(bankCodeOrName);
        if (bank == null) {
            bank = this.bankHibernateDAO.getBankByCode(bankCodeOrName);
        }
        return new Long(bank.getId().intValue());
    }

    public ErrorDetails payWaterTax(String consumerNo, String paymentMode, BigDecimal totalAmount, String paidBy) {
        ErrorDetails errorDetails = this.validatePaymentDetails(consumerNo, paymentMode, totalAmount, paidBy);
        if (null != errorDetails) {
            return errorDetails;
        }
        errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("PTIS-REST-0");
        errorDetails.setErrorMessage("SUCCESS");
        return errorDetails;
    }

    public List<MasterCodeNamePairDetails> getPropertyTypeMasterDetails() {
        ArrayList<MasterCodeNamePairDetails> propTypeMasterDetailsList = new ArrayList<MasterCodeNamePairDetails>(0);
        List<PropertyTypeMaster> propertyTypeMasters = this.propertyTypeMasterDAO.findAllExcludeEWSHS();
        for (PropertyTypeMaster propertyTypeMaster : propertyTypeMasters) {
            MasterCodeNamePairDetails propTypeMasterDetails = new MasterCodeNamePairDetails();
            propTypeMasterDetails.setCode(propertyTypeMaster.getCode());
            propTypeMasterDetails.setName(propertyTypeMaster.getType());
            propTypeMasterDetailsList.add(propTypeMasterDetails);
        }
        return propTypeMasterDetailsList;
    }

    public PropertyTypeMaster getPropertyTypeMasterByCode(String propertyTypeMasterCode) {
        return this.propertyTypeMasterDAO.getPropertyTypeMasterByCode(propertyTypeMasterCode);
    }

    public List<MasterCodeNamePairDetails> getPropertyTypeCategoryDetails(String categoryCode) {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>(0);
        AbstractMap codeNameMap = null;
        PropertyTypeMaster propertyTypeMasters = this.propertyTypeMasterDAO.getPropertyTypeMasterByCode(categoryCode);
        if (null != propertyTypeMasters && null != (codeNameMap = propertyTypeMasters.getCode().equalsIgnoreCase("VAC_LAND") ? PropertyTaxConstants.VAC_LAND_PROPERTY_TYPE_CATEGORY : PropertyTaxConstants.NON_VAC_LAND_PROPERTY_TYPE_CATEGORY) && !codeNameMap.isEmpty()) {
            for (String code : codeNameMap.keySet()) {
                MasterCodeNamePairDetails mstrCodeNamepairDetails = new MasterCodeNamePairDetails();
                mstrCodeNamepairDetails.setCode(code);
                mstrCodeNamepairDetails.setName((String)codeNameMap.get(code));
                mstrCodeNamePairDetailsList.add(mstrCodeNamepairDetails);
            }
        }
        return mstrCodeNamePairDetailsList;
    }

    public List<MasterCodeNamePairDetails> getPropertyTypes() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        MasterCodeNamePairDetails mstrCodeNamepairDetails = null;
        HashMap<String, String> vacLandMap = PropertyTaxConstants.VAC_LAND_PROPERTY_TYPE_CATEGORY;
        TreeMap<String, String> nonVacLandMap = PropertyTaxConstants.NON_VAC_LAND_PROPERTY_TYPE_CATEGORY;
        for (String key : vacLandMap.keySet()) {
            mstrCodeNamepairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamepairDetails.setCode(key);
            mstrCodeNamepairDetails.setName((String)vacLandMap.get(key));
            mstrCodeNamePairDetailsList.add(mstrCodeNamepairDetails);
        }
        for (String code : nonVacLandMap.keySet()) {
            mstrCodeNamepairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamepairDetails.setCode(code);
            mstrCodeNamepairDetails.setName((String)nonVacLandMap.get(code));
            mstrCodeNamePairDetailsList.add(mstrCodeNamepairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public List<MasterCodeNamePairDetails> getPropertyTypes(String categoryCode) {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>(0);
        AbstractMap codeNameMap = null;
        PropertyTypeMaster propertyTypeMasters = this.propertyTypeMasterDAO.getPropertyTypeMasterByCode(categoryCode);
        if (null != propertyTypeMasters && null != (codeNameMap = propertyTypeMasters.getCode().equalsIgnoreCase("VAC_LAND") ? PropertyTaxConstants.VAC_LAND_PROPERTY_TYPE_CATEGORY : PropertyTaxConstants.NON_VAC_LAND_PROPERTY_TYPE_CATEGORY) && !codeNameMap.isEmpty()) {
            for (String code : codeNameMap.keySet()) {
                MasterCodeNamePairDetails mstrCodeNamepairDetails = new MasterCodeNamePairDetails();
                mstrCodeNamepairDetails.setCode(code);
                mstrCodeNamepairDetails.setName((String)codeNameMap.get(code));
                mstrCodeNamePairDetailsList.add(mstrCodeNamepairDetails);
            }
        }
        return mstrCodeNamePairDetailsList;
    }

    public List<MasterCodeNamePairDetails> getApartmentsAndComplexes() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>(0);
        List apartmentList = this.entityManager.createQuery("from Apartment").getResultList();
        if (null != apartmentList) {
            for (Apartment apartment : apartmentList) {
                MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
                mstrCodeNamePairDetails.setCode(apartment.getCode());
                mstrCodeNamePairDetails.setName(apartment.getName());
                mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
            }
        }
        return mstrCodeNamePairDetailsList;
    }

    public List<MasterCodeNamePairDetails> getReasonsForChangeProperty(String reason) {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>(0);
        Query qry = this.entityManager.createQuery("from PropertyMutationMaster pmm where pmm.type = :type");
        qry.setParameter("type", (Object)reason);
        List propMutationMasterList = qry.getResultList();
        if (null != propMutationMasterList) {
            for (PropertyMutationMaster propMutationMaster : propMutationMasterList) {
                MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
                mstrCodeNamePairDetails.setCode(propMutationMaster.getCode());
                mstrCodeNamePairDetails.setName(propMutationMaster.getMutationName());
                mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
            }
        }
        return mstrCodeNamePairDetailsList;
    }

    public List<MasterCodeNamePairDetails> getBoundariesByBoundaryTypeAndHierarchyType(String boundaryType, String hierarchyType) {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>(0);
        List boundaryList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName(boundaryType, hierarchyType);
        if (boundaryList != null) {
            for (Boundary boundary : boundaryList) {
                MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
                mstrCodeNamePairDetails.setCode(boundary.getBoundaryNum().toString());
                mstrCodeNamePairDetails.setName(boundary.getName());
                mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
            }
        }
        return mstrCodeNamePairDetailsList;
    }

    public LocalityDetails getLocalityDetailsByLocalityCode(String localityCode) {
        Long boundaryNo = Long.valueOf(localityCode.substring(0, localityCode.indexOf("~")).trim());
        String name = localityCode.substring(localityCode.indexOf("~") + 1).trim();
        LocalityDetails localityDetails = null;
        Query qry = this.entityManager.createQuery("from Boundary b where b.boundaryNum = :boundaryNo and b.name = :name");
        qry.setParameter("boundaryNo", (Object)boundaryNo);
        qry.setParameter("name", (Object)name);
        List list = qry.getResultList();
        if (null != list && !list.isEmpty()) {
            localityDetails = new LocalityDetails();
            Boundary boundary = (Boundary)list.get(0);
            qry = this.entityManager.createQuery("from CrossHierarchy cr where cr.child = :child");
            qry.setParameter("child", (Object)boundary);
            list = qry.getResultList();
            if (null != list && !list.isEmpty()) {
                CrossHierarchy crossHeirarchyImpl = (CrossHierarchy)list.get(0);
                qry = this.entityManager.createQuery("from Boundary b where b.id = :id");
                qry.setParameter("id", (Object)crossHeirarchyImpl.getParent().getId());
                list = qry.getResultList();
                if (null != list && !list.isEmpty()) {
                    Boundary block = (Boundary)list.get(0);
                    localityDetails.setBlockName(block.getName());
                    qry = this.entityManager.createQuery("from Boundary b where b.id = :id");
                    qry.setParameter("id", (Object)block.getParent().getId());
                    list = qry.getResultList();
                    if (null != list && !list.isEmpty()) {
                        Boundary ward = (Boundary)list.get(0);
                        localityDetails.setWardName(ward.getName());
                        qry = this.entityManager.createQuery("from Boundary b where b.id = :id");
                        qry.setParameter("id", (Object)ward.getParent().getId());
                        list = qry.getResultList();
                        if (null != list && !list.isEmpty()) {
                            Boundary zone = (Boundary)list.get(0);
                            localityDetails.setZoneName(zone.getName());
                        }
                    }
                }
            }
        }
        return localityDetails;
    }

    public Boundary getBoundaryByNumberAndType(String boundaryNum, String boundaryTypeName, String hierarchyName) {
        BoundaryType boundaryType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyTypeName(boundaryTypeName, hierarchyName);
        Boundary boundary = this.boundaryService.getBoundaryByTypeAndNo(boundaryType, Long.valueOf(boundaryNum));
        return boundary;
    }

    public List<MasterCodeNamePairDetails> getEnumerationBlocks() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        List enumerationBlockList = this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Election Ward", "ELECTION");
        for (Boundary boundary : enumerationBlockList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(boundary.getBoundaryNum().toString());
            mstrCodeNamePairDetails.setName(boundary.getName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public List<MasterCodeNamePairDetails> getFloorTypes() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        List floorTypeList = this.entityManager.createQuery("from FloorType order by name").getResultList();
        for (FloorType floorType : floorTypeList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(floorType.getId().toString());
            mstrCodeNamePairDetails.setName(floorType.getName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public List<MasterCodeNamePairDetails> getRoofTypes() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        List roofTypeList = this.entityManager.createQuery("from RoofType order by name").getResultList();
        for (RoofType roofType : roofTypeList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(roofType.getId().toString());
            mstrCodeNamePairDetails.setName(roofType.getName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public List<MasterCodeNamePairDetails> getWallTypes() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        List wallTypeList = this.entityManager.createQuery("from WallType order by name").getResultList();
        for (WallType wallType : wallTypeList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(wallType.getId().toString());
            mstrCodeNamePairDetails.setName(wallType.getName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public List<MasterCodeNamePairDetails> getWoodTypes() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        List woodTypeList = this.entityManager.createQuery("from WoodType order by name").getResultList();
        for (WoodType woodType : woodTypeList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(woodType.getId().toString());
            mstrCodeNamePairDetails.setName(woodType.getName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public List<MasterCodeNamePairDetails> getBuildingClassifications() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        List structClsfList = this.entityManager.createQuery("from StructureClassification").getResultList();
        for (StructureClassification structClsf : structClsfList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(structClsf.getConstrTypeCode());
            mstrCodeNamePairDetails.setName(structClsf.getTypeName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public StructureClassification getStructureClassificationByCode(String classificationCode) {
        Query qry = this.entityManager.createQuery("from StructureClassification sc where sc.constrTypeCode =:code");
        qry.setParameter("code", (Object)classificationCode);
        return (StructureClassification)((Object)qry.getSingleResult());
    }

    public List<MasterCodeNamePairDetails> getNatureOfUsages() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        List usageList = this.entityManager.createQuery("from PropertyUsage order by usageName").getResultList();
        for (PropertyUsage propUsage : usageList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(propUsage.getUsageCode());
            mstrCodeNamePairDetails.setName(propUsage.getUsageName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public PropertyUsage getPropertyUsageByUsageCde(String usageCode) {
        Query qry = this.entityManager.createQuery("from PropertyUsage pu where pu.usageCode = :usageCode order by usageName");
        qry.setParameter("usageCode", (Object)usageCode);
        PropertyUsage propertyUsage = (PropertyUsage)((Object)qry.getSingleResult());
        return propertyUsage;
    }

    public List<MasterCodeNamePairDetails> getOccupancies() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        List propOccupList = this.entityManager.createQuery("from PropertyOccupation").getResultList();
        for (PropertyOccupation propOccup : propOccupList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(propOccup.getOccupancyCode());
            mstrCodeNamePairDetails.setName(propOccup.getOccupation());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public PropertyOccupation getPropertyOccupationByOccupancyCode(String occupancyCode) {
        Query qry = this.entityManager.createQuery("from PropertyOccupation po where po.occupancyCode = :occupancyCode");
        qry.setParameter("occupancyCode", (Object)occupancyCode);
        PropertyOccupation propertyOccupation = (PropertyOccupation)((Object)qry.getSingleResult());
        return propertyOccupation;
    }

    public List<MasterCodeNamePairDetails> getExemptionCategories() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        List taxExeptionReasonList = this.entityManager.createQuery("from TaxExeptionReason order by name").getResultList();
        for (TaxExeptionReason taxExeptionReason : taxExeptionReasonList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(taxExeptionReason.getCode());
            mstrCodeNamePairDetails.setName(taxExeptionReason.getName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public TaxExeptionReason getTaxExemptionReasonByCode(String exemptionReasonCode) {
        TaxExeptionReason taxExeptionReason = null;
        Query qry = this.entityManager.createQuery("from TaxExeptionReason ter where ter.code = :code");
        qry.setParameter("code", (Object)("" + exemptionReasonCode));
        List list = qry.getResultList();
        if (null != list && !list.isEmpty()) {
            taxExeptionReason = (TaxExeptionReason)((Object)qry.getSingleResult());
        }
        return taxExeptionReason;
    }

    public List<MasterCodeNamePairDetails> getApproverDepartments() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        List approverDepartmentList = this.entityManager.createQuery("from Department order by name").getResultList();
        for (Department approverDepartment : approverDepartmentList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(approverDepartment.getCode());
            mstrCodeNamePairDetails.setName(approverDepartment.getName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public NewPropertyDetails createNewProperty(String propertyTypeMasterCode, String propertyCategoryCode, String exemptionCode, String apartmentCmplxCode, List<OwnerDetails> ownerDetailsList, String mutationReasonCode, String extentOfSite, Boolean isExtentAppurtenantLand, String occupancyCertificationNo, String regdDocNo, String regdDocDate, String localityCode, String blockNum, String zoneNum, String street, String electionWardCode, String doorNo, String enumerationBlockCode, String pinCode, Boolean isCorrAddrDiff, String corrAddr1, String corrAddr2, String corrPinCode, Boolean hasLift, Boolean hasToilet, Boolean hasWaterTap, Boolean hasElectricity, Boolean hasAttachedBathroom, Boolean hasWaterHarvesting, Boolean hasCable, String floorTypeCode, String roofTypeCode, String wallTypeCode, String woodTypeCode, List<FloorDetails> floorDetailsList, String surveyNumber, String pattaNumber, Float vacantLandArea, Double marketValue, Double currentCapitalValue, String effectiveDate, String northBoundary, String southBoundary, String eastBoundary, String westBoundary, String parentPropertyNumber, List<Document> documents) throws ParseException {
        NewPropertyDetails newPropertyDetails = null;
        BasicProperty basicProperty = this.createBasicProperty(propertyTypeMasterCode, propertyCategoryCode, exemptionCode, apartmentCmplxCode, mutationReasonCode, ownerDetailsList, extentOfSite, isExtentAppurtenantLand, occupancyCertificationNo, regdDocNo, regdDocDate, localityCode, blockNum, zoneNum, street, doorNo, electionWardCode, pinCode, isCorrAddrDiff, corrAddr1, corrAddr2, corrPinCode, hasLift, hasToilet, hasWaterTap, hasElectricity, hasAttachedBathroom, hasWaterHarvesting, hasCable, floorTypeCode, roofTypeCode, wallTypeCode, woodTypeCode, floorDetailsList, surveyNumber, pattaNumber, vacantLandArea, marketValue, currentCapitalValue, effectiveDate, northBoundary, southBoundary, eastBoundary, westBoundary, parentPropertyNumber, documents);
        basicProperty.setIsTaxXMLMigrated(PropertyTaxConstants.STATUS_YES_XML_MIGRATION);
        this.processAndStoreDocumentsWithReason(basicProperty, "CREATE");
        basicProperty.setPropertyOwnerInfoProxy(this.getPropertyOwnerInfoList(ownerDetailsList));
        this.basicPropertyService.createOwners(this.property, basicProperty, basicProperty.getAddress());
        this.transitionWorkFlow(this.property);
        this.basicPropertyService.applyAuditing((AbstractAuditable)this.property.getState());
        basicProperty = (BasicProperty)this.basicPropertyService.persist(basicProperty);
        if (null != basicProperty) {
            newPropertyDetails = new NewPropertyDetails();
            newPropertyDetails.setApplicationNo(basicProperty.getProperty().getApplicationNo());
            ErrorDetails errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-0");
            errorDetails.setErrorMessage("SUCCESS");
            newPropertyDetails.setErrorDetails(errorDetails);
        }
        return newPropertyDetails;
    }

    private BasicProperty createBasicProperty(String propertyTypeMasterCode, String propertyCategoryCode, String exemptionCode, String apartmentCmplxCode, String mutationReasonCode, List<OwnerDetails> ownerDetailsList, String extentOfSite, Boolean isExtentAppurtenantLand, String occupancyCertificationNo, String regdDocNo, String regdDocDate, String localityNum, String blockNum, String zoneNum, String street, String doorNo, String electionWardCode, String pinCode, Boolean isCorrAddrDiff, String corrAddr1, String corrAddr2, String corrPinCode, Boolean lift, Boolean toilet, Boolean waterTap, Boolean electricity, Boolean attachedBathroom, Boolean waterHarvesting, Boolean cable, String floorTypeId, String roofTypeId, String wallTypeId, String woodTypeId, List<FloorDetails> floorDetailsList, String surveyNumber, String pattaNumber, Float vacantLandArea, Double marketValue, Double currentCapitalValue, String effectiveDate, String northBoundary, String southBoundary, String eastBoundary, String westBoundary, String parentPropertyNumber, List<Document> documents) throws ParseException {
        BasicPropertyImpl basicProperty = new BasicPropertyImpl();
        basicProperty.setRegdDocNo(regdDocNo);
        basicProperty.setRegdDocDate(this.convertStringToDate(regdDocDate));
        basicProperty.setActive(Boolean.TRUE);
        basicProperty.setSource(PropertyTaxConstants.SOURCEOFDATA_MOBILE);
        Boundary block = this.getBoundaryByNumberAndType(blockNum, "Block", "REVENUE");
        PropertyAddress propAddress = this.createPropAddress(localityNum, block, doorNo, pinCode, isCorrAddrDiff, corrAddr1, corrAddr2, corrPinCode);
        basicProperty.setAddress(propAddress);
        PropertyID propertyID = this.createPropertID(basicProperty, localityNum, block, electionWardCode, zoneNum, northBoundary, southBoundary, eastBoundary, westBoundary);
        basicProperty.setPropertyID(propertyID);
        PropertyStatus propertyStatus = this.getPropertyStatus();
        basicProperty.setStatus(propertyStatus);
        basicProperty.setUnderWorkflow(Boolean.TRUE);
        PropertyMutationMaster propertyMutationMaster = this.getPropertyMutationMaster(mutationReasonCode);
        basicProperty.setPropertyMutationMaster(propertyMutationMaster);
        PropertyService propService = (PropertyService)this.beanProvider.getBean("propService", PropertyService.class);
        if (propertyMutationMaster.getCode().equals("BIFUR")) {
            basicProperty.addPropertyStatusValues(propService.createPropStatVal(basicProperty, "CREATE", null, null, null, null, parentPropertyNumber));
        }
        basicProperty.setIsBillCreated(PropertyTaxConstants.STATUS_BILL_NOTCREATED);
        PropertyTypeMaster propertyTypeMaster = this.getPropertyTypeMasterByCode(propertyTypeMasterCode);
        PropertyImpl propertyImpl = this.createPropertyWithBasicDetails(propertyTypeMasterCode);
        propertyImpl.getPropertyDetail().setCorrAddressDiff(isCorrAddrDiff);
        propertyImpl.getPropertyDetail().setAppurtenantLandChecked(isExtentAppurtenantLand);
        propertyImpl.getPropertyDetail().setEffectiveDate(this.convertStringToDate(effectiveDate));
        propertyImpl.setBasicProperty(basicProperty);
        propertyImpl.getBasicProperty().setPropertyID(propertyID);
        if (documents != null) {
            propertyImpl.setDocuments(documents);
        }
        if (StringUtils.isNotBlank((CharSequence)exemptionCode)) {
            TaxExeptionReason taxExemptedReason = this.getTaxExemptionReasonByCode(exemptionCode);
            propertyImpl.setTaxExemptedReason(taxExemptedReason);
        }
        if (StringUtils.isNotBlank((CharSequence)apartmentCmplxCode)) {
            Apartment apartment = this.getApartmentByCode(apartmentCmplxCode);
            propertyImpl.getPropertyDetail().setApartment(apartment);
        }
        propertyImpl.getPropertyDetail().setOccupancyCertificationNo(occupancyCertificationNo);
        if (!propertyTypeMasterCode.equalsIgnoreCase("VAC_LAND")) {
            FloorType floorType = this.floorTypeService.getFloorTypeById(Long.valueOf(floorTypeId));
            RoofType roofType = this.roofTypeService.getRoofTypeById(Long.valueOf(roofTypeId));
            WallType wallType = null;
            WoodType woodType = null;
            if (StringUtils.isNotBlank((CharSequence)wallTypeId)) {
                wallType = this.wallTypeService.getWallTypeById(Long.valueOf(wallTypeId));
            }
            if (StringUtils.isNotBlank((CharSequence)wallTypeId)) {
                woodType = this.woodTypeService.getWoodTypeById(Long.valueOf(woodTypeId));
            }
            propertyImpl.getPropertyDetail().setFloorDetailsProxy(this.getFloorList(floorDetailsList));
            propertyImpl.getPropertyDetail().setLift(lift);
            propertyImpl.getPropertyDetail().setToilets(toilet);
            propertyImpl.getPropertyDetail().setWaterTap(waterTap);
            propertyImpl.getPropertyDetail().setElectricity(electricity);
            propertyImpl.getPropertyDetail().setAttachedBathRoom(attachedBathroom);
            propertyImpl.getPropertyDetail().setWaterHarvesting(waterHarvesting);
            propertyImpl.getPropertyDetail().setCable(cable);
            this.property = propService.createProperty(propertyImpl, extentOfSite, mutationReasonCode, propertyTypeMaster.getId().toString(), null, null, PropertyTaxConstants.STATUS_ISACTIVE, regdDocNo, null, floorType != null ? floorType.getId() : null, roofType != null ? roofType.getId() : null, wallType != null ? wallType.getId() : null, woodType != null ? woodType.getId() : null, null);
        } else {
            propertyImpl.getPropertyDetail().setDateOfCompletion(this.convertStringToDate(effectiveDate));
            propertyImpl.getPropertyDetail().setCurrentCapitalValue(currentCapitalValue);
            propertyImpl.getPropertyDetail().setSurveyNumber(surveyNumber);
            propertyImpl.getPropertyDetail().setPattaNumber(pattaNumber);
            Area area = new Area();
            area.setArea(vacantLandArea);
            propertyImpl.getPropertyDetail().setSitalArea(area);
            propertyImpl.getPropertyDetail().setMarketValue(marketValue);
            this.property = propService.createProperty(propertyImpl, extentOfSite, mutationReasonCode, propertyTypeMaster.getId().toString(), null, null, PropertyTaxConstants.STATUS_ISACTIVE, regdDocNo, null, null, null, null, null, null);
        }
        this.property.setStatus(PropertyTaxConstants.STATUS_DEMAND_INACTIVE);
        this.property.setPropertyModifyReason("CREATE");
        this.property.getPropertyDetail().setCategoryType(propertyCategoryCode);
        basicProperty.addProperty(this.property);
        Date propCompletionDate = null;
        propCompletionDate = !this.property.getPropertyDetail().getPropertyTypeMaster().getCode().equalsIgnoreCase("VAC_LAND") ? propService.getLowestDtOfCompFloorWise(this.property.getPropertyDetail().getFloorDetailsProxy()) : this.property.getPropertyDetail().getDateOfCompletion();
        basicProperty.setPropOccupationDate(propCompletionDate);
        if (this.property != null && !this.property.getDocuments().isEmpty()) {
            propService.processAndStoreDocument(this.property.getDocuments());
        }
        try {
            propService.createDemand(propertyImpl, propCompletionDate);
        }
        catch (TaxCalculatorExeption e) {
            e.printStackTrace();
        }
        return basicProperty;
    }

    private PropertyStatus getPropertyStatus() {
        Query qry = this.entityManager.createQuery("from PropertyStatus where statusCode = :statusCode");
        qry.setParameter("statusCode", (Object)"WORKFLOW");
        PropertyStatus propertyStatus = (PropertyStatus)qry.getSingleResult();
        return propertyStatus;
    }

    private PropertyAddress createPropAddress(String localityNum, Boundary block, String doorNo, String pinCode, Boolean isCorrespondenceAddrDiff, String corrAddr1, String corrAddr2, String corrPinCode) {
        PropertyAddress propAddr = new PropertyAddress();
        propAddr.setHouseNoBldgApt(doorNo);
        propAddr.setAreaLocalitySector(this.getBoundaryByNumberAndType(localityNum, "Locality", "LOCATION").getName());
        String cityName = ApplicationThreadLocals.getCityName();
        propAddr.setStreetRoadLine(block.getParent().getName());
        propAddr.setCityTownVillage(cityName);
        if (StringUtils.isNotBlank((CharSequence)pinCode)) {
            propAddr.setPinCode(pinCode);
        }
        CorrespondenceAddress ownerAddress = null;
        if (isCorrespondenceAddrDiff.booleanValue()) {
            ownerAddress = this.createCorrespondenceAddress(doorNo, corrAddr1, corrAddr2, corrPinCode);
        } else {
            ownerAddress = new CorrespondenceAddress();
            ownerAddress.setAreaLocalitySector(propAddr.getAreaLocalitySector());
            ownerAddress.setHouseNoBldgApt(propAddr.getHouseNoBldgApt());
            ownerAddress.setStreetRoadLine(propAddr.getStreetRoadLine());
            ownerAddress.setPinCode(propAddr.getPinCode());
        }
        return propAddr;
    }

    private Address createCorrespondenceAddress(String corrDoorNo, String corrAddr1, String corrAddr2, String corrPinCode) {
        CorrespondenceAddress ownerCorrAddr = new CorrespondenceAddress();
        ownerCorrAddr.setHouseNoBldgApt(corrDoorNo);
        ownerCorrAddr.setAreaLocalitySector(corrAddr1);
        ownerCorrAddr.setStreetRoadLine(corrAddr2);
        ownerCorrAddr.setPinCode(corrPinCode);
        return ownerCorrAddr;
    }

    private PropertyID createPropertID(BasicProperty basicProperty, String localityNum, Boundary block, String electionBoundaryNum, String zoneNum, String northBoundary, String southBoundary, String eastBoundary, String westBoundary) {
        PropertyID propertyID = new PropertyID();
        Boundary ward = block.getParent();
        Boundary zone = this.getBoundaryByNumberAndType(zoneNum, "Zone", "REVENUE");
        Boundary locality = this.getBoundaryByNumberAndType(localityNum, "Locality", "LOCATION");
        propertyID.setArea(block);
        propertyID.setWard(ward);
        propertyID.setZone(zone);
        propertyID.setLocality(locality);
        propertyID.setBasicProperty(basicProperty);
        Boundary electionBoundary = this.getBoundaryByNumberAndType(electionBoundaryNum, "Ward", "ADMINISTRATION");
        if (electionBoundary != null) {
            propertyID.setElectionBoundary(electionBoundary);
            basicProperty.setBoundary(electionBoundary);
        }
        if (StringUtils.isNotBlank((CharSequence)northBoundary)) {
            propertyID.setNorthBoundary(northBoundary);
        }
        if (StringUtils.isNotBlank((CharSequence)southBoundary)) {
            propertyID.setSouthBoundary(southBoundary);
        }
        if (StringUtils.isNotBlank((CharSequence)eastBoundary)) {
            propertyID.setEastBoundary(eastBoundary);
        }
        if (StringUtils.isNotBlank((CharSequence)westBoundary)) {
            propertyID.setWestBoundary(westBoundary);
        }
        propertyID.setBasicProperty(basicProperty);
        return propertyID;
    }

    private PropertyMutationMaster getPropertyMutationMaster(String mutationReasonCode) {
        Query qry = this.entityManager.createQuery("from PropertyMutationMaster pmm where pmm.code = :mutationReasonCode");
        qry.setParameter("mutationReasonCode", (Object)mutationReasonCode);
        PropertyMutationMaster propMutationMaster = (PropertyMutationMaster)qry.getSingleResult();
        return propMutationMaster;
    }

    public ErrorDetails validatePaymentDetails(String assessmentNo, String paymentMode, BigDecimal totalAmount, String paidBy) {
        ErrorDetails errorDetails = null;
        if (assessmentNo == null || assessmentNo.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-12");
            errorDetails.setErrorMessage("Assessment number is required");
        } else {
            if (assessmentNo.trim().length() > 0 && assessmentNo.trim().length() < 10) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-8");
                errorDetails.setErrorMessage("Assessment number length can not less than 10 digits");
            }
            if (!this.basicPropertyDAO.isAssessmentNoExist(assessmentNo).booleanValue()) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-11");
                errorDetails.setErrorMessage("Assessment number not found");
            }
        }
        if (paymentMode == null || paymentMode.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-13");
            errorDetails.setErrorMessage("Payment mode is required");
        } else if (!("CASH".equalsIgnoreCase(paymentMode.trim()) || "CHEQUE".equalsIgnoreCase(paymentMode.trim()) || "DD".equalsIgnoreCase(paymentMode.trim()))) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-14");
            errorDetails.setErrorMessage("Payment mode is invalid");
        }
        return errorDetails;
    }

    private String formatDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        return sdf.format(date);
    }

    public Date convertStringToDate(String dateInString) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        Date stringToDate = sdf.parse(dateInString);
        return stringToDate;
    }

    private void processAndStoreDocumentsWithReason(BasicProperty basicProperty, String reason) {
        if (!this.uploads.isEmpty()) {
            int fileCount = 0;
            for (File file : this.uploads) {
                FileStoreMapper fileStore = this.fileStoreService.store(file, this.uploadFileNames.get(fileCount), this.uploadContentTypes.get(fileCount++), "PTIS");
                PropertyDocs propertyDoc = new PropertyDocs();
                propertyDoc.setSupportDoc(fileStore);
                propertyDoc.setBasicProperty(basicProperty);
                propertyDoc.setReason(reason);
                basicProperty.addDocs(propertyDoc);
            }
        }
    }

    private PropertyImpl createPropertyWithBasicDetails(String propertyType) {
        PropertyImpl propertyImpl = new PropertyImpl();
        if (propertyType.equalsIgnoreCase("VAC_LAND")) {
            propertyImpl.setPropertyDetail(new VacantProperty());
        } else {
            propertyImpl.setPropertyDetail(new BuiltUpProperty());
        }
        propertyImpl.setBasicProperty(new BasicPropertyImpl());
        return propertyImpl;
    }

    private List<Floor> getFloorList(List<FloorDetails> floorDetailsList) throws ParseException {
        ArrayList<Floor> floorList = new ArrayList<Floor>(0);
        for (FloorDetails floorDetails : floorDetailsList) {
            Floor floor = new Floor();
            floor.setFloorNo(Integer.valueOf(floorDetails.getFloorNoCode()));
            floor.setStructureClassification(this.getStructureClassificationByCode(floorDetails.getBuildClassificationCode()));
            floor.setPropertyUsage(this.getPropertyUsageByUsageCde(floorDetails.getNatureOfUsageCode()));
            floor.setPropertyOccupation(this.getPropertyOccupationByOccupancyCode(floorDetails.getOccupancyCode()));
            floor.setFirmName(floorDetails.getFirmName());
            floor.setOccupantName(floorDetails.getOccupantName());
            floor.setConstructionDate(this.convertStringToDate(floorDetails.getConstructionDate()));
            floor.setOccupancyDate(this.convertStringToDate(floorDetails.getOccupancyDate()));
            floor.setCreatedDate(new Date());
            Area builtUpArea = new Area();
            builtUpArea.setArea(floorDetails.getPlinthArea());
            builtUpArea.setBreadth(floorDetails.getPlinthBreadth());
            builtUpArea.setLength(floorDetails.getPlinthLength());
            floor.setBuiltUpArea(builtUpArea);
            floor.setUnstructuredLand(floorDetails.getUnstructuredLand());
            floor.setBuildingPermissionNo(floorDetails.getBuildingPermissionNo());
            if (StringUtils.isNotBlank((CharSequence)floorDetails.getBuildingPermissionDate())) {
                floor.setBuildingPermissionDate(this.convertStringToDate(floorDetails.getBuildingPermissionDate()));
            }
            Area buildingPlanPlinthArea = new Area();
            buildingPlanPlinthArea.setArea(floorDetails.getBuildingPlanPlinthArea());
            floor.setBuildingPlanPlinthArea(buildingPlanPlinthArea);
            floorList.add(floor);
        }
        return floorList;
    }

    private List<PropertyOwnerInfo> getPropertyOwnerInfoList(List<OwnerDetails> ownerDetailsList) {
        ArrayList<PropertyOwnerInfo> proeprtyOwnerInfoList = new ArrayList<PropertyOwnerInfo>(0);
        for (OwnerDetails ownerDetais : ownerDetailsList) {
            PropertyOwnerInfo ownerInfo = new PropertyOwnerInfo();
            User owner = new User();
            owner.setAadhaarNumber(ownerDetais.getAadhaarNo());
            owner.setSalutation(ownerDetais.getSalutationCode());
            owner.setName(ownerDetais.getName());
            owner.setGender(Gender.valueOf((String)ownerDetais.getGender()));
            owner.setMobileNumber(ownerDetais.getMobileNumber());
            owner.setEmailId(ownerDetais.getEmailId());
            owner.setGuardianRelation(ownerDetais.getGuardianRelation());
            owner.setGuardian(ownerDetais.getGuardian());
            ownerInfo.setOwner(owner);
            proeprtyOwnerInfoList.add(ownerInfo);
        }
        return proeprtyOwnerInfoList;
    }

    public List<MasterCodeNamePairDetails> getPropertyCreateDocumentTypes() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>(0);
        PropertyService propService = (PropertyService)this.beanProvider.getBean("propService", PropertyService.class);
        List<DocumentType> documentTypes = propService.getDocumentTypesForTransactionType(TransactionType.CREATE);
        for (DocumentType documentType : documentTypes) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(documentType.getId().toString());
            mstrCodeNamePairDetails.setName(documentType.getName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    public DocumentType getDocumentTypeByCode(String docTypeCode) {
        PropertyService propService = (PropertyService)this.beanProvider.getBean("propService", PropertyService.class);
        List<DocumentType> documentTypes = propService.getDocumentTypesForTransactionType(TransactionType.CREATE);
        DocumentType documentType = null;
        for (DocumentType docType : documentTypes) {
            if (docType.getId() != Long.valueOf(docTypeCode)) continue;
            documentType = docType;
        }
        return documentType;
    }

    public List<Document> getDocuments(InputStream photoAsmntStream, FormDataContentDisposition photoAsmntDisp, InputStream bldgPermCopyStream, FormDataContentDisposition bldgPermCopyDisp, InputStream atstdCopyPropDocStream, FormDataContentDisposition atstdCopyPropDocDisp, InputStream nonJudcStampStream, FormDataContentDisposition nonJudcStampDisp, InputStream afdvtBondStream, FormDataContentDisposition afdvtBondDisp, InputStream deathCertCopyStream, FormDataContentDisposition deathCertCopyDisp) {
        ArrayList<Document> documents = new ArrayList<Document>(0);
        DocumentType documentType = null;
        Document document = null;
        if (photoAsmntStream != null && photoAsmntDisp != null) {
            documentType = this.getDocumentTypeByCode("1");
            document = this.createDocument(photoAsmntStream, photoAsmntDisp);
            document.setType(documentType);
            documents.add(document);
        }
        if (bldgPermCopyStream != null && bldgPermCopyDisp != null) {
            documentType = this.getDocumentTypeByCode("2");
            document = this.createDocument(bldgPermCopyStream, bldgPermCopyDisp);
            document.setType(documentType);
            documents.add(document);
        }
        if (atstdCopyPropDocStream != null && atstdCopyPropDocDisp != null) {
            documentType = this.getDocumentTypeByCode("3");
            document = this.createDocument(atstdCopyPropDocStream, atstdCopyPropDocDisp);
            document.setType(documentType);
            documents.add(document);
        }
        if (nonJudcStampStream != null && nonJudcStampDisp != null) {
            documentType = this.getDocumentTypeByCode("4");
            document = this.createDocument(nonJudcStampStream, nonJudcStampDisp);
            document.setType(documentType);
            documents.add(document);
        }
        if (afdvtBondStream != null && afdvtBondDisp != null) {
            documentType = this.getDocumentTypeByCode("5");
            document = this.createDocument(afdvtBondStream, afdvtBondDisp);
            document.setType(documentType);
            documents.add(document);
        }
        if (deathCertCopyStream != null && deathCertCopyDisp != null) {
            documentType = this.getDocumentTypeByCode("6");
            document = this.createDocument(deathCertCopyStream, deathCertCopyDisp);
            document.setType(documentType);
            documents.add(document);
        }
        return documents;
    }

    public List<Document> getDocuments(MultipartFile photoAsmntDisp, MultipartFile bldgPermCopyDisp, MultipartFile atstdCopyPropDocDisp, MultipartFile nonJudcStampDisp, MultipartFile afdvtBondDisp, MultipartFile deathCertCopyDisp) throws IOException {
        ArrayList<Document> documents = new ArrayList<Document>(0);
        DocumentType documentType = null;
        Document document = null;
        if (!photoAsmntDisp.isEmpty() && photoAsmntDisp != null) {
            documentType = this.getDocumentTypeByCode("1");
            document = this.createDocument(photoAsmntDisp.getInputStream(), photoAsmntDisp.getName());
            document.setType(documentType);
            documents.add(document);
        }
        if (!bldgPermCopyDisp.isEmpty() && bldgPermCopyDisp != null) {
            documentType = this.getDocumentTypeByCode("2");
            document = this.createDocument(bldgPermCopyDisp.getInputStream(), bldgPermCopyDisp.getName());
            document.setType(documentType);
            documents.add(document);
        }
        if (!atstdCopyPropDocDisp.isEmpty() && atstdCopyPropDocDisp != null) {
            documentType = this.getDocumentTypeByCode("3");
            document = this.createDocument(atstdCopyPropDocDisp.getInputStream(), atstdCopyPropDocDisp.getName());
            document.setType(documentType);
            documents.add(document);
        }
        if (!nonJudcStampDisp.isEmpty() && nonJudcStampDisp != null) {
            documentType = this.getDocumentTypeByCode("4");
            document = this.createDocument(nonJudcStampDisp.getInputStream(), nonJudcStampDisp.getName());
            document.setType(documentType);
            documents.add(document);
        }
        if (!afdvtBondDisp.isEmpty() && afdvtBondDisp != null) {
            documentType = this.getDocumentTypeByCode("5");
            document = this.createDocument(afdvtBondDisp.getInputStream(), afdvtBondDisp.getName());
            document.setType(documentType);
            documents.add(document);
        }
        if (!deathCertCopyDisp.isEmpty() && deathCertCopyDisp != null) {
            documentType = this.getDocumentTypeByCode("6");
            document = this.createDocument(deathCertCopyDisp.getInputStream(), deathCertCopyDisp.getName());
            document.setType(documentType);
            documents.add(document);
        }
        return documents;
    }

    private Document createDocument(InputStream inputStream, FormDataContentDisposition formDataContentDisposition) {
        Document document = new Document();
        ArrayList<File> files = new ArrayList<File>(0);
        ArrayList<String> contentTypes = new ArrayList<String>(0);
        ArrayList<String> fileNames = new ArrayList<String>(0);
        File file = null;
        if (inputStream != null && formDataContentDisposition != null) {
            fileNames.add(formDataContentDisposition.getFileName());
            document.setUploadsFileName(fileNames);
            file = this.writeToFile(inputStream, formDataContentDisposition.getFileName());
            files.add(file);
            document.setUploads(files);
            contentTypes.add(MessageFormat.format("application/{0}", FilenameUtils.getExtension((String)file.getPath())));
            document.setUploadsContentType(contentTypes);
        }
        return document;
    }

    public BillReceiptInfo validateTransanctionIdPresent(String transantion) {
        return this.collectionService.getReceiptInfo("PT", transantion);
    }

    private Document createDocument(InputStream inputStream, String fileName) {
        Document document = new Document();
        ArrayList<File> files = new ArrayList<File>(0);
        ArrayList<String> contentTypes = new ArrayList<String>(0);
        ArrayList<String> fileNames = new ArrayList<String>(0);
        File file = null;
        if (inputStream != null && fileName != null) {
            fileNames.add(fileName);
            document.setUploadsFileName(fileNames);
            file = this.writeToFile(inputStream, fileName);
            files.add(file);
            document.setUploads(files);
            contentTypes.add(MessageFormat.format("application/{0}", FilenameUtils.getExtension((String)file.getPath())));
            document.setUploadsContentType(contentTypes);
        }
        return document;
    }

    private File writeToFile(InputStream uploadedInputStream, String fileName) {
        File file = new File(fileName);
        try {
            FileOutputStream out = new FileOutputStream(new File(fileName));
            int read = 0;
            byte[] bytes = new byte[1024];
            while ((read = uploadedInputStream.read(bytes)) != -1) {
                ((OutputStream)out).write(bytes, 0, read);
            }
            out.flush();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    private PropertyImpl transitionWorkFlow(PropertyImpl property) {
        DateTime currentDate = new DateTime();
        User user = this.userService.getUserById(ApplicationThreadLocals.getUserId());
        String approverComments = "Property has been successfully forwarded.";
        String currentState = "Create:Bill Collector Approved";
        PropertyService propService = (PropertyService)this.beanProvider.getBean("propService", PropertyService.class);
        Assignment assignment = propService.getUserPositionByZone(property.getBasicProperty(), property.getBasicProperty().getSource());
        Position pos = assignment.getPosition();
        WorkFlowMatrix wfmatrix = this.propertyWorkflowService.getWfMatrix(property.getStateType(), null, null, "NEW ASSESSMENT", "Create:Bill Collector Approved", null);
        property.transition().start().withSenderName(user.getName()).withComments("Property has been successfully forwarded.").withStateValue(wfmatrix.getCurrentState()).withDateInfo(currentDate.toDate()).withOwner(pos).withNextAction("UD Revenue Inspector Approval Pending").withNatureOfTask("New Assessment");
        return property;
    }

    public List<MasterCodeNamePairDetails> getDocumentTypes() {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>(0);
        List documentTypesList = this.entityManager.createQuery("from DocumentType order by id").getResultList();
        for (DocumentType documentType : documentTypesList) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(documentType.getId().toString());
            mstrCodeNamePairDetails.setName(documentType.getName());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return mstrCodeNamePairDetailsList;
    }

    private Apartment getApartmentByCode(String apartmentCode) {
        Query qry = this.entityManager.createQuery("from Apartment ap where ap.code = :code");
        qry.setParameter("code", (Object)apartmentCode);
        Apartment apartment = (Apartment)((Object)qry.getSingleResult());
        return apartment;
    }

    public RestAssessmentDetails fetchAssessmentDetails(String assessmentNo) {
        PropertyMutation propertyMutation;
        this.assessmentDetails = new RestAssessmentDetails();
        this.basicProperty = this.basicPropertyDAO.getAllBasicPropertyByPropertyID(assessmentNo);
        if (this.basicProperty != null) {
            this.assessmentDetails.setAssessmentNo(this.basicProperty.getUpicNo());
            this.assessmentDetails.setPropertyAddress(this.basicProperty.getAddress().toString());
            this.property = (PropertyImpl)this.basicProperty.getProperty();
            this.assessmentDetails.setLocalityName(this.basicProperty.getPropertyID().getLocality().getName());
            if (this.property != null) {
                this.assessmentDetails.setOwnerDetails(this.prepareOwnerInfo(this.property));
                if (this.property.getPropertyDetail().getTotalBuiltupArea() != null && this.property.getPropertyDetail().getTotalBuiltupArea().getArea() != null) {
                    this.assessmentDetails.setPlinthArea(this.property.getPropertyDetail().getTotalBuiltupArea().getArea());
                }
                Ptdemand currentPtdemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(this.property);
                BigDecimal totalTaxDue = BigDecimal.ZERO;
                if (currentPtdemand != null) {
                    for (EgDemandDetails demandDetails : currentPtdemand.getEgDemandDetails()) {
                        if (demandDetails.getAmount().compareTo(demandDetails.getAmtCollected()) <= 0) continue;
                        totalTaxDue = totalTaxDue.add(demandDetails.getAmount().subtract(demandDetails.getAmtCollected()));
                    }
                }
                this.assessmentDetails.setTotalTaxDue(totalTaxDue);
            }
        }
        if ((propertyMutation = this.getLatestPropertyMutationByAssesmentNo(assessmentNo)) != null) {
            this.assessmentDetails.setMutationFee(propertyMutation.getMutationFee());
            if (StringUtils.isNotBlank((CharSequence)propertyMutation.getReceiptNum())) {
                this.assessmentDetails.setIsMutationFeePaid("Y");
                this.assessmentDetails.setFeeReceipt(propertyMutation.getReceiptNum());
                Date receiptDate = null;
                Query qry = this.entityManager.createQuery("select receiptdate from ReceiptHeader where receiptnumber = :receiptNum");
                qry.setParameter("receiptNum", (Object)propertyMutation.getReceiptNum());
                receiptDate = (Date)qry.getSingleResult();
                this.assessmentDetails.setFeeReceiptDate(new SimpleDateFormat("dd/MM/yyyy").format(receiptDate));
            } else {
                this.assessmentDetails.setIsMutationFeePaid("N");
            }
            this.assessmentDetails.setApplicationNo(propertyMutation.getApplicationNo());
        } else {
            this.assessmentDetails.setIsMutationFeePaid("N");
            this.assessmentDetails.setFeeReceipt("");
            this.assessmentDetails.setFeeReceiptDate("");
            this.assessmentDetails.setApplicationNo("");
        }
        return this.assessmentDetails;
    }

    public RestAssessmentDetails loadAssessmentDetails(String applicationNo) {
        this.assessmentDetails = new RestAssessmentDetails();
        PropertyMutation propertyMutation = this.getPropertyMutationByAssesmentNoAndApplicationNo(null, applicationNo);
        if (propertyMutation != null) {
            this.basicProperty = propertyMutation.getBasicProperty();
            if (this.basicProperty != null) {
                this.assessmentDetails.setAssessmentNo(this.basicProperty.getUpicNo());
                this.assessmentDetails.setPropertyAddress(this.basicProperty.getAddress().toString());
                this.property = (PropertyImpl)this.basicProperty.getProperty();
                this.assessmentDetails.setLocalityName(this.basicProperty.getPropertyID().getLocality().getName());
                if (this.property != null) {
                    this.assessmentDetails.setOwnerDetails(this.prepareOwnerInfo(this.property));
                    if (this.property.getPropertyDetail().getTotalBuiltupArea() != null && this.property.getPropertyDetail().getTotalBuiltupArea().getArea() != null) {
                        this.assessmentDetails.setPlinthArea(this.property.getPropertyDetail().getTotalBuiltupArea().getArea());
                    }
                    Ptdemand currentPtdemand = this.ptDemandDAO.getNonHistoryCurrDmdForProperty(this.property);
                    BigDecimal totalTaxDue = BigDecimal.ZERO;
                    if (currentPtdemand != null) {
                        for (EgDemandDetails demandDetails : currentPtdemand.getEgDemandDetails()) {
                            if (demandDetails.getAmount().compareTo(demandDetails.getAmtCollected()) <= 0) continue;
                            totalTaxDue = totalTaxDue.add(demandDetails.getAmount().subtract(demandDetails.getAmtCollected()));
                        }
                    }
                    this.assessmentDetails.setTotalTaxDue(totalTaxDue);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)propertyMutation.getReceiptNum())) {
                this.assessmentDetails.setFeeReceipt(propertyMutation.getReceiptNum());
                this.assessmentDetails.setIsMutationFeePaid("Y");
                this.assessmentDetails.setMutationFee(BigDecimal.ZERO);
            } else {
                this.assessmentDetails.setIsMutationFeePaid("N");
                this.assessmentDetails.setMutationFee(propertyMutation.getMutationFee());
            }
            this.assessmentDetails.setApplicationNo(propertyMutation.getApplicationNo());
        } else {
            this.assessmentDetails.setIsMutationFeePaid("N");
        }
        return this.assessmentDetails;
    }

    public ReceiptDetails payMutationFee(PayPropertyTaxDetails payPropertyTaxDetails) {
        ReceiptDetails receiptDetails = null;
        ErrorDetails errorDetails = null;
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(payPropertyTaxDetails.getAssessmentNo());
        PropertyMutation propertyMutation = this.getLatestPropertyMutationByAssesmentNo(payPropertyTaxDetails.getAssessmentNo());
        this.propertyTaxBillable.setBasicProperty(basicProperty);
        ApplicationThreadLocals.setUserId((Long)2L);
        this.propertyTaxBillable.setTransanctionReferenceNumber(payPropertyTaxDetails.getTransactionId());
        this.propertyTaxBillable.setMutationFeePayment(Boolean.TRUE);
        this.propertyTaxBillable.setMutationFee(payPropertyTaxDetails.getPaymentAmount());
        this.propertyTaxBillable.setCallbackForApportion(Boolean.FALSE);
        if (propertyMutation != null) {
            this.propertyTaxBillable.setMutationApplicationNo(propertyMutation.getApplicationNo());
        }
        this.propertyTaxBillable.setUserId(ApplicationThreadLocals.getUserId());
        this.propertyTaxBillable.setReferenceNumber(this.propertyTaxNumberGenerator.generateManualBillNumber(basicProperty.getPropertyID()));
        EgBill egBill = this.ptBillServiceImpl.generateBill(this.propertyTaxBillable);
        CollectionHelper collectionHelper = new CollectionHelper(egBill);
        HashMap<String, String> paymentDetailsMap = new HashMap<String, String>();
        paymentDetailsMap.put("amount", payPropertyTaxDetails.getPaymentAmount().toString());
        paymentDetailsMap.put("paidBy", egBill.getCitizenName());
        if ("CHEQUE".equalsIgnoreCase(payPropertyTaxDetails.getPaymentMode().toLowerCase()) || "DD".equalsIgnoreCase(payPropertyTaxDetails.getPaymentMode().toLowerCase())) {
            paymentDetailsMap.put("instrumentNumber", payPropertyTaxDetails.getChqddNo());
            paymentDetailsMap.put("instrumentDate", ChequePayment.CHEQUE_DATE_FORMAT.format(payPropertyTaxDetails.getChqddDate()));
            paymentDetailsMap.put("branchName", payPropertyTaxDetails.getBranchName());
            Long validatesBankId = this.validateBank(payPropertyTaxDetails.getBankName());
            paymentDetailsMap.put("bankId", validatesBankId.toString());
        }
        Payment payment = Payment.create((String)payPropertyTaxDetails.getPaymentMode().toLowerCase(), paymentDetailsMap);
        collectionHelper.setIsMutationFeePayment(true);
        BillReceiptInfo billReceiptInfo = collectionHelper.executeCollection(payment, payPropertyTaxDetails.getSource());
        if (null != billReceiptInfo) {
            receiptDetails = new ReceiptDetails();
            receiptDetails.setReceiptNo(billReceiptInfo.getReceiptNum());
            receiptDetails.setReceiptDate(this.formatDate(billReceiptInfo.getReceiptDate()));
            receiptDetails.setPayeeName(billReceiptInfo.getPayeeName());
            receiptDetails.setPayeeAddress(billReceiptInfo.getPayeeAddress());
            receiptDetails.setBillReferenceNo(billReceiptInfo.getBillReferenceNum());
            receiptDetails.setServiceName(billReceiptInfo.getServiceName());
            receiptDetails.setDescription(billReceiptInfo.getDescription());
            receiptDetails.setPaidBy(billReceiptInfo.getPaidBy());
            receiptDetails.setPaymentAmount(billReceiptInfo.getTotalAmount());
            receiptDetails.setPaymentMode(payPropertyTaxDetails.getPaymentMode());
            receiptDetails.setTransactionId(billReceiptInfo.getManualReceiptNumber());
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-0");
            errorDetails.setErrorMessage("SUCCESS");
            receiptDetails.setErrorDetails(errorDetails);
        }
        return receiptDetails;
    }

    public boolean validateMutationFee(String assessmentNo, BigDecimal paymentAmount) {
        boolean validFee = true;
        PropertyMutation propertyMutation = this.getLatestPropertyMutationByAssesmentNo(assessmentNo);
        if (propertyMutation != null) {
            if (paymentAmount.compareTo(propertyMutation.getMutationFee()) > 0) {
                validFee = false;
            }
        } else {
            validFee = false;
        }
        return validFee;
    }

    public PropertyMutation getPropertyMutationByAssesmentNoAndApplicationNo(String assessmentNo, String applicationNo) {
        PropertyMutation propertyMutation = this.propertyMutationDAO.getPropertyMutationForAssessmentNoAndApplicationNumber(assessmentNo, applicationNo);
        return propertyMutation;
    }

    public PropertyMutation getLatestPropertyMutationByAssesmentNo(String assessmentNo) {
        PropertyMutation propertyMutation = this.propertyMutationDAO.getPropertyLatestMutationForAssessmentNo(assessmentNo);
        return propertyMutation;
    }

    public List<Object[]> getWardBlockLocalityMapping() {
        String query = "select parent.parent.boundaryNum as wardnum, parent.parent.name as wardname, parent.boundaryNum as blocknum, parent.name as blockname, child.boundaryNum as localitynum, child.name as localityname from CrossHierarchy ch, Boundary parent, Boundary child where ch.parent.id = parent.id  and ch.child.id = child.id  and ch.parentType.name=:block and ch.childType.name=:locality  and parent.parent.boundaryType.hierarchyType.name=:hierarchyType";
        List boundaryDetails = ((Session)this.entityManager.unwrap(Session.class)).createQuery(query).setParameter("block", (Object)"Block").setParameter("locality", (Object)"Locality").setParameter("hierarchyType", (Object)"REVENUE").list();
        return boundaryDetails;
    }
}

