/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.entity.recovery;

import java.util.Date;
import org.egov.infra.persistence.validator.annotation.DateFormat;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infstr.models.BaseModel;
import org.egov.ptis.domain.entity.recovery.Recovery;
import org.egov.ptis.notice.PtNotice;
import org.hibernate.validator.constraints.Length;

public class CeaseNotice
extends BaseModel {
    private static final long serialVersionUID = 1L;
    private Recovery recovery;
    private PtNotice notice;
    private Date executionDate;
    private String remarks;

    @Required(message="intimation.recovery.null")
    public Recovery getRecovery() {
        return this.recovery;
    }

    public PtNotice getNotice() {
        return this.notice;
    }

    @DateFormat(message="invalid.fieldvalue.executionDate")
    @Required(message="intimation.executionDate.null")
    public Date getExecutionDate() {
        return this.executionDate;
    }

    public void setRecovery(Recovery recovery) {
        this.recovery = recovery;
    }

    public void setNotice(PtNotice notice) {
        this.notice = notice;
    }

    public void setExecutionDate(Date executionDate) {
        this.executionDate = executionDate;
    }

    @Length(max=1024, message="intimation.remark.length")
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("executionDate :").append(null != this.executionDate ? this.executionDate : " ");
        sb.append("NoticeNo :").append(null != this.notice ? this.notice.getNoticeNo() : " ");
        return sb.toString();
    }
}

