/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.dao.property;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.dao.property.PropertyDAO;
import org.egov.ptis.domain.dao.property.PropertyIDDAO;
import org.egov.ptis.domain.dao.property.SearchPropertyDAO;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyAddress;
import org.egov.ptis.domain.entity.property.PropertyID;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.entity.property.SearchResult;
import org.egov.ptis.exceptions.PropertyNotFoundException;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="searchPropertyDAO")
@Transactional(readOnly=true)
public class SearchPropertyHibernateDAO
implements SearchPropertyDAO {
    private static final Logger LOGGER = Logger.getLogger(SearchPropertyHibernateDAO.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private PropertyIDDAO propertyIDDAO;
    @Autowired
    private PropertyDAO propertyDAO;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public SearchResult getBasicPropertyByRegNum(String regNum) throws PropertyNotFoundException {
        SearchResult retSearchResult;
        block7: {
            if (regNum == null || regNum.equals("")) {
                throw new ApplicationRuntimeException("Reg Num /Folio No is not Set during PropertySearch !!");
            }
            LOGGER.debug((Object)("getBasicPropertyByRegNum : regNum : " + regNum));
            BasicProperty basicProperty = null;
            Property property = null;
            retSearchResult = null;
            try {
                basicProperty = this.basicPropertyDAO.getBasicPropertyByRegNum(regNum);
                if (basicProperty != null) {
                    property = basicProperty.getProperty();
                    if (property != null) {
                        retSearchResult = new SearchResult();
                        retSearchResult.setFolioNumber(regNum);
                        retSearchResult.setUpicNumber(basicProperty.getUpicNo());
                        retSearchResult.setAssesseeFullName(basicProperty.getFullOwnerName());
                        retSearchResult.setAddress(basicProperty.getAddress().toString());
                        retSearchResult.setBasicPropertyId(String.valueOf(basicProperty.getId()));
                    }
                    break block7;
                }
                throw new PropertyNotFoundException("Search Failed No Such Property Existing : BasicProperty is Null");
            }
            catch (HibernateException e) {
                PropertyNotFoundException pnf = new PropertyNotFoundException("Hibernate Exception In getBasicPropertyByRegNum: " + e.getMessage());
                pnf.initCause(e);
                throw pnf;
            }
            catch (PropertyNotFoundException e) {
                LOGGER.error((Object)("PropertyNotFoundException in  getBasicPropertyByRegNum : " + e.getMessage()));
                throw new PropertyNotFoundException("Exception in  getBasicPropertyByRegNum");
            }
            catch (Exception e) {
                LOGGER.error((Object)("Exception in  getBasicPropertyByRegNum : " + e.getMessage()));
                throw new ApplicationRuntimeException("Exception in  getBasicPropertyByRegNum");
            }
        }
        return retSearchResult;
    }

    @Override
    public SearchResult getPropertyByPropertyId(String propertyId) throws PropertyNotFoundException {
        if (propertyId == null || propertyId.trim().equals("")) {
            throw new ApplicationRuntimeException("propertyId  is not Set during PropertySearch !!");
        }
        BasicProperty basicProperty = null;
        PropertyImpl property = null;
        SearchResult retSearchResult = null;
        BigDecimal currDemand = BigDecimal.ZERO;
        BigDecimal currDemandDue = BigDecimal.ZERO;
        BigDecimal currCollection = BigDecimal.ZERO;
        BigDecimal arrearsDue = BigDecimal.ZERO;
        BigDecimal arrDemand = BigDecimal.ZERO;
        BigDecimal arrCollection = BigDecimal.ZERO;
        try {
            basicProperty = this.basicPropertyDAO.getAllBasicPropertyByPropertyID(propertyId);
            if (basicProperty != null && (property = (PropertyImpl)basicProperty.getProperty()) != null) {
                LOGGER.debug((Object)("getPropertyByPropertyId : property id : " + property.getId()));
                Map<String, BigDecimal> DmdCollMap = this.ptDemandDAO.getDemandCollMap(property);
                currDemand = DmdCollMap.get("CURR_FIRSTHALF_DMD");
                arrDemand = DmdCollMap.get("ARR_DMD");
                currCollection = DmdCollMap.get("CURR_FIRSTHALF_COLL");
                arrCollection = DmdCollMap.get("ARR_COLL");
                currDemandDue = currDemand.subtract(currCollection);
                arrearsDue = arrDemand.subtract(arrCollection);
                PropertyAddress propertyAddress = basicProperty.getAddress();
                retSearchResult = new SearchResult();
                retSearchResult.setFolioNumber(basicProperty.getOldMuncipalNum());
                retSearchResult.setUpicNumber(basicProperty.getUpicNo());
                retSearchResult.setAssesseeFullName(basicProperty.getFullOwnerName());
                retSearchResult.setAddress(propertyAddress.toString());
                if (currDemand != null) {
                    retSearchResult.setCurrDemand(currDemand);
                }
                if (currDemandDue != null) {
                    retSearchResult.setCurrDemandDue(currDemandDue);
                }
                if (arrearsDue != null) {
                    retSearchResult.setArrearDue(arrearsDue);
                }
                retSearchResult.setBasicPropertyId(String.valueOf(basicProperty.getId()));
            }
        }
        catch (HibernateException e) {
            PropertyNotFoundException exception = new PropertyNotFoundException("Hibernate Exception In getPropertyByPropertyId: " + e.getMessage());
            exception.initCause(e);
            throw exception;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in  getPropertyByPropertyId : " + e.getMessage()));
            throw new ApplicationRuntimeException("Exception in  getPropertyByPropertyId");
        }
        return retSearchResult;
    }

    @Override
    public List getPropertyByBoundry(Integer zoneID, Integer wardID, Integer colonyID) throws PropertyNotFoundException {
        ArrayList<SearchResult> retList;
        block7: {
            if (zoneID == null || wardID == null || colonyID == null) {
                throw new ApplicationRuntimeException("Parameters not Set during PropertySearch based on Boundry!!");
            }
            LOGGER.info((Object)(">>>>>>>>>>>>>colonyId" + colonyID));
            BasicProperty basicProperty = null;
            PropertyID propertyID2 = null;
            PropertyImpl property = null;
            SearchResult retSearchResult = null;
            retList = null;
            try {
                List propIdList = this.propertyIDDAO.getPropertyIDByBoundry(zoneID, wardID, colonyID);
                if (propIdList != null && !propIdList.isEmpty()) {
                    retList = new ArrayList<SearchResult>();
                    for (PropertyID propertyID2 : propIdList) {
                        basicProperty = propertyID2.getBasicProperty();
                        LOGGER.info((Object)(">>>>>>>>>>>>>5basicProperty :" + basicProperty));
                        if (basicProperty == null || (property = (PropertyImpl)basicProperty.getProperty()) == null) continue;
                        LOGGER.info((Object)("::::::::::::::::::::property" + property.getId()));
                        retSearchResult = new SearchResult();
                        retSearchResult.setFolioNumber(basicProperty.getOldMuncipalNum());
                        retSearchResult.setUpicNumber(basicProperty.getUpicNo());
                        retSearchResult.setAssesseeFullName(basicProperty.getFullOwnerName());
                        retSearchResult.setAddress(basicProperty.getAddress().toString());
                        retSearchResult.setBasicPropertyId(String.valueOf(basicProperty.getId()));
                        retList.add(retSearchResult);
                    }
                    break block7;
                }
                throw new PropertyNotFoundException("Search Failed No Such Property Existing :Searching Property Based on Colony No !!");
            }
            catch (HibernateException e) {
                PropertyNotFoundException exception = new PropertyNotFoundException("Hibernate Exception In getPropertyByBoundry: " + e.getMessage());
                exception.initCause(e);
                throw exception;
            }
            catch (PropertyNotFoundException e) {
                LOGGER.error((Object)("PropertyNotFoundException in  getPropertyByBoundry : " + e.getMessage()));
                throw new PropertyNotFoundException("Exception in  getPropertyByBoundry");
            }
            catch (Exception e) {
                LOGGER.error((Object)("Exception in  getPropertyByBoundry : " + e.getMessage()));
                throw new ApplicationRuntimeException("Exception in  getPropertyByBoundry");
            }
        }
        return retList;
    }

    @Override
    public List getPropertyIDByBoundryForWardBlockStreet(Integer wardID, Integer blockID, Integer streetID) throws PropertyNotFoundException {
        ArrayList<SearchResult> retList;
        block7: {
            if (wardID == null || blockID == null || streetID == null) {
                throw new ApplicationRuntimeException("Parameters not Set during PropertySearch based on Boundry!!");
            }
            LOGGER.info((Object)(">>>>>>>>>>>>>streetID" + streetID));
            LOGGER.info((Object)"inside ward block street ");
            BasicProperty basicProperty = null;
            PropertyID propertyID2 = null;
            PropertyImpl property = null;
            SearchResult retSearchResult = null;
            retList = null;
            try {
                List propIdList = this.propertyIDDAO.getPropertyIDByBoundryForWardBlockStreet(wardID, blockID, streetID);
                if (propIdList != null && !propIdList.isEmpty()) {
                    retList = new ArrayList<SearchResult>();
                    for (PropertyID propertyID2 : propIdList) {
                        basicProperty = propertyID2.getBasicProperty();
                        LOGGER.info((Object)(">>>>>>>>>>>>>5basicProperty :" + basicProperty));
                        if (basicProperty == null || (property = (PropertyImpl)basicProperty.getProperty()) == null) continue;
                        LOGGER.info((Object)("::::::::::::::::::::property" + property.getId()));
                        retSearchResult = new SearchResult();
                        retSearchResult.setFolioNumber(basicProperty.getOldMuncipalNum());
                        retSearchResult.setUpicNumber(basicProperty.getUpicNo());
                        retSearchResult.setAssesseeFullName(basicProperty.getFullOwnerName());
                        retSearchResult.setAddress(basicProperty.getAddress().toString());
                        retSearchResult.setBasicPropertyId(String.valueOf(basicProperty.getId()));
                        retList.add(retSearchResult);
                    }
                    break block7;
                }
                throw new PropertyNotFoundException("Search Failed No Such Property Existing :Searching Property Based on Colony No !!");
            }
            catch (HibernateException e) {
                PropertyNotFoundException exception = new PropertyNotFoundException("Hibernate Exception In getPropertyByBoundry: " + e.getMessage());
                exception.initCause(e);
                throw exception;
            }
            catch (PropertyNotFoundException e) {
                LOGGER.error((Object)("PropertyNotFoundException in  getPropertyByBoundry : " + e.getMessage()));
                throw new PropertyNotFoundException("Exception in  getPropertyByBoundry");
            }
            catch (Exception e) {
                LOGGER.error((Object)("Exception in  getPropertyByBoundry : " + e.getMessage()));
                throw new ApplicationRuntimeException("Exception in  getPropertyByBoundry");
            }
        }
        return retList;
    }

    @Override
    public SearchResult getPropertyByBoundryAndMunNo(Integer zoneID, Integer wardID, Integer colonyID, Integer munNo) throws PropertyNotFoundException {
        SearchResult retSearchResult;
        block7: {
            if (zoneID == null || wardID == null || colonyID == null || munNo == null) {
                throw new ApplicationRuntimeException("Parameters not Set during PropertySearch based on Boundry!!");
            }
            BasicProperty basicProperty = null;
            PropertyID propertyID = null;
            Property property = null;
            retSearchResult = null;
            try {
                propertyID = this.propertyIDDAO.getPropertyByBoundryAndMunNo(zoneID, wardID, colonyID, munNo);
                if (propertyID != null) {
                    basicProperty = propertyID.getBasicProperty();
                    if (basicProperty != null && (property = basicProperty.getProperty()) != null) {
                        retSearchResult = new SearchResult();
                        retSearchResult.setFolioNumber(basicProperty.getOldMuncipalNum());
                        retSearchResult.setUpicNumber(basicProperty.getUpicNo());
                        retSearchResult.setAssesseeFullName(basicProperty.getFullOwnerName());
                        retSearchResult.setAddress(basicProperty.getAddress().toString());
                        retSearchResult.setBasicPropertyId(String.valueOf(basicProperty.getId()));
                    }
                    break block7;
                }
                throw new PropertyNotFoundException("Search Failed No Such Property Existing : Searching Property Based on Colony No,Please Try Later !!");
            }
            catch (HibernateException e) {
                PropertyNotFoundException exception = new PropertyNotFoundException("Hibernate Exception In getPropertyByBoundryAndMunNo: " + e.getMessage());
                exception.initCause(e);
                throw exception;
            }
            catch (PropertyNotFoundException e) {
                LOGGER.error((Object)("PropertyNotFoundException in  getPropertyByBoundry : " + e.getMessage()));
                throw new PropertyNotFoundException("Exception in  getPropertyByBoundry");
            }
            catch (Exception e) {
                LOGGER.error((Object)("Exception in  getPropertyByBoundryAndMunNo : " + e.getMessage()));
                throw new ApplicationRuntimeException("Exception in  getPropertyByBoundryAndMunNo");
            }
        }
        return retSearchResult;
    }

    @Override
    public List getPropertyByBoundryAndOwnerName(Integer boundryID, String ownerName, String phNumber) throws PropertyNotFoundException {
        if (boundryID == null) {
            throw new ApplicationRuntimeException("Parameters not Set during PropertySearch based on Boundry!!");
        }
        try {
            LOGGER.info((Object)"Executing testChequeQry query................................................");
            Boundary boundary = this.boundaryService.getBoundaryById(Long.valueOf(boundryID.longValue()));
            LOGGER.info((Object)"testQry executed......................................................");
            StringBuffer qryStr = new StringBuffer(2000);
            LOGGER.info((Object)"-----------search by boundary--------");
            qryStr.append("select distinct pi From PropertyImpl pi left join fetch pi.basicProperty bp where bp.boundary = :boundary  and pi.status='A' and pi.isDefaultProperty='Y' and bp.active='Y' ");
            LOGGER.info((Object)("searching for boundary" + qryStr.toString() + "boundaryId" + boundryID));
            Query qry = this.getCurrentSession().createQuery(qryStr.toString());
            if (ownerName != null && !ownerName.equals("")) {
                boolean phNumFound = false;
                qryStr.append(" and (pi.propertyOwnerSet.firstName like :firstName or pi.propertyOwnerSet.middleName like :firstName or pi.propertyOwnerSet.lastName like :firstName )");
                LOGGER.info((Object)("Query String for ownername" + qryStr.toString() + " ........ " + ownerName + "///////" + ownerName));
                qry = this.getCurrentSession().createQuery(qryStr.toString());
                if (phNumber != null && !phNumber.equals("")) {
                    phNumFound = true;
                    qryStr.append(" and (pi.propertyOwnerSet.homePhone =:homePhone or pi.propertyOwnerSet.officePhone =:homePhone or pi.propertyOwnerSet.mobilePhone =:homePhone)");
                    LOGGER.info((Object)("----------Searching With  Phnumber-----" + qryStr.toString()));
                    LOGGER.debug((Object)"allvalues set for phnumber");
                }
                qryStr.append(" order by bp.upicNo asc");
                qry = this.getCurrentSession().createQuery(qryStr.toString());
                qry.setString("firstName", ownerName + "%");
                if (phNumFound) {
                    qry.setString("homePhone", phNumber);
                }
                LOGGER.debug((Object)"allvalues set for ownerFullName");
            }
            qry.setEntity("boundary", (Object)boundary);
            List propertyList = qry.list();
            LOGGER.info((Object)("query given list of props" + propertyList.size()));
            if (propertyList != null) {
                return this.getSearchResultList(propertyList);
            }
            throw new PropertyNotFoundException("Internal Server Error in Searching Property Based on Colony No,Please Try Later !!");
        }
        catch (HibernateException e) {
            PropertyNotFoundException exception = new PropertyNotFoundException("Hibernate Exception In getPropertyByBoundryAndOwnerName: " + e.getMessage());
            exception.initCause(e);
            throw exception;
        }
        catch (PropertyNotFoundException e) {
            LOGGER.error((Object)("PropertyNotFoundException in  getPropertyByBoundryAndOwnerName : " + e.getMessage()));
            throw new PropertyNotFoundException("Exception in  getPropertyByBoundryAndOwnerName");
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in  getPropertyByBoundryAndOwnerName : " + e.getMessage()));
            throw new ApplicationRuntimeException("Exception in  getPropertyByBoundryAndOwnerName");
        }
    }

    @Override
    public List getPropertyByOldMuncipalNo(String oldMuncipalNo) throws PropertyNotFoundException {
        ArrayList<SearchResult> retList;
        block7: {
            if (oldMuncipalNo == null || oldMuncipalNo.trim().equals("")) {
                throw new ApplicationRuntimeException("oldMuncipalNo  is not Set during PropertySearch !!");
            }
            LOGGER.info((Object)(">>>>>>>>>>>>>oldMuncipalNo" + oldMuncipalNo));
            BasicProperty basicProperty2 = null;
            Property property = null;
            SearchResult retSearchResult = null;
            retList = null;
            try {
                List basicPropertyList = this.basicPropertyDAO.getBasicPropertyByOldMunipalNo(oldMuncipalNo);
                if (basicPropertyList != null) {
                    retList = new ArrayList<SearchResult>();
                    for (BasicProperty basicProperty2 : basicPropertyList) {
                        property = basicProperty2.getProperty();
                        if (property == null) continue;
                        retSearchResult = new SearchResult();
                        retSearchResult.setFolioNumber(basicProperty2.getOldMuncipalNum());
                        retSearchResult.setUpicNumber(basicProperty2.getUpicNo());
                        retSearchResult.setAssesseeFullName(basicProperty2.getFullOwnerName());
                        retSearchResult.setAddress(basicProperty2.getAddress().toString());
                        retSearchResult.setBasicPropertyId(String.valueOf(basicProperty2.getId()));
                        retList.add(retSearchResult);
                    }
                    break block7;
                }
                throw new PropertyNotFoundException("Search Failed No Such Property Existing : Searching Property Based on oldMuncipalNo,Please Try Later !!");
            }
            catch (HibernateException e) {
                PropertyNotFoundException exception = new PropertyNotFoundException("Hibernate Exception In getPropertyByOldMuncipalNo: " + e.getMessage());
                exception.initCause(e);
                throw exception;
            }
            catch (PropertyNotFoundException e) {
                LOGGER.error((Object)("PropertyNotFoundException in  getPropertyByOldMuncipalNo : " + e.getMessage()));
                throw new PropertyNotFoundException("Exception in  getPropertyByOldMuncipalNo");
            }
            catch (Exception e) {
                LOGGER.error((Object)("Exception in  getPropertyByOldMuncipalNo : " + e.getMessage()));
                throw new ApplicationRuntimeException("Exception in  getPropertyByOldMuncipalNo");
            }
        }
        return retList;
    }

    @Override
    public List getPropertiesById(List lstboundaries, String OwnerName2, String phoneNumber) throws PropertyNotFoundException {
        StringBuffer qryStr = new StringBuffer(2000);
        List propertyList = null;
        ArrayList<Long> streetIds = null;
        LOGGER.info((Object)"-----------search by boundary--------");
        try {
            if (lstboundaries != null) {
                LOGGER.info((Object)">>>>>>>>getting list of boundary Ids from boundary list");
                streetIds = new ArrayList<Long>();
                for (List resultList : lstboundaries) {
                    for (Boundary bndry : resultList) {
                        Long bndryId = bndry.getId();
                        LOGGER.debug((Object)("<<<<<<< bndryId = " + bndryId));
                        if (bndryId == null || streetIds.contains(bndryId)) continue;
                        streetIds.add(bndryId);
                    }
                }
            }
            String OwnerNewName = null;
            if (OwnerName2 != null) {
                StringBuffer OwnName = new StringBuffer(1500);
                StringTokenizer strToken = new StringTokenizer(OwnerName2);
                while (strToken.hasMoreTokens()) {
                    OwnName.append(strToken.nextToken(" "));
                    OwnName.append("%");
                }
                OwnerNewName = OwnName.toString();
                LOGGER.info((Object)("The Rearranged String is!!!!!!!!!!!!" + OwnerNewName));
            }
            qryStr.append("select distinct prop from PropertyImpl prop left join prop.basicProperty BP left join prop.propertyOwnerSet po  where BP.boundary.id in (:streetIds) and po.id in(select distinct own.id from Owner own where upper(own.firstName) like :OwnerName or upper(own.middleName) like :OwnerName or upper(own.lastName) like :OwnerName or upper(own.firstName)||upper(own.middleName) like :OwnName or upper(own.firstName)||upper(own.lastName) like :OwnName or upper(own.firstName)||upper(own.middleName)||upper(own.lastName) like :OwnName or upper(own.middleName)||upper(own.lastName) like :OwnName)");
            Query qry = this.getCurrentSession().createQuery(qryStr.toString());
            if (phoneNumber != null && !phoneNumber.equals("")) {
                qryStr.append(" and po.id in(select distinct own.id from Owner own where own.homePhone =:phoneNumber or own.officePhone =:phoneNumber  or own.mobilePhone =:phoneNumber) ");
                LOGGER.info((Object)("----------Searching With  Phnumber-----" + qryStr.toString()));
                qry = this.getCurrentSession().createQuery(qryStr.toString());
                qry.setString("phoneNumber", phoneNumber);
                LOGGER.debug((Object)"allvalues set for phnumber");
            }
            qry.setParameterList("streetIds", streetIds);
            qry.setString("OwnerName", OwnerName2.toUpperCase() + "%");
            qry.setString("OwnName", OwnerNewName.toUpperCase());
            propertyList = qry.list();
        }
        catch (Exception e) {
            LOGGER.error((Object)("error in query" + e.getMessage()));
        }
        return this.getSearchResultList(propertyList);
    }

    @Override
    public SearchResult getPropertyByKhataNumber(String khataNumber) throws PropertyNotFoundException {
        SearchResult retSearchResult;
        block7: {
            if (khataNumber == null || khataNumber.trim().equals("")) {
                throw new ApplicationRuntimeException("khataNumber  is not Set during PropertySearch !!");
            }
            LOGGER.info((Object)(">>>>>>>>>>>>>khataNumber" + khataNumber));
            BasicProperty basicProperty = null;
            PropertyImpl property = null;
            retSearchResult = null;
            try {
                basicProperty = this.basicPropertyDAO.getBasicPropertyByRegNum(khataNumber);
                if (basicProperty != null) {
                    property = (PropertyImpl)basicProperty.getProperty();
                    if (property != null) {
                        LOGGER.info((Object)("property id" + property.getId()));
                        retSearchResult = new SearchResult();
                        retSearchResult.setFolioNumber(basicProperty.getOldMuncipalNum());
                        retSearchResult.setUpicNumber(basicProperty.getUpicNo());
                        retSearchResult.setAssesseeFullName(basicProperty.getFullOwnerName());
                        retSearchResult.setAddress(basicProperty.getAddress().toString());
                    }
                    break block7;
                }
                throw new PropertyNotFoundException("Search Failed No Such Property Existing : Searching Property Based on Khata Number,Please Try Later !!");
            }
            catch (HibernateException e) {
                PropertyNotFoundException exception = new PropertyNotFoundException("Hibernate Exception In getPropertyByKhataNumber: " + e.getMessage());
                exception.initCause(e);
                throw exception;
            }
            catch (PropertyNotFoundException e) {
                LOGGER.error((Object)("PropertyNotFoundException in  getPropertyByKhataNumber : " + e.getMessage()));
                throw new PropertyNotFoundException("Exception in  getPropertyByKhataNumber");
            }
            catch (Exception e) {
                LOGGER.error((Object)("Exception in  getPropertyByKhataNumber : " + e.getMessage()));
                throw new ApplicationRuntimeException("Exception in  getPropertyByKhataNumber");
            }
        }
        return retSearchResult;
    }

    @Override
    public List getPropertyByRvAmout(Integer boundaryID, Character RvSel, String lowVal, String HighVal) throws PropertyNotFoundException {
        LOGGER.info((Object)">>>>>>>>>>inside getPropertyByRvAmout>>>>>>>>>>>>>>");
        if (RvSel == null || RvSel.equals("")) {
            throw new ApplicationRuntimeException("RV amout selection was not Set during PropertySearch based on Boundry!!");
        }
        LOGGER.info((Object)("after query execution--------------RvSel--" + RvSel.charValue() + "---------lowVal----------" + lowVal + "--------HighVal--------" + HighVal));
        try {
            LOGGER.info((Object)"Executing testChequeQry query...............");
            Boundary boundary = this.boundaryService.getBoundaryById(Long.valueOf(boundaryID.longValue()));
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            String finEndDate = sdf.format(new Date());
            StringBuffer qryStr = new StringBuffer(2000);
            qryStr.append("select distinct pi From PropertyImpl pi inner join pi.basicProperty bp inner join pi.ptDemandARVSet rv where rv.toDate = to_date('" + finEndDate + "','dd/mm/yyyy') and pi.status='A' and bp.active='Y' ");
            boolean rvLess = false;
            boolean rvGreater = false;
            boolean rvBetween = false;
            boolean rvEqual = false;
            boolean seatFound = false;
            if (boundaryID != null && boundaryID != 0) {
                seatFound = true;
                qryStr.append(" and bp.boundary = :boundary");
                LOGGER.info((Object)(">>>>>>>>>>>>>>Search by seat no>>>>>>>>>>>>> " + qryStr.toString() + "....." + boundaryID));
            }
            if (RvSel.charValue() == '1') {
                rvLess = true;
                qryStr.append(" and rv.arv <= :highVal ");
                LOGGER.info((Object)">>>>>>>>>>>>>>Search by arv amount rvsel--- 1");
            }
            if (RvSel.charValue() == '2') {
                rvGreater = true;
                qryStr.append(" and rv.arv >= :lowVal ");
                LOGGER.info((Object)">>>>>>>>>>>>>>Search by arv amount rvsel--- 2");
            }
            if (RvSel.charValue() == '3') {
                rvBetween = true;
                qryStr.append(" and rv.arv >= :lowVal and rv.arv <= :highVal ");
                LOGGER.info((Object)">>>>>>>>>>>>>>Search by arv amount rvsel--- 3");
            }
            if (RvSel.charValue() == '4') {
                rvEqual = true;
                qryStr.append(" and rv.arv = :lowVal ");
                LOGGER.info((Object)">>>>>>>>>>>>>>Search by arv amount rvsel--- 2");
            }
            LOGGER.info((Object)("query string final--------------" + qryStr.toString()));
            Query qry = this.getCurrentSession().createQuery(qryStr.toString());
            if (seatFound) {
                qry.setEntity("boundary", (Object)boundary);
            }
            if (rvLess) {
                qry.setBigDecimal("highVal", new BigDecimal(HighVal));
            }
            if (rvGreater) {
                qry.setBigDecimal("lowVal", new BigDecimal(lowVal));
            }
            if (rvBetween) {
                qry.setBigDecimal("lowVal", new BigDecimal(lowVal));
                qry.setBigDecimal("highVal", new BigDecimal(HighVal));
            }
            if (rvEqual) {
                qry.setBigDecimal("lowVal", new BigDecimal(lowVal));
            }
            LOGGER.info((Object)"before query execution");
            List propertyList = qry.list();
            if (propertyList == null) {
                throw new PropertyNotFoundException("No Properties Found with the matching Criteria: lowval:" + lowVal + ",highval:" + HighVal);
            }
            if (propertyList.size() > 200) {
                ArrayList<String> errorList = new ArrayList<String>();
                errorList.add(0, "more props");
                return errorList;
            }
            return this.getSearchResultList(propertyList);
        }
        catch (Exception e) {
            LOGGER.info((Object)("Excetion in getPropertyByRvAmout----------------" + e));
            throw new ApplicationRuntimeException("Error in getPropertyByRvAmout", (Throwable)e);
        }
    }

    @Override
    public List getPropertyByDmdAmout(Integer boundaryID, Character DmdSel, Character DmdChoice, String lowVal, String HighVal) throws PropertyNotFoundException {
        HashMap dmdMap = new HashMap();
        LOGGER.info((Object)"inside getPropertyByDmdAmout");
        ArrayList<PropertyImpl> propList = new ArrayList<PropertyImpl>();
        BigDecimal lowerLimit = BigDecimal.ZERO;
        BigDecimal upperLimit = BigDecimal.ZERO;
        LOGGER.info((Object)("lowerLimit -----------" + lowerLimit + "---upperLimit-----------" + upperLimit));
        LOGGER.info((Object)("DmdSel------------" + DmdSel.charValue() + "------DmdChoice-----------" + DmdChoice.charValue()));
        try {
            LOGGER.info((Object)("dmdMap.size()----------------------------------------" + dmdMap.size()));
            if (dmdMap.size() > 200) {
                ArrayList<String> errorList = new ArrayList<String>();
                errorList.add(0, "more props");
                return errorList;
            }
            if (dmdMap != null && !dmdMap.isEmpty()) {
                for (String pid : dmdMap.keySet()) {
                    BasicProperty basiProperty = this.basicPropertyDAO.findById(Integer.valueOf(pid), false);
                    PropertyImpl property = (PropertyImpl)basiProperty.getProperty();
                    propList.add(property);
                }
            }
            LOGGER.info((Object)("the size of the list-->" + propList.size()));
            if (propList == null) {
                throw new PropertyNotFoundException("No Properties Found with the matching Criteria: lowerLimit:" + lowVal + ",upperLimit:" + HighVal);
            }
            return this.getSearchResultList(propList);
        }
        catch (Exception e) {
            LOGGER.info((Object)("Excetion in getPropertyByDmdAmout---------" + e));
            throw new ApplicationRuntimeException("Error in getPropertyByDmdAmout", (Throwable)e);
        }
    }

    public List getSearchResultList(List propertyList) {
        BasicProperty basicProperty = null;
        HashSet<String> bpSet = new HashSet<String>();
        PropertyAddress address = null;
        ArrayList<SearchResult> retList = new ArrayList<SearchResult>();
        BigDecimal existARV = BigDecimal.ZERO;
        if (propertyList != null) {
            for (PropertyImpl property : propertyList) {
                if (property == null || bpSet.contains((basicProperty = property.getBasicProperty()).getUpicNo())) continue;
                bpSet.add(basicProperty.getUpicNo());
                if (basicProperty == null) continue;
                BigDecimal demand = BigDecimal.ZERO;
                BigDecimal rebate = BigDecimal.ZERO;
                BigDecimal collection = BigDecimal.ZERO;
                BigDecimal currDemand = BigDecimal.ZERO;
                SearchResult retSearchResult = new SearchResult();
                retSearchResult.setFolioNumber(basicProperty.getOldMuncipalNum());
                retSearchResult.setUpicNumber(basicProperty.getUpicNo());
                address = basicProperty.getAddress();
                if (address != null) {
                    retSearchResult.setAddress(basicProperty.getAddress().toString());
                }
                retSearchResult.setAssesseeFullName(basicProperty.getFullOwnerName());
                retSearchResult.setBasicPropertyId(String.valueOf(basicProperty.getId()));
                retSearchResult.setCurrYearArv(existARV.toString());
                demand = (BigDecimal)this.propertyDAO.getPropertyDemand(basicProperty.getUpicNo()).get(0);
                rebate = (BigDecimal)this.propertyDAO.getPropertyRebate(basicProperty.getUpicNo()).get(0);
                collection = (BigDecimal)this.propertyDAO.getPropertyCollection(basicProperty.getUpicNo()).get(0);
                if (demand != null && !demand.equals(BigDecimal.ZERO)) {
                    currDemand = demand;
                }
                if (rebate != null && !rebate.equals(BigDecimal.ZERO)) {
                    currDemand = demand.subtract(rebate);
                }
                if (collection != null && !collection.equals(BigDecimal.ZERO)) {
                    currDemand = currDemand.subtract(collection);
                }
                retSearchResult.setCurrDemand(currDemand);
                retList.add(retSearchResult);
            }
        }
        return retList;
    }

    @Override
    public List getInActivePropertyByBoundary(List lstboundaries) throws PropertyNotFoundException {
        LOGGER.info((Object)"getInActivePropertyByBoundary ");
        ArrayList<Long> streetIds = null;
        try {
            LOGGER.info((Object)"Executing boundary query................................................");
            if (lstboundaries != null) {
                LOGGER.info((Object)">>>>>>>>getting list of boundary Ids from boundary list");
                streetIds = new ArrayList<Long>();
                for (List resultList : lstboundaries) {
                    for (Boundary bndry : resultList) {
                        Long bndryId = bndry.getId();
                        LOGGER.debug((Object)("<<<<<<< bndryId = " + bndryId));
                        if (bndryId == null || streetIds.contains(bndryId)) continue;
                        streetIds.add(bndryId);
                    }
                }
            }
            StringBuffer qryStr = new StringBuffer(2000);
            qryStr.append("select distinct pi From PropertyImpl pi left join fetch pi.basicProperty bp where bp.boundary.id in (:streetIds) and pi.status='A' and bp.active='N'");
            Query qry = this.getCurrentSession().createQuery(qryStr.toString());
            qry.setParameterList("streetIds", streetIds);
            List propertyList = qry.list();
            if (propertyList != null) {
                return this.getSearchResultList(propertyList);
            }
            throw new PropertyNotFoundException("Internal Server Error in Searching InActive Property Based on Boundary,Please Try Later !!");
        }
        catch (HibernateException e) {
            PropertyNotFoundException exception = new PropertyNotFoundException("Hibernate Exception In getInActivePropertyByBoundary: " + e.getMessage());
            exception.initCause(e);
            throw exception;
        }
        catch (PropertyNotFoundException e) {
            LOGGER.error((Object)("PropertyNotFoundException in  getInActivePropertyByBoundary : " + e.getMessage()));
            throw new PropertyNotFoundException("Exception in  getInActivePropertyByBoundary");
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in  getInActivePropertyByBoundary : " + e.getMessage()));
            throw new ApplicationRuntimeException("Exception in  getInActivePropertyByBoundary");
        }
    }

    @Override
    public List getPropertyByMobileNumber(String mobileNum) throws PropertyNotFoundException {
        List propList = new ArrayList();
        StringBuffer qryStr = new StringBuffer(2000);
        try {
            Module module = this.moduleDao.getModuleByName("Property Tax");
            Installment installment = this.installmentDao.getInsatllmentByModuleForGivenDate(module, new Date());
            if (mobileNum != null && !mobileNum.equals("")) {
                Query qry = null;
                qryStr.append("select distinct pi From PropertyImpl pi left join fetch pi.basicProperty bp left join fetch bp.address ad where ad.mobileNo like :mobileNum  and pi.status='A' and pi.installment = :Installment ");
                qry = this.getCurrentSession().createQuery(qryStr.toString());
                qry.setString("mobileNum", "%" + mobileNum + "%");
                qry.setEntity("Installment", (Object)installment);
                propList = qry.list();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in  getPropertyByMobileNumber : " + e.getMessage()));
            throw new ApplicationRuntimeException("Exception in  getPropertyByMobileNumber");
        }
        return propList;
    }

    @Override
    public List getPropertyByBillNumber(String billNumber) throws PropertyNotFoundException {
        List propList = new ArrayList();
        StringBuffer qryStr = new StringBuffer(2000);
        try {
            if (billNumber != null && !billNumber.equals("")) {
                Module module = this.moduleDao.getModuleByName("Property Tax");
                Installment installment = this.installmentDao.getInsatllmentByModuleForGivenDate(module, new Date());
                Query qry = null;
                qryStr.append("From PropertyImpl pi left join fetch pi.basicProperty bp  where  bp.upicNo like :billNumber  and pi.isDefaultProperty='Y' and pi.status='A' and pi.installment = :Installment ");
                qry = this.getCurrentSession().createQuery(qryStr.toString());
                qry.setString("billNumber", billNumber + "%");
                qry.setEntity("Installment", (Object)installment);
                propList = qry.list();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in  getPropertyByBillNumber : " + e.getMessage()));
            throw new ApplicationRuntimeException("Exception in  getPropertyByBillNumber");
        }
        return propList;
    }

    @Override
    public List getPropertyByBoundryAndOwnerNameAndHouseNo(Integer boundryID, String ownerName, String newHouseNo, String oldHouseNo) throws PropertyNotFoundException {
        List propertyList = new ArrayList();
        try {
            if (boundryID != null && !boundryID.equals("")) {
                Boundary boundary = this.boundaryService.getBoundaryById(Long.valueOf(boundryID.longValue()));
                LOGGER.info((Object)("boundary.obj................" + boundary));
                StringBuffer qryStr = new StringBuffer(2000);
                qryStr.append("select distinct pi From PropertyImpl pi left join fetch pi.basicProperty bp left join fetch bp.propertyID ppid left join pi.propertyOwnerSet ownerSet where  pi.status='A' and pi.isDefaultProperty='Y' and bp.active='Y'  ");
                LOGGER.info((Object)("searching for boundary " + qryStr.toString() + "boundaryId" + boundryID));
                boolean bndryFound = false;
                boolean wardBndryFound = false;
                boolean areaBndryFound = false;
                boolean ownerFound = false;
                boolean houseFound = false;
                boolean oldHouseNum = false;
                if (boundary != null) {
                    String boundryType = boundary.getBoundaryType().getName();
                    LOGGER.info((Object)("testQry executed.......boundryType................." + boundryType));
                    if (boundryType != null && boundryType.endsWith("Ward")) {
                        wardBndryFound = true;
                        qryStr.append(" and ppid.ward = :boundary");
                    } else if (boundryType != null && boundryType.endsWith("Area")) {
                        areaBndryFound = true;
                        qryStr.append(" and ppid.area = :boundryID");
                    } else if (boundryType != null && boundryType.endsWith("Locality")) {
                        bndryFound = true;
                        qryStr.append(" and ppid.locality = :boundryID");
                    } else if (boundryType != null && boundryType.endsWith("Street")) {
                        bndryFound = true;
                        qryStr.append(" and ppid.street = :boundryID");
                    }
                }
                if (ownerName != null && !ownerName.equals("")) {
                    ownerFound = true;
                    qryStr.append(" and (upper(ownerSet.firstName) like :firstName or upper(ownerSet.middleName) like :firstName or upper(ownerSet.lastName) like :firstName) ");
                }
                if (newHouseNo != null && !newHouseNo.equals("")) {
                    houseFound = true;
                    qryStr.append(" and (upper(pi.basicProperty.address.houseNo) like :houseno ) ");
                }
                if (oldHouseNo != null && !oldHouseNo.equals("")) {
                    oldHouseNum = true;
                    qryStr.append(" and (upper(pi.basicProperty.address.doorNumOld) like :oldHouseNo) ");
                }
                qryStr.append(" order by bp.id ");
                LOGGER.debug((Object)("query string final--------------" + qryStr.toString()));
                Query qry = this.getCurrentSession().createQuery(qryStr.toString());
                if (wardBndryFound) {
                    qry.setEntity("boundary", (Object)boundary);
                }
                if (areaBndryFound) {
                    qry.setInteger("boundryID", boundryID.intValue());
                }
                if (bndryFound) {
                    qry.setInteger("boundryID", boundryID.intValue());
                }
                if (ownerFound) {
                    qry.setString("firstName", "%" + ownerName.toUpperCase() + "%");
                }
                if (houseFound) {
                    qry.setString("houseno", newHouseNo.toUpperCase() + "%");
                }
                if (oldHouseNum) {
                    qry.setString("oldHouseNo", oldHouseNo.toUpperCase() + "%");
                }
                propertyList = qry.list();
            }
            return propertyList;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error in getPropertyByBoundryAndOwnerNameAndHouseNo", (Throwable)e);
        }
    }

    @Override
    public List<Property> getPropertyByObjectionDetails(Long propertyTypeMasterId, String objectionNumber, Date fromObjection, Date toObjection) throws ValidationException {
        if ((objectionNumber == null || objectionNumber.trim().isEmpty()) && fromObjection == null && toObjection == null) {
            throw new ValidationException("ObjectioNumber or ObjectionDate is mandatory", "ObjectioNumber or ObjectionDate is mandatory", new String[0]);
        }
        Criteria propertyCriteria = this.getCurrentSession().createCriteria(PropertyImpl.class, "propertyImpl").add((Criterion)Restrictions.eq((String)"status", (Object)PropertyTaxConstants.STATUS_ISACTIVE));
        DetachedCriteria detachCrtObjection = DetachedCriteria.forClass(RevisionPetition.class);
        detachCrtObjection.setProjection((Projection)Projections.projectionList().add((Projection)Projections.property((String)"basicProperty")));
        if (propertyTypeMasterId != null && propertyTypeMasterId > 0L) {
            propertyCriteria.createAlias("propertyDetail", "propertyDetail");
            propertyCriteria.createAlias("propertyDetail.propertyTypeMaster", "propertyTypeMaster");
            propertyCriteria.add((Criterion)Restrictions.eq((String)"propertyTypeMaster.id", (Object)propertyTypeMasterId));
        }
        if (objectionNumber != null && !objectionNumber.trim().isEmpty()) {
            detachCrtObjection.add(Restrictions.ilike((String)"objectionNumber", (Object)objectionNumber));
        }
        if (fromObjection != null && toObjection != null) {
            detachCrtObjection.add(Restrictions.between((String)"recievedOn", (Object)fromObjection, (Object)toObjection));
        } else if (fromObjection != null) {
            detachCrtObjection.add((Criterion)Restrictions.ge((String)"recievedOn", (Object)fromObjection));
        } else if (toObjection != null) {
            detachCrtObjection.add((Criterion)Restrictions.le((String)"recievedOn", (Object)toObjection));
        }
        propertyCriteria.add(Subqueries.propertyIn((String)"basicProperty", (DetachedCriteria)detachCrtObjection));
        return propertyCriteria.list();
    }

    public List getPropertyByBoundryAndQueryParamMap(Map<String, Object> queryParamMap) throws PropertyNotFoundException {
        String ownerName = null;
        String newHouseNo = null;
        Object oldHouseNo = null;
        Integer propTypeId = null;
        BigDecimal dmdFrmAmt = null;
        BigDecimal dmdToAmt = null;
        BigDecimal defaultFrmamt = null;
        BigDecimal defaultToAmt = null;
        List propertyList = new ArrayList();
        try {
            Integer boundryID;
            if (queryParamMap.get("BOUNDARYID") != null && (boundryID = (Integer)queryParamMap.get("BOUNDARYID")) != null && !boundryID.equals("")) {
                Boundary boundary = this.boundaryService.getBoundaryById(Long.valueOf(boundryID.longValue()));
                LOGGER.info((Object)("boundary.obj................" + boundary));
                if (boundary != null) {
                    String boundryType = boundary.getBoundaryType().getName();
                    LOGGER.info((Object)("testQry executed.......boundryType................." + boundryType));
                    StringBuffer qryStr = new StringBuffer(2000);
                    qryStr.append("select EGPTP.ID_PROPERTY from egpt_property egptp left outer join egpt_basic_property egptb").append(" on EGPTP.ID_BASIC_PROPERTY=EGPTB.ID_BASIC_PROPERTY").append(" left outer join egpt_propertyid egptpid on EGPTB.ID_PROPERTYID=EGPTPID.ID").append(" left outer join egpt_property_detail egptpd on EGPTP.ID_PROPERTY=EGPTPD.ID_PROPERTY").append(" left outer join egpt_ptdemand egptde on EGPTP.ID_PROPERTY=EGPTDE.ID_PROPERTY").append(" left outer join EG_DEMAND_DETAILS egdet on EGPTDE.ID_DEMAND=EGDET.ID_DEMAND").append(" left outer join eg_demand_reason egdr on EGDET.ID_DEMAND_REASON=egdr.id").append(" left outer join eg_address egadd on EGPTB.ADDRESSID=EGADD.ADDRESSID").append(" left outer join EGPT_PROPERTY_OWNER egptprown on EGPTP.ID_PROPERTY=EGPTPROWN.ID_PROPERTY").append(" left outer join eg_citizen egciti on EGPTPROWN.OWNERID=EGCITI.CITIZENID").append(" where EGPTP.STATUS='A' and EGPTP.IS_DEFAULT_PROPERTY='Y' and EGPTB.IS_ACTIVE='Y'");
                    LOGGER.debug((Object)("searching for boundary " + qryStr.toString() + "boundaryId" + boundryID));
                    boolean zoneBndryFound = false;
                    boolean bndryFound = false;
                    boolean wardBndryFound = false;
                    boolean areaBndryFound = false;
                    boolean ownerFound = false;
                    boolean houseFound = false;
                    boolean propTypeFound = false;
                    boolean demandFound = false;
                    boolean defaulterFound = false;
                    if (boundryType != null && boundryType.endsWith("Revenue Zone")) {
                        zoneBndryFound = true;
                        qryStr.append(" and EGPTPID.ZONE_NUM= :boundryID");
                    } else if (boundryType != null && boundryType.endsWith("Revenue Ward")) {
                        wardBndryFound = true;
                        qryStr.append(" and EGPTPID.WARD_ADM_ID = :boundryID");
                    } else if (boundryType != null && boundryType.endsWith("Revenue Area")) {
                        areaBndryFound = true;
                        qryStr.append(" and EGPTPID.ADM1 = :boundryID");
                    } else if (boundryType != null && boundryType.endsWith("Revenue Locality")) {
                        bndryFound = true;
                        qryStr.append(" and EGPTPID.ADM2 = :boundryID");
                    } else if (boundryType != null && boundryType.endsWith("Revenue Street")) {
                        bndryFound = true;
                        qryStr.append(" and EGPTPID.ADM3 = :boundryID");
                    }
                    if (queryParamMap.get("OWNERNAME") != null && !(ownerName = queryParamMap.get("OWNERNAME").toString()).equals("")) {
                        ownerFound = true;
                        qryStr.append(" and upper(EGCITI.FIRSTNAME) like :firstName ");
                    }
                    if (queryParamMap.get("NEWHOUSENO") != null && !(newHouseNo = queryParamMap.get("NEWHOUSENO").toString()).equals("")) {
                        houseFound = true;
                        qryStr.append(" and upper(EGADD.HOUSENO) like :houseno ");
                    }
                    if (queryParamMap.get("PROPERTYTYPE") != null && (propTypeId = (Integer)queryParamMap.get("PROPERTYTYPE")) != -1) {
                        propTypeFound = true;
                        qryStr.append(" and EGPTPD.ID_PROPERTYTYPEMASTER =:propType ");
                    }
                    qryStr.append(" and EGDR.ID_INSTALLMENT = (select id_installment from eg_installment_master where start_date<=sysdate and end_date>=sysdate").append(" and id_module=(select id_module from eg_module where module_name='Property Tax')) ").append(" group by EGDR.ID_INSTALLMENT,EGPTP.ID_PROPERTY");
                    if (queryParamMap.get("DMD_FROM_AMOUNT") != null || queryParamMap.get("DMD_TO_AMOUNT") != null) {
                        dmdFrmAmt = (BigDecimal)queryParamMap.get("DMD_FROM_AMOUNT");
                        dmdToAmt = (BigDecimal)queryParamMap.get("DMD_TO_AMOUNT");
                        demandFound = true;
                        qryStr.append(" having sum( EGDET.AMOUNT) BETWEEN :dmdFrmAmt and :dmdToAmt ");
                    }
                    if (queryParamMap.get("DEFAULTER_FROM_AMOUNT") != null || queryParamMap.get("DEFAULTER_TO_AMOUNT") != null) {
                        defaultFrmamt = (BigDecimal)queryParamMap.get("DEFAULTER_FROM_AMOUNT");
                        defaultToAmt = (BigDecimal)queryParamMap.get("DEFAULTER_TO_AMOUNT");
                        defaulterFound = true;
                        qryStr.append(" having sum(EGDET.AMOUNT)- sum(EGDET.AMT_COLLECTED) between :defaultFrmAmt and :defaultToAmt ");
                    }
                    LOGGER.info((Object)("query string final--------------" + qryStr.toString()));
                    SQLQuery qry = this.getCurrentSession().createSQLQuery(qryStr.toString());
                    if (zoneBndryFound) {
                        qry.setInteger("boundryID", boundryID.intValue());
                    }
                    if (wardBndryFound) {
                        qry.setInteger("boundryID", boundryID.intValue());
                    }
                    if (areaBndryFound) {
                        qry.setInteger("boundryID", boundryID.intValue());
                    }
                    if (bndryFound) {
                        qry.setInteger("boundryID", boundryID.intValue());
                    }
                    if (ownerFound) {
                        qry.setString("firstName", "%" + ownerName.toUpperCase() + "%");
                    }
                    if (houseFound) {
                        qry.setString("houseno", newHouseNo.toUpperCase() + "%");
                    }
                    if (propTypeFound) {
                        qry.setInteger("propType", propTypeId.intValue());
                    }
                    if (demandFound) {
                        qry.setBigDecimal("dmdFrmAmt", dmdFrmAmt);
                        qry.setBigDecimal("dmdToAmt", dmdToAmt);
                    }
                    if (defaulterFound) {
                        qry.setBigDecimal("defaultFrmAmt", defaultFrmamt);
                        qry.setBigDecimal("defaultToAmt", defaultToAmt);
                    }
                    propertyList = qry.list();
                }
            }
            return propertyList;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error in getPropertyByBoundryAndOwnerNameAndHouseNo", (Throwable)e);
        }
    }
}

