/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.dao.property;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.ptis.notice.PtNotice;
import org.egov.ptis.notice.SearchNoticeForm;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="noticeDAO")
@Transactional(readOnly=true)
public class NoticeDAO {
    public static final Logger LOGGER = Logger.getLogger(NoticeDAO.class);
    @PersistenceContext
    private EntityManager entityManager;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public boolean saveNoticeDetails(PtNotice notice, InputStream noticeDocFis) {
        boolean isNoticeSaved = false;
        try {
            Query query = this.getCurrentSession().createSQLQuery("insert into EGPT_NOTICE (ID,ID_MODULE,NOTICETYPE,NOTICENO,NOTICEDATE,ID_USER) values (SEQ_EGPT_NOTICE.nextval,?,?,?,sysdate,?").setParameter(0, (Object)notice.getModuleId()).setParameter(1, (Object)notice.getNoticeType()).setParameter(2, (Object)notice.getNoticeNo()).setParameter(3, (Object)notice.getUserId());
            query.executeUpdate();
            isNoticeSaved = true;
        }
        catch (Exception e) {
            LOGGER.info((Object)("Exception in saveNoticeDetails()--- NoticeDao--" + e.getMessage()));
        }
        return isNoticeSaved;
    }

    public InputStream getNoticeDocument(String noticeNo, String objectNo) {
        Object conn = null;
        InputStream istream = null;
        String isBlob = null;
        try {
            List results = this.getCurrentSession().createSQLQuery("select DOCUMENT,IS_BLOB,DOCUMENT1 from notice where NOTICENO = ? and OBJECTNO = ?").setParameter(0, (Object)noticeNo).setParameter(1, (Object)objectNo).list();
            for (Object result : results) {
                Object[] objects = (Object[])result;
                isBlob = (String)objects[1];
                if (isBlob != null && isBlob.equals("Y")) {
                    istream = (InputStream)objects[2];
                    continue;
                }
                if (isBlob != null && (isBlob == null || !isBlob.equals("N"))) continue;
                istream = (InputStream)objects[0];
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)("Exception in getNoticeDocument()--- NoticeDao--" + e.getMessage()));
        }
        return istream;
    }

    public List<PtNotice> getNoticeDetails(SearchNoticeForm searchNoticeForm) {
        StringBuffer queryStr = new StringBuffer(500);
        ArrayList<String> params = new ArrayList<String>();
        Object resultSet = null;
        PtNotice notice = null;
        ArrayList<PtNotice> searchNoticeList = new ArrayList<PtNotice>();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", Locale.US);
        try {
            if (searchNoticeForm != null) {
                queryStr.append("select * from EGPT_NOTICE where NOTICETYPE = ? and NOTICENO = ? ");
                params.add(searchNoticeForm.getNoticeType());
                params.add(searchNoticeForm.getNoticeNumber());
                if (searchNoticeForm.getFromDate() != null && !searchNoticeForm.getFromDate().equals("") && searchNoticeForm.getToDate() != null && !searchNoticeForm.getToDate().equals("")) {
                    Date toDate = sdf.parse(searchNoticeForm.getToDate());
                    int day = toDate.getDate();
                    toDate.setDate(day + 1);
                    queryStr.append(" and NOTICEDATE between to_date(?,'dd/MM/yyyy') and to_date(?,'dd/MM/yyyy')");
                    params.add(searchNoticeForm.getFromDate());
                    params.add(sdf.format(toDate));
                }
                queryStr.append(" order by NOTICEDATE desc ");
                SQLQuery query = this.getCurrentSession().createSQLQuery(queryStr.toString());
                int i = 0;
                for (Object e : params) {
                    query.setParameter(i, e);
                    ++i;
                }
                List results = query.list();
                for (Object object : results) {
                    Object[] result = (Object[])object;
                    notice = new PtNotice();
                    notice.setNoticeNo((String)result[3]);
                    notice.setNoticeDate((Date)result[4]);
                    searchNoticeList.add(notice);
                }
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)("Exception in getNoticeDetails()--- NoticeDao--" + e.getMessage()));
        }
        return searchNoticeList;
    }
}

