/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.client.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.demand.model.EgDemandReasonDetails;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.client.model.TaxDetail;
import org.egov.ptis.client.model.calculator.APMiscellaneousTaxDetail;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.UnitCalculationDetail;
import org.egov.ptis.domain.model.calculator.MiscellaneousTax;
import org.egov.ptis.domain.model.calculator.MiscellaneousTaxDetail;
import org.egov.ptis.domain.model.calculator.TaxCalculationInfo;
import org.egov.ptis.domain.model.calculator.UnitTaxCalculationInfo;
import org.springframework.beans.factory.annotation.Autowired;

public class PropertyNoticeService {
    private static final String STR_MIGRATED = "Migrated";
    private static final Logger LOGGER = Logger.getLogger(PropertyNoticeService.class);
    private String indexNumber;
    private BasicProperty basicProperty;
    private Map<Date, TaxCalculationInfo> taxCalculations = new TreeMap<Date, TaxCalculationInfo>();
    private List<UnitCalculationDetail> unitCalcDetails;
    private PropertyTaxUtil propertyTaxUtil;
    private PersistenceService<BasicProperty, Long> basicPropertyService;
    private Map<Date, String> occupancyAndPropertyType = new TreeMap<Date, String>();
    @Autowired
    private ModuleService moduleDao;
    @Autowired
    private InstallmentDao installmentDao;
    private static Map<Integer, Map<String, Map<Date, BigDecimal>>> dateAndTotalCalcTaxByTaxForUnit;

    public PropertyNoticeService() {
    }

    public PropertyNoticeService(BasicProperty basicProperty, PropertyTaxUtil propertyTaxUtil, PersistenceService<BasicProperty, Long> basicPropertyService) {
        this.basicProperty = basicProperty;
        this.propertyTaxUtil = propertyTaxUtil;
        this.basicPropertyService = basicPropertyService;
    }

    public static PropertyNoticeService createNoticeService(BasicProperty basicProperty, PropertyTaxUtil propertyTaxUtil, PersistenceService<BasicProperty, Long> basicPropertyService) {
        return new PropertyNoticeService(basicProperty, propertyTaxUtil, basicPropertyService);
    }

    public Map<Date, TaxCalculationInfo> getTaxCaluculations() {
        return this.taxCalculations;
    }

    public void setTaxCaluculations(Map<Date, TaxCalculationInfo> taxCaluculations) {
        this.taxCalculations = taxCaluculations;
    }

    public List<UnitCalculationDetail> getUnitCalcDetails() {
        return this.unitCalcDetails;
    }

    public void setUnitCalcDetails(List<UnitCalculationDetail> unitCalcDetails) {
        this.unitCalcDetails = unitCalcDetails;
    }

    public void setPropertyTaxUtil(PropertyTaxUtil propertyTaxUtil) {
        this.propertyTaxUtil = propertyTaxUtil;
    }

    public String getIndexNumber() {
        return this.indexNumber;
    }

    public void setIndexNumber(String indexNumber) {
        this.indexNumber = indexNumber;
    }

    public PropertyTaxUtil getPropertyTaxUtil() {
        return this.propertyTaxUtil;
    }

    private void preparePropertyTypesByOccupancy(Map<Date, Property> propertyByOccupancy) {
        for (Map.Entry<Date, Property> entry : propertyByOccupancy.entrySet()) {
            this.occupancyAndPropertyType.put(entry.getKey(), entry.getValue().getPropertyDetail().getPropertyTypeMaster().getCode());
        }
    }

    public void migrateTaxXML() {
        LOGGER.debug((Object)("Entered into migrateTaxXML basicProperty.upicNo=" + this.basicProperty.getUpicNo()));
        try {
            Map<Date, Property> propertyByOccupancy = this.getPropertiesByOccupancy();
            this.preparePropertyTypesByOccupancy(propertyByOccupancy);
            this.prepareInstallmentWiseTaxCalcs(propertyByOccupancy);
            this.initCurrentUnitSlabs();
            List<UnitCalculationDetail> unitCalculationDetails = this.getTheRowsForChange();
            this.persistUnitCalcDetails(unitCalculationDetails);
        }
        catch (Exception e) {
            String errorMsg = "Error in Tax XML migration for " + this.basicProperty.getUpicNo();
            LOGGER.error((Object)errorMsg, (Throwable)e);
            throw new ApplicationRuntimeException(errorMsg, (Throwable)e);
        }
        LOGGER.debug((Object)"Exiting from migrateTaxXML");
    }

    private void initCurrentUnitSlabs() {
        dateAndTotalCalcTaxByTaxForUnit = new TreeMap<Integer, Map<String, Map<Date, BigDecimal>>>();
    }

    private List<UnitCalculationDetail> getTheRowsForChange() {
        LOGGER.debug((Object)"Entered into getTheRowsForChange");
        ArrayList<UnitCalculationDetail> unitCalculationDetails = new ArrayList<UnitCalculationDetail>();
        TreeMap<Integer, UnitTaxCalculationInfo> prevInstallmentUnitsByUnitNo = new TreeMap<Integer, UnitTaxCalculationInfo>();
        TreeMap nextInstallmentUnitsByUnitNo = new TreeMap();
        InstallmentUnitTax instPrevCurrUnitTax = null;
        List<String> emptyList = Collections.emptyList();
        Boundary propertyArea = null;
        for (Map.Entry<Date, TaxCalculationInfo> taxCalcAndInstallment : this.taxCalculations.entrySet()) {
            Module module = this.moduleDao.getModuleByName("Property Tax");
            Installment installment = this.installmentDao.getInsatllmentByModuleForGivenDate(module, taxCalcAndInstallment.getKey());
            TaxCalculationInfo taxCalcInfo = taxCalcAndInstallment.getValue();
            LOGGER.info((Object)("getTheRowsForChange - Installment =" + installment));
            prevInstallmentUnitsByUnitNo.putAll(nextInstallmentUnitsByUnitNo);
            nextInstallmentUnitsByUnitNo.clear();
            propertyArea = this.basicProperty.getProperty().getAreaBndry() != null ? this.basicProperty.getProperty().getAreaBndry() : this.basicProperty.getPropertyID().getArea();
            if (this.isStartingInstallment(prevInstallmentUnitsByUnitNo)) {
                for (Map.Entry entry : nextInstallmentUnitsByUnitNo.entrySet()) {
                    instPrevCurrUnitTax = InstallmentUnitTax.create(installment, null, (UnitTaxCalculationInfo)entry.getValue());
                    unitCalculationDetails.addAll(this.createUnitCalculationDetail(this.basicProperty.getProperty(), installment, taxCalcInfo, instPrevCurrUnitTax.getCurrentUnitAsList(), false));
                    this.setOccupancyDateAsFromDate(unitCalculationDetails);
                    instPrevCurrUnitTax.getCurrentUnitTaxSlabs(emptyList);
                }
                continue;
            }
            for (Map.Entry currentUnitTaxEntry : nextInstallmentUnitsByUnitNo.entrySet()) {
                instPrevCurrUnitTax = InstallmentUnitTax.create(installment, (UnitTaxCalculationInfo)prevInstallmentUnitsByUnitNo.get(currentUnitTaxEntry.getKey()), (UnitTaxCalculationInfo)currentUnitTaxEntry.getValue());
                if (instPrevCurrUnitTax.isCurrentUnitNewUnit()) {
                    unitCalculationDetails.addAll(this.createUnitCalculationDetail(this.basicProperty.getProperty(), installment, taxCalcInfo, instPrevCurrUnitTax.getCurrentUnitAsList(), false));
                    instPrevCurrUnitTax.getCurrentUnitTaxSlabs(emptyList);
                    continue;
                }
                if (instPrevCurrUnitTax.isSameALV() && instPrevCurrUnitTax.isSameOccupancy() || !instPrevCurrUnitTax.isSameALV()) {
                    if (!instPrevCurrUnitTax.isSameALV()) {
                        unitCalculationDetails.addAll(this.createUnitCalculationDetail(this.basicProperty.getProperty(), installment, taxCalcInfo, instPrevCurrUnitTax.getCurrentUnitAsList(), false));
                        instPrevCurrUnitTax.getCurrentUnitTaxSlabs(emptyList);
                    }
                    unitCalculationDetails.addAll(this.getUnitCalDetailsForSlabChange(this.basicProperty.getProperty(), taxCalcInfo, instPrevCurrUnitTax));
                }
                if (!instPrevCurrUnitTax.isSameALV() || instPrevCurrUnitTax.isSameOccupancy()) continue;
                unitCalculationDetails.addAll(this.createUnitCalculationDetail(this.basicProperty.getProperty(), installment, taxCalcInfo, instPrevCurrUnitTax.getCurrentUnitAsList(), false));
                instPrevCurrUnitTax.getCurrentUnitTaxSlabs(emptyList);
            }
        }
        LOGGER.debug((Object)"Exiting from getTheRowsForChange");
        return unitCalculationDetails;
    }

    private void setOccupancyDateAsFromDate(List<UnitCalculationDetail> unitCalculationDetails) {
        LOGGER.debug((Object)"Entered into setOccupancyDateAsFromDate");
        for (UnitCalculationDetail unitCalcDetail : unitCalculationDetails) {
            unitCalcDetail.setFromDate(unitCalcDetail.getOccupancyDate());
        }
        LOGGER.debug((Object)"Exiting from setOccupancyDateAsFromDate");
    }

    public void persistUnitCalcDetails(List<UnitCalculationDetail> unitCalculationDetails) {
        LOGGER.debug((Object)"Entered into persistUnitCalcDetails");
        this.basicProperty.getProperty().addAllUnitCalculationDetails(new LinkedHashSet<UnitCalculationDetail>(unitCalculationDetails));
        this.basicProperty.setIsTaxXMLMigrated(Character.valueOf('Y'));
        this.basicPropertyService.update((Object)this.basicProperty);
        LOGGER.debug((Object)"Exiting from persistUnitCalcDetails");
    }

    private boolean isStartingInstallment(Map<Integer, UnitTaxCalculationInfo> prevInstallmentUnitsByUnitNo) {
        return prevInstallmentUnitsByUnitNo.isEmpty();
    }

    private Map<Date, Property> getPropertiesByOccupancy() {
        LOGGER.debug((Object)"Entered into getPropertiesByOccupancy");
        TreeMap<Date, Property> propertyByCreatedDate = new TreeMap<Date, Property>();
        TreeMap<Date, Property> propertyByOccupancyDate = new TreeMap<Date, Property>();
        for (Property property : this.basicProperty.getPropertySet()) {
            if (property.getRemarks() != null && property.getRemarks().startsWith(STR_MIGRATED)) continue;
            propertyByCreatedDate.put(property.getCreatedDate(), property);
        }
        Date effectiveDate = null;
        for (Map.Entry entry : propertyByCreatedDate.entrySet()) {
            effectiveDate = ((Property)entry.getValue()).getPropertyDetail().getDateOfCompletion() == null ? ((Property)entry.getValue()).getEffectiveDate() : ((Property)entry.getValue()).getPropertyDetail().getDateOfCompletion();
            propertyByOccupancyDate.put(effectiveDate, (Property)entry.getValue());
        }
        LOGGER.debug((Object)"Exiting from getPropertiesByOccupancy");
        return propertyByOccupancyDate;
    }

    private int getBeginIndex(Map<Date, Property> propertyByOccupancyDate) {
        LOGGER.debug((Object)"Entered into getBeginIndex");
        int beginIndex = 0;
        ArrayList<Date> occupancyDates = new ArrayList<Date>(propertyByOccupancyDate.keySet());
        if (occupancyDates.size() > 1) {
            Property firstProperty = propertyByOccupancyDate.get(occupancyDates.get(0));
            Property nextProperty = propertyByOccupancyDate.get(occupancyDates.get(1));
            if (firstProperty.getPropertyDetail().getPropertyMutationMaster().getCode().equalsIgnoreCase("NEW") && nextProperty.getPropertyDetail().getPropertyMutationMaster().getCode().equalsIgnoreCase("DATA_ENTRY")) {
                LOGGER.debug((Object)"Returning from getBeginIndex with value 1");
                return 1;
            }
        }
        LOGGER.debug((Object)("Exiting from getBeginIndex, beginIndex=" + beginIndex));
        return beginIndex;
    }

    private void prepareInstallmentWiseTaxCalcs(Map<Date, Property> propertyByOccupancyDate) {
        LOGGER.info((Object)("Entered into prepareInstallmentWiseTaxCalcs occupancyDates=" + propertyByOccupancyDate.keySet()));
        Property prevProperty = null;
        Property nextProperty = null;
        ArrayList<Date> occupancyDates = new ArrayList<Date>(propertyByOccupancyDate.keySet());
        if (occupancyDates.size() > 1) {
            int first = this.getBeginIndex(propertyByOccupancyDate);
            int next = first + 1;
            prevProperty = propertyByOccupancyDate.get(occupancyDates.get(first));
            nextProperty = propertyByOccupancyDate.get(occupancyDates.get(next));
            this.taxCalculations.putAll(this.propertyTaxUtil.getTaxCalInfoMap(prevProperty.getPtDemandSet(), (Date)occupancyDates.get(first)));
            this.taxCalculations.keySet().removeAll(this.getInstallmentStartDates(this.propertyTaxUtil.getInstallmentListByStartDate(this.getPropertyOccupancyDate(nextProperty)), (Date)occupancyDates.get(next)));
            ArrayList<Date> retainDates = new ArrayList<Date>();
            for (int i = next; i < propertyByOccupancyDate.size() - 1; ++i) {
                prevProperty = propertyByOccupancyDate.get(occupancyDates.get(i));
                nextProperty = propertyByOccupancyDate.get(occupancyDates.get(i + 1));
                this.taxCalculations.putAll(this.propertyTaxUtil.getTaxCalInfoMap(prevProperty.getPtDemandSet(), (Date)occupancyDates.get(i)));
                retainDates.addAll(new ArrayList<Date>(this.taxCalculations.keySet()));
                retainDates.addAll(this.getInstallmentStartDates(this.propertyTaxUtil.getInstallmentListByStartDate(this.getPropertyOccupancyDate(prevProperty)), (Date)occupancyDates.get(i)));
                this.taxCalculations.keySet().retainAll(retainDates);
                this.taxCalculations.keySet().removeAll(this.getInstallmentStartDates(this.propertyTaxUtil.getInstallmentListByStartDate(this.getPropertyOccupancyDate(nextProperty)), (Date)occupancyDates.get(i + 1)));
            }
        }
        Date activePropOccupancyDate = (Date)occupancyDates.get(occupancyDates.size() - 1);
        Property activeProperty = propertyByOccupancyDate.get(activePropOccupancyDate);
        Map<Date, TaxCalculationInfo> activePropTaxCalcs = this.propertyTaxUtil.getTaxCalInfoMap(activeProperty.getPtDemandSet(), activePropOccupancyDate);
        activePropTaxCalcs.keySet().retainAll(this.getInstallmentStartDates(this.propertyTaxUtil.getInstallmentListByStartDate(this.getPropertyOccupancyDate(activeProperty)), activePropOccupancyDate));
        this.taxCalculations.putAll(activePropTaxCalcs);
        LOGGER.debug((Object)("prepareInstallmentWiseTaxCalcs - installments=" + this.taxCalculations.keySet()));
        LOGGER.debug((Object)"Exiting from prepareInstallmentWiseTaxCalcs");
    }

    private List<Date> getInstallmentStartDates(List<Installment> installments, Date occupancyDate) {
        LOGGER.debug((Object)("Entered into getInstallmentStartDates installments=" + installments + ", occupancyDate=" + occupancyDate));
        ArrayList<Date> installmentStartDates = new ArrayList<Date>();
        for (Installment installment : installments) {
            if (this.propertyTaxUtil.between(occupancyDate, installment.getFromDate(), installment.getToDate()).booleanValue()) {
                installmentStartDates.add(occupancyDate);
                continue;
            }
            installmentStartDates.add(installment.getFromDate());
        }
        LOGGER.debug((Object)("Exiting from getInstallmentStartDates - installmentStartDates=" + installmentStartDates));
        return installmentStartDates;
    }

    private Date getPropertyOccupancyDate(Property property) {
        return property.getPropertyDetail().getDateOfCompletion() == null ? property.getEffectiveDate() : property.getPropertyDetail().getDateOfCompletion();
    }

    private List<UnitCalculationDetail> getUnitCalDetailsForSlabChange(Property property, TaxCalculationInfo taxCalcInfo, InstallmentUnitTax instUnitTax) {
        Map<String, Date> slabChangedTaxes = instUnitTax.getSlabChangedTaxes();
        ArrayList<UnitCalculationDetail> unitCalculationDetails = new ArrayList<UnitCalculationDetail>();
        if (slabChangedTaxes.isEmpty()) {
            LOGGER.debug((Object)"slabChangedTaxes - No tax slabs have changed");
        } else {
            LOGGER.debug((Object)("slabChangedTaxes -" + slabChangedTaxes));
            instUnitTax.getCurrentUnitTaxSlabs(new ArrayList<String>(slabChangedTaxes.keySet()));
        }
        return unitCalculationDetails;
    }

    private List<UnitCalculationDetail> createUnitCalculationDetail(Property property, Installment installment, TaxCalculationInfo taxCalcInfo, List<UnitTaxCalculationInfo> unitTaxes, Boolean isTaxSlabChange) {
        LOGGER.debug((Object)"Entered into createUnitCalculationDetail");
        LOGGER.debug((Object)("createUnitCalculationDetail - property=" + property + ", installment=" + installment + ", unitTaxes.size=" + unitTaxes.size() + ", isTaxSlabChange=" + isTaxSlabChange));
        UnitCalculationDetail unitCalculationDetail = null;
        ArrayList<UnitCalculationDetail> unitCalculationDetails = new ArrayList<UnitCalculationDetail>();
        try {
            for (UnitTaxCalculationInfo unitTax : unitTaxes) {
                unitCalculationDetail = new UnitCalculationDetail();
                unitCalculationDetail.setCreatedTimeStamp(new Date());
                unitCalculationDetail.setLastUpdatedTimeStamp(new Date());
                unitCalculationDetail.setUnitNumber(Integer.valueOf(unitTax.getFloorNumber()));
                unitCalculationDetail.setUnitArea(unitTax.getFloorArea());
                unitCalculationDetail.setOccupancyDate(unitTax.getOccpancyDate());
                unitCalculationDetail.setGuidanceValue(unitTax.getBaseRate() == null ? BigDecimal.ZERO : unitTax.getBaseRate());
                unitCalculationDetail.setGuidValEffectiveDate(unitTax.getBaseRateEffectiveDate() == null ? unitTax.getOccpancyDate() : unitTax.getBaseRateEffectiveDate());
                unitCalculationDetail.setUnitOccupation(this.buildUnitOccupation(this.occupancyAndPropertyType.get(unitTax.getOccpancyDate()), unitTax));
                unitCalculationDetail.setInstallmentFromDate(installment.getFromDate());
                unitCalculationDetail.setMonthlyRent(unitTax.getMrv() == null ? BigDecimal.ZERO : unitTax.getMrv());
                if (isTaxSlabChange.booleanValue()) {
                    unitCalculationDetail.setFromDate(unitTax.getOccpancyDate());
                }
                this.setAnnualLettingValues(property, installment, unitCalculationDetail, taxCalcInfo);
                unitCalculationDetails.addAll(this.setMiscellaneousTaxDetails(property, installment, unitCalculationDetail, unitTax));
                this.setUnitAreaCalculationDetails(property, installment, unitCalculationDetail, unitTax);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while parsing unit tax instDate", (Throwable)e);
            throw new ApplicationRuntimeException("Error while parsing unit tax instDate", (Throwable)e);
        }
        LOGGER.debug((Object)("createUnitCalculationDetail - unitCalculationDetails=" + unitCalculationDetails));
        LOGGER.debug((Object)"Exiting from createUnitCalculationDetail");
        return unitCalculationDetails;
    }

    private void setAnnualLettingValues(Property property, Installment installment, UnitCalculationDetail unitCalculationDetail, TaxCalculationInfo taxCalcInfo) {
        LOGGER.debug((Object)"Entered into setAnnualLettingValues");
        LOGGER.debug((Object)("setAnnualLettingValues - property=" + property + ", installment=" + installment + ", unitCalculationDetail=" + unitCalculationDetail));
        TreeMap taxNameAndALV = new TreeMap();
        List<UnitTaxCalculationInfo> unitTaxes = taxCalcInfo.getUnitTaxCalculationInfos();
        LOGGER.debug((Object)("setAnnualLettingValues - unitCalculationDetail=" + unitCalculationDetail));
        LOGGER.debug((Object)"Exiting from setAnnualLettingValues");
    }

    private List<UnitCalculationDetail> setMiscellaneousTaxDetails(Property property, Installment installment, UnitCalculationDetail unitCalculationDetail, UnitTaxCalculationInfo consolidatedUnitTax) {
        LOGGER.debug((Object)"Entered into setMiscellaneousTaxDetails");
        LOGGER.debug((Object)("setMiscellaneousTaxDetails - property=" + property + ", installment=" + installment + ", unitCalculationDetail=" + unitCalculationDetail));
        BigDecimal totalCalculatedTax = BigDecimal.ZERO;
        Integer totalNoOfDays = PropertyTaxUtil.getNumberOfDays(installment.getFromDate(), installment.getToDate()).intValue();
        List<Object> demandReasonDetails = new ArrayList();
        String propertyType = property.getPropertyDetail().getPropertyTypeMaster().getCode();
        String amenities = "";
        String propertyTypeCategory = "";
        ArrayList<UnitCalculationDetail> unitCalculationDetails = new ArrayList<UnitCalculationDetail>();
        HashMap<String, TaxDetail> taxDetailAndTaxName = new HashMap<String, TaxDetail>();
        Object boundaryCategory = null;
        Integer noOfDaysForNewTaxSlab = 0;
        for (MiscellaneousTax miscTax : consolidatedUnitTax.getMiscellaneousTaxes()) {
            if (!this.hasNonHistoryTaxDetails(miscTax.getTaxDetails())) continue;
            String demandReasonCode = miscTax.getTaxName();
            BigDecimal alv = BigDecimal.ZERO;
            BigDecimal taxPercentage = BigDecimal.ZERO;
            BigDecimal calculatedAnnualTax = BigDecimal.ZERO;
            BigDecimal calculatedActualTax = BigDecimal.ZERO;
            BigDecimal demandRsnDtlPercResult = BigDecimal.ZERO;
            LOGGER.debug((Object)("setMiscellaneousTaxDetails - demandReasonCode=" + demandReasonCode + ", alv = " + alv));
            demandReasonDetails = this.propertyTaxUtil.getDemandReasonDetails(demandReasonCode, alv, installment);
            EgDemandReasonDetails demandReasonDetail = (EgDemandReasonDetails)demandReasonDetails.get(demandReasonDetails.size() - 1);
            if (propertyType != null && propertyType.equalsIgnoreCase("STATE_GOVT") && miscTax.getTaxName().equalsIgnoreCase("GEN_TAX")) {
                demandRsnDtlPercResult = BigDecimal.ZERO;
                if (demandReasonDetail != null) {
                    if (BigDecimal.ZERO.equals(demandReasonDetail.getFlatAmount())) {
                        Amount amount = new Amount(demandReasonDetail.getPercentage());
                        demandRsnDtlPercResult = amount.percentOf(alv);
                        amount.setValue(new BigDecimal(PropertyTaxConstants.STATEGOVT_BUILDING_GENERALTAX_ADDITIONALDEDUCTION));
                        calculatedAnnualTax = demandRsnDtlPercResult.subtract(amount.percentOf(demandRsnDtlPercResult));
                    } else if (demandReasonDetail.getPercentage() == null) {
                        calculatedAnnualTax = demandReasonDetail.getFlatAmount();
                    } else {
                        taxPercentage = demandReasonDetail.getPercentage();
                    }
                }
            } else if (demandReasonDetails != null) {
                if (BigDecimal.ZERO.equals(demandReasonDetail.getFlatAmount())) {
                    taxPercentage = demandReasonDetail.getPercentage();
                } else if (demandReasonDetail.getPercentage() == null) {
                    calculatedAnnualTax = demandReasonDetail.getFlatAmount();
                } else {
                    taxPercentage = demandReasonDetail.getPercentage();
                }
            }
            if (demandReasonDetail != null && demandReasonDetail.getFlatAmount().compareTo(BigDecimal.ZERO) > 0) {
                if (demandReasonDetail.getIsFlatAmntMax().equals(1) && calculatedAnnualTax.compareTo(demandReasonDetail.getFlatAmount()) > 0) {
                    calculatedAnnualTax = demandReasonDetail.getFlatAmount();
                }
                if (demandReasonDetail.getIsFlatAmntMax().equals(0) && calculatedAnnualTax.compareTo(demandReasonDetail.getFlatAmount()) < 0) {
                    calculatedAnnualTax = demandReasonDetail.getFlatAmount();
                }
            }
            APMiscellaneousTaxDetail miscTaxDetail = new APMiscellaneousTaxDetail();
            miscTaxDetail.setFromDate(demandReasonDetail.getFromDate());
            miscTaxDetail.setTaxValue(demandReasonDetail.getPercentage());
            miscTaxDetail.setCalculatedTaxValue(calculatedAnnualTax);
            if (propertyType != null && propertyType.equalsIgnoreCase("CENTRAL_GOVT_50")) {
                calculatedActualTax = calculatedAnnualTax.setScale(0, 4);
                calculatedAnnualTax = BigDecimal.ZERO;
                miscTaxDetail.setCalculatedTaxValue(calculatedAnnualTax);
                miscTaxDetail.setActualTaxValue(calculatedActualTax);
            }
            calculatedAnnualTax = calculatedAnnualTax.setScale(0, 4);
            miscTax.setTotalCalculatedTax(calculatedAnnualTax);
            miscTax.setTotalActualTax(calculatedActualTax.setScale(0, 4));
            miscTax.getTaxDetails().clear();
            if (BigDecimal.ZERO.equals(calculatedAnnualTax) || demandReasonDetail == null) continue;
            TaxDetail taxDetail = new TaxDetail();
            taxDetail.setTaxName(demandReasonCode);
            taxDetail.setCalculatedTax(calculatedAnnualTax);
            taxDetail.setFromDate(demandReasonDetail.getFromDate());
            taxDetailAndTaxName.put(demandReasonCode, taxDetail);
        }
        unitCalculationDetail.setTaxPayable(totalCalculatedTax);
        if (noOfDaysForNewTaxSlab > 0) {
            unitCalculationDetail.setTaxDays(noOfDaysForNewTaxSlab);
        } else {
            unitCalculationDetail.setTaxDays(totalNoOfDays);
        }
        unitCalculationDetails.add(unitCalculationDetail);
        LOGGER.debug((Object)("unitCalculationDetails= " + unitCalculationDetails + ", Exiting from setMiscellaneousTaxDetails"));
        return unitCalculationDetails;
    }

    private boolean hasNonHistoryTaxDetails(List<MiscellaneousTaxDetail> taxDetails) {
        for (MiscellaneousTaxDetail taxDetail : taxDetails) {
            if (!this.isNonHistoryTaxDetail(taxDetail)) continue;
            return true;
        }
        return false;
    }

    private boolean isNonHistoryTaxDetail(MiscellaneousTaxDetail taxDetail) {
        return taxDetail.getIsHistory() == null || taxDetail.getIsHistory().equals(PropertyTaxConstants.NON_HISTORY_TAX_DETAIL);
    }

    public void setUnitAreaCalculationDetails(Property property, Installment installment, UnitCalculationDetail unitCalculationDetail, UnitTaxCalculationInfo consolidatedUnitTax) {
        LOGGER.debug((Object)"Entered into setUnitAreaCalculationDetails");
        LOGGER.debug((Object)("setUnitAreaCalculationDetails - property=" + property + ", installment=" + installment + ", unitCalculationDetail=" + unitCalculationDetail));
        LOGGER.debug((Object)("setUnitAreaCalculationDetails - unitCalculationDetail=" + unitCalculationDetail));
        LOGGER.debug((Object)"Exiting from setUnitAreaCalculationDetails");
    }

    private Boolean isZero(BigDecimal value) {
        return BigDecimal.ZERO.compareTo(value) == 0;
    }

    private String buildUnitOccupation(String propType, UnitTaxCalculationInfo unit) {
        LOGGER.debug((Object)("Entered into buildUnitOccupation, propType=" + propType));
        StringBuilder occupierName = new StringBuilder();
        if ("VAC_LAND".equals(propType)) {
            if ("OWNER".equals(unit.getUnitOccupation()) || "COMMERCIAL".equals(unit.getUnitOccupation())) {
                occupierName.append(propType);
            } else if ("TENANT".equals(unit.getUnitOccupation())) {
                occupierName.append("OP-" + unit.getUnitOccupier());
            }
        } else if ("RESD".equals(propType)) {
            occupierName.append("R");
        } else if ("NON_RESD".equals(propType)) {
            occupierName.append("NR");
        } else if ("STATE_GOVT".equals(propType)) {
            occupierName.append("SGovt-OWNER");
        } else if ("CENTRAL_GOVT_50".equals(propType)) {
            occupierName.append("CGovt-OWNER");
        } else if ("MIXED".equals(propType)) {
            occupierName.append("R-NR");
        }
        if (!("VAC_LAND".equals(propType) || "STATE_GOVT".equals(propType) || "CENTRAL_GOVT_50".equals(propType))) {
            if ("TENANT".equals(unit.getUnitOccupation())) {
                occupierName.append("-" + unit.getUnitOccupier());
            } else if ("OWNER".equals(unit.getUnitOccupation()) || "COMMERCIAL".equals(unit.getUnitOccupation())) {
                occupierName.append("-" + unit.getUnitOccupation());
            }
        }
        LOGGER.debug((Object)("occupierName=" + occupierName.toString() + "\nExiting from buildUnitOccupation"));
        return occupierName.toString();
    }

    public BasicProperty getBasicProperty() {
        return this.basicProperty;
    }

    public void setBasicProperty(BasicProperty basicProperty) {
        this.basicProperty = basicProperty;
    }

    private static class InstallmentUnitTax {
        private UnitTaxCalculationInfo prevUnitTax;
        private UnitTaxCalculationInfo currentUnitTax;
        private Installment installment;

        public InstallmentUnitTax() {
        }

        public InstallmentUnitTax(Installment installment, UnitTaxCalculationInfo prevUnitTax, UnitTaxCalculationInfo currentUnitTax) {
            this.installment = installment;
            this.prevUnitTax = prevUnitTax;
            this.currentUnitTax = currentUnitTax;
        }

        public static InstallmentUnitTax create(Installment installment, UnitTaxCalculationInfo prevUnitTax, UnitTaxCalculationInfo currentUnitTax) {
            return new InstallmentUnitTax(installment, prevUnitTax, currentUnitTax);
        }

        public boolean isCurrentUnitNewUnit() {
            return this.prevUnitTax == null ? this.currentUnitTax != null : false;
        }

        public boolean isSameALV() {
            return this.prevUnitTax.getNetARV().compareTo(this.currentUnitTax.getNetARV()) == 0;
        }

        public boolean isSameOccupancy() {
            return this.prevUnitTax.getOccpancyDate().equals(this.currentUnitTax.getOccpancyDate());
        }

        public boolean isCurrentUnitSlabChanged() {
            return true;
        }

        public UnitTaxCalculationInfo getPrevUnitTax() {
            return this.prevUnitTax;
        }

        public UnitTaxCalculationInfo getCurrentUnitTax() {
            return this.currentUnitTax;
        }

        public Installment getInstallment() {
            return this.installment;
        }

        public List<UnitTaxCalculationInfo> getCurrentUnitAsList() {
            ArrayList<UnitTaxCalculationInfo> units = new ArrayList<UnitTaxCalculationInfo>();
            units.add(this.currentUnitTax);
            return units;
        }

        public void getCurrentUnitTaxSlabs(List<String> taxNames) {
            TreeMap dateAndPercentageByTax;
            LOGGER.debug((Object)"Entered into getCurrentUnitTaxSlabs");
            LOGGER.debug((Object)("getCurrentUnitTaxSlabs - dateAndPercentageByTaxForUnit: " + dateAndTotalCalcTaxByTaxForUnit));
            LOGGER.debug((Object)("getCurrentUnitTaxSlabs - taxNames: " + taxNames));
            Map map = dateAndPercentageByTax = dateAndTotalCalcTaxByTaxForUnit.get(this.currentUnitTax.getFloorNumber()) == null ? new TreeMap() : (Map)dateAndTotalCalcTaxByTaxForUnit.get(this.currentUnitTax.getFloorNumber());
            if (taxNames.isEmpty()) {
                block0: for (MiscellaneousTax mt1 : this.currentUnitTax.getMiscellaneousTaxes()) {
                    TreeMap<Date, BigDecimal> dateAndPercentage1 = new TreeMap<Date, BigDecimal>();
                    for (MiscellaneousTaxDetail mtd : mt1.getTaxDetails()) {
                        if (!this.isHistory(mtd)) continue;
                        dateAndPercentage1.put(mtd.getFromDate(), mtd.getCalculatedTaxValue());
                        dateAndPercentageByTax.put(mt1.getTaxName(), dateAndPercentage1);
                        continue block0;
                    }
                }
            } else {
                for (MiscellaneousTax mt2 : this.currentUnitTax.getMiscellaneousTaxes()) {
                    if (!taxNames.contains(mt2.getTaxName())) continue;
                    TreeMap<Date, BigDecimal> dateAndPercentage2 = new TreeMap<Date, BigDecimal>();
                    MiscellaneousTaxDetail mtd = mt2.getTaxDetails().size() > 1 ? mt2.getTaxDetails().get(1) : mt2.getTaxDetails().get(0);
                    if (!this.isHistory(mtd)) continue;
                    dateAndPercentage2.put(mtd.getFromDate(), mtd.getCalculatedTaxValue());
                    dateAndPercentageByTax.put(mt2.getTaxName(), dateAndPercentage2);
                }
            }
            dateAndTotalCalcTaxByTaxForUnit.put(Integer.valueOf(this.currentUnitTax.getFloorNumber()), dateAndPercentageByTax);
            LOGGER.debug((Object)("Exiting from getCurrentUnitTaxSlabs - dateAndPercentageByTaxForUnit: " + dateAndTotalCalcTaxByTaxForUnit));
        }

        public Map<String, Date> getSlabChangedTaxes() {
            LOGGER.debug((Object)"Entered into getSlabChangedTaxes");
            LOGGER.debug((Object)("getSlabChangedTaxes - dateAndPercentageByTaxForUnit: " + dateAndTotalCalcTaxByTaxForUnit));
            LOGGER.debug((Object)("getSlabChangedTaxes - UnitNumber : " + this.currentUnitTax.getFloorNumber()));
            Map taxAndListOfMapsOfDateAndPercentage = (Map)dateAndTotalCalcTaxByTaxForUnit.get(this.currentUnitTax.getFloorNumber());
            HashMap<String, Date> taxNames = new HashMap<String, Date>();
            if (taxAndListOfMapsOfDateAndPercentage != null && !taxAndListOfMapsOfDateAndPercentage.isEmpty()) {
                for (MiscellaneousTax tax : this.currentUnitTax.getMiscellaneousTaxes()) {
                    Map taxDateAndPercentages = (Map)taxAndListOfMapsOfDateAndPercentage.get(tax.getTaxName());
                    TreeMap<Date, MiscellaneousTaxDetail> taxDetailAndEffectiveDate = new TreeMap<Date, MiscellaneousTaxDetail>();
                    for (MiscellaneousTaxDetail mtd : tax.getTaxDetails()) {
                        if (mtd.getIsHistory() != null && !PropertyTaxConstants.NON_HISTORY_TAX_DETAIL.equals(mtd.getIsHistory())) continue;
                        taxDetailAndEffectiveDate.put(mtd.getFromDate(), mtd);
                    }
                    MiscellaneousTaxDetail mtd = (MiscellaneousTaxDetail)taxDetailAndEffectiveDate.get(taxDetailAndEffectiveDate.keySet().toArray()[taxDetailAndEffectiveDate.size() - 1]);
                    LOGGER.info((Object)("getSlabChangedTaxes - " + mtd));
                    if (taxDateAndPercentages != null) {
                        if (taxDateAndPercentages.get(mtd.getFromDate()) != null) continue;
                        taxNames.put(tax.getTaxName(), mtd.getFromDate());
                        continue;
                    }
                    taxNames.put(tax.getTaxName(), mtd.getFromDate());
                }
            }
            LOGGER.debug((Object)("getSlabChangedTaxes - slab changed taxes : " + taxNames));
            LOGGER.debug((Object)"Exiting from getSlabChangedTaxes");
            return taxNames;
        }

        private boolean isHistory(MiscellaneousTaxDetail mtd) {
            return mtd.getIsHistory() == null || mtd.getIsHistory().equals(Character.valueOf('N'));
        }
    }

    private static class Amount {
        private BigDecimal value;
        private static final BigDecimal HUNDRED = new BigDecimal(100);

        Amount(BigDecimal value) {
            this.value = value;
        }

        public void setValue(BigDecimal value) {
            this.value = value;
        }

        public BigDecimal percentOf(BigDecimal amount) {
            return amount.multiply(this.value).divide(HUNDRED);
        }
    }
}

