/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.client.bill;

import java.math.BigDecimal;
import org.egov.commons.Installment;

public class BillDetailBean {
    private Installment installment;
    private Integer orderNo;
    private BigDecimal amount;
    private String key;
    private String glCode;
    private String reasonMaster;
    private String description;
    private Integer isActualDemand;
    private String purpose;

    public BillDetailBean() {
    }

    public BillDetailBean(Installment installment, Integer orderNo, String key, BigDecimal billDetailAmount, String glCode, String reasonMaster, Integer isActualDemand, String purpose) {
        this.installment = installment;
        this.orderNo = orderNo;
        this.amount = billDetailAmount;
        this.key = key;
        this.glCode = glCode;
        this.reasonMaster = reasonMaster;
        this.isActualDemand = isActualDemand;
        this.purpose = purpose;
        this.description = reasonMaster.equalsIgnoreCase("ADVANCE_REBATE") ? reasonMaster + "-" + key : reasonMaster + "-" + installment.getDescription();
    }

    public boolean isRebate() {
        return this.reasonMaster.equalsIgnoreCase("ADVANCE_REBATE") || this.reasonMaster.equalsIgnoreCase("REBATE");
    }

    public boolean invalidData() {
        return this.orderNo == null || this.amount == null || this.glCode == null;
    }

    public String toString() {
        return new StringBuilder(200).append("BillDetailBean [").append("installment=").append(this.installment).append(", reasonMaster=").append(this.reasonMaster).append(", description=").append(this.description).append(", glCode=").append(this.glCode).append(", orderNo=").append(this.orderNo).append(", key=").append(this.key).append(", isActualDemand=").append(this.isActualDemand).append(this.purpose).append("]").toString();
    }

    public Installment getInstallment() {
        return this.installment;
    }

    public void setInstallment(Installment installment) {
        this.installment = installment;
    }

    public Integer getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(Integer orderNo) {
        this.orderNo = orderNo;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getGlCode() {
        return this.glCode;
    }

    public void setGlCode(String glCode) {
        this.glCode = glCode;
    }

    public String getReasonMaster() {
        return this.reasonMaster;
    }

    public void setReasonMaster(String reasonMaster) {
        this.reasonMaster = reasonMaster;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getIsActualDemand() {
        return this.isActualDemand;
    }

    public void setIsActualDemand(Integer isActualDemand) {
        this.isActualDemand = isActualDemand;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }
}

