/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.autonumber.impl;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.ptis.autonumber.NoticeNumberGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NoticeNumberGeneratorImpl
implements NoticeNumberGenerator {
    private static final String SEQ_EGPT_NOTICE_NUMBER = "SEQ_EGPT_NOTICE_NUMBER";
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;

    @Override
    public String generateNoticeNumber(String noticeType) {
        String noticeNumber = "";
        if (StringUtils.isNotBlank((CharSequence)noticeType)) {
            String noticeTypeCode = "";
            if (noticeType.equalsIgnoreCase("Special Notice")) {
                noticeTypeCode = "SN";
            } else if (noticeType.equalsIgnoreCase("Mutation Certificate")) {
                noticeTypeCode = "MC";
            }
            String sequenceName = SEQ_EGPT_NOTICE_NUMBER;
            Serializable nextSequence = this.applicationSequenceNumberGenerator.getNextSequence(SEQ_EGPT_NOTICE_NUMBER);
            noticeNumber = String.format("%s/%s%06d", noticeTypeCode, ApplicationThreadLocals.getCityCode(), nextSequence);
        }
        return noticeNumber;
    }
}

