/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.client.util;

import java.util.Date;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class PropertyTaxutilTest {
    @Test
    public void sameDayShouldReturnZero() {
        DateTime date = new DateTime();
        long noofdays = PropertyTaxUtil.getNumberOfDays((Date)date.toDate(), (Date)date.toDate());
        Assert.assertEquals((long)noofdays, (long)0L);
    }

    @Test
    public void consecutiveDays() {
        DateTime date = new DateTime();
        long noofdays = PropertyTaxUtil.getNumberOfDays((Date)date.toDate(), (Date)date.withDayOfYear(date.getDayOfYear() + 1).toDate());
        Assert.assertEquals((long)noofdays, (long)1L);
    }

    @Test
    public void differentDates() {
        DateTime start = new DateTime(2016, 8, 1, 12, 0, 0, 0);
        DateTime end = new DateTime(2016, 8, 30, 12, 0, 0, 0);
        long noofdays = PropertyTaxUtil.getNumberOfDays((Date)start.toDate(), (Date)end.toDate());
        Assert.assertEquals((long)noofdays, (long)29L);
    }

    @Test
    public void negativeResult() {
        DateTime start = new DateTime(2016, 7, 15, 12, 0, 0, 0);
        DateTime end = new DateTime(2016, 7, 1, 12, 0, 0, 0);
        long noofdays = PropertyTaxUtil.getNumberOfDays((Date)start.toDate(), (Date)end.toDate());
        Assert.assertEquals((long)noofdays, (long)0L);
    }
}

