/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.workflow.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.script.ScriptContext;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.infra.admin.master.entity.Action;
import org.egov.infra.admin.master.service.ActionService;
import org.egov.infra.exception.AuthorizationException;
import org.egov.infra.script.service.ScriptService;
import org.egov.infstr.services.PersistenceService;
import org.springframework.beans.factory.annotation.Autowired;

public class ActionsBasedOnWorkFlowFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(ActionsBasedOnWorkFlowFilter.class);
    @Autowired
    private ScriptService scriptService;
    private PersistenceService workFlowPerService;
    @Autowired
    private ActionService actionService;

    public void init(FilterConfig config) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Action action = null;
        boolean authorized = true;
        if (request.getParameter("ENTITY_ID") != null) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            List authResList = new ArrayList();
            String billNo = httpRequest.getParameter("ENTITY_ID");
            action = this.getAction(httpRequest);
            authResList = this.getWorkFlowActionAuth(action.getUrl(), billNo);
            authorized = Boolean.valueOf(authResList.get(0).toString());
            if (!authorized) {
                request.setAttribute("AuthRuleErrMsgKey", (Object)authResList.get(1).toString());
                throw new AuthorizationException(authResList.get(1).toString());
            }
        }
        chain.doFilter(request, response);
    }

    private List getWorkFlowActionAuth(String actionUrl, String properrtyId) {
        ScriptContext scriptContext = ScriptService.createContext((Object[])new Object[]{"ActionName", actionUrl, "properrtyId", properrtyId, "persistService", this.workFlowPerService});
        return (List)this.scriptService.executeScript("WorkFlowBasedActions", scriptContext);
    }

    public void destroy() {
        LOGGER.info((Object)"destroying filter");
    }

    private Action getAction(HttpServletRequest request) {
        Action action;
        String actionId = request.getParameter("actionid");
        if (actionId == null || actionId.length() == 0) {
            String requestURI = request.getRequestURI();
            String contextPath = request.getContextPath();
            requestURI = StringUtils.remove((String)requestURI, (String)contextPath);
            action = this.actionService.getActionByUrlAndContextRoot(requestURI, StringUtils.remove((String)contextPath, (char)'/'));
        } else {
            action = this.actionService.getActionById(Long.valueOf(actionId));
        }
        return action;
    }

    public void setWorkFlowPerService(PersistenceService authRuleService) {
        this.workFlowPerService = authRuleService;
    }
}

