/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.service.utils;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.pims.commons.Position;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.service.DemandBill.DemandBillService;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class PropertyTaxCommonUtils {
    private static final Logger LOGGER = Logger.getLogger(PropertyTaxCommonUtils.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;
    @Autowired
    private ApplicationContext beanProvider;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private AssignmentService assignmentService;

    public Installment getCurrentInstallment() {
        org.hibernate.Query query = ((Session)this.entityManager.unwrap(Session.class)).createQuery("select installment from Installment installment,CFinancialYear finYear where installment.module.name =:moduleName  and (cast(:currDate as date)) between finYear.startingDate and finYear.endingDate  and cast(installment.fromDate as date) >= cast(finYear.startingDate as date) and cast(installment.toDate as date) <= cast(finYear.endingDate as date) order by installment.fromDate asc ");
        query.setString("moduleName", "Property Tax");
        query.setDate("currDate", new Date());
        List installments = query.list();
        return (Installment)installments.get(0);
    }

    public String getAppConfigValue(String key, String moduleName) {
        AppConfigValues appConfigValues;
        String value = "";
        if (key != null && moduleName != null && (appConfigValues = this.appConfigValuesService.getAppConfigValueByDate(moduleName, key, new Date())) != null) {
            value = appConfigValues.getValue();
        }
        return value;
    }

    public Map<String, Object> getTaxDetailsForWorkflowProperty(BasicProperty basicProperty) {
        Map<Object, Object> demandCollMap = new TreeMap();
        HashMap<String, Object> wfPropTaxDetailsMap = new HashMap<String, Object>();
        Property property = basicProperty.getWFProperty();
        try {
            demandCollMap = this.propertyTaxUtil.prepareDemandDetForView(property, this.getCurrentInstallment());
            if (!demandCollMap.isEmpty()) {
                for (Map.Entry<Object, Object> entry : demandCollMap.entrySet()) {
                    String key = (String)entry.getKey();
                    Map reasonDmd = (Map)entry.getValue();
                    if (key.equals("Current 1st Half")) {
                        wfPropTaxDetailsMap.put("firstHalf", "Current 1st Half");
                        wfPropTaxDetailsMap.put("firstHalfGT", reasonDmd.get("General Tax") != null ? reasonDmd.get("General Tax") : demandCollMap.get("Vacant Land Tax"));
                        wfPropTaxDetailsMap.put("firstHalfEC", reasonDmd.get("Education Cess") != null ? reasonDmd.get("Education Cess") : BigDecimal.ZERO);
                        wfPropTaxDetailsMap.put("firstHalfLC", reasonDmd.get("Library Cess"));
                        wfPropTaxDetailsMap.put("firstHalfUAP", reasonDmd.get("Unauthorized Penalty") != null ? reasonDmd.get("Unauthorized Penalty") : BigDecimal.ZERO);
                        wfPropTaxDetailsMap.put("firstHalfTotal", reasonDmd.get("CURR_FIRSTHALF_DMD") != null ? reasonDmd.get("CURR_FIRSTHALF_DMD") : BigDecimal.ZERO);
                        wfPropTaxDetailsMap.put("firstHalfTaxDue", (reasonDmd.get("CURR_FIRSTHALF_DMD") != null ? (BigDecimal)reasonDmd.get("CURR_FIRSTHALF_DMD") : BigDecimal.ZERO).subtract((BigDecimal)reasonDmd.get("CURR_FIRSTHALF_COLL")));
                        continue;
                    }
                    if (key.equals("Current 2nd Half")) {
                        wfPropTaxDetailsMap.put("secondHalf", "Current 2nd Half");
                        wfPropTaxDetailsMap.put("secondHalfGT", reasonDmd.get("General Tax") != null ? reasonDmd.get("General Tax") : demandCollMap.get("Vacant Land Tax"));
                        wfPropTaxDetailsMap.put("secondHalfEC", reasonDmd.get("Education Cess") != null ? reasonDmd.get("Education Cess") : BigDecimal.ZERO);
                        wfPropTaxDetailsMap.put("secondHalfLC", reasonDmd.get("Library Cess"));
                        wfPropTaxDetailsMap.put("secondHalfUAP", reasonDmd.get("Unauthorized Penalty") != null ? reasonDmd.get("Unauthorized Penalty") : BigDecimal.ZERO);
                        wfPropTaxDetailsMap.put("secondHalfTotal", reasonDmd.get("CURR_SECONDHALF_DMD") != null ? reasonDmd.get("CURR_SECONDHALF_DMD") : BigDecimal.ZERO);
                        wfPropTaxDetailsMap.put("secondHalfTaxDue", (reasonDmd.get("CURR_SECONDHALF_DMD") != null ? (BigDecimal)reasonDmd.get("CURR_SECONDHALF_DMD") : BigDecimal.ZERO).subtract((BigDecimal)reasonDmd.get("CURR_SECONDHALF_COLL")));
                        continue;
                    }
                    wfPropTaxDetailsMap.put("arrears", "Arrears");
                    wfPropTaxDetailsMap.put("arrearTax", reasonDmd.get("ARR_DMD") != null ? reasonDmd.get("ARR_DMD") : BigDecimal.ZERO);
                    wfPropTaxDetailsMap.put("totalArrDue", (reasonDmd.get("ARR_DMD") != null ? (BigDecimal)reasonDmd.get("ARR_DMD") : BigDecimal.ZERO).subtract((BigDecimal)reasonDmd.get("ARR_COLL")));
                }
            }
        }
        catch (ParseException e) {
            LOGGER.error((Object)"Exception in getTaxDetailsForWorkflowProperty: ", (Throwable)e);
            throw new ApplicationRuntimeException("Exception in getTaxDetailsForWorkflowProperty : " + e);
        }
        return wfPropTaxDetailsMap;
    }

    public boolean isDigitalSignatureEnabled() {
        List appConfigValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("Property Tax", "PTIS_DIGITAL_SIGNATURE_REQUIRED");
        return !appConfigValues.isEmpty() && "Y".equals(((AppConfigValues)appConfigValues.get(0)).getValue());
    }

    public List<Installment> getAdvanceInstallmentsList(Date startDate) {
        ArrayList<Installment> advanceInstallments = new ArrayList();
        String query = "select inst from Installment inst where inst.module.name = 'Property Tax' and inst.fromDate >= :startdate order by inst.fromDate asc ";
        advanceInstallments = ((Session)this.entityManager.unwrap(Session.class)).createQuery(query).setParameter("startdate", (Object)startDate).setMaxResults(PropertyTaxConstants.MAX_ADVANCES_ALLOWED.intValue()).list();
        return advanceInstallments;
    }

    public void makeExistingDemandBillInactive(String assessmentNo) {
        DemandBillService demandBillService = (DemandBillService)this.beanProvider.getBean("demandBillService");
        demandBillService.makeDemandBillInactive(assessmentNo);
    }

    public String getAllDesignationsForUser(Long userId) {
        List positions = null;
        ArrayList<String> designationList = new ArrayList<String>();
        StringBuilder listString = new StringBuilder();
        if (userId != null && userId.intValue() != 0 && (positions = this.positionMasterService.getPositionsForEmployee(userId)) != null) {
            for (Position position : positions) {
                designationList.add(position.getDeptDesig().getDesignation().getName());
            }
            for (String s : designationList) {
                listString.append(s + ", ");
            }
        }
        return listString.toString();
    }

    public boolean isReceiptCanceled(String receiptNumber) {
        Query qry = this.entityManager.createNamedQuery("RECEIPTS_BY_RECEIPTNUM");
        qry.setParameter(1, (Object)receiptNumber);
        ReceiptHeader receiptHeader = (ReceiptHeader)qry.getSingleResult();
        return receiptHeader.getStatus().getCode().equals("CANCELLED") ? Boolean.TRUE : Boolean.FALSE;
    }

    public Installment getCurrentPeriodInstallment() {
        Module module = this.moduleService.getModuleByName("Property Tax");
        return this.installmentDao.getInsatllmentByModuleForGivenDate(module, new Date());
    }

    public Assignment getUserAssignmentByPassingPositionAndUser(User user, Position position) {
        Assignment userAssignment = null;
        if (user != null && position != null) {
            List assignmentList = this.assignmentService.findByEmployeeAndGivenDate(user.getId(), new Date());
            for (Assignment assignment : assignmentList) {
                if (position.getId() != assignment.getPosition().getId()) continue;
                userAssignment = assignment;
            }
        }
        return userAssignment;
    }

    public Assignment getWorkflowInitiatorAssignment(Long userId) {
        Assignment wfInitiatorAssignment = null;
        if (userId != null) {
            List assignmentList = this.assignmentService.getAllActiveEmployeeAssignmentsByEmpId(userId);
            for (Assignment assignment : assignmentList) {
                if (!assignment.getDesignation().getName().equals("Junior Assistant") && !assignment.getDesignation().getName().equals("Senior Assistant")) continue;
                wfInitiatorAssignment = assignment;
            }
        }
        return wfInitiatorAssignment;
    }
}

