/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.service.elasticsearch;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.service.CFinancialYearService;
import org.egov.infra.utils.DateUtils;
import org.egov.ptis.bean.dashboard.CollReceiptDetails;
import org.egov.ptis.bean.dashboard.CollTableData;
import org.egov.ptis.bean.dashboard.CollectionDetails;
import org.egov.ptis.bean.dashboard.CollectionDetailsRequest;
import org.egov.ptis.bean.dashboard.CollectionTrend;
import org.egov.ptis.bean.dashboard.ReceiptTableData;
import org.egov.ptis.bean.dashboard.ReceiptsTrend;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.elasticsearch.model.BillCollectorIndex;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.ResultsExtractor;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@Service
public class CollectionIndexElasticSearchService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionIndexElasticSearchService.class);
    @Autowired
    private CFinancialYearService cFinancialYearService;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    public BigDecimal getConsolidatedCollForYears(Date fromDate, Date toDate, String billingService) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)"receiptDate").gte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).must((QueryBuilder)QueryBuilders.matchQuery((String)"billingService", (Object)billingService)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)"Cancelled"));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)queryBuilder).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"collectiontotal").field("totalAmount")).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, (ResultsExtractor)new ResultsExtractor<Aggregations>(){

            public Aggregations extract(SearchResponse response) {
                return response.getAggregations();
            }
        });
        Sum aggr = (Sum)collAggr.get("collectiontotal");
        return BigDecimal.valueOf(aggr.getValue()).setScale(0, 4);
    }

    public Map<String, BigDecimal> getFinYearsCollByService(String billingService) {
        HashMap<String, BigDecimal> consolidatedCollValues = new HashMap<String, BigDecimal>();
        CFinancialYear currFinYear = this.cFinancialYearService.getFinancialYearByDate(new Date());
        consolidatedCollValues.put("cytdColln", this.getConsolidatedCollForYears(currFinYear.getStartingDate(), DateUtils.addDays((Date)new Date(), (int)1), billingService));
        consolidatedCollValues.put("lytdColln", this.getConsolidatedCollForYears(DateUtils.addYears((Date)currFinYear.getStartingDate(), (int)-1), DateUtils.addDays((Date)DateUtils.addYears((Date)new Date(), (int)-1), (int)1), billingService));
        return consolidatedCollValues;
    }

    private BoolQueryBuilder prepareWhereClause(CollectionDetailsRequest collectionDetailsRequest, String indexName) {
        BoolQueryBuilder boolQuery = null;
        if (indexName.equals("propertytax")) {
            boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.rangeQuery((String)"totalDemand").from(0).to(null));
        } else if (indexName.equals("receipts")) {
            boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"billingService", (Object)"Property Tax"));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getRegionName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"regionName", (Object)collectionDetailsRequest.getRegionName()));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getDistrictName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"districtName", (Object)collectionDetailsRequest.getDistrictName()));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getUlbGrade())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityGrade", (Object)collectionDetailsRequest.getUlbGrade()));
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getUlbCode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityCode", (Object)collectionDetailsRequest.getUlbCode()));
        }
        return boolQuery;
    }

    public void getCompleteCollectionIndexDetails(CollectionDetailsRequest collectionDetailsRequest, CollectionDetails collectionIndexDetails) {
        Date toDate;
        Date fromDate;
        BigDecimal todayColl = BigDecimal.ZERO;
        BigDecimal tillDateColl = BigDecimal.ZERO;
        Long startTime = System.currentTimeMillis();
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new Date();
            toDate = DateUtils.addDays((Date)fromDate, (int)1);
        }
        todayColl = this.getCollectionBetweenDates(collectionDetailsRequest, fromDate, toDate, null);
        collectionIndexDetails.setTodayColl(todayColl);
        todayColl = this.getCollectionBetweenDates(collectionDetailsRequest, DateUtils.addYears((Date)fromDate, (int)-1), DateUtils.addYears((Date)toDate, (int)-1), null);
        collectionIndexDetails.setLyTodayColl(todayColl);
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new DateTime().withMonthOfYear(4).dayOfMonth().withMinimumValue().toDate();
            toDate = DateUtils.addDays((Date)new Date(), (int)1);
        }
        tillDateColl = this.getCollectionBetweenDates(collectionDetailsRequest, fromDate, toDate, null);
        collectionIndexDetails.setCytdColl(tillDateColl);
        tillDateColl = this.getCollectionBetweenDates(collectionDetailsRequest, DateUtils.addYears((Date)fromDate, (int)-1), DateUtils.addYears((Date)toDate, (int)-1), null);
        collectionIndexDetails.setLytdColl(tillDateColl);
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by getCompleteCollectionIndexDetails() is : " + timeTaken + " (millisecs) ");
    }

    public BigDecimal getCollectionBetweenDates(CollectionDetailsRequest collectionDetailsRequest, Date fromDate, Date toDate, String cityName) {
        Long startTime = System.currentTimeMillis();
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, "receipts");
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"receiptDate").gte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)"Cancelled"));
        if (StringUtils.isNotBlank((CharSequence)cityName)) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityName", (Object)cityName));
        }
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"collectiontotal").field("totalAmount")).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, (ResultsExtractor)new ResultsExtractor<Aggregations>(){

            public Aggregations extract(SearchResponse response) {
                return response.getAggregations();
            }
        });
        Sum aggr = (Sum)collAggr.get("collectiontotal");
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by getCollectionBetweenDates() is : " + timeTaken + " (millisecs) ");
        return BigDecimal.valueOf(aggr.getValue()).setScale(0, 4);
    }

    public List<CollTableData> getResponseTableData(CollectionDetailsRequest collectionDetailsRequest) {
        Date toDate;
        Date fromDate;
        ArrayList<CollTableData> collIndDataList = new ArrayList<CollTableData>();
        BigDecimal cytdDmd = BigDecimal.ZERO;
        BigDecimal performance = BigDecimal.ZERO;
        BigDecimal balance = BigDecimal.ZERO;
        BigDecimal variance = BigDecimal.ZERO;
        String aggregationField = "regionName";
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getType())) {
            if (collectionDetailsRequest.getType().equalsIgnoreCase("region")) {
                aggregationField = "regionName";
            } else if (collectionDetailsRequest.getType().equalsIgnoreCase("district")) {
                aggregationField = "districtName";
            } else if (collectionDetailsRequest.getType().equalsIgnoreCase("ulb")) {
                aggregationField = "cityName";
            } else if (collectionDetailsRequest.getType().equalsIgnoreCase("grade")) {
                aggregationField = "cityGrade";
            } else if (collectionDetailsRequest.getType().equalsIgnoreCase("ward") || collectionDetailsRequest.getType().equalsIgnoreCase("billcollector")) {
                aggregationField = "revenueWard";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new Date();
            toDate = DateUtils.addDays((Date)fromDate, (int)1);
        }
        Long startTime = System.currentTimeMillis();
        Map<String, BigDecimal> todayCollMap = this.getCollectionAndDemandValues(collectionDetailsRequest, fromDate, toDate, "receipts", "totalAmount", aggregationField);
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new DateTime().withMonthOfYear(4).dayOfMonth().withMinimumValue().toDate();
            toDate = DateUtils.addDays((Date)new Date(), (int)1);
        }
        int noOfMonths = DateUtils.noOfMonths((Date)fromDate, (Date)toDate) + 1;
        Map<String, BigDecimal> cytdCollMap = this.getCollectionAndDemandValues(collectionDetailsRequest, fromDate, toDate, "receipts", "totalAmount", aggregationField);
        Map<String, BigDecimal> totalDemandMap = this.getCollectionAndDemandValues(collectionDetailsRequest, fromDate, toDate, "propertytax", "totalDemand", aggregationField);
        Map<String, BigDecimal> currYrTotalDemandMap = this.getCollectionAndDemandValues(collectionDetailsRequest, fromDate, toDate, "propertytax", "totalDemand", aggregationField);
        Map<String, BigDecimal> lytdCollMap = this.getCollectionAndDemandValues(collectionDetailsRequest, DateUtils.addYears((Date)fromDate, (int)-1), DateUtils.addYears((Date)toDate, (int)-1), "receipts", "totalAmount", aggregationField);
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by getCollectionAndDemandValues() is : " + timeTaken + " (millisecs) ");
        startTime = System.currentTimeMillis();
        for (Map.Entry<String, BigDecimal> entry : cytdCollMap.entrySet()) {
            CollTableData collIndData = new CollTableData();
            String name = entry.getKey();
            if (aggregationField.equals("regionName")) {
                collIndData.setRegionName(name);
            } else if (aggregationField.equals("districtName")) {
                collIndData.setRegionName(collectionDetailsRequest.getRegionName());
                collIndData.setDistrictName(name);
            } else if (aggregationField.equals("cityName")) {
                collIndData.setUlbName(name);
                collIndData.setDistrictName(collectionDetailsRequest.getDistrictName());
                collIndData.setUlbGrade(collectionDetailsRequest.getUlbGrade());
            } else if (aggregationField.equals("cityGrade")) {
                collIndData.setUlbGrade(name);
            } else if (aggregationField.equals("revenueWard")) {
                collIndData.setWardName(name);
            }
            collIndData.setTodayColl(todayCollMap.get(name) == null ? BigDecimal.ZERO : todayCollMap.get(name));
            collIndData.setCytdColl(entry.getValue());
            BigDecimal currentYearTotalDemand = currYrTotalDemandMap.get(name) == null ? BigDecimal.valueOf(0L) : currYrTotalDemandMap.get(name);
            cytdDmd = currentYearTotalDemand.divide(BigDecimal.valueOf(12L), 4).multiply(BigDecimal.valueOf(noOfMonths));
            collIndData.setCytdDmd(cytdDmd);
            if (cytdDmd != BigDecimal.valueOf(0L)) {
                balance = cytdDmd.subtract(collIndData.getCytdColl());
                performance = collIndData.getCytdColl().multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(cytdDmd, 1, 4);
                collIndData.setPerformance(performance);
                collIndData.setCytdBalDmd(balance);
            }
            collIndData.setTotalDmd(totalDemandMap.get(name) == null ? BigDecimal.ZERO : totalDemandMap.get(name));
            collIndData.setLytdColl(lytdCollMap.get(name) == null ? BigDecimal.ZERO : lytdCollMap.get(name));
            variance = collIndData.getLytdColl().compareTo(BigDecimal.ZERO) == 0 ? PropertyTaxConstants.BIGDECIMAL_100 : collIndData.getCytdColl().subtract(collIndData.getLytdColl()).multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(collIndData.getLytdColl(), 1, 4);
            collIndData.setLyVar(variance);
            collIndDataList.add(collIndData);
        }
        timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken for setting values in getResponseTableData() is : " + timeTaken + " (millisecs) ");
        return collIndDataList;
    }

    public Map<String, BigDecimal> getCollectionAndDemandValues(CollectionDetailsRequest collectionDetailsRequest, Date fromDate, Date toDate, String indexName, String fieldName, String aggregationField) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, indexName);
        if (indexName.equals("receipts")) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"receiptDate").gte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)"Cancelled"));
        }
        AggregationBuilder aggregation = ((TermsBuilder)AggregationBuilders.terms((String)"by_city").field(aggregationField)).size(120).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"total").field(fieldName));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{indexName}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)aggregation).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, (ResultsExtractor)new ResultsExtractor<Aggregations>(){

            public Aggregations extract(SearchResponse response) {
                return response.getAggregations();
            }
        });
        StringTerms cityAggr = (StringTerms)collAggr.get("by_city");
        HashMap<String, BigDecimal> cytdCollMap = new HashMap<String, BigDecimal>();
        for (Terms.Bucket entry : cityAggr.getBuckets()) {
            Sum aggr = (Sum)entry.getAggregations().get("total");
            cytdCollMap.put(String.valueOf(entry.getKey()), BigDecimal.valueOf(aggr.getValue()).setScale(0, 4));
        }
        return cytdCollMap;
    }

    public List<CollectionTrend> getMonthwiseCollectionDetails(CollectionDetailsRequest collectionDetailsRequest) {
        Date toDate;
        Date fromDate;
        ArrayList<CollectionTrend> collTrendsList = new ArrayList<CollectionTrend>();
        CFinancialYear financialYear = this.cFinancialYearService.getFinancialYearByDate(new Date());
        Date finYearStartDate = financialYear.getStartingDate();
        Date finYearEndDate = financialYear.getEndingDate();
        Map monthValuesMap = DateUtils.getAllMonthsWithFullNames();
        ArrayList yearwiseMonthlyCollList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new DateTime().withMonthOfYear(4).dayOfMonth().withMinimumValue().toDate();
            toDate = DateUtils.addDays((Date)new Date(), (int)1);
        }
        Long startTime = System.currentTimeMillis();
        for (int count = 0; count <= 2; ++count) {
            LinkedHashMap<String, BigDecimal> monthwiseColl = new LinkedHashMap<String, BigDecimal>();
            Aggregations collAggr = this.getMonthwiseCollectionsForConsecutiveYears(collectionDetailsRequest, fromDate, toDate);
            Histogram dateaggs = (Histogram)collAggr.get("date_agg");
            for (Histogram.Bucket entry : dateaggs.getBuckets()) {
                String[] dateArr = entry.getKeyAsString().split("T");
                Date dateForMonth = DateUtils.getDate((String)dateArr[0], (String)"yyyy-MM-dd");
                Integer month = Integer.valueOf(dateArr[0].split("-", 3)[1]);
                String monthName = (String)monthValuesMap.get(month);
                Sum aggregateSum = (Sum)entry.getAggregations().get("current_total");
                if (!DateUtils.between((Date)dateForMonth, (Date)finYearStartDate, (Date)finYearEndDate) || BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4).compareTo(BigDecimal.ZERO) <= 0) continue;
                monthwiseColl.put(monthName, BigDecimal.valueOf(aggregateSum.getValue()).setScale(0, 4));
            }
            yearwiseMonthlyCollList.add(monthwiseColl);
            if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
                fromDate = DateUtils.addYears((Date)fromDate, (int)-1);
                toDate = DateUtils.addYears((Date)toDate, (int)-1);
            } else {
                fromDate = DateUtils.addYears((Date)finYearStartDate, (int)-1);
                toDate = DateUtils.addYears((Date)finYearEndDate, (int)-1);
            }
            finYearStartDate = DateUtils.addYears((Date)finYearStartDate, (int)-1);
            finYearEndDate = DateUtils.addYears((Date)finYearEndDate, (int)-1);
        }
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by getMonthwiseCollectionsForConsecutiveYears() for 3 consecutive years is : " + timeTaken + " (millisecs) ");
        startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            for (Map.Entry entry : DateUtils.getAllFinancialYearMonthsWithFullNames().entrySet()) {
                CollectionTrend collTrend = new CollectionTrend();
                collTrend.setMonth((String)entry.getValue());
                collTrend.setCyColl(((Map)yearwiseMonthlyCollList.get(0)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCollList.get(0)).get(collTrend.getMonth()));
                collTrend.setLyColl(((Map)yearwiseMonthlyCollList.get(1)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCollList.get(1)).get(collTrend.getMonth()));
                collTrend.setPyColl(((Map)yearwiseMonthlyCollList.get(2)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCollList.get(2)).get(collTrend.getMonth()));
                collTrendsList.add(collTrend);
            }
        } else {
            for (Map.Entry entry : ((Map)yearwiseMonthlyCollList.get(0)).entrySet()) {
                CollectionTrend collTrend = new CollectionTrend();
                collTrend.setMonth((String)entry.getKey());
                collTrend.setCyColl((BigDecimal)entry.getValue());
                collTrend.setLyColl(((Map)yearwiseMonthlyCollList.get(1)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCollList.get(1)).get(collTrend.getMonth()));
                collTrend.setPyColl(((Map)yearwiseMonthlyCollList.get(2)).get(collTrend.getMonth()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)yearwiseMonthlyCollList.get(2)).get(collTrend.getMonth()));
                collTrendsList.add(collTrend);
            }
        }
        timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken setting values in getMonthwiseCollectionDetails() is : " + timeTaken + " (millisecs) ");
        return collTrendsList;
    }

    private Aggregations getMonthwiseCollectionsForConsecutiveYears(CollectionDetailsRequest collectionDetailsRequest, Date fromDate, Date toDate) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, "receipts");
        boolQuery = boolQuery.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)"Cancelled"));
        AggregationBuilder monthAggregation = ((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)"date_agg").field("receiptDate")).interval(DateHistogramInterval.MONTH).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"current_total").field("totalAmount"));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"receiptDate").gte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false))).addAggregation((AbstractAggregationBuilder)monthAggregation).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, (ResultsExtractor)new ResultsExtractor<Aggregations>(){

            public Aggregations extract(SearchResponse response) {
                return response.getAggregations();
            }
        });
        return collAggr;
    }

    public void getTotalReceiptsCount(CollectionDetailsRequest collectionDetailsRequest, CollReceiptDetails receiptDetails) {
        Date toDate;
        Date fromDate;
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new Date();
            toDate = DateUtils.addDays((Date)fromDate, (int)1);
        }
        Long startTime = System.currentTimeMillis();
        Long receiptsCount = this.getTotalReceiptCountsForDates(collectionDetailsRequest, fromDate, toDate);
        receiptDetails.setTodayRcptsCount(receiptsCount);
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new DateTime().withMonthOfYear(4).dayOfMonth().withMinimumValue().toDate();
            toDate = DateUtils.addDays((Date)new Date(), (int)1);
        }
        receiptsCount = this.getTotalReceiptCountsForDates(collectionDetailsRequest, fromDate, toDate);
        receiptDetails.setCytdRcptsCount(receiptsCount);
        receiptsCount = this.getTotalReceiptCountsForDates(collectionDetailsRequest, DateUtils.addYears((Date)fromDate, (int)-1), DateUtils.addYears((Date)toDate, (int)-1));
        receiptDetails.setLytdRcptsCount(receiptsCount);
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by getTotalReceiptCountsForDates() for all dates is : " + timeTaken + " (millisecs) ");
    }

    private Long getTotalReceiptCountsForDates(CollectionDetailsRequest collectionDetailsRequest, Date fromDate, Date toDate) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, "receipts");
        boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"receiptDate").gte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)"Cancelled"));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)"receipt_count").field("consumerCode")).build();
        Aggregations collCountAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, (ResultsExtractor)new ResultsExtractor<Aggregations>(){

            public Aggregations extract(SearchResponse response) {
                return response.getAggregations();
            }
        });
        ValueCount aggr = (ValueCount)collCountAggr.get("receipt_count");
        return aggr.getValue();
    }

    public List<ReceiptsTrend> getMonthwiseReceiptsTrend(CollectionDetailsRequest collectionDetailsRequest) {
        Date toDate;
        Date fromDate;
        ArrayList<ReceiptsTrend> rcptTrendsList = new ArrayList<ReceiptsTrend>();
        CFinancialYear financialYear = this.cFinancialYearService.getFinancialYearByDate(new Date());
        Date finYearStartDate = financialYear.getStartingDate();
        Date finYearEndDate = financialYear.getEndingDate();
        Map monthValuesMap = DateUtils.getAllMonthsWithFullNames();
        ArrayList yearwiseMonthlyCountList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new DateTime().withMonthOfYear(4).dayOfMonth().withMinimumValue().toDate();
            toDate = DateUtils.addDays((Date)new Date(), (int)1);
        }
        Long startTime = System.currentTimeMillis();
        for (int count = 0; count <= 2; ++count) {
            LinkedHashMap<String, Long> monthwiseCount = new LinkedHashMap<String, Long>();
            Aggregations collAggregation = this.getReceiptsCountForConsecutiveYears(collectionDetailsRequest, fromDate, toDate);
            Histogram dateaggs = (Histogram)collAggregation.get("date_agg");
            for (Histogram.Bucket entry : dateaggs.getBuckets()) {
                String[] dateArr = entry.getKeyAsString().split("T");
                Date dateForMonth = DateUtils.getDate((String)dateArr[0], (String)"yyyy-MM-dd");
                Integer month = Integer.valueOf(dateArr[0].split("-", 3)[1]);
                String monthName = (String)monthValuesMap.get(month);
                Long rcptCount = entry.getDocCount();
                if (!DateUtils.between((Date)dateForMonth, (Date)finYearStartDate, (Date)finYearEndDate) || rcptCount <= 0L) continue;
                monthwiseCount.put(monthName, rcptCount);
            }
            yearwiseMonthlyCountList.add(monthwiseCount);
            if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
                fromDate = DateUtils.addYears((Date)fromDate, (int)-1);
                toDate = DateUtils.addYears((Date)toDate, (int)-1);
            } else {
                fromDate = DateUtils.addYears((Date)finYearStartDate, (int)-1);
                toDate = DateUtils.addYears((Date)finYearEndDate, (int)-1);
            }
            finYearStartDate = DateUtils.addYears((Date)finYearStartDate, (int)-1);
            finYearEndDate = DateUtils.addYears((Date)finYearEndDate, (int)-1);
        }
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by getReceiptsCountForConsecutiveYears() for 3 consecutive years is : " + timeTaken + " (millisecs) ");
        startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            for (Map.Entry entry : DateUtils.getAllFinancialYearMonthsWithFullNames().entrySet()) {
                ReceiptsTrend rcptsTrend = new ReceiptsTrend();
                rcptsTrend.setMonth((String)entry.getValue());
                rcptsTrend.setCyRcptsCount(((Map)yearwiseMonthlyCountList.get(0)).get(rcptsTrend.getMonth()) == null ? Long.valueOf(0L) : (Long)((Map)yearwiseMonthlyCountList.get(0)).get(rcptsTrend.getMonth()));
                rcptsTrend.setLyRcptsCount(((Map)yearwiseMonthlyCountList.get(1)).get(rcptsTrend.getMonth()) == null ? Long.valueOf(0L) : (Long)((Map)yearwiseMonthlyCountList.get(1)).get(rcptsTrend.getMonth()));
                rcptsTrend.setPyRcptsCount(((Map)yearwiseMonthlyCountList.get(2)).get(rcptsTrend.getMonth()) == null ? Long.valueOf(0L) : (Long)((Map)yearwiseMonthlyCountList.get(2)).get(rcptsTrend.getMonth()));
                rcptTrendsList.add(rcptsTrend);
            }
        } else {
            for (Map.Entry entry : ((Map)yearwiseMonthlyCountList.get(0)).entrySet()) {
                ReceiptsTrend rcptsTrend = new ReceiptsTrend();
                rcptsTrend.setMonth((String)entry.getKey());
                rcptsTrend.setCyRcptsCount((Long)entry.getValue());
                rcptsTrend.setLyRcptsCount(((Map)yearwiseMonthlyCountList.get(1)).get(rcptsTrend.getMonth()) == null ? Long.valueOf(0L) : (Long)((Map)yearwiseMonthlyCountList.get(1)).get(rcptsTrend.getMonth()));
                rcptsTrend.setPyRcptsCount(((Map)yearwiseMonthlyCountList.get(2)).get(rcptsTrend.getMonth()) == null ? Long.valueOf(0L) : (Long)((Map)yearwiseMonthlyCountList.get(2)).get(rcptsTrend.getMonth()));
                rcptTrendsList.add(rcptsTrend);
            }
        }
        timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken foro setting values in getMonthwiseReceiptsTrend() is : " + timeTaken + " (millisecs) ");
        return rcptTrendsList;
    }

    private Aggregations getReceiptsCountForConsecutiveYears(CollectionDetailsRequest collectionDetailsRequest, Date fromDate, Date toDate) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, "receipts");
        boolQuery = boolQuery.mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)"Cancelled"));
        AggregationBuilder monthAggregation = ((DateHistogramBuilder)AggregationBuilders.dateHistogram((String)"date_agg").field("receiptDate")).interval(DateHistogramInterval.MONTH).subAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)"receipt_count").field("receiptNumber"));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"receiptDate").gte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false))).addAggregation((AbstractAggregationBuilder)monthAggregation).build();
        Aggregations collCountAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, (ResultsExtractor)new ResultsExtractor<Aggregations>(){

            public Aggregations extract(SearchResponse response) {
                return response.getAggregations();
            }
        });
        return collCountAggr;
    }

    public List<ReceiptTableData> getReceiptTableData(CollectionDetailsRequest collectionDetailsRequest) {
        Date toDate;
        Date fromDate;
        ArrayList<ReceiptTableData> receiptDataList = new ArrayList<ReceiptTableData>();
        BigDecimal variance = BigDecimal.ZERO;
        String aggregationField = "regionName";
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getType())) {
            if (collectionDetailsRequest.getType().equalsIgnoreCase("region")) {
                aggregationField = "regionName";
            } else if (collectionDetailsRequest.getType().equalsIgnoreCase("district")) {
                aggregationField = "districtName";
            } else if (collectionDetailsRequest.getType().equalsIgnoreCase("ulb")) {
                aggregationField = "cityName";
            } else if (collectionDetailsRequest.getType().equalsIgnoreCase("grade")) {
                aggregationField = "cityGrade";
            } else if (collectionDetailsRequest.getType().equalsIgnoreCase("ward")) {
                aggregationField = "revenueWard";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new Date();
            toDate = DateUtils.addDays((Date)fromDate, (int)1);
        }
        Long startTime = System.currentTimeMillis();
        Map<String, BigDecimal> currDayCollMap = this.getCollectionAndDemandCountResults(collectionDetailsRequest, fromDate, toDate, "receipts", "consumerCode", aggregationField);
        if (StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)collectionDetailsRequest.getToDate())) {
            fromDate = DateUtils.getDate((String)collectionDetailsRequest.getFromDate(), (String)"yyyy-MM-dd");
            toDate = DateUtils.addDays((Date)DateUtils.getDate((String)collectionDetailsRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        } else {
            fromDate = new DateTime().withMonthOfYear(4).dayOfMonth().withMinimumValue().toDate();
            toDate = DateUtils.addDays((Date)new Date(), (int)1);
        }
        Map<String, BigDecimal> cytdCollMap = this.getCollectionAndDemandCountResults(collectionDetailsRequest, fromDate, toDate, "receipts", "consumerCode", aggregationField);
        Map<String, BigDecimal> lytdCollMap = this.getCollectionAndDemandCountResults(collectionDetailsRequest, DateUtils.addYears((Date)fromDate, (int)-1), DateUtils.addYears((Date)toDate, (int)-1), "receipts", "consumerCode", aggregationField);
        Long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken by getCollectionAndDemandCountResults() is : " + timeTaken + " (millisecs) ");
        startTime = System.currentTimeMillis();
        for (Map.Entry<String, BigDecimal> entry : cytdCollMap.entrySet()) {
            ReceiptTableData receiptData = new ReceiptTableData();
            String name = entry.getKey();
            if (aggregationField.equals("regionName")) {
                receiptData.setRegionName(name);
            } else if (aggregationField.equals("districtName")) {
                receiptData.setRegionName(collectionDetailsRequest.getRegionName());
                receiptData.setDistrictName(name);
            } else if (aggregationField.equals("cityName")) {
                receiptData.setUlbName(name);
                receiptData.setDistrictName(collectionDetailsRequest.getDistrictName());
                receiptData.setUlbGrade(collectionDetailsRequest.getUlbGrade());
            } else if (aggregationField.equals("cityGrade")) {
                receiptData.setUlbGrade(name);
            } else if (aggregationField.equals("revenueWard")) {
                receiptData.setWardName(name);
            }
            receiptData.setCytdColl(entry.getValue());
            receiptData.setCurrDayColl(currDayCollMap.get(name) == null ? BigDecimal.valueOf(0L) : currDayCollMap.get(name));
            receiptData.setLytdColl(lytdCollMap.get(name) == null ? BigDecimal.valueOf(0L) : lytdCollMap.get(name));
            variance = receiptData.getLytdColl().compareTo(BigDecimal.ZERO) == 0 ? PropertyTaxConstants.BIGDECIMAL_100 : receiptData.getCytdColl().subtract(receiptData.getLytdColl()).multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(receiptData.getLytdColl(), 1, 4);
            receiptData.setLyVar(variance);
            receiptDataList.add(receiptData);
        }
        timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.debug("Time taken for setting values in getReceiptTableData() is : " + timeTaken + " (millisecs) ");
        return receiptDataList;
    }

    public Map<String, BigDecimal> getCollectionAndDemandCountResults(CollectionDetailsRequest collectionDetailsRequest, Date fromDate, Date toDate, String indexName, String fieldName, String aggregationField) {
        BoolQueryBuilder boolQuery = this.prepareWhereClause(collectionDetailsRequest, indexName);
        if (indexName.equals("receipts")) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"receiptDate").gte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(PropertyTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false)).mustNot((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)"Cancelled"));
        }
        AggregationBuilder aggregation = ((TermsBuilder)AggregationBuilders.terms((String)"by_city").field(aggregationField)).size(120).subAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)"total_count").field(fieldName));
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{indexName}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)aggregation).build();
        Aggregations collAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQueryColl, (ResultsExtractor)new ResultsExtractor<Aggregations>(){

            public Aggregations extract(SearchResponse response) {
                return response.getAggregations();
            }
        });
        StringTerms cityAggr = (StringTerms)collAggr.get("by_city");
        HashMap<String, BigDecimal> cytdCollMap = new HashMap<String, BigDecimal>();
        for (Terms.Bucket entry : cityAggr.getBuckets()) {
            ValueCount aggr = (ValueCount)entry.getAggregations().get("total_count");
            cytdCollMap.put(String.valueOf(entry.getKey()), BigDecimal.valueOf(aggr.getValue()).setScale(0, 4));
        }
        return cytdCollMap;
    }

    public List<CollTableData> getResponseTableDataForBillCollector(CollectionDetailsRequest collectionDetailsRequest) {
        HashMap<String, CollTableData> wardReceiptDetails = new HashMap<String, CollTableData>();
        LinkedHashMap billCollectorWiseMap = new LinkedHashMap();
        ArrayList collDetails = new ArrayList();
        ArrayList<CollTableData> billCollectorWiseTableData = new ArrayList<CollTableData>();
        BigDecimal currDayColl = BigDecimal.ZERO;
        BigDecimal cytdColl = BigDecimal.ZERO;
        BigDecimal lytdColl = BigDecimal.ZERO;
        BigDecimal cytdDmd = BigDecimal.ZERO;
        BigDecimal performance = BigDecimal.ZERO;
        BigDecimal totalDmd = BigDecimal.ZERO;
        BigDecimal variance = BigDecimal.ZERO;
        List<CollTableData> wardWiseData = this.getResponseTableData(collectionDetailsRequest);
        for (CollTableData tableData : wardWiseData) {
            wardReceiptDetails.put(tableData.getWardName(), tableData);
        }
        List<BillCollectorIndex> billCollectorsList = this.getBillCollectorDetails(collectionDetailsRequest);
        for (BillCollectorIndex billCollectorIndex : billCollectorsList) {
            if (billCollectorWiseMap.isEmpty()) {
                collDetails.add(wardReceiptDetails.get(billCollectorIndex.getRevenueWard()));
                billCollectorWiseMap.put(billCollectorIndex.getBillCollector(), collDetails);
                continue;
            }
            if (!billCollectorWiseMap.containsKey(billCollectorIndex.getBillCollector())) {
                collDetails = new ArrayList();
                collDetails.add(wardReceiptDetails.get(billCollectorIndex.getRevenueWard()));
                billCollectorWiseMap.put(billCollectorIndex.getBillCollector(), collDetails);
                continue;
            }
            if (wardReceiptDetails.get(billCollectorIndex.getRevenueWard()) == null) continue;
            ((List)billCollectorWiseMap.get(billCollectorIndex.getBillCollector())).add(wardReceiptDetails.get(billCollectorIndex.getRevenueWard()));
        }
        for (Map.Entry entry : billCollectorWiseMap.entrySet()) {
            CollTableData collTableData = new CollTableData();
            currDayColl = BigDecimal.ZERO;
            cytdColl = BigDecimal.ZERO;
            lytdColl = BigDecimal.ZERO;
            cytdDmd = BigDecimal.ZERO;
            performance = BigDecimal.ZERO;
            totalDmd = BigDecimal.ZERO;
            variance = BigDecimal.ZERO;
            for (CollTableData tableData : (List)entry.getValue()) {
                currDayColl = currDayColl.add(tableData.getTodayColl() == null ? BigDecimal.ZERO : tableData.getTodayColl());
                cytdColl = cytdColl.add(tableData.getCytdColl() == null ? BigDecimal.ZERO : tableData.getCytdColl());
                cytdDmd = cytdDmd.add(tableData.getCytdDmd() == null ? BigDecimal.ZERO : tableData.getCytdDmd());
                totalDmd = totalDmd.add(tableData.getTotalDmd() == null ? BigDecimal.ZERO : tableData.getTotalDmd());
                lytdColl = lytdColl.add(tableData.getLytdColl() == null ? BigDecimal.ZERO : tableData.getLytdColl());
            }
            collTableData.setBillCollector((String)entry.getKey());
            collTableData.setTodayColl(currDayColl);
            collTableData.setCytdColl(cytdColl);
            collTableData.setCytdDmd(cytdDmd);
            collTableData.setCytdBalDmd(cytdDmd.subtract(cytdColl));
            collTableData.setTotalDmd(totalDmd);
            collTableData.setLytdColl(lytdColl);
            if (cytdDmd != BigDecimal.valueOf(0L)) {
                performance = collTableData.getCytdColl().multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(cytdDmd, 1, 4);
                collTableData.setPerformance(performance);
            }
            variance = collTableData.getLytdColl().compareTo(BigDecimal.ZERO) == 0 ? PropertyTaxConstants.BIGDECIMAL_100 : collTableData.getCytdColl().subtract(collTableData.getLytdColl()).multiply(PropertyTaxConstants.BIGDECIMAL_100).divide(collTableData.getLytdColl(), 1, 4);
            collTableData.setLyVar(variance);
            billCollectorWiseTableData.add(collTableData);
        }
        return billCollectorWiseTableData;
    }

    private List<BillCollectorIndex> getBillCollectorDetails(CollectionDetailsRequest collectionDetailsRequest) {
        NativeSearchQuery searchQueryColl = new NativeSearchQueryBuilder().withIndices(new String[]{"billcollector"}).withFields(new String[]{"billCollector", "revenueWard"}).withQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityCode", (Object)collectionDetailsRequest.getUlbCode()))).withSort((SortBuilder)new FieldSortBuilder("billCollector").order(SortOrder.ASC)).withPageable((Pageable)new PageRequest(0, 200)).build();
        List billCollectorsList = this.elasticsearchTemplate.queryForList((SearchQuery)searchQueryColl, BillCollectorIndex.class);
        return billCollectorsList;
    }
}

