/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.scheduler;

import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.scheduler.quartz.AbstractQuartzJob;
import org.egov.infra.utils.DateUtils;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.demand.Ptdemand;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.PropertyImpl;
import org.egov.ptis.domain.service.property.PropertyPersistenceService;
import org.egov.ptis.service.utils.PropertyTaxCommonUtils;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.StatefulJob;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@DisallowConcurrentExecution
public class DemandActivationJob
extends AbstractQuartzJob
implements StatefulJob {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(DemandActivationJob.class);
    private static final String STR_REMARKS_DEMAND_ACTIVATION = "Demand activated by system on 15thd day after notice generation";
    @Autowired
    private PropertyPersistenceService basicPropertyService;
    @Autowired
    private PropertyTaxCommonUtils propertyTaxCommonUtils;

    public void executeJob() {
        LOGGER.debug((Object)"Entered into DemandActivationJob.execute");
        Long currentTimeMillis = System.currentTimeMillis();
        List<Ptdemand> properties = this.getInactiveDemandNotObjectedProperties();
        BasicProperty basicProperty = null;
        for (Ptdemand demand : properties) {
            try {
                basicProperty = demand.getEgptProperty().getBasicProperty();
                this.activateDemand(basicProperty);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error while activating the demand for " + basicProperty.getUpicNo()), (Throwable)e);
            }
        }
        LOGGER.info((Object)("Demand activation for " + properties.size() + " properties is completed in " + (System.currentTimeMillis() - currentTimeMillis) / 1000L + " sec(s)"));
        LOGGER.debug((Object)"Exting from DemandActivationJob.execute");
    }

    private EgDemandDetails getAdvanceDemandDetail(Ptdemand ptDemand) {
        EgDemandDetails advanceDemandDetail = null;
        for (EgDemandDetails demandDetail : ptDemand.getEgDemandDetails()) {
            if (!demandDetail.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("ADVANCE")) continue;
            advanceDemandDetail = demandDetail;
            break;
        }
        return advanceDemandDetail;
    }

    private void activateDemand(BasicProperty basicProperty) {
        LOGGER.debug((Object)"Entered into activateDemand");
        PropertyImpl inactiveProperty = basicProperty.getInactiveProperty();
        inactiveProperty.setStatus(PropertyTaxConstants.STATUS_ISACTIVE);
        inactiveProperty.setRemarks(inactiveProperty.getRemarks() == null ? STR_REMARKS_DEMAND_ACTIVATION : inactiveProperty.getRemarks().concat(", ").concat(STR_REMARKS_DEMAND_ACTIVATION));
        inactiveProperty.setLastModifiedDate(new Date());
        this.basicPropertyService.merge(basicProperty);
        LOGGER.debug((Object)"Exiting from activateDemand");
    }

    private List<Ptdemand> getInactiveDemandNotObjectedProperties() {
        LOGGER.debug((Object)"Entered into getQueryString");
        Date date15DaysPast = DateUtils.add((Date)new Date(), (int)5, (int)-15);
        String stringQuery = "SELECT ptd FROM PtNotice n, PtNotice pvr, Ptdemand ptd LEFT JOIN FETCH ptd.egptProperty p LEFT JOIN FETCH p.basicProperty bp WHERE n.basicProperty = bp AND pvr.basicProperty = bp AND bp.active = true AND bp.status.statusCode <> :bpStatus AND p.status = 'I' AND ptd.egInstallmentMaster = :currInstallment AND pvr.noticeType = :noticeType AND n.noticeDate > p.createdDate AND pvr.noticeDate > p.createdDate AND n.noticeDate < :pastDate AND pvr.noticeDate < :pastDate ";
        LOGGER.debug((Object)"getQueryString, query=SELECT ptd FROM PtNotice n, PtNotice pvr, Ptdemand ptd LEFT JOIN FETCH ptd.egptProperty p LEFT JOIN FETCH p.basicProperty bp WHERE n.basicProperty = bp AND pvr.basicProperty = bp AND bp.active = true AND bp.status.statusCode <> :bpStatus AND p.status = 'I' AND ptd.egInstallmentMaster = :currInstallment AND pvr.noticeType = :noticeType AND n.noticeDate > p.createdDate AND pvr.noticeDate > p.createdDate AND n.noticeDate < :pastDate AND pvr.noticeDate < :pastDate ");
        List properties = this.basicPropertyService.getSession().createQuery("SELECT ptd FROM PtNotice n, PtNotice pvr, Ptdemand ptd LEFT JOIN FETCH ptd.egptProperty p LEFT JOIN FETCH p.basicProperty bp WHERE n.basicProperty = bp AND pvr.basicProperty = bp AND bp.active = true AND bp.status.statusCode <> :bpStatus AND p.status = 'I' AND ptd.egInstallmentMaster = :currInstallment AND pvr.noticeType = :noticeType AND n.noticeDate > p.createdDate AND pvr.noticeDate > p.createdDate AND n.noticeDate < :pastDate AND pvr.noticeDate < :pastDate ").setString("bpStatus", "OBJECTED").setParameter("pastDate", (Object)date15DaysPast).setString("noticeType", "Special Notice").setEntity("currInstallment", (Object)this.propertyTaxCommonUtils.getCurrentInstallment()).list();
        LOGGER.debug((Object)"Exting from getQueryString");
        return properties;
    }
}

