/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.entity.property;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.ptis.domain.entity.property.DocumentType;

@Entity
@Table(name="egpt_document")
@SequenceGenerator(name="SEQ_EGPT_DOCUMENT", sequenceName="SEQ_EGPT_DOCUMENT", allocationSize=1)
public class Document
extends AbstractAuditable {
    public static final String SEQ_DOCUMENT = "SEQ_EGPT_DOCUMENT";
    private static final long serialVersionUID = 7655384098687964458L;
    @Id
    @GeneratedValue(generator="SEQ_EGPT_DOCUMENT", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @JoinColumn(name="type")
    private DocumentType type;
    private String description;
    @Temporal(value=TemporalType.DATE)
    private Date docDate;
    private boolean enclosed;
    @OneToMany(fetch=FetchType.LAZY, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinTable(name="egpt_document_files", joinColumns={@JoinColumn(name="document")}, inverseJoinColumns={@JoinColumn(name="filestore")})
    private Set<FileStoreMapper> files = new HashSet<FileStoreMapper>();
    @Transient
    private List<File> uploads = new ArrayList<File>();
    @Transient
    private List<String> uploadsFileName = new ArrayList<String>();
    @Transient
    private List<String> uploadsContentType = new ArrayList<String>();

    public Long getId() {
        return this.id;
    }

    protected void setId(Long id) {
        this.id = id;
    }

    public DocumentType getType() {
        return this.type;
    }

    public void setType(DocumentType type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getDocDate() {
        return this.docDate;
    }

    public void setDocDate(Date docDate) {
        this.docDate = docDate;
    }

    public boolean isEnclosed() {
        return this.enclosed;
    }

    public void setEnclosed(boolean enclosed) {
        this.enclosed = enclosed;
    }

    public Set<FileStoreMapper> getFiles() {
        return this.files;
    }

    public void setFiles(Set<FileStoreMapper> files) {
        this.files = files;
    }

    public List<File> getUploads() {
        return this.uploads;
    }

    public void setUploads(List<File> uploads) {
        this.uploads = uploads;
    }

    public List<String> getUploadsFileName() {
        return this.uploadsFileName;
    }

    public void setUploadsFileName(List<String> uploadsFileName) {
        this.uploadsFileName = uploadsFileName;
    }

    public List<String> getUploadsContentType() {
        return this.uploadsContentType;
    }

    public void setUploadsContentType(List<String> uploadsContentType) {
        this.uploadsContentType = uploadsContentType;
    }
}

