/*
 * Decompiled with CFR 0.152.
 */
package org.egov.ptis.domain.dao.property;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.ptis.domain.dao.property.PropertyOccupationDAO;
import org.egov.ptis.domain.entity.property.PropertyOccupation;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="propertyOccupationDAO")
@Transactional(readOnly=true)
public class PropertyOccupationHibernateDAO
implements PropertyOccupationDAO {
    @PersistenceContext
    private EntityManager entityManager;

    private Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public PropertyOccupation getPropertyOccupationByOccCodeAndUsage(String occCode, Long propertyUsage) {
        Query qry = null;
        PropertyOccupation propOcc = null;
        if (occCode != null && propertyUsage != null) {
            qry = this.getCurrentSession().createQuery("from PropertyOccupation PO where PO.occupancyCode = :occCode and PO.propertyUsage.id = :propertyUsage and :date between PO.fromDate and PO.toDate ");
            qry.setString("occCode", occCode);
            qry.setLong("propertyUsage", propertyUsage.longValue());
            qry.setDate("date", new Date());
            if (qry.list().size() == 1) {
                propOcc = (PropertyOccupation)((Object)qry.uniqueResult());
            }
        }
        return propOcc;
    }

    @Override
    public PropertyOccupation getPropertyOccupationByOccCode(String occCode) {
        PropertyOccupation propOcc = null;
        Query qry = null;
        if (occCode != null) {
            qry = this.getCurrentSession().createQuery("from PropertyOccupation PO where PO.occupancyCode = :occCode AND ((PO.toDate IS NULL AND PO.fromDate <= :currDate) OR (PO.fromDate <= :currDate AND PO.toDate >= :currDate)) ");
            qry.setString("occCode", occCode);
            qry.setDate("currDate", new Date());
            if (qry.list().size() == 1) {
                propOcc = (PropertyOccupation)((Object)qry.uniqueResult());
            }
        }
        return propOcc;
    }

    @Override
    public PropertyOccupation getPropertyOccupationByOccCodeAndDate(String occCode, Date fromDate) {
        PropertyOccupation propOcc = null;
        Query qry = null;
        if (occCode != null) {
            qry = this.getCurrentSession().createQuery("from PropertyOccupation PO where PO.occupancyCode = :occCode AND ((PO.toDate IS NULL AND PO.fromDate <= :fromDate) OR (PO.fromDate <= :fromDate AND PO.toDate >= :fromDate)) ");
            qry.setString("occCode", occCode);
            qry.setDate("fromDate", fromDate);
            if (qry.list().size() == 1) {
                propOcc = (PropertyOccupation)((Object)qry.uniqueResult());
            }
        }
        return propOcc;
    }

    @Override
    public PropertyOccupation findById(Long id, boolean lock) {
        return null;
    }

    @Override
    public List<PropertyOccupation> findAll() {
        return null;
    }

    @Override
    public PropertyOccupation create(PropertyOccupation propertyOccupation) {
        return null;
    }

    @Override
    public void delete(PropertyOccupation propertyOccupation) {
    }

    @Override
    public PropertyOccupation update(PropertyOccupation propertyOccupation) {
        return null;
    }
}

